/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.elm.goods.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ImageBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisGoodsBaseService;
import com.yqbsoft.laser.service.ext.channel.elm.ElmConstants;
import com.yqbsoft.laser.service.ext.channel.elm.domain.ElmResult;
import com.yqbsoft.laser.service.ext.channel.elm.domain.ElmResultObject;
import com.yqbsoft.laser.service.ext.channel.elm.domain.OItemCreateProperty;
import com.yqbsoft.laser.service.ext.channel.elm.domain.OItemIdWithSpecPrice;
import com.yqbsoft.laser.service.ext.channel.elm.domain.OMaterial;
import com.yqbsoft.laser.service.ext.channel.elm.domain.OSpec;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisGoodsServiceImpl
extends DisGoodsBaseService {
    private String SYS_CODE = "elm.DisGoodsServiceImpl";

    protected String getChannelCode() {
        return ElmConstants.channelCode;
    }

    public Map<String, Object> buildComGoodsClassParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap<String, Object> metasmap = new HashMap<String, Object>();
        metasmap.put("app_key", configMap.get("key"));
        metasmap.put("timestamp", new Date().getTime() / 1000L);
        sendParam.put("metas", metasmap);
        HashMap<String, Object> params = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            if (("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsClass".equals(channelApiCode)) && "parentId".equals(disChannelApiparam.getChannelApiparamKey())) {
                String parentId = (String)sendParam.remove(disChannelApiparam.getChannelApiparamKey());
                String elmParentId = this.getCategoryId((String)param.get("tenantCode"), (String)param.get("channelCode"), parentId);
                params.put(disChannelApiparam.getChannelApiparamKey(), elmParentId);
                continue;
            }
            params.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        sendParam.put("params", params);
        return sendParam;
    }

    public String sendComSaveGoodsClass(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(ElmConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        ElmResult elmResult = this.make(json);
        if (null == elmResult) {
            return json;
        }
        if (null != elmResult.getError()) {
            return elmResult.getError().getMessage();
        }
        if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode)) {
            String id = String.valueOf((Integer)elmResult.getResult().get("id"));
            this.saveClassDictionary(disChannel, (String)param.get("memberCode"), ((RsGoodsClassDomain)param.get("rsGoodsClassDomain")).getGoodsClassCode(), id, (String)param.get("tenantCode"));
        }
        return "SUCCESS";
    }

    private ElmResultObject makeObject(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".makeObject.json");
            return null;
        }
        ElmResultObject elmResult = (ElmResultObject)JsonUtil.buildNormalBinder().getJsonToObject(json, ElmResultObject.class);
        if (null == elmResult) {
            return null;
        }
        return elmResult;
    }

    private ElmResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        ElmResult elmResult = (ElmResult)JsonUtil.buildNormalBinder().getJsonToObject(json, ElmResult.class);
        if (null == elmResult) {
            return null;
        }
        return elmResult;
    }

    private void makeSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, Map<OItemCreateProperty, Object> properties) {
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty((Collection)rsResourceGoodsReDomain.getRsSkuDomainList()) || MapUtil.isEmpty(properties)) {
            return;
        }
        ArrayList<OSpec> oSpecs = new ArrayList<OSpec>();
        DecimalFormat formatter = new DecimalFormat("#.##");
        for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
            OSpec oSpec = new OSpec();
            oSpec.setSpecId(Long.valueOf(rsSkuDomain.getSkuCode()));
            oSpec.setName(rsSkuDomain.getSkuName());
            oSpec.setPrice(Double.valueOf(formatter.format(rsSkuDomain.getPricesetNprice())));
            oSpec.setStock(null == rsSkuDomain.getGoodsSupplynum() ? 0 : rsSkuDomain.getGoodsSupplynum().intValue());
            oSpec.setMaxStock(999);
            oSpec.setStockStatus(0);
            oSpec.setOnShelf(null == rsSkuDomain.getDataOpbillstate() ? 0 : rsSkuDomain.getDataOpbillstate());
            oSpec.setExtendCode(rsSkuDomain.getSkuCode());
            oSpec.setBarCode(StringUtils.isBlank((String)rsSkuDomain.getSkuBarcode()) ? rsSkuDomain.getSkuNo() : rsSkuDomain.getSkuBarcode());
            oSpec.setWeight(rsSkuDomain.getGoodsSupplyweight().intValue());
            oSpec.setActivityLevel(0);
            oSpec.setPid(null == rsSkuDomain.getSkuOldcode() ? null : Long.valueOf(rsSkuDomain.getSkuOldcode()));
            oSpecs.add(oSpec);
        }
        properties.put(OItemCreateProperty.specs, oSpecs);
    }

    private List<String> createImageList(DisChannel disChannel, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return null;
        }
        ArrayList<String> imageList = new ArrayList<String>();
        String code = "";
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            code = this.getFileOcode(disChannel, rsGoodsFileDomain.getGoodsFileName(), this.getChannelCode(), rsGoodsFileDomain.getTenantCode());
            if (!StringUtils.isNotBlank((String)code)) continue;
            imageList.add(code);
        }
        return imageList;
    }

    private Map<OItemCreateProperty, Object> createGoods(DisChannel disChannel, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == disChannel || null == rsResourceGoodsReDomain) {
            return null;
        }
        HashMap<OItemCreateProperty, Object> properties = new HashMap<OItemCreateProperty, Object>();
        properties.put(OItemCreateProperty.name, rsResourceGoodsReDomain.getGoodsName());
        properties.put(OItemCreateProperty.description, rsResourceGoodsReDomain.getGoodsProperty());
        properties.put(OItemCreateProperty.imageHash, this.getFileOcode(disChannel, rsResourceGoodsReDomain.getDataPicpath(), this.getChannelCode(), rsResourceGoodsReDomain.getTenantCode()));
        this.makeSku(rsResourceGoodsReDomain, properties);
        properties.put(OItemCreateProperty.minPurchaseQuantity, null == rsResourceGoodsReDomain.getGoodsMinnum() ? 1 : rsResourceGoodsReDomain.getGoodsMinnum().intValue());
        properties.put(OItemCreateProperty.unit, rsResourceGoodsReDomain.getPartsnameNumunit());
        properties.put(OItemCreateProperty.setMeal, 1);
        List<String> imageList = this.createImageList(disChannel, rsResourceGoodsReDomain.getRsGoodsFileDomainList());
        properties.put(OItemCreateProperty.imageHashs, imageList);
        List<OMaterial> oMaterials = this.createOmaterial(rsResourceGoodsReDomain);
        properties.put(OItemCreateProperty.materials, oMaterials);
        return properties;
    }

    private List<OMaterial> createOmaterial(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        ArrayList<OMaterial> oMaterialList = new ArrayList<OMaterial>();
        if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                OMaterial oMaterial = new OMaterial();
                String code = (String)(StringUtils.isBlank((String)rsGoodsRelDomain.getSkuNo()) ? Integer.valueOf(1) : rsGoodsRelDomain.getSkuNo());
                oMaterial.setId(Long.valueOf(code));
                oMaterial.setName(rsGoodsRelDomain.getSkuName());
                oMaterialList.add(oMaterial);
            }
        } else {
            OMaterial oMaterial = new OMaterial();
            oMaterial.setId(26042L);
            oMaterial.setName("\u5176\u5b83");
            oMaterialList.add(oMaterial);
        }
        return oMaterialList;
    }

    public Map<String, Object> buildComGoodsParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap<String, Object> metasmap = new HashMap<String, Object>();
        metasmap.put("app_key", configMap.get("key"));
        metasmap.put("timestamp", new Date().getTime() / 1000L);
        sendParam.put("metas", metasmap);
        HashMap<String, Object> params = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            params.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            ImageBean imageBean = (ImageBean)param.get("imageBean");
            if (null == imageBean || null == imageBean.getImage()) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.imageBean");
            }
            String images = Base64.encodeBase64String((byte[])imageBean.getImage());
            params.put("images", images);
        } else if ("cmc.disGoods.saveSendGoods".equals(channelApiCode) || "cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            Map<OItemCreateProperty, Object> properties = this.createGoods(disChannel, rsResourceGoodsReDomain);
            if ("cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
                params.put("itemId", rsResourceGoodsReDomain.getGoodsEocode());
            }
            params.put("categoryId", param.get("categoryId"));
            params.put("properties", properties);
        } else if ("cmc.disGoods.updateSendSkuNum".equals(channelApiCode)) {
            HashMap<Long, Integer> stockMap = new HashMap<Long, Integer>();
            stockMap.put(Long.valueOf((String)param.get("skuEocode")), Integer.valueOf(param.get("goodsSupplynum").toString()));
            params.put("stockMap", stockMap);
        } else if ("cmc.disGoods.updateSendSkuPrice".equals(channelApiCode)) {
            ArrayList<OItemIdWithSpecPrice> oItemIdWithSpecPriceList = new ArrayList<OItemIdWithSpecPrice>();
            HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>();
            OItemIdWithSpecPrice oItemIdWithSpecPrice = new OItemIdWithSpecPrice();
            oItemIdWithSpecPriceList.add(oItemIdWithSpecPrice);
            oItemIdWithSpecPrice.setItemId(Long.valueOf((String)param.get("goodsEocode")));
            oItemIdWithSpecPrice.setPriceMap(priceMap);
            priceMap.put((String)param.get("skuEocode"), (BigDecimal)param.get("pricesetNprice"));
            params.put("shopId", param.get("shoppingId"));
            params.put("specPrices", oItemIdWithSpecPriceList);
        }
        sendParam.put("params", params);
        return sendParam;
    }

    public String sendComSaveGoods(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(ElmConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            ElmResultObject elmResult = this.makeObject(json);
            if (null == elmResult) {
                return "ERROR";
            }
            if (null != elmResult.getError()) {
                return elmResult.getError().getMessage();
            }
            String code = (String)elmResult.getResult();
            this.saveFileList(disChannel, (String)param.get("fileCode"), (String)param.get("fchannelCode"), code, (String)param.get("tenantCode"));
        } else {
            ElmResult elmResult = this.make(json);
            if (null == elmResult) {
                return "ERROR";
            }
            if (null != elmResult.getError()) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.elmResult", (Object)(elmResult.getError().getCode() + "=" + elmResult.getError().getMessage() + "=" + url + ":" + JsonUtil.buildNormalBinder().toJson(sendhttpParam) + ":" + configMap.toString()));
                return elmResult.getError().getMessage();
            }
            if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.rsResourceGoodsReDomain", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                this.saveGoods(disChannel, rsResourceGoodsReDomain.getGoodsNo(), rsResourceGoodsReDomain.getGoodsCode(), String.valueOf((Integer)elmResult.getResult().get("id")), rsResourceGoodsReDomain.getTenantCode());
                List skuList = (List)elmResult.getResult().get("specs");
                if (ListUtil.isNotEmpty((Collection)skuList)) {
                    for (Map map : skuList) {
                        this.saveSku(disChannel, null, (String)map.get("extendCode"), String.valueOf((Integer)map.get("specId")), rsResourceGoodsReDomain.getTenantCode());
                    }
                }
            }
            if ("cmc.disGoods.saveSendSku".equals(channelApiCode)) {
                RsSkuDomain rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
                if (null == rsSkuDomain) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.rsSkuDomain", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                this.saveSku(disChannel, rsSkuDomain.getSkuNo(), rsSkuDomain.getSkuCode(), String.valueOf((Integer)elmResult.getResult().get("specId")), rsSkuDomain.getTenantCode());
            }
        }
        return "SUCCESS";
    }

    public static void main(String[] args) {
        DecimalFormat formatter = new DecimalFormat("#.##");
        System.out.println(formatter.format(Double.valueOf(formatter.format(new BigDecimal("100.11")))));
    }
}

