/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.elm.order.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.elm.ElmConstants;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "elm.DisOrderServiceImpl";

    protected String getChannelCode() {
        return ElmConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap<String, Object> metasmap = new HashMap<String, Object>();
        metasmap.put("app_key", configMap.get("key"));
        metasmap.put("timestamp", new Date().getTime() / 1000L);
        sendParam.put("metas", metasmap);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if ("cmc.disOrder.queryOrder".equals(channelApiCode)) {
            params.put("shopId", param.get("shoppingId"));
            params.put("pageNo", param.get("pageNo"));
            params.put("pageSize", param.get("pageSize"));
            params.put("date", param.get("param"));
        } else if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            // empty if block
        }
        sendParam.put("params", params);
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(ElmConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map elmOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)elmOrderMap)) {
            return null;
        }
        if (null != elmOrderMap.get("error")) {
            throw new ApiException(this.SYS_CODE + ".sendComOrder.elmResultListOrder", (String)elmOrderMap.get("error"));
        }
        if (null == elmOrderMap.get("result")) {
            return null;
        }
        if ("cmc.disOrder.queryOrder".equals(channelApiCode)) {
            Map result = (Map)elmOrderMap.get("result");
            if (MapUtil.isEmpty((Map)result)) {
                return null;
            }
            List listMap = (List)result.get("list");
            if (ListUtil.isEmpty((Collection)listMap)) {
                return null;
            }
            return this.createListOrder(listMap, disChannel);
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            Map map = (Map)elmOrderMap.get("result");
            if (MapUtil.isEmpty((Map)map)) {
                return null;
            }
            return this.createOrder(map, disChannel);
        }
        return null;
    }

    private List<DisContractDomain> createListOrder(List<Map<String, Object>> list, DisChannel disChannel) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        for (Map<String, Object> map : list) {
            DisContractDomain disContractDomain = this.makeOrder(map, disChannel);
            if (null == disContractDomain) continue;
            disContractDomainList.add(disContractDomain);
        }
        return disContractDomainList;
    }

    private DisContractDomain createOrder(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeOrder(param, disChannel);
    }

    private DisContractDomain makeOrder(Map<String, Object> map, DisChannel disChannel) {
        if (null == map || null == disChannel) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        DisContractDomain disContractDomain = new DisContractDomain();
        disContractDomain.setGoodsReceiptArrdess((String)map.get("address"));
        disContractDomain.setChannelCode(disChannel.getChannelCode());
        disContractDomain.setChannelName(disChannel.getChannelName());
        disContractDomain.setTenantCode(disChannel.getTenantCode());
        String activeAt = (String)map.get("activeAt");
        String deliverTime = (String)map.get("deliverTime");
        String confirmCookingTime = (String)map.get("confirmCookingTime");
        try {
            disContractDomain.setContractValidate(StringUtils.isNotBlank((String)activeAt) ? sdf.parse(activeAt) : null);
            disContractDomain.setContractEffectivedate(StringUtils.isNotBlank((String)deliverTime) ? sdf.parse(deliverTime) : null);
            disContractDomain.setGmtVaild(StringUtils.isNotBlank((String)confirmCookingTime) ? sdf.parse(confirmCookingTime) : null);
        }
        catch (ParseException e) {
            // empty catch block
        }
        Double deliverFee = (Double)map.get("deliverFee");
        if (null == deliverFee) {
            deliverFee = new Double("0");
        }
        disContractDomain.setGoodsLogmoney(BigDecimal.valueOf(deliverFee));
        disContractDomain.setContractRemark((String)map.get("description"));
        disContractDomain.setContractInvoice((String)map.get("invoice"));
        disContractDomain.setContractTypepro("00");
        if (((Boolean)map.get("book")).booleanValue()) {
            disContractDomain.setContractTypepro("01");
        }
        disContractDomain.setContractType("19");
        disContractDomain.setContractPmode("1");
        if (((Boolean)map.get("onlinePaid")).booleanValue()) {
            disContractDomain.setContractPmode("0");
        }
        disContractDomain.setContractNbillcode((String)map.get("id"));
        disContractDomain.setGoodsReceiptPhone(this.changeParam((List)map.get("phoneList")));
        String memberCcode = this.getMemberCode(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("shopId")));
        disContractDomain.setMemberCode(disChannel.getMemberCode());
        disContractDomain.setMemberName(disChannel.getMemberName());
        disContractDomain.setMemberCcode(memberCcode);
        disContractDomain.setMemberCname((String)map.get("shopName"));
        this.setContractPro(disContractDomain, "daySn", String.valueOf(map.get("daySn")), "\u6d41\u6c34\u53f7");
        disContractDomain.setDataStatestr((String)map.get("status"));
        String dataState = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)map.get("status"));
        if (StringUtils.isBlank((String)dataState) || "null".equals(dataState)) {
            dataState = "2";
        }
        disContractDomain.setDataState(Integer.valueOf(Integer.parseInt(dataState)));
        String refundStatus = this.getRefundFlag(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)map.get("refundStatus"));
        if (StringUtils.isBlank((String)refundStatus) || "null".equals(refundStatus)) {
            refundStatus = "0";
        }
        disContractDomain.setRefundFlag(Integer.valueOf(Integer.parseInt(refundStatus)));
        disContractDomain.setMemberBcode((String)map.get("userIdStr"));
        Double income = (Double)map.get("income");
        if (null == income) {
            income = new Double("0");
        }
        disContractDomain.setDataBmoney(BigDecimal.valueOf(income));
        Double totalPrice = (Double)map.get("totalPrice");
        if (null == totalPrice) {
            totalPrice = new Double("0");
        }
        disContractDomain.setContractMoney(BigDecimal.valueOf(totalPrice));
        Double originalPrice = (Double)map.get("originalPrice");
        if (null == originalPrice) {
            originalPrice = new Double("0");
        }
        disContractDomain.setContractInmoney(BigDecimal.valueOf(originalPrice));
        this.setContractPro(disContractDomain, "geo", (String)map.get("deliveryGeo"), "\u7ecf\u7eac\u5ea6");
        disContractDomain.setGoodsReceiptMem((String)map.get("consignee"));
        if (((Boolean)map.get("invoiced")).booleanValue()) {
            String str = "{ \"invoiceType\":" + map.get("invoiceType") + ",\"invoice\":" + map.get("invoice") + ",\"invoiceType\":" + map.get("invoiceType") + "}";
            disContractDomain.setContractInvoicestr(str);
        }
        this.setContractPro(disContractDomain, "downgraded", String.valueOf(map.get("downgraded")), "\u964d\u7ea7\u6807\u8bc6");
        this.setContractPro(disContractDomain, "secretPhoneExpireTime", String.valueOf(map.get("secretPhoneExpireTime")), "\u4fdd\u62a4\u5c0f\u53f7\u5931\u6548\u65f6\u95f4");
        disContractDomain.setContractActives(JsonUtil.buildNormalBinder().toJson(map.get("orderActivities")));
        Double packageFee = (Double)map.get("packageFee");
        if (null == packageFee) {
            packageFee = new Double("0");
        }
        disContractDomain.setContractPaymoney(BigDecimal.valueOf(packageFee));
        Double coldBoxFee = (Double)map.get("coldBoxFee");
        if (null == coldBoxFee) {
            coldBoxFee = new Double("0");
        }
        disContractDomain.setContractEarnest(BigDecimal.valueOf(coldBoxFee));
        this.setContractPro(disContractDomain, "cancelOrderDescription", (String)map.get("cancelOrderDescription"), "\u7528\u6237\u53d6\u6d88\u539f\u56e0");
        this.setContractPro(disContractDomain, "cancelOrderCreatedAt", String.valueOf(map.get("cancelOrderCreatedAt")), "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u65f6\u95f4");
        disContractDomain.setContractCommis(JsonUtil.buildNormalBinder().toJson(map.get("orderCommissions")));
        disContractDomain.setContractExtinfo(JsonUtil.buildNormalBinder().toJson(map.get("userExtraInfo")));
        if (StringUtils.isNotBlank((String)((String)map.get("superVip")))) {
            this.setContractPro(disContractDomain, "superVip", (String)map.get("superVip"), "\u4f1a\u5458\u6807\u8bc6", "");
        }
        disContractDomain.setContractPumode(String.valueOf(map.get("orderBusinessType")));
        disContractDomain.setPackageBillno(String.valueOf(map.get("pickUpNumber")));
        disContractDomain.setContractProperty("0");
        if (((Boolean)map.get("pinTuanOrder")).booleanValue()) {
            disContractDomain.setContractProperty("1");
        }
        if (((Boolean)map.get("isBusinessOrder")).booleanValue()) {
            disContractDomain.setContractProperty("2");
        }
        this.setContractPro(disContractDomain, "orderSourceTag", (String)map.get("orderSourceTag"), "\u8ba2\u5355\u6765\u6e90\u6807\u7b7e", "");
        List list = (List)map.get("groups");
        List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(list, disContractDomain);
        disContractDomain.setPackageList(disPackageDomains);
        return disContractDomain;
    }

    private String changeParam(List<String> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String rStr = "";
        for (String str : list) {
            rStr = rStr + str + ",";
        }
        return rStr;
    }

    private List<DisPackageDomain> makeDisPackageDomain(List<Map<String, Object>> goodGroup, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(goodGroup)) {
            return null;
        }
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = null;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal goodsNum = BigDecimal.ZERO;
        for (Map<String, Object> oGoodsGroup : goodGroup) {
            pag = new DisPackageDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
            }
            pag.setPackageName((String)oGoodsGroup.get("name"));
            pag.setPackageType((String)oGoodsGroup.get("type"));
            List list = (List)oGoodsGroup.get("items");
            if (ListUtil.isEmpty((Collection)list)) {
                return null;
            }
            List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(list, pag, disContractDomain);
            goodsNum = goodsNum.add(pag.getGoodsNum());
            goodsWeight = goodsWeight.add(pag.getGoodsWeight());
            pag.setContractGoodsList(goodsList);
            rePagList.add(pag);
        }
        disContractDomain.setGoodsNum(goodsNum);
        disContractDomain.setDataBnum(goodsNum);
        disContractDomain.setGoodsWeight(goodsWeight);
        disContractDomain.setDataBweight(goodsWeight);
        return rePagList;
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(List<Map<String, Object>> items, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(items)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (Map<String, Object> oGoodsItem : items) {
            disContractGoodsDomain = new DisContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
            }
            GoodsBean goodsBean = this.getResourceBySkuNo((String)oGoodsItem.get("extendCode"), disContractDomain.getMemberCode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode());
            if (null != goodsBean && null != goodsBean.getRsSku()) {
                disContractGoodsDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
            }
            disContractGoodsDomain.setSkuNo((String)oGoodsItem.get("extendCode"));
            disContractGoodsDomain.setSkuEocode(String.valueOf(oGoodsItem.get("skuId")));
            disContractGoodsDomain.setGoodsEocode(String.valueOf(oGoodsItem.get("vfoodId")));
            disContractGoodsDomain.setSkuName((String)oGoodsItem.get("name"));
            disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf((Double)oGoodsItem.get("price")));
            disContractGoodsDomain.setContractGoodsPrice(BigDecimal.valueOf((Double)oGoodsItem.get("userPrice")));
            if (null == disContractGoodsDomain.getContractGoodsPrice() || disContractGoodsDomain.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0) {
                disContractGoodsDomain.setContractGoodsPrice(disContractGoodsDomain.getPricesetNprice());
            }
            BigDecimal goodsNum = BigDecimal.valueOf(((Integer)oGoodsItem.get("quantity")).intValue());
            disContractGoodsDomain.setGoodsCamount(goodsNum);
            disContractGoodsDomain.setGoodsNum(goodsNum);
            disContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
            disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            disContractGoodsDomain.setContractGoodsInmoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
            disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getContractGoodsPrice().multiply(goodsNum));
            disContractGoodsDomain.setGoodsSpecs(JsonUtil.buildNormalBinder().toJson(oGoodsItem.get("newSpecs")));
            disContractGoodsDomain.setGoodsProtins(JsonUtil.buildNormalBinder().toJson(oGoodsItem.get("attributes")));
            if (null == disContractGoodsDomain.getGoodsNum()) {
                disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
            if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
                disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
            if (null == disContractGoodsDomain.getContractGoodsMoney()) {
                disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
            if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
                disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == disContractGoodsDomain.getGoodsWeight()) {
                disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
            goodsDomainList.add(disContractGoodsDomain);
        }
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproValue) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == sendhttpParam) {
            return "{\"message\":\"ok\"}";
        }
        this.logger.error(this.SYS_CODE + ".saveOrderParam : ", (Object)(sendhttpParam + " ----------\u3002"));
        Object obj = sendhttpParam.get("type");
        if (null == obj || "null".equals(obj.toString())) {
            return "{\"message\":\"ok\"}";
        }
        String typestr = String.valueOf(obj);
        if (StringUtils.isBlank((String)typestr)) {
            return "{\"message\":\"ok\"}";
        }
        int type = Integer.valueOf(typestr);
        if (type == 10) {
            String msg = (String)sendhttpParam.get("message");
            Map elmOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(msg, String.class, Object.class);
            DisContractDomain disContractDomain = this.createOrder(elmOrderMap, disChannel);
            if (null == disContractDomain) {
                return null;
            }
            disContractDomain.setDataStatestr(typestr);
            ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
            disContractDomainList.add(disContractDomain);
            this.saveOrder(disContractDomainList, disChannel);
        } else if (10 < type && type <= 76) {
            String msg = (String)sendhttpParam.get("message");
            Map elmOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(msg, String.class, Object.class);
            HashMap<String, String> stateMap = new HashMap<String, String>();
            stateMap.put("dataStatestr", typestr);
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), (String)elmOrderMap.get("orderId"), disChannel)) {
                DisContractDomain disContractDomain = this.createOrder(elmOrderMap, disChannel);
                if (null == disContractDomain) {
                    return null;
                }
                disContractDomain.setDataStatestr(typestr);
                ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
                disContractDomainList.add(disContractDomain);
                this.saveOrder(disContractDomainList, disChannel);
            } else {
                String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)elmOrderMap.get("status"));
                if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                    dataStateStr = String.valueOf(type);
                }
                Integer dataState = Integer.valueOf(dataStateStr);
                this.updateOrder(disChannel.getTenantCode(), (String)elmOrderMap.get("orderId"), dataState, null, stateMap, disChannel);
            }
        } else if (type == 91 || type == 93 || type == 100 || type == 105 || type == 110 || type == 201) {
            // empty if block
        }
        return "{\"message\":\"ok\"}";
    }
}

