/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.order.service;

import com.yqbsoft.laser.service.distribution.model.DisContract;
import com.yqbsoft.laser.service.distribution.service.DisContractService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.domain.WebRequestDTO;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.ext.channel.jd.utils.SignUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "jddj.DisOrderServiceImpl";
    @Autowired
    private DisContractService disContractService;

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        String memberCode;
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            sendParam.put("orderId", (String)param.get("contractNbillcode"));
            sendParam.remove("pageNo");
            sendParam.remove("pageSize");
        }
        if ("cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            sendParam.put("orderStartTime_begin", (String)param.get("start_time"));
            sendParam.put("orderStartTime_end", (String)param.get("end_time"));
            sendParam.remove("start_time");
            sendParam.remove("end_time");
        }
        if (StringUtils.isBlank((String)(memberCode = (String)param.get("memberCode")))) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        this.logger.error(this.SYS_CODE + ".buildComOrderParam.sendParam", (Object)("====" + sendParam.toString() + "====" + configMap.toString() + "====" + channelApiCode));
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        for (String key : sendhttpParam.keySet()) {
            Object o;
            if ("token".equals(key) || (o = sendhttpParam.get(key)) == null) continue;
            String a = o.toString();
            mapSend.put(key, a);
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jdOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jdOrderMap)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if (!"0".equals(jdOrderMap.get("code"))) {
            throw new ApiException(this.SYS_CODE + ".sendComOrder.jdResultListOrder", (String)jdOrderMap.get("msg"));
        }
        if (null == jdOrderMap.get("data")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.data", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.queryOrder".equals(channelApiCode) || "cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.dataMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String result1 = (String)dataMap.get("result");
            Map resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result1, String.class, Object.class);
            if (MapUtil.isEmpty((Map)resultMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            if ("0".equals((String)resultMap.get("totalCount"))) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.totalCount is 0", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "SUCCESS";
            }
            List listMap = (List)resultMap.get("resultList");
            if (ListUtil.isEmpty((Collection)listMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.listMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            return this.createListOrder(listMap, disChannel);
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            String dataString = (String)jdOrderMap.get("data");
            if (StringUtils.isBlank((String)dataString)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.dataString", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(dataString, String.class, Object.class);
            if (MapUtil.isEmpty((Map)map)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.map", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String resultMap = (String)map.get("result");
            if (StringUtils.isEmpty((String)resultMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            Map resMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultMap, String.class, Object.class);
            if (MapUtil.isEmpty((Map)resMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            List resultList = (List)resMap.get("resultList");
            if (ListUtil.isEmpty((Collection)resultList)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultList", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            Map endMap = (Map)resultList.get(0);
            if (MapUtil.isEmpty((Map)endMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.endMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String orderStatus = String.valueOf(endMap.get("orderStatus"));
            if ("32000".equals(orderStatus)) {
                DisContractDomain order = this.createOrder(endMap, disChannel);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                disContractList.add(order);
                this.logger.error(this.SYS_CODE + ".sendComOrder : " + JsonUtil.buildNormalBinder().toJson((Object)order));
                this.saveOrder(disContractList, disChannel);
            } else {
                String dataStateStr;
                String orderId = String.valueOf(endMap.get("orderId"));
                if (StringUtils.isBlank((String)orderId)) {
                    return null;
                }
                DisContract disContract = this.disContractService.getContract(Integer.valueOf((String)endMap.get("orderId")));
                if (null == disContract) {
                    DisContractDomain order = this.createOrder(endMap, disChannel);
                    ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                    disContractList.add(order);
                    this.logger.error(this.SYS_CODE + ".sendComOrder.disContract : " + JsonUtil.buildNormalBinder().toJson((Object)order));
                    this.saveOrder(disContractList, disChannel);
                }
                if (StringUtils.isBlank((String)(dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), orderStatus))) || "null".equals(dataStateStr)) {
                    dataStateStr = String.valueOf(orderStatus);
                }
                Integer dataState = Integer.valueOf(dataStateStr);
                this.updateOrder(disChannel.getTenantCode(), orderId, dataState, null, null, disChannel);
            }
        }
        this.logger.error(this.SYS_CODE + ".sendComOrder.sendStoreEndParam.saveGoods", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
        return "SUCCESS";
    }

    private List<DisContractDomain> createListOrder(List<Map<String, Object>> list, DisChannel disChannel) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        for (Map<String, Object> map : list) {
            DisContractDomain disContractDomain = this.makeOrder(map, disChannel);
            if (null == disContractDomain) continue;
            disContractDomainList.add(disContractDomain);
        }
        return disContractDomainList;
    }

    private DisContractDomain createOrder(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeOrder(param, disChannel);
    }

    private DisContractDomain makeOrder(Map<String, Object> map, DisChannel disChannel) {
        if (null == map || null == disChannel) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        DisContractDomain disContractDomain = new DisContractDomain();
        disContractDomain.setGoodsReceiptArrdess((String)map.get("buyerFullAddress"));
        disContractDomain.setChannelCode(disChannel.getChannelCode());
        disContractDomain.setChannelName(disChannel.getChannelName());
        disContractDomain.setTenantCode(disChannel.getTenantCode());
        String activeAt = (String)map.get("orderStartTime");
        String deliverTime = (String)map.get("orderPreStartDeliveryTime");
        String confirmCookingTime = (String)map.get("pickDeadline");
        try {
            disContractDomain.setContractValidate(StringUtils.isNotBlank((String)activeAt) ? sdf.parse(activeAt) : null);
            disContractDomain.setContractEffectivedate(StringUtils.isNotBlank((String)deliverTime) ? sdf.parse(deliverTime) : null);
            disContractDomain.setGmtVaild(StringUtils.isNotBlank((String)confirmCookingTime) ? sdf.parse(confirmCookingTime) : null);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        disContractDomain.setGoodsLogmoney(BigDecimal.valueOf(((Integer)map.get("orderReceivableFreight")).intValue()));
        disContractDomain.setContractRemark((String)map.get("orderBuyerRemark"));
        List list = (List)map.get("product");
        List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(list, disContractDomain);
        disContractDomain.setPackageList(disPackageDomains);
        Map orderInvoiceMap = (Map)map.get("orderInvoice");
        if (MapUtil.isNotEmpty((Map)orderInvoiceMap) && StringUtils.isNotBlank((String)((String)orderInvoiceMap.get("invoice")))) {
            disContractDomain.setContractInvoice((String)map.get("invoice"));
        }
        disContractDomain.setContractTypepro("00");
        disContractDomain.setContractType("19");
        disContractDomain.setContractPmode("1");
        if (1 == (Integer)map.get("orderPayType")) {
            disContractDomain.setContractPmode("0");
        }
        disContractDomain.setContractNbillcode(String.valueOf(map.get("orderId")));
        disContractDomain.setGoodsReceiptPhone((String)map.get("buyerMobile"));
        String memberCcode = this.getMemberCode(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("deliveryStationNo")));
        disContractDomain.setMemberCode(disChannel.getMemberCode());
        disContractDomain.setMemberName(disChannel.getMemberName());
        disContractDomain.setMemberCcode(memberCcode);
        disContractDomain.setMemberCname((String)map.get("deliveryStationName"));
        this.setContractPro(disContractDomain, "orderNum", String.valueOf(map.get("orderNum")), "\u5f53\u5929\u95e8\u5e97\u8ba2\u5355\u5e8f\u53f7");
        String dataState = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("orderStatus")));
        if (null != dataState) {
            disContractDomain.setDataState(Integer.valueOf(Integer.parseInt(dataState)));
        }
        if ("20020".equals(String.valueOf(map.get("orderStatus"))) || "20030".equals(String.valueOf(map.get("orderStatus"))) || "20040".equals(String.valueOf(map.get("orderStatus"))) || "20060".equals(String.valueOf(map.get("orderStatus")))) {
            String refundStatus = this.getRefundFlag(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)map.get("refundStatus"));
            disContractDomain.setRefundFlag(Integer.valueOf(Integer.parseInt(refundStatus)));
        }
        disContractDomain.setDataBmoney(BigDecimal.valueOf(((Integer)map.get("orderBuyerPayableMoney")).intValue()));
        disContractDomain.setContractMoney(BigDecimal.valueOf(((Integer)map.get("orderDiscountMoney")).intValue()));
        disContractDomain.setContractInmoney(BigDecimal.valueOf(((Integer)map.get("orderTotalMoney")).intValue()));
        disContractDomain.setGoodsReceiptMem((String)map.get("buyerFullName"));
        if (MapUtil.isNotEmpty((Map)orderInvoiceMap) && StringUtils.isNotBlank((String)((String)orderInvoiceMap.get("invoice")))) {
            String orderType = "";
            while (0 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4e2a\u4eba";
            }
            while (1 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4f01\u4e1a\u666e\u7968";
            }
            while (2 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4f01\u4e1a\u4e13\u7968";
            }
            String str = "{ \"invoiceType\":" + orderType + ",\"invoice\":" + (String)map.get("invoice") + "}";
            disContractDomain.setContractInvoicestr(str);
        }
        disContractDomain.setContractPaymoney(BigDecimal.valueOf(((Integer)map.get("packagingMoney")).intValue()));
        if ("20020".equals(String.valueOf(map.get("orderStatus"))) || "20030".equals(String.valueOf(map.get("orderStatus"))) || "20040".equals(String.valueOf(map.get("orderStatus"))) || "20060".equals(String.valueOf(map.get("orderStatus")))) {
            this.setContractPro(disContractDomain, "cancelOrderDescription", String.valueOf(map.get("orderStatus")), "\u7528\u6237\u53d6\u6d88\u539f\u56e0");
            this.setContractPro(disContractDomain, "cancelOrderCreatedAt", map.get("orderCancelTime").toString(), "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u65f6\u95f4");
        }
        disContractDomain.setContractPumode(String.valueOf(map.get("businessType")));
        disContractDomain.setContractProperty("0");
        if (((Boolean)map.get("isGroupon")).booleanValue()) {
            disContractDomain.setContractProperty("1");
        }
        if (!"0".equals(String.valueOf(map.get("orderStatus")))) {
            disContractDomain.setContractProperty("2");
        }
        return disContractDomain;
    }

    private String changeParam(List<String> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String rStr = "";
        for (String str : list) {
            rStr = rStr + str + ",";
        }
        return rStr;
    }

    private List<DisPackageDomain> makeDisPackageDomain(List<Map<String, Object>> goodGroup, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(goodGroup)) {
            return null;
        }
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = new DisPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
        }
        List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(goodGroup, pag, disContractDomain);
        pag.setContractGoodsList(goodsList);
        rePagList.add(pag);
        return rePagList;
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(List<Map<String, Object>> items, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(items)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (Map<String, Object> oGoodsItem : items) {
            disContractGoodsDomain = new DisContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
            }
            disContractGoodsDomain.setSkuCode((String)oGoodsItem.get("upcCode"));
            disContractGoodsDomain.setSkuEocode(String.valueOf(oGoodsItem.get("skuId")));
            disContractGoodsDomain.setGoodsEocode(String.valueOf(oGoodsItem.get("skuIdIsv")));
            disContractGoodsDomain.setSkuName((String)oGoodsItem.get("name"));
            disContractGoodsDomain.setContractGoodsGtype(String.valueOf(oGoodsItem.get("adjustId")));
            disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf(((Integer)oGoodsItem.get("skuStorePrice")).intValue()));
            disContractGoodsDomain.setContractGoodsPrice(BigDecimal.valueOf(((Integer)oGoodsItem.get("skuJdPrice")).intValue()));
            BigDecimal goodsNum = BigDecimal.valueOf(((Integer)oGoodsItem.get("skuCount")).intValue());
            disContractGoodsDomain.setGoodsCamount(goodsNum);
            disContractGoodsDomain.setGoodsNum(goodsNum);
            disContractGoodsDomain.setContractGoodsInmoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
            disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getContractGoodsPrice().multiply(goodsNum));
            disContractGoodsDomain.setGoodsSpecs((String)oGoodsItem.get("skuCostumeProperty"));
            if (null == disContractGoodsDomain.getGoodsNum()) {
                disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
            if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
                disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
            if (null == disContractGoodsDomain.getContractGoodsMoney()) {
                disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
            if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
                disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == disContractGoodsDomain.getGoodsWeight()) {
                disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
            goodsDomainList.add(disContractGoodsDomain);
        }
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproValue) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == sendhttpParam) {
            return this.resultReturn("-1", "\u64cd\u4f5c\u5931\u8d25", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.error(this.SYS_CODE + "saveOrderParam : ", (Object)(sendhttpParam + " ----------\u3002"));
        String status = (String)sendhttpParam.get("statusId");
        if (StringUtils.isBlank((String)status)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.status is null!", (Object)(sendhttpParam + " ----------\u3002"));
            return this.resultReturn("-1", "\u64cd\u4f5c\u5931\u8d25", "status \u53c2\u6570\u4e3a\u7a7a");
        }
        String billId = (String)sendhttpParam.get("billId");
        if (StringUtils.isBlank((String)billId)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.billId is null!", (Object)(sendhttpParam + " ----------\u3002"));
            return this.resultReturn("-1", "\u64cd\u4f5c\u5931\u8d25", "billId \u53c2\u6570\u4e3a\u7a7a");
        }
        String timestamp = (String)sendhttpParam.get("timestamp");
        if (StringUtils.isBlank((String)timestamp)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.timestamp is null!", (Object)(sendhttpParam + " ----------\u3002"));
            return this.resultReturn("-1", "\u64cd\u4f5c\u5931\u8d25", "timestamp \u53c2\u6570\u4e3a\u7a7a");
        }
        String memberCode = (String)sendhttpParam.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.memberCode is null" + "===" + sendhttpParam.toString() + "=====" + configMap.toString() + "====" + channelApiCode);
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String tenantCode = (String)sendhttpParam.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.tenantCode is null" + "===" + sendhttpParam.toString() + "=====" + configMap.toString() + "====" + channelApiCode);
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String apiCode = "cmc.disOrder.getSendOrder";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("channelApiCode", apiCode);
        paramMap.put("contractNbillcode", billId);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        String res = (String)this.sendCall(paramMap, apiCode, memberCode, tenantCode);
        if (!"SUCCESS".equals(res)) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.res is error", (Object)("====" + res));
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        this.logger.error(this.SYS_CODE + ".saveOrderParam.res is success", (Object)("====" + res));
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }
}

