/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.order.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "jddj.DisRefundrServiceImpl";

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        return sendParam;
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            strMap.put(key, String.valueOf(map.get(key)));
        }
        return strMap;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(JdConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = HttpUtil.sendSimplePostRequest(url, sendhttpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map mtOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)mtOrderMap)) {
            return null;
        }
        if (null != mtOrderMap.get("error")) {
            throw new ApiException(this.SYS_CODE + ".sendComRefund.mtResultListOrder", (String)mtOrderMap.get("error"));
        }
        if (null == mtOrderMap.get("data")) {
            return null;
        }
        if ("cmc.disRefund.getSendRefund".equals(channelApiCode)) {
            List mapList = (List)mtOrderMap.get("data");
            if (ListUtil.isEmpty((Collection)mapList)) {
                return null;
            }
            for (Map map : mapList) {
                if (!sendhttpParam.get("refundOcode").equals((String)map.get("refund_id"))) continue;
                return this.createRefund(map, disChannel);
            }
        }
        return null;
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        try {
            return this.makeRefund(param, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".createRefund.e", (Throwable)e);
            return null;
        }
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        if (MapUtil.isEmpty(map) || null == disChannel) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        String order_id = (String)map.get("orderId");
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), order_id, disChannel);
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)order_id);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
        }
        disRefundDomain.setRefundOcode((String)map.get("afsServiceOrder"));
        String ctimeStr = (String)map.get("createTime");
        Date sendTime = null;
        if (null != ctimeStr) {
            try {
                sendTime = sdf.parse(ctimeStr);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        disRefundDomain.setRefundCreate(sendTime);
        String res_reason = (String)map.get("questionDesc");
        disRefundDomain.setRefundEx(res_reason);
        disRefundDomain.setRefundUsertype(String.valueOf(map.get("apply_type")));
        disRefundDomain.setRefundMeo((String)map.get("apply_reason"));
        disRefundDomain.setDataStatestr(String.valueOf(map.get("res_type")));
        disRefundDomain.setRefundType("B01");
        disRefundDomain.setRefundMoney(BigDecimal.valueOf((Long)map.get("afsMoney") * 100L));
        String pictures = (String)map.get("questionPic");
        disRefundDomain.setOcRefundFileDomainList(this.createFile(pictures, disRefundDomain));
        List goodlist = (List)map.get("afsDetailList");
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disRefundDomain, disContractDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisRefundDomain disRefundDomain, DisContractDomain disContractDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            return null;
        }
        Map<String, DisContractGoodsDomain> map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            for (String key : map.keySet()) {
                DisContractGoodsDomain disContractGoodsDomain = map.get(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                refundGoodsList.add(disRefundGoodsDomain);
            }
        } else {
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = map.remove(gmap.get("skuIdIsv"));
                if (null == disContractGoodsDomain) {
                    return null;
                }
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setRefundGoodsNum(BigDecimal.valueOf(((Integer)gmap.get("skuCount")).intValue()));
                disRefundGoodsDomain.setRefundGoodsPrice(BigDecimal.valueOf((Long)gmap.get("payPrice") * 100L));
                disRefundGoodsDomain.setRefundGoodsWeight(BigDecimal.valueOf(((Integer)gmap.get("skuCount")).intValue()));
                disRefundGoodsDomain.setRefundGoodsAmt(BigDecimal.valueOf((Long)gmap.get("cashMoney") * 100L));
                refundGoodsList.add(disRefundGoodsDomain);
            }
        }
        return refundGoodsList;
    }

    private DisRefundGoodsDomain create(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            return null;
        }
        DisRefundGoodsDomain disRefundGoodsDomain = new DisRefundGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundGoodsDomain, (Object)disContractGoodsDomain);
            disRefundGoodsDomain.setRefundGoodsAmt(disContractGoodsDomain.getContractGoodsMoney());
            disRefundGoodsDomain.setRefundGoodsNum(disContractGoodsDomain.getGoodsCamount());
            disRefundGoodsDomain.setRefundGoodsWeight(disContractGoodsDomain.getGoodsCweight());
            disRefundGoodsDomain.setRefundGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return disRefundGoodsDomain;
    }

    private Map<String, DisContractGoodsDomain> getMap(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty((Collection)disContractDomain.getPackageList())) {
            return null;
        }
        HashMap<String, DisContractGoodsDomain> map = new HashMap<String, DisContractGoodsDomain>();
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                map.put(disContractGoodsDomain.getSkuNo(), disContractGoodsDomain);
            }
        }
        return map;
    }

    private List<DisRefundFileDomain> createFile(String pictures, DisRefundDomain disRefundDomain) {
        if (StringUtils.isBlank((String)pictures) || null == disRefundDomain) {
            return null;
        }
        ArrayList<DisRefundFileDomain> disRefundFileDomainList = new ArrayList<DisRefundFileDomain>();
        String[] s = pictures.split("\\,");
        if (null == s || s.length == 0) {
            return null;
        }
        for (String refundFileUrl : s) {
            DisRefundFileDomain disRefundFileDomain = new DisRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disRefundFileDomain, (Object)disRefundDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
            }
            disRefundFileDomain.setRefundFileUrl(refundFileUrl);
            disRefundFileDomainList.add(disRefundFileDomain);
        }
        return disRefundFileDomainList;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return null;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == sendhttpParam) {
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String refund_id = (String)jsonToMap.get("billId");
        if (StringUtils.isBlank((String)refund_id)) {
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String page_in = (String)sendhttpParam.get("page_in");
        String status = (String)jsonToMap.get("statusId");
        String reason_code = (String)sendhttpParam.get("reason_code");
        DisRefundDomain disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), refund_id, disChannel);
        if (null == disRefundDomain) {
            if (StringUtils.isNotBlank((String)page_in) || StringUtils.isNotBlank((String)reason_code)) {
                disRefundDomain = this.getSendRefund(null, refund_id, null, disChannel.getTenantCode());
                if (null == disRefundDomain) {
                    return this.resultReturn("-1", "ERROR", "disRefundDomain");
                }
                ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
                disRefundDomainList.add(disRefundDomain);
                this.saveRefund(disRefundDomainList, disChannel);
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.createRefund(sendhttpParam, disChannel);
            if (null == disRefundDomain) {
                return this.resultReturn("-1", "ERROR", "disRefundDomain");
            }
            ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
            disRefundDomainList.add(disRefundDomain);
            this.saveRefund(disRefundDomainList, disChannel);
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        if (StringUtils.isNotBlank((String)page_in)) {
            status = disRefundDomain.getDataStatestr();
        } else {
            String stateOld;
            if (StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)reason_code)) {
                this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("1003".equals(reason_code)) {
                status = "9";
            }
            if (StringUtils.isEmpty((String)(stateOld = disRefundDomain.getDataStatestr()))) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (Integer.parseInt(status) <= Integer.parseInt(stateOld)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), status);
        if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
            dataStateStr = status;
        }
        Integer dataState = Integer.valueOf(dataStateStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataStatestr", status);
        this.updateRefund(disChannel.getTenantCode(), refund_id, dataState, null, map, disChannel);
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }
}

