/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.utils;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class HttpUtil {
    protected static final SupperLogUtil logger = new SupperLogUtil(HttpUtil.class);
    private static final String HTTP_CONTENT_CHARSET = "UTF-8";
    public static final Integer MAX_TIME_OUT = 10000;
    public static final Integer MAX_IDLE_TIME_OUT = 20000;
    public static final Long MAX_MANAGER_TIME = 1000L;
    public static final Integer MAX_CONN = 100;
    public static final HttpClient httpClient = new HttpClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendSimplePostRequest(String url, Map<String, Object> param) {
        String result = null;
        PostMethod post = new PostMethod(url);
        try {
            post.getParams().setParameter("http.protocol.content-charset", (Object)HTTP_CONTENT_CHARSET);
            if (param != null) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    if (entry.getValue() == null) continue;
                    post.addParameter(entry.getKey(), (String)entry.getValue());
                }
            }
            post.addRequestHeader(new Header("Connection", "close"));
            httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() == 200) {
                String i$ = post.getResponseBodyAsString();
                return i$;
            }
            result = "{\"code\":\"" + post.getStatusCode() + "\", \"msg\":\"" + post.getStatusText() + "\"}";
            post.abort();
        }
        catch (Exception ex) {
            logger.error("HttpUtil", (Throwable)ex);
            result = "{\"code\":\"-1\", \"msg\":\"" + ex.getMessage() + "\"}";
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendSimpleGetRequest(String url, Map<String, Object> param) {
        String result = null;
        StringBuilder sb = new StringBuilder();
        GetMethod get = null;
        try {
            String paramStr = "";
            if (param != null) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    if (entry.getValue() == null) continue;
                    sb.append(entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), "utf-8")).append("&");
                }
                paramStr = sb.toString();
                paramStr = paramStr.substring(0, paramStr.length() - 1);
            }
            get = new GetMethod(url + "?" + paramStr);
            get.getParams().setParameter("http.protocol.content-charset", (Object)HTTP_CONTENT_CHARSET);
            get.addRequestHeader(new Header("Connection", "close"));
            httpClient.executeMethod((HttpMethod)get);
            if (get.getStatusCode() == 200) {
                String string = get.getResponseBodyAsString();
                return string;
            }
            get.abort();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = "{\"code\":\"-1\", \"msg\":\"\u670d\u52a1\u5f00\u5c0f\u5dee\uff0c\u7cfb\u7edf\u52aa\u529b\u4fee\u590d\u4e2d\"}";
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return result;
    }

    static {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue());
        connectionManager.getParams().setParameter("http.connection-manager.max-total", (Object)MAX_CONN);
        httpClient.setHttpConnectionManager((HttpConnectionManager)connectionManager);
        httpClient.getParams().setIntParameter("http.socket.timeout", MAX_TIME_OUT.intValue());
        httpClient.getParams().setIntParameter("http.connection.timeout", MAX_TIME_OUT.intValue());
        httpClient.getParams().setLongParameter("http.conn-manager.timeout", MAX_MANAGER_TIME.longValue());
    }
}

