/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.order.service;

import com.yqbsoft.laser.service.ext.channel.discom.api.DisRefundService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResChannelsendDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateReplyDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsDataDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "jddj.DisOrderServiceImpl";
    DisRefundService disRefundService;

    public void setDisRefundService(DisRefundService disRefundService) {
        this.disRefundService = disRefundService;
    }

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComOrderParam", (Object)("====" + channelApiCode + "===" + sendParam.toString() + "====" + configMap.toString() + "====" + param.toString()));
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            params.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        String appKey = configMap.get("key");
        String format = configMap.get("format");
        String v = configMap.get("v");
        sendParam.put("app_key", appKey);
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        sendParam.put("timestamp", timestamp);
        sendParam.put("format", format);
        sendParam.put("v", v);
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            params.put("orderStartTime_begin", (String)param.get("start_time"));
            params.put("orderStartTime_end", (String)param.get("end_time"));
        }
        if ("cmc.disOrder.updateSendOrderPrint".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("isAgreed", "false");
            params.put("operator", (String)param.get("operator"));
            if (null == param.get("operator")) {
                params.put("operator", "\u4e2d\u53f0");
            }
        }
        if ("cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode) && (null == params.get("remark") || StringUtils.isBlank((String)params.get("remark").toString()))) {
            params.put("remark", "\u4e2d\u53f0\u53d1\u8d77\u53d6\u6d88");
        }
        if ("cmc.disOrder.updateSendOrderPickCode".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("selfPickCode", (String)param.get("selfPickCode"));
            params.put("operPin", (String)param.get("operPin"));
        }
        if ("cmc.disOrder.updateSendOrderOK".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operPin", (String)param.get("operPin"));
            params.put("operTime", (String)param.get("operTime"));
        }
        if ("cmc.disOrder.updateSendOrderAddTips".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("tips", (String)param.get("tips"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operateTime", (String)param.get("operateTime"));
        }
        if ("cmc.disOrder.updateSendOrderReceiveAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("isAgreed", "true");
            params.put("operator", (String)param.get("operator"));
            params.put("remark", (String)param.get("remark"));
        }
        if ("cmc.disOrder.updateSendOrderReceiveNoAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("isAgreed", "false");
            params.put("operator", (String)param.get("operator"));
            params.put("remark", (String)param.get("remark"));
        }
        if ("cmc.disOrder.updateSendOrderPlatDelivery".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.getSendOrderLog".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.updateSendOrderAdjust".equals(channelApiCode)) {
            ArrayList oaosAdjustDTOList = new ArrayList();
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operPin", (String)param.get("operPin"));
            params.put("remark", (String)param.get("remark"));
            HashMap<String, String> oaosAdjustDTOMap = new HashMap<String, String>();
            oaosAdjustDTOMap.put("outSkuId", "688555");
            oaosAdjustDTOMap.put("skuCount", "1");
            oaosAdjustDTOList.add(oaosAdjustDTOMap);
            params.put("oaosAdjustDTOList", oaosAdjustDTOList);
        }
        if ("cmc.disOrder.getHandleReportRecord".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.urgeDispatching".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("updatePin", (String)param.get("updatePin"));
        }
        if ("cmc.disOrder.getOrderSettlement".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.updateOrderSerllerDelivery".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.updateOrderModifySellerDelivery".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("updatePin", (String)param.get("updatePin"));
        }
        if ("cmc.disOrder.updateOrderSelfMention".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.sendOrderHandleReport".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("imgs", (String)param.get("imgs"));
        }
        if ("cmc.disOrder.getHandleReportRecord".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        sendParam.put("jd_param_json", JsonUtil.buildNormalBinder().toJson(params));
        this.logger.error(this.SYS_CODE + "." + channelApiCode, (Object)("=:= " + configMap + "=:= " + param + "=:= " + sendParam));
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, sendhttpParam);
            this.logger.error(this.SYS_CODE + "." + channelApiCode, (Object)("=:= " + json));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jdOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jdOrderMap)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        this.logger.error(this.SYS_CODE + " code : ", (Object)(channelApiCode + " ; " + jdOrderMap.get("code")));
        if (!"0".equals(jdOrderMap.get("code")) && !channelApiCode.equals("cmc.disOrder.getSendOrder")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.code", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)jdOrderMap.get("msg");
        }
        if (null == jdOrderMap.get("data")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.data", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)jdOrderMap.get("msg");
        }
        if ("cmc.disOrder.queryOrder".equals(channelApiCode) || "cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.dataMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return (String)dataMap.get("msg");
            }
            String result1 = (String)dataMap.get("result");
            Map resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result1, String.class, Object.class);
            if (MapUtil.isEmpty((Map)resultMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return (String)dataMap.get("msg");
            }
            if ("0".equals((String)resultMap.get("totalCount"))) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.totalCount is 0", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return (String)dataMap.get("msg");
            }
            List listMap = (List)resultMap.get("resultList");
            if (ListUtil.isEmpty((Collection)listMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.listMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            return this.createListOrder(listMap, disChannel);
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            String dataString = (String)jdOrderMap.get("data");
            if (StringUtils.isBlank((String)dataString)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.dataString", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(dataString, String.class, Object.class);
            if (MapUtil.isEmpty((Map)map)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.map", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            String resultMap = (String)map.get("result");
            if (StringUtils.isEmpty((String)resultMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            Map resMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultMap, String.class, Object.class);
            if (MapUtil.isEmpty((Map)resMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            List resultList = (List)resMap.get("resultList");
            if (ListUtil.isEmpty((Collection)resultList)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultList", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            Map endMap = (Map)resultList.get(0);
            if (MapUtil.isEmpty((Map)endMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.endMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            DisContractDomain disContractDomain = this.createOrder(endMap, disChannel);
            return disContractDomain;
        }
        if ("cmc.disOrder.updateSendOrderPrint".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderPrint.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderPrint.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderCanRefund".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderCanRefund.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderCanRefund.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderAccept".equals(channelApiCode) || "cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderUserAccept".equals(channelApiCode) || "cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderUserAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderUserAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderPickCode".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderPickCode.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderPickCode.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderOK".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderOK.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderOK.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderAddTips".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderAddTips.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderAddTips.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderUserCanelAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderUserCanelAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderReceiveAccept".equals(channelApiCode) || "cmc.disOrder.updateSendOrderReceiveNoAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderReceiveAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderReceiveAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderPlatDelivery".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderPlatDelivery.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderPlatDelivery.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.getSendOrderLog".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            return data;
        }
        if ("cmc.disOrder.updateSendOrderAdjust".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            return data;
        }
        if ("cmc.disOrder.getHandleReportRecord".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            return data;
        }
        if ("cmc.disOrder.commentReply".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".commentReply.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".commentReply.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.queryComment".equals(channelApiCode)) {
            String memberCname;
            this.logger.error(this.SYS_CODE, (Object)(".sendComOrder.queryComment." + json));
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".queryComment.json.dataMap", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            if (null == dataMap.get("result") || StringUtils.isBlank((String)dataMap.get("result").toString())) {
                this.logger.error(this.SYS_CODE + ".queryComment.json.dataMap.result", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            Map dataResult = (Map)dataMap.get("result");
            if (MapUtil.isEmpty((Map)dataResult)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.json.dataResult", (Object)("=:=" + json + "=:=" + sendhttpParam + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            String memberCcode = null == param.get("memberCcode") ? "" : param.get("memberCcode").toString();
            List<ResChannelsendDomain> resChannelsendDomainList = this.buildResChannelsend(dataResult, disChannel, memberCcode, memberCname = null == param.get("memberCname") ? "" : param.get("memberCname").toString());
            if (ListUtil.isEmpty(resChannelsendDomainList)) {
                this.logger.error(this.SYS_CODE + ".resChannelsendDomainList ", (Object)dataResult);
                return null;
            }
            this.saveChannelsendBatch(resChannelsendDomainList);
        } else if ("cmc.disOrder.partrefundApply".equals(channelApiCode) || "cmc.disOrder.updateSendOrderUserAccept".equals(channelApiCode)) {
            Map ocRefundDomain = (Map)param.get("ocRefundDomain");
            this.logger.error(this.SYS_CODE + ".ocRefundDomain." + channelApiCode, (Object)(ocRefundDomain + " =:= " + param));
            if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                this.logger.error(this.SYS_CODE + channelApiCode + ".ocRefundDomain ", param);
            }
            this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), "60", disChannel.getTenantCode());
        } else if ("cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode)) {
            Map ocRefundDomain = (Map)param.get("ocRefundDomain");
            if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                this.logger.error(this.SYS_CODE + ".cmc.disOrder.updateSendOrderUserNoAccept.ocRefundDomain1 ", param);
            }
            this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), "50", disChannel.getTenantCode());
        } else if ("cmc.disOrder.getSendRefundByOcode".equals(channelApiCode)) {
            this.logger.error(this.SYS_CODE, (Object)(".sendComOrder.getSendRefundByOcode." + json));
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".getSendRefundByOcode.json.dataMap", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            if (null == dataMap.get("result") || StringUtils.isBlank((String)dataMap.get("result").toString())) {
                this.logger.error(this.SYS_CODE + ".getSendRefundByOcode.json.dataMap.result", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            Map dataResult = (Map)dataMap.get("result");
            if (MapUtil.isEmpty((Map)dataResult)) {
                this.logger.error(this.SYS_CODE + ".getSendRefundByOcode.json.dataResult", (Object)("=:=" + json + "=:=" + sendhttpParam + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            return this.createRefund(dataMap, disChannel);
        }
        return null;
    }

    private List<ResChannelsendDomain> buildResChannelsend(Map<String, Object> map, DisChannel disChannel, String memberCcode, String memberCname) {
        Date date;
        if (MapUtil.isEmpty(map) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildResChannelsend ", (Object)"param is null");
            return null;
        }
        ArrayList<ResChannelsendDomain> resChannelsendDomainList = new ArrayList<ResChannelsendDomain>();
        Map<String, String> templateMap = this.fetchTemplate();
        String score3Con = null == map.get("score3Content") ? "" : (StringUtils.isNotBlank((String)map.get("score3Content").toString()) ? map.get("score3Content").toString() + ";" : "");
        String score4Con = null == map.get("score4Content") ? "" : map.get("score4Content").toString();
        ResEvaluateGoodsDomain resEvaluateGoodsDomain = new ResEvaluateGoodsDomain();
        resEvaluateGoodsDomain.setEvaluateGoodsContent(score3Con + score4Con);
        resEvaluateGoodsDomain.setEvaluateGoodsOcode(map.get("orderId").toString());
        resEvaluateGoodsDomain.setContractNbillcode(map.get("orderId").toString());
        resEvaluateGoodsDomain.setEvaluateGoodsType("order");
        this.defaultEvaluateGoods(resEvaluateGoodsDomain, disChannel, memberCcode, memberCname);
        ArrayList resEvaluateScopeDomains = new ArrayList();
        Integer score3 = null == map.get("score3") ? null : (Integer)map.get("score3");
        Integer score4 = null == map.get("score4") ? null : (Integer)map.get("score4");
        Long createTime = null == map.get("createTime") ? null : (Long)map.get("createTime");
        Date date2 = date = null == createTime ? null : new Date(createTime);
        if (null != date) {
            resEvaluateGoodsDomain.setEvaluateGoodsDate(date);
        }
        this.defaultEvaluateScope(resEvaluateScopeDomains, disChannel, score3, "score3", templateMap.get("score3"), "order");
        this.defaultEvaluateScope(resEvaluateScopeDomains, disChannel, score4, "score4", templateMap.get("score4"), "order");
        Object orgCommentContent = map.get("orgCommentContent");
        if (null != orgCommentContent && StringUtils.isNotBlank((String)((String)orgCommentContent))) {
            ArrayList<ResEvaluateReplyDomain> resEvaluateReplyDomains = new ArrayList<ResEvaluateReplyDomain>();
            Long orgCommentTime = null == map.get("orgCommentTime") ? null : (Long)map.get("orgCommentTime");
            Date orgCommentdate = null == orgCommentTime ? null : new Date(orgCommentTime);
            resEvaluateReplyDomains.add(this.defaultEvaluateReply(resEvaluateGoodsDomain, disChannel, String.valueOf(orgCommentContent), map.get("orderId").toString(), orgCommentdate));
            resEvaluateGoodsDomain.setEvaluateReplyDomainList(resEvaluateReplyDomains);
        }
        resEvaluateGoodsDomain.setEvaluateScopeList(resEvaluateScopeDomains);
        resChannelsendDomainList.add(this.makeResChannelsend(resEvaluateGoodsDomain, "add"));
        return resChannelsendDomainList;
    }

    private Map<String, String> fetchTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("score3", "\u914d\u9001\u8bc4\u5206");
        map.put("score4", "\u5546\u54c1\u670d\u52a1\u8bc4\u5206");
        return map;
    }

    private List<DisContractDomain> createListOrder(List<Map<String, Object>> list, DisChannel disChannel) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        for (Map<String, Object> map : list) {
            String tenantCode;
            String memberCode;
            if (null == map.get("jd_param_json")) continue;
            String jdParamList = this.decodeParam((String)map.get("jd_param_json"));
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
            String billId = (String)jsonToMap.get("billId");
            DisContractDomain disContractDomain = this.getSendOrder(billId, memberCode = (String)jsonToMap.get("memberCode"), tenantCode = (String)jsonToMap.get("tenantCode"));
            if (null == disContractDomain) {
                return null;
            }
            disContractDomainList.add(disContractDomain);
        }
        return disContractDomainList;
    }

    private DisContractDomain createOrder(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeOrder(param, disChannel);
    }

    private DisRefundDomain createRefundJddj2(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        if (null == disContractDomain) {
            return null;
        }
        return this.bulidRefundJddj2(disContractDomain, disChannel, map);
    }

    private DisRefundDomain bulidRefundJddj2(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        if (null == disContractDomain) {
            this.logger.info(this.SYS_CODE + ".bulidRefundJddj2", (Object)(" =:= " + disContractDomain + " =:= " + disChannel));
            return null;
        }
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".bulidRefundJddj2.copyAllPropertys", (Throwable)e);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String ctimeStr = (String)map.get("timestamp");
        try {
            disRefundDomain.setRefundCreate(sdf.parse(ctimeStr));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String res_reason = null == map.get("remark") ? null : map.get("remark").toString();
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo(res_reason);
        disRefundDomain.setDataStatestr(String.valueOf(map.get("statusId")));
        disRefundDomain.setRefundType("jddj2");
        disRefundDomain.setRefundMoney(disContractDomain.getDataBmoney());
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(null, disContractDomain, disRefundDomain));
        return disRefundDomain;
    }

    private DisRefundGoodsDomain create(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            this.logger.error(this.SYS_CODE + ".create.", (Object)"param is null");
            return null;
        }
        DisRefundGoodsDomain disRefundGoodsDomain = new DisRefundGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundGoodsDomain, (Object)disContractGoodsDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigDecimal refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
        BigDecimal allowNum = disContractGoodsDomain.getGoodsCamount().subtract(refnum);
        disRefundGoodsDomain.setRefundGoodsNum(allowNum);
        disRefundGoodsDomain.setRefundGoodsAmt(disContractGoodsDomain.getContractGoodsMoney());
        disRefundGoodsDomain.setRefundGoodsWeight(disContractGoodsDomain.getGoodsCweight());
        disRefundGoodsDomain.setRefundGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        return disRefundGoodsDomain;
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeRefund(param, disChannel);
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        String orderId = map.get("orderId").toString();
        disRefundDomain.setContractNbillcode(orderId);
        disRefundDomain.setRefundOcode(map.get("afsServiceOrder").toString());
        disRefundDomain.setDataStatestr(map.get("afsServiceState").toString());
        String createTime = (String)map.get("createTime");
        Date refundTime = null;
        if (null != createTime && Long.valueOf(createTime) > 0L) {
            refundTime = StringUtils.isNotBlank((String)createTime) ? new Date(Long.valueOf(createTime)) : null;
        }
        disRefundDomain.setRefundCreate(refundTime);
        disRefundDomain.setRefundEx(map.get("questionTypeCid").toString());
        disRefundDomain.setRefundMeo(map.get("questionDesc").toString());
        disRefundDomain.setRefundUsertype("0");
        if (null != map.get("photos") && ListUtil.isNotEmpty((Collection)((Collection)map.get("questionPic")))) {
            List listStr = (List)map.get("photos");
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        String refundPrice = String.valueOf(map.get("cashMoney"));
        List goodlist = (List)map.get("afsDetailList");
        if (ListUtil.isEmpty((Collection)goodlist)) {
            this.logger.error(this.SYS_CODE + ".goodsList jddj1", map);
            return null;
        }
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel);
        if (null != disContractDomain) {
            disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode(), disChannel);
        }
        disRefundDomain.setRefundType("jddj1");
        disRefundDomain.setRefundMoney(null == refundPrice ? BigDecimal.ZERO : new BigDecimal(refundPrice).divide(new BigDecimal("100")).setScale(2, 4));
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disContractDomain, disRefundDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(goodlist + "=:=" + disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            for (String key : map.keySet()) {
                BigDecimal refnum;
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
                if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                    refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                refundGoodsList.add(disRefundGoodsDomain);
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
            }
            disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
        } else {
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(gmap.get("skuIdIsv"));
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                Integer skuCount = null == gmap.get("skuCount") ? null : (Integer)gmap.get("skuCount");
                BigDecimal number = null == skuCount ? BigDecimal.ZERO : BigDecimal.valueOf(skuCount.intValue());
                Long cashMoney = null == gmap.get("cashMoney") ? null : (Long)gmap.get("cashMoney");
                BigDecimal totalRefund = null == cashMoney ? BigDecimal.ZERO : BigDecimal.valueOf(cashMoney).divide(new BigDecimal("100")).setScale(2, 4);
                disRefundGoodsDomain.setRefundGoodsNum(number);
                disRefundGoodsDomain.setRefundGoodsPrice(totalRefund.divide(number).setScale(2, 4));
                disRefundGoodsDomain.setRefundGoodsAmt(totalRefund);
                disRefundGoodsDomain.setRefundGoodsWeight(number);
                refundGoodsList.add(disRefundGoodsDomain);
            }
        }
        return refundGoodsList;
    }

    private DisContractDomain makeOrder(Map<String, Object> map, DisChannel disChannel) {
        Map orderInvoiceMap;
        String refundStatus;
        String dataState;
        String phone;
        if (null == map || null == disChannel) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DisContractDomain disContractDomain = new DisContractDomain();
        disContractDomain.setGoodsReceiptArrdess((String)map.get("buyerFullAddress"));
        disContractDomain.setChannelCode(disChannel.getChannelCode());
        disContractDomain.setChannelName(disChannel.getChannelName());
        disContractDomain.setTenantCode(disChannel.getTenantCode());
        String activeAt = (String)map.get("orderStartTime");
        String deliverTime = (String)map.get("orderPreEndDeliveryTime");
        String confirmCookingTime = (String)map.get("pickDeadline");
        disContractDomain.setContractPumode("9999".equals((String)map.get("deliveryCarrierNo")) ? "1" : "0");
        disContractDomain.setPackageBillno((String)map.get("deliveryBillNo"));
        disContractDomain.setFchannelCode(String.valueOf((Integer)map.get("payChannel")));
        if (null != map.get("payChannel")) {
            disContractDomain.setFaccountName(this.payType((Integer)map.get("payChannel")));
        }
        try {
            disContractDomain.setContractValidate(StringUtils.isNotBlank((String)activeAt) ? sdf.parse(activeAt) : null);
            disContractDomain.setContractEffectivedate(StringUtils.isNotBlank((String)deliverTime) ? sdf.parse(deliverTime) : null);
            disContractDomain.setGmtVaild(StringUtils.isNotBlank((String)confirmCookingTime) ? sdf.parse(confirmCookingTime) : null);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (null != map.get("orderFreightMoney")) {
            disContractDomain.setGoodsLogmoney(BigDecimal.valueOf(((Integer)map.get("orderFreightMoney")).intValue()).divide(new BigDecimal(100)));
        }
        if (null != map.get("orderBuyerRemark")) {
            disContractDomain.setContractRemark((String)map.get("orderBuyerRemark"));
        }
        List list = (List)map.get("product");
        disContractDomain.setContractTypepro("01");
        disContractDomain.setContractType("21");
        disContractDomain.setContractPmode("1");
        if (null != map.get("orderPayType") && 1 == (Integer)map.get("orderPayType")) {
            disContractDomain.setContractPmode("0");
        }
        if (null != map.get("orderId")) {
            disContractDomain.setContractNbillcode(String.valueOf(map.get("orderId")));
        }
        String string = phone = null == map.get("buyerMobile") ? null : map.get("buyerMobile").toString();
        if (StringUtils.isNotBlank((String)phone)) {
            if (phone.contains(",")) {
                phone = phone.replace(",", "\u8f6c");
            }
            disContractDomain.setGoodsReceiptPhone(phone);
        }
        String memberCcode = this.getMemberCode(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("deliveryStationNo")));
        disContractDomain.setMemberCode(disChannel.getMemberCode());
        disContractDomain.setMemberName(disChannel.getMemberName());
        disContractDomain.setMemberCcode(memberCcode);
        if (null != map.get("deliveryStationName")) {
            disContractDomain.setMemberCname((String)map.get("deliveryStationName"));
        }
        this.setContractPro(disContractDomain, "daySn", String.valueOf(map.get("orderNum")), "\u5f53\u5929\u95e8\u5e97\u8ba2\u5355\u5e8f\u53f7");
        if (null != map.get("orderStatus")) {
            disContractDomain.setDataStatestr(String.valueOf(map.get("orderStatus")));
        }
        if (null != (dataState = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("orderStatus"))))) {
            disContractDomain.setDataState(Integer.valueOf(Integer.parseInt(dataState)));
        }
        if (("20020".equals(String.valueOf(map.get("orderStatus"))) || "20030".equals(String.valueOf(map.get("orderStatus"))) || "20040".equals(String.valueOf(map.get("orderStatus"))) || "20060".equals(String.valueOf(map.get("orderStatus")))) && null != (refundStatus = this.getRefundFlag(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)map.get("refundStatus")))) {
            disContractDomain.setRefundFlag(Integer.valueOf(Integer.parseInt(refundStatus)));
        }
        if (null != map.get("orderBuyerPayableMoney")) {
            disContractDomain.setDataBmoney(BigDecimal.valueOf(((Integer)map.get("orderBuyerPayableMoney")).intValue()).divide(new BigDecimal(100), 2, 4));
            disContractDomain.setContractMoney(disContractDomain.getDataBmoney());
        }
        if (null != map.get("orderTotalMoney")) {
            disContractDomain.setContractInmoney(BigDecimal.valueOf(((Integer)map.get("orderTotalMoney")).intValue()).divide(new BigDecimal(100), 2, 4));
        }
        if (null != map.get("orderDiscountMoney")) {
            disContractDomain.setGoodsPmoney(BigDecimal.valueOf(((Integer)map.get("orderDiscountMoney")).intValue()).divide(new BigDecimal(100), 2, 4));
        }
        if (null != map.get("buyerFullName")) {
            disContractDomain.setGoodsReceiptMem((String)map.get("buyerFullName"));
        }
        BigDecimal sumskuNum = BigDecimal.ZERO;
        BigDecimal sumskuWeight = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((Collection)list)) {
            for (Map OrderProductDTO2 : list) {
                Object skuWeight;
                if (null != OrderProductDTO2.get("skuCount")) {
                    sumskuNum = sumskuNum.add(BigDecimal.valueOf(((Integer)OrderProductDTO2.get("skuCount")).intValue()));
                }
                if (null == (skuWeight = OrderProductDTO2.get("skuWeight"))) continue;
                sumskuWeight = sumskuWeight.add(new BigDecimal(String.valueOf(skuWeight)));
            }
        }
        disContractDomain.setGoodsWeight(sumskuWeight);
        disContractDomain.setDataBweight(sumskuWeight);
        disContractDomain.setGoodsNum(sumskuNum);
        disContractDomain.setDataBnum(sumskuNum);
        this.setContractPro(disContractDomain, "carrierNo", (String)map.get("deliveryCarrierNo"), "\u627f\u8fd0\u5546\u7f16\u53f7");
        this.setContractPro(disContractDomain, "carrierName", (String)map.get("deliveryCarrierName"), "\u627f\u8fd0\u5546\u540d\u79f0");
        if (null != map.get("merchantPaymentDistanceFreightMoney")) {
            this.setContractPro(disContractDomain, "freightMoney", BigDecimal.valueOf(((Integer)map.get("merchantPaymentDistanceFreightMoney")).intValue()).divide(new BigDecimal(100)).toString(), "\u5546\u5bb6\u652f\u4ed8\u8fdc\u8ddd\u79bb\u8fd0\u8d39");
        }
        if (null != map.get("orderReceivableFreight")) {
            this.setContractPro(disContractDomain, "orderReceivableFreight", BigDecimal.valueOf(((Integer)map.get("orderReceivableFreight")).intValue()).divide(new BigDecimal(100)).toString(), "\u8ba2\u5355\u5e94\u6536\u8fd0\u8d39");
        }
        if (null != map.get("platformPointsDeductionMoney")) {
            this.setContractPro(disContractDomain, "deductionMoney", BigDecimal.valueOf(((Integer)map.get("platformPointsDeductionMoney")).intValue()).divide(new BigDecimal(100)).toString(), "\u7528\u6237\u79ef\u5206\u62b5\u6263\u91d1\u989d");
        }
        if (null != map.get("packagingMoney")) {
            BigDecimal bd = BigDecimal.valueOf(((Integer)map.get("packagingMoney")).intValue()).divide(new BigDecimal(100));
            this.setContractPro(disContractDomain, "packagingMoney", bd.toString(), "\u5305\u88c5\u91d1\u989d");
            disContractDomain.setContractPaymoney(bd);
        }
        if (null != map.get("tips")) {
            this.setContractPro(disContractDomain, "tips", BigDecimal.valueOf(((Integer)map.get("tips")).intValue()).divide(new BigDecimal(100)).toString(), "\u5546\u5bb6\u7ed9\u914d\u9001\u5458\u52a0\u7684\u5c0f\u8d39");
        }
        if (null != map.get("buyerLng")) {
            this.setContractPro(disContractDomain, "buyerLng", BigDecimal.valueOf((Double)map.get("buyerLng")).divide(new BigDecimal(100)).toString(), "\u6536\u8d27\u4eba\u5730\u5740\u817e\u8baf\u5750\u6807\u7ecf\u5ea6");
        }
        if (null != map.get("buyerLat")) {
            this.setContractPro(disContractDomain, "buyerLat", BigDecimal.valueOf((Double)map.get("buyerLat")).divide(new BigDecimal(100)).toString(), "\u6536\u8d27\u4eba\u5730\u5740\u817e\u8baf\u5750\u6807\u7eac\u5ea6");
        }
        if (null != map.get("buyerCityName")) {
            this.setContractPro(disContractDomain, "buyerCityName", (String)map.get("buyerCityName"), "\u6536\u8d27\u4eba\u5e02\u540d\u79f0");
        }
        if (null != map.get("buyerCountryName")) {
            this.setContractPro(disContractDomain, "buyerCountryName", (String)map.get("buyerCountryName"), "\u6536\u8d27\u4eba\u53bf(\u533a)\u540d\u79f0");
        }
        if (null != map.get("orderBuyerRemark")) {
            this.setContractPro(disContractDomain, "buyerRemark", (String)map.get("orderBuyerRemark"), "\u8ba2\u5355\u4e70\u5bb6\u5907\u6ce8");
        }
        if (null != map.get("businessTag")) {
            this.setContractPro(disContractDomain, "businessTag", (String)map.get("businessTag"), "\u4e1a\u52a1\u6807\u8bc6");
        }
        if (null != map.get("equipmentId")) {
            this.setContractPro(disContractDomain, "equipmentId", (String)map.get("equipmentId"), "\u8bbe\u5907id");
        }
        if (null != map.get("buyerPoi")) {
            this.setContractPro(disContractDomain, "buyerPoi", (String)map.get("buyerPoi"), "\u6536\u8d27\u4ebaPOI\u4fe1\u606f");
        }
        if (null != map.get("orderNum")) {
            this.setContractPro(disContractDomain, "orderNum", String.valueOf((Integer)map.get("orderNum")), "\u5f53\u5929\u95e8\u5e97\u8ba2\u5355\u5e8f\u53f7");
        }
        if (null != map.get("userTip")) {
            this.setContractPro(disContractDomain, "userTip", String.valueOf((Integer)map.get("userTip")), "\u7528\u6237\u5c0f\u8d39");
        }
        if (null != map.get("businessType")) {
            this.setContractPro(disContractDomain, "businessType", String.valueOf((Integer)map.get("businessType")), "\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b");
        }
        if (MapUtil.isNotEmpty((Map)(orderInvoiceMap = (Map)map.get("orderInvoice")))) {
            String invoiceTitle = null == orderInvoiceMap.get("invoiceTitle") ? null : (String)orderInvoiceMap.get("invoiceTitle");
            String invoiceDutyNo = null == orderInvoiceMap.get("invoiceDutyNo") ? null : (String)orderInvoiceMap.get("invoiceDutyNo");
            String invoiceMoneyDetail = null == orderInvoiceMap.get("invoiceMoneyDetail") ? null : (String)orderInvoiceMap.get("invoiceMoneyDetail");
            String money = StringUtils.isNotBlank((String)invoiceMoneyDetail) ? invoiceMoneyDetail : String.valueOf(disContractDomain.getDataBmoney());
            disContractDomain.setContractInvoice(invoiceTitle + " ; " + invoiceDutyNo + " ; " + money);
            String orderType = "";
            while (0 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4e2a\u4eba";
            }
            while (1 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4f01\u4e1a\u666e\u7968";
            }
            while (2 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4f01\u4e1a\u4e13\u7968";
            }
            String str = "{  \"invoiceType\":" + orderType + ",\"invoiceTitle\":" + invoiceTitle + ",\"taxerId\":" + invoiceDutyNo + "}";
            disContractDomain.setContractInvoicestr(str);
        }
        if ("20020".equals(String.valueOf(map.get("orderStatus"))) || "20030".equals(String.valueOf(map.get("orderStatus"))) || "20040".equals(String.valueOf(map.get("orderStatus"))) || "20060".equals(String.valueOf(map.get("orderStatus")))) {
            if (null != map.get("orderStatus")) {
                this.setContractPro(disContractDomain, "cancelOrderDescription", String.valueOf(map.get("orderStatus")), "\u7528\u6237\u53d6\u6d88\u539f\u56e0");
            }
            if (null != map.get("orderCancelTime")) {
                this.setContractPro(disContractDomain, "cancelOrderCreatedAt", map.get("orderCancelTime").toString(), "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u65f6\u95f4");
            }
        }
        disContractDomain.setContractProperty("0");
        if (null != map.get("isGroupon") && ((Boolean)map.get("isGroupon")).booleanValue()) {
            disContractDomain.setContractProperty("1");
        }
        if (!"0".equals(String.valueOf(map.get("orderStatus")))) {
            disContractDomain.setContractProperty("2");
        }
        List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(list, disContractDomain);
        disContractDomain.setPackageList(disPackageDomains);
        return disContractDomain;
    }

    private List<DisPackageDomain> makeDisPackageDomain(List<Map<String, Object>> goodGroup, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(goodGroup)) {
            return null;
        }
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = new DisPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
        }
        List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(goodGroup, pag, disContractDomain);
        pag.setContractGoodsList(goodsList);
        disContractDomain.setGoodsMoney(pag.getGoodsInmoney());
        disContractDomain.setGoodsNum(pag.getGoodsNum());
        disContractDomain.setDataBnum(pag.getGoodsNum());
        disContractDomain.setGoodsWeight(pag.getGoodsWeight());
        disContractDomain.setDataBweight(pag.getGoodsWeight());
        rePagList.add(pag);
        return rePagList;
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(List<Map<String, Object>> items, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(items)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (Map<String, Object> oGoodsItem : items) {
            disContractGoodsDomain = new DisContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
            }
            GoodsBean goodsBean = this.getResourceBySkuNo((String)oGoodsItem.get("skuIdIsv"), disContractDomain.getMemberCode(), disContractDomain.getMemberCcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode());
            if (null != goodsBean && null != goodsBean.getRsSku()) {
                disContractGoodsDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
            }
            disContractGoodsDomain.setSkuNo((String)oGoodsItem.get("skuIdIsv"));
            disContractGoodsDomain.setSkuEocode(String.valueOf(oGoodsItem.get("skuId")));
            disContractGoodsDomain.setGoodsEocode(String.valueOf(oGoodsItem.get("skuIdIsv")));
            disContractGoodsDomain.setSkuName((String)oGoodsItem.get("skuName"));
            disContractGoodsDomain.setGoodsName((String)oGoodsItem.get("skuName"));
            disContractGoodsDomain.setContractGoodsGtype("0");
            disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf(((Integer)oGoodsItem.get("skuStorePrice")).intValue()).divide(new BigDecimal(100)));
            disContractGoodsDomain.setContractGoodsPrice(BigDecimal.valueOf(((Integer)oGoodsItem.get("skuJdPrice")).intValue()).divide(new BigDecimal(100)));
            if (null == disContractGoodsDomain.getContractGoodsPrice() || disContractGoodsDomain.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0) {
                disContractGoodsDomain.setContractGoodsPrice(disContractGoodsDomain.getPricesetNprice());
            }
            BigDecimal goodsNum = BigDecimal.valueOf(((Integer)oGoodsItem.get("skuCount")).intValue());
            Object skuWeight = oGoodsItem.get("skuWeight");
            BigDecimal goodsWeight = new BigDecimal(String.valueOf(skuWeight));
            disContractGoodsDomain.setGoodsCamount(goodsNum);
            disContractGoodsDomain.setGoodsNum(goodsNum);
            disContractGoodsDomain.setGoodsCweight(goodsWeight);
            disContractGoodsDomain.setGoodsWeight(goodsWeight);
            disContractGoodsDomain.setContractGoodsInmoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
            disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getContractGoodsPrice().multiply(goodsNum));
            disContractGoodsDomain.setGoodsSpecs((String)oGoodsItem.get("skuCostumeProperty"));
            if (null == disContractGoodsDomain.getGoodsNum()) {
                disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
            if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
                disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
            if (null == disContractGoodsDomain.getContractGoodsMoney()) {
                disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
            if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
                disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == disContractGoodsDomain.getGoodsWeight()) {
                disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
            goodsDomainList.add(disContractGoodsDomain);
        }
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney);
        disPackageDomain.setGoodsInmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproValue) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + "saveOrderParam.come====", (Object)sendhttpParam.toString());
        if (null == sendhttpParam) {
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        if (null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        if ("afterSaleBillStatus".equals(methodType)) {
            return this.disRefundService.saveSendRefundState(sendhttpParam);
        }
        if (null == jsonToMap.get("billId") && null == jsonToMap.get("statusId") && null == jsonToMap.get("timestamp")) {
            if (null == jsonToMap.get("orderId")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.orderId is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String orderId = (String)jsonToMap.get("orderId");
            if (null == jsonToMap.get("deliveryStatus")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatus is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String deliveryStatus = (String)jsonToMap.get("deliveryStatus");
            if (null == jsonToMap.get("deliveryStatusTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatusTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierNo")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierNo is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierName")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierName is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("createPin")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.createPin is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("opTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.opTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(orderId, (String)sendhttpParam.get("memberCode"), (String)sendhttpParam.get("tenantCode"));
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("32000".equals(deliveryStatus)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), deliveryStatus);
            if ("33060".equals(dataStateStr) || "20020".equals(dataStateStr)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(deliveryStatus);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", deliveryStatus);
            try {
                this.updateOrder(disChannel.getTenantCode(), orderId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".updateOrder000 result is error");
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        if (null != jsonToMap.get("billId") && null != jsonToMap.get("statusId") && null != jsonToMap.get("timestamp")) {
            DisRefundDomain disRefundDomain;
            String msgStatusId;
            String msgBillId;
            String billId = (String)jsonToMap.get("billId");
            String statusId = (String)jsonToMap.get("statusId");
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(billId, (String)sendhttpParam.get("memberCode"), (String)sendhttpParam.get("tenantCode"));
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("pushDeliveryStatus".equals(methodType)) {
                String orderId;
                String string = orderId = null == param.get("orderId") ? null : param.get("orderId").toString();
                if (StringUtils.isBlank((String)orderId)) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam.pushDeliveryStatus.orderId . ", (Object)jsonToMap);
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                SgSendgoodsReDomain sgSendgoodsReDomain = this.getSendgoodsReDomainByNbbillcode(disChannel.getTenantCode(), orderId);
                if (null == sgSendgoodsReDomain) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam.pushDeliveryStatus.sgSendgoodsReDomain . ", (Object)(disChannel.getTenantCode() + " : " + orderId));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                ArrayList<SgSendgoodsLogDomain> sgSendgoodsLogDomainList = new ArrayList<SgSendgoodsLogDomain>();
                SgSendgoodsLogDomain sgSendgoodsLogDomain = new SgSendgoodsLogDomain();
                sgSendgoodsLogDomain.setSendgoodsLogMem(param.get("deliveryManName").toString());
                sgSendgoodsLogDomain.setSendgoodsLogPhone(param.get("deliveryManPhone").toString());
                sgSendgoodsLogDomain.setSendgoodsCode(sgSendgoodsReDomain.getSendgoodsCode());
                sgSendgoodsLogDomain.setContractBillcode(sgSendgoodsReDomain.getContractBillcode());
                sgSendgoodsLogDomain.setContractBbillcode(sgSendgoodsReDomain.getContractBbillcode());
                sgSendgoodsLogDomain.setContractNbbillcode(sgSendgoodsReDomain.getContractNbbillcode());
                sgSendgoodsLogDomain.setContractObillcode(sgSendgoodsReDomain.getContractObillcode());
                sgSendgoodsLogDomain.setContractNbillcode(sgSendgoodsReDomain.getContractNbillcode());
                String str = this.getDelStatus().get(statusId);
                if (StringUtils.isNotBlank((String)str)) {
                    sgSendgoodsLogDomain.setRemark(str);
                }
                sgSendgoodsLogDomainList.add(sgSendgoodsLogDomain);
                String localStatus = this.getSgSendgoodsState(disChannel.getTenantCode(), disChannel.getChannelCode(), statusId);
                SgSendgoodsDataDomain sgDataDomain = this.makeSgSendgoodsData(sgSendgoodsReDomain, sgSendgoodsLogDomainList, localStatus, "DisSgSendgoods");
                SgSendgoodsDataDomain sgDataDomain1 = this.makeSgSendgoodsData(sgSendgoodsReDomain, sgSendgoodsLogDomainList, localStatus, "DisSendGoodsNotice");
                ArrayList<SgSendgoodsDataDomain> sgSendgoodsDataDomainList = new ArrayList<SgSendgoodsDataDomain>();
                sgSendgoodsDataDomainList.add(sgDataDomain);
                sgSendgoodsDataDomainList.add(sgDataDomain1);
                this.sendSaveSgSendGoodsState(sgSendgoodsDataDomainList);
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("newApplyAfterSaleBill".equals(methodType)) {
                msgBillId = null == param.get("billId") ? null : param.get("billId").toString();
                String string = msgStatusId = null == param.get("statusId") ? null : param.get("statusId").toString();
                if (StringUtils.isBlank((String)msgBillId) || StringUtils.isBlank((String)msgStatusId)) {
                    this.logger.error(this.SYS_CODE + ".newApplyAfterSaleBill:", (Object)("msgBillId:" + msgBillId + ";msgStatusId:" + msgStatusId));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                disRefundDomain = this.getSendRefundByOcode(msgBillId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode());
                if (null == disRefundDomain) {
                    this.logger.error(this.SYS_CODE + ".disRefundDomain.", (Object)(msgBillId + "=:=" + sendhttpParam + "=:=" + disChannel.getTenantCode()));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
            }
            if ("afterSaleBillStatus".equals(methodType)) {
                msgBillId = null == param.get("billId") ? null : param.get("billId").toString();
                String string = msgStatusId = null == param.get("statusId") ? null : param.get("statusId").toString();
                if (StringUtils.isBlank((String)msgBillId) || StringUtils.isBlank((String)msgStatusId)) {
                    this.logger.error(this.SYS_CODE + ".afterSaleBillStatus:", (Object)("msgBillId:" + msgBillId + ";msgStatusId:" + msgStatusId));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                disRefundDomain = this.getSendRefundByOcode(msgBillId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode());
                if (null == disRefundDomain) {
                    this.logger.error(this.SYS_CODE + ".afterSaleBillStatus.disRefundDomain.", (Object)(msgBillId + "=:=" + sendhttpParam + "=:=" + disChannel.getTenantCode()));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                HashMap<String, String> mapP = new HashMap<String, String>();
                mapP.put("dataStatestr", msgStatusId);
                this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(msgStatusId), disRefundDomain.getDataState(), mapP);
            }
            if ("applyCancelOrder".equals(methodType)) {
                msgBillId = null == param.get("billId") ? null : param.get("billId").toString();
                String string = msgStatusId = null == param.get("statusId") ? null : param.get("statusId").toString();
                if (StringUtils.isBlank((String)msgBillId) || StringUtils.isBlank((String)msgStatusId)) {
                    this.logger.error(this.SYS_CODE + ".applyCancelOrder:", (Object)("msgBillId:" + msgBillId + ";msgStatusId:" + msgStatusId));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                if ("20030".equals(msgStatusId)) {
                    DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), msgBillId, disChannel);
                    if (null == disContractDomain) {
                        disContractDomain = this.getSendOrder(msgBillId, (String)sendhttpParam.get("memberCode"), (String)sendhttpParam.get("tenantCode"));
                        if (null == disContractDomain) {
                            this.logger.error(this.SYS_CODE + ".applyCancelOrder.", (Object)msgBillId);
                            return this.resultReturn("-1", "ERROR", "jd_param_json");
                        }
                        ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                        disContractList.add(disContractDomain);
                        this.saveOrder(disContractList, disChannel);
                        disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), msgBillId, disChannel);
                    }
                    if (null == (disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode(), disChannel))) {
                        this.logger.error(this.SYS_CODE + ".applyCancelOrder", (Object)msgBillId);
                        return null;
                    }
                    this.createRefundJddj2(disContractDomain, disChannel, this.getQueryParamMap("billId,statusId,remark,timestamp", new Object[]{msgBillId, msgStatusId, param.get("remark"), param.get("timestamp")}));
                }
            }
            if ("32000".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), statusId);
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(statusId);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", statusId);
            try {
                this.updateOrder(disChannel.getTenantCode(), billId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }

    private Map<String, String> getDelStatus() {
        HashMap<String, String> delStatus = new HashMap<String, String>();
        delStatus.put("10", "\u7b49\u5f85\u62a2\u5355");
        delStatus.put("20", "\u5df2\u62a2\u5355");
        delStatus.put("21", "\u914d\u9001\u5458\u53d6\u6d88\u62a2\u5355\uff0c\u7b49\u5f85\u91cd\u65b0\u62a2\u5355");
        delStatus.put("22", "\u66f4\u6362\u914d\u9001\u5458");
        delStatus.put("23", "\u914d\u9001\u5458\u5df2\u5230\u5e97");
        delStatus.put("25", "\u53d6\u8d27\u5931\u8d25");
        delStatus.put("26", "\u53d6\u8d27\u5931\u8d25\u5ba1\u6838\u9a73\u56de");
        delStatus.put("27", "\u53d6\u8d27\u5931\u8d25\u5f85\u5ba1\u6838");
        delStatus.put("30", "\u53d6\u8d27\u5b8c\u6210");
        delStatus.put("35", "\u6295\u9012\u5931\u8d25");
        delStatus.put("40", "\u5df2\u5b8c\u6210");
        return delStatus;
    }

    private String payType(Integer payChannel) {
        if (null == payChannel) {
            this.logger.error(this.SYS_CODE + ".payType", (Object)"param is null");
            return null;
        }
        String faccountName = "";
        switch (payChannel) {
            case 8001: {
                faccountName = "\u5fae\u4fe1\u652f\u4ed8";
                break;
            }
            case 8002: {
                faccountName = "\u5fae\u4fe1\u514d\u5bc6\u4ee3\u6263";
                break;
            }
            case 8003: {
                faccountName = "\u5fae\u4fe1\u627e\u4eba\u4ee3\u4ed8";
                break;
            }
            case 9000: {
                faccountName = "\u4eac\u4e1c\u652f\u4ed8";
                break;
            }
            case 9002: {
                faccountName = "\u4eac\u4e1c\u94f6\u884c\u5361\u652f\u4ed8";
                break;
            }
            case 9004: {
                faccountName = "\u4eac\u4e1c\u767d\u6761\u652f\u4ed8";
                break;
            }
            case 9012: {
                faccountName = "\u4eac\u4e1c\u4f59\u989d\u652f\u4ed8";
                break;
            }
            case 9022: {
                faccountName = "\u4eac\u4e1c\u5c0f\u91d1\u5e93\u652f\u4ed8";
                break;
            }
            default: {
                faccountName = "\u5176\u4ed6\u65b9\u5f0f\u652f\u4ed8";
            }
        }
        return faccountName;
    }

    private void creatOrder(DisChannel disChannel, Map<String, Object> sendhttpParam) {
        DisContractDomain disContractDomain = this.createOrder(sendhttpParam, disChannel);
        if (null == disContractDomain) {
            return;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        disContractDomainList.add(disContractDomain);
        try {
            this.saveOrder(disContractDomainList, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".creatOrder", (Object)("====" + disChannel.toString() + "#########" + disContractDomain.toString() + "@@@@@@@@@" + sendhttpParam.toString() + "----------"));
        }
    }
}

