/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.order.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefund;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "jddj.DisRefundrServiceImpl";

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComRefundParam", (Object)("=:=" + channelApiCode + "=:=" + sendParam.toString() + "=:=" + configMap.toString() + "=:=" + param.toString()));
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            params.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        String appKey = configMap.get("key");
        String format = configMap.get("format");
        String v = configMap.get("v");
        sendParam.put("app_key", appKey);
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        sendParam.put("timestamp", timestamp);
        sendParam.put("format", format);
        sendParam.put("v", v);
        if ("cmc.disRefund.updateSendRefund".equals(channelApiCode) || "cmc.disRefund.updateSendRefundCannel".equals(channelApiCode)) {
            if (null == params.get("approveType")) {
                this.logger.error(this.SYS_CODE + ".refund:", (Object)(params + "=:=" + sendParam + "=:=" + param));
                return null;
            }
            if (null == params.get("serviceOrder") || StringUtils.isBlank((String)params.get("serviceOrder").toString())) {
                Map ocRefundDomain = (Map)param.get("ocRefundDomain");
                if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                    this.logger.error(this.SYS_CODE + ".buildComOrderParam.updateSendRefund." + param);
                    return null;
                }
                params.put("serviceOrder", ocRefundDomain.get("refundOcode"));
            }
            if ("3".equals(params.get("approveType")) && (null == params.get("rejectReason") || StringUtils.isBlank((String)params.get("rejectReason").toString()))) {
                this.logger.error(this.SYS_CODE + ".approveType=3", (Object)(params + "=:=" + sendParam + "=:=" + param));
                return null;
            }
        }
        sendParam.put("jd_param_json", JsonUtil.buildNormalBinder().toJson(params));
        this.logger.error(this.SYS_CODE + "." + channelApiCode, (Object)(params + "=:= " + configMap + "=:= " + param + "=:= " + sendParam));
        return sendParam;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, sendhttpParam);
            this.logger.error(this.SYS_CODE + "." + channelApiCode, (Object)("=:= " + json));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jdOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jdOrderMap)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        this.logger.error(this.SYS_CODE + " code : ", (Object)(channelApiCode + " ; " + jdOrderMap.get("code")));
        if (!"0".equals(jdOrderMap.get("code")) && !channelApiCode.equals("cmc.disOrder.getSendOrder")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.code", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)jdOrderMap.get("msg");
        }
        if (null == jdOrderMap.get("data")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.data", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)jdOrderMap.get("msg");
        }
        if ("cmc.disRefund.getSendRefund".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap) || null == dataMap.get("result") || StringUtils.isBlank((String)dataMap.get("result").toString())) {
                this.logger.error(this.SYS_CODE + ".getSendRefundByOcode.json.dataMap", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            Map dataResult = (Map)dataMap.get("result");
            if (MapUtil.isEmpty((Map)dataResult)) {
                this.logger.error(this.SYS_CODE + ".getSendRefundByOcode.json.dataResult", (Object)("=:=" + json + "=:=" + sendhttpParam + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            DisRefundDomain disRefundDomain = this.createRefund(dataResult, disChannel);
            this.logger.error(this.SYS_CODE + ". disRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
            ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
            disRefundDomainList.add(disRefundDomain);
            this.logger.error(this.SYS_CODE + " disRefundDomainList : ", (Object)(disRefundDomainList.size() + " ==== " + disRefundDomainList));
            this.saveRefund(disRefundDomainList, disChannel);
            return disRefundDomain;
        }
        if ("cmc.disRefund.updateSendRefund".equals(channelApiCode)) {
            Map ocRefundDomain = (Map)param.get("ocRefundDomain");
            if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                this.logger.error(this.SYS_CODE + ".cmc.disOrder.partrefundApply.ocRefundDomain1 ", param);
            }
            this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), "32", disChannel.getTenantCode());
        } else if ("cmc.disRefund.updateSendRefundCannel".equals(channelApiCode)) {
            Map ocRefundDomain = (Map)param.get("ocRefundDomain");
            if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                this.logger.error(this.SYS_CODE + ".cmc.disOrder.partrefundApply.ocRefundDomain1 ", param);
            }
            this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), "33", disChannel.getTenantCode());
        }
        return null;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        DisRefundDomain disRefundDomain;
        this.logger.error(this.SYS_CODE + "......", (Object)(sendhttpParam + "=:=" + configMap + "=:=" + param));
        if (null == sendhttpParam || null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        String billId = (String)jsonToMap.get("billId");
        String statusId = (String)jsonToMap.get("statusId");
        if ("newApplyAfterSaleBill".equals(methodType) || "newAfterSaleBill".equals(methodType)) {
            if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                this.logger.error(this.SYS_CODE + ".newApplyAfterSaleBill:", (Object)("billId:" + billId + ";statusId:" + statusId));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), billId, disChannel);
            if (null == disRefundDomain && null == (disRefundDomain = this.getSendRefund(null, billId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode()))) {
                this.logger.error(this.SYS_CODE + ".disRefundDomain.", (Object)(billId + "=:=" + sendhttpParam + "=:=" + disChannel.getTenantCode()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        if ("afterSaleBillStatus".equals(methodType)) {
            OcRefund ocRefund;
            if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                this.logger.error(this.SYS_CODE + ".afterSaleBillStatus:", (Object)("billId:" + billId + ";statusId:" + statusId));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), billId, disChannel);
            if (null == disRefundDomain && null == (disRefundDomain = this.getSendRefund(null, billId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode()))) {
                this.logger.error(this.SYS_CODE + ".afterSaleBillStatus.", (Object)("disRefundDomain is null" + billId + "=:=" + sendhttpParam.get("memberCode")));
                return this.resultReturn("-1", "ERROR", "jd_param_json");
            }
            HashMap<String, String> mapP = new HashMap<String, String>();
            mapP.put("dataStatestr", statusId);
            this.updateRefund(disChannel.getTenantCode(), billId, Integer.parseInt(statusId), disRefundDomain.getDataState(), mapP, disChannel);
            if ("32".equals(statusId) || "92".equals(statusId) || "114".equals(statusId)) {
                OcRefund ocRefund2 = this.queryRefundByNbbillcode(disChannel.getChannelCode(), disRefundDomain.getContractNbillcode(), disChannel.getTenantCode());
                if (null != ocRefund2) {
                    this.updateExtrinsicStateByRefundCode(ocRefund2.getRefundCode(), "32", disChannel.getTenantCode());
                }
            } else if (("33".equals(statusId) || "40".equals(statusId) || "93".equals(statusId)) && null != (ocRefund = this.queryRefundByNbbillcode(disChannel.getChannelCode(), disRefundDomain.getContractNbillcode(), disChannel.getTenantCode()))) {
                this.updateExtrinsicStateByRefundCode(ocRefund.getRefundCode(), "33", disChannel.getTenantCode());
            }
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeRefund(param, disChannel);
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        Object o;
        String pic;
        this.logger.error(this.SYS_CODE + ".makeRefund1: ", map);
        String PICURL = "http://img10.360buyimg.com/o2o/";
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        String orderId = map.get("orderId").toString();
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel);
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain1", (Object)orderId);
            return null;
        }
        disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode());
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)orderId);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
        }
        disRefundDomain.setContractNbillcode(orderId);
        disRefundDomain.setRefundOcode(map.get("afsServiceOrder").toString());
        disRefundDomain.setDataStatestr(map.get("afsServiceState").toString());
        Object time = map.get("createTime");
        String createTime = null == time ? null : String.valueOf(time);
        Date refundTime = null;
        if (null != createTime && Long.valueOf(createTime) > 0L) {
            refundTime = StringUtils.isNotBlank((String)createTime) ? new Date(Long.valueOf(createTime)) : null;
        }
        disRefundDomain.setRefundDate(refundTime);
        Object questionType = map.get("questionTypeCid");
        String questionTypeCid = null == questionType ? null : String.valueOf(questionType);
        disRefundDomain.setRefundEx(this.fetchRefundType(questionTypeCid));
        disRefundDomain.setRefundMeo(map.get("questionDesc").toString());
        disRefundDomain.setRefundUsertype("0");
        if (null != map.get("questionPic") && StringUtils.isNotBlank((String)(pic = String.valueOf(map.get("questionPic"))))) {
            pic = "http://img10.360buyimg.com/o2o/" + pic;
            pic = pic.replace(",", ",http://img10.360buyimg.com/o2o/");
            String[] str = pic.split("\\,");
            List<String> listStr = Arrays.asList(str);
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        String refundPrice = null == (o = map.get("cashMoney")) ? null : String.valueOf(o);
        List goodlist = (List)map.get("afsDetailList");
        if (ListUtil.isEmpty((Collection)goodlist)) {
            this.logger.error(this.SYS_CODE + ".goodsList jddj1", map);
            return null;
        }
        String refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != refundAuditTime && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        disRefundDomain.setRefundType("jddj1");
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        disRefundDomain.setRefundMoney(null == refundPrice ? BigDecimal.ZERO : new BigDecimal(refundPrice).divide(new BigDecimal("100")).setScale(2, 4));
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disContractDomain, disRefundDomain));
        this.logger.error(this.SYS_CODE + ".makeRefund2: ", (Object)JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(goodlist + "=:=" + disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            for (String key : map.keySet()) {
                BigDecimal refnum;
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
                if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                    refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                refundGoodsList.add(disRefundGoodsDomain);
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
            }
            disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
        } else {
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(gmap.get("skuIdIsv"));
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                Integer skuCount = null == gmap.get("skuCount") ? null : (Integer)gmap.get("skuCount");
                BigDecimal number = null == skuCount ? BigDecimal.ZERO : BigDecimal.valueOf(skuCount.intValue());
                Object o = map.get("cashMoney");
                String cashMoney = null == o ? null : String.valueOf(o);
                BigDecimal totalRefund = null == cashMoney ? BigDecimal.ZERO : new BigDecimal(cashMoney).divide(new BigDecimal("100")).setScale(2, 4);
                disRefundGoodsDomain.setRefundGoodsNum(number);
                disRefundGoodsDomain.setRefundGoodsPrice(totalRefund.divide(number).setScale(2, 4));
                disRefundGoodsDomain.setRefundGoodsAmt(totalRefund);
                disRefundGoodsDomain.setRefundGoodsWeight(number);
                refundGoodsList.add(disRefundGoodsDomain);
            }
        }
        return refundGoodsList;
    }

    private String fetchRefundType(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("201", "\u5546\u54c1\u8d28\u91cf\u95ee\u9898");
        map.put("202", "\u9001\u9519\u8d27");
        map.put("203", "\u7f3a\u4ef6\u5c11\u4ef6");
        map.put("501", "\u5168\u90e8\u5546\u54c1\u672a\u6536\u5230");
        map.put("208", "\u5305\u88c5\u810f\u6c61\u6709\u7834\u635f");
        map.put("207", "\u7f3a\u65a4\u5c11\u4e24");
        map.put("210", "\u5546\u5bb6\u901a\u77e5\u6211\u7f3a\u8d27");
        map.put("303", "\u5b9e\u7269\u4e0e\u539f\u56fe\u4e0d\u7b26");
        map.put("402", "\u4e0d\u60f3\u8981\u4e86");
        map.put("502", "\u672a\u5728\u65f6\u6548\u5185\u9001\u8fbe");
        return (String)map.get(id);
    }
}

