/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.oauth.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOauthBaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdvop.JdVopConstants;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.OauthBeanForJdVop;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.RsaCoderUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class DisOauthServiceImpl
extends DisOauthBaseServiceImpl {
    private String SYS_CODE = "jdvop.DisOauthServiceImpl";

    private String saveDisTokenForJd(DisChannel disChannel, OauthBeanForJdVop oauthBean, String memberCode) {
        if (StringUtils.isBlank((String)memberCode) || null == disChannel || null == oauthBean) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode(disChannel.getChannelCode());
        disOauthTokenDomain.setChannelName(disChannel.getChannelName());
        disOauthTokenDomain.setMemberCode(memberCode);
        disOauthTokenDomain.setMemberName(memberCode);
        disOauthTokenDomain.setOauthTokenExpireIn(oauthBean.getExpires_in());
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthBean.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthBean.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(disChannel.getTenantCode());
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }

    public String sendGetToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.param");
            return "error";
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return "error";
        }
        String json = null;
        String url = configMap.get(JdVopConstants.serviceUrl);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = WebUtils.doGet((String)url, httpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        String memberCode = (String)param.get("memberCode");
        OauthBeanForJdVop oa = new OauthBeanForJdVop();
        if (channelApiCode.equals("cmc.disOauth.getUrl")) {
            return "success";
        }
        if (channelApiCode.equals("cmc.disOauth.updateToken")) {
            Map remap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            oa.setAccess_token((String)remap.get("access_token"));
            oa.setExpires_in((Integer)remap.get("expires_in"));
            oa.setRefresh_token((String)remap.get("refresh_token"));
        } else if (channelApiCode.equals("cmc.disOauth.reflashToken")) {
            // empty if block
        }
        return this.saveDisTokenForJd(disChannel, oa, memberCode);
    }

    public String sendReflashToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.param");
            return "error";
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return "error";
        }
        String json = null;
        String url = configMap.get(JdVopConstants.serviceUrl);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = WebUtils.doGet((String)url, httpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        String memberCode = (String)param.get("memberCode");
        OauthBeanForJdVop oa = new OauthBeanForJdVop();
        Map remap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        oa.setAccess_token((String)remap.get("access_token"));
        oa.setExpires_in((Integer)remap.get("expires_in"));
        oa.setRefresh_token((String)remap.get("refresh_token"));
        return this.saveDisTokenForJd(disChannel, oa, memberCode);
    }

    public static void main(String[] args) {
        String password = "*8888888Z";
        String rsa_key = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKGZQEp44UqTk84LYrOqI/NL+hmcOrL3xf9M4tpsu8+hr1BFUTxjul5G30e9jfq/ywfAP1OPNZj//UU0Fcuvg9rofxtmL9UrD25KD9bZ03JamF4dKIb3uMSL0zUE8f9M1TtSjy+Qy95hz3IqBbyho95pGMd4ibSHBVbQ4PphQbEXAgMBAAECgYBdyGTJU5HcB/2VbIIhprIqdoN07XgbeTRNT7+v576vZzQpL7FPjMkSAat/JQEK7tfTbbzSr5/5ZUcFLI8hoICyTuDX8zpsL4bGL8EqcHEZFzke3IGtqWTDenskGQp+2FZZ0cUzmJ8nhWFjb7c2IZBpgZ2G6vN9BB0M4a03i849gQJBAPzLQfumwBY0NpVgA6//c9vgUPt+jHZi2R/RyHqiLDzxsaAKb7wfn84CQ/vlUC2OheCQFCpVi+9MwVs0rFd+kyECQQCjpekxVZ9Yp/iYFc8WT9S1OUTdfZgpJUNs++2AZmnyrraeNiatymJT7u/KoJfLch3Cd0cHwZmo3ucE0s9zknU3AkEAowoEuGVHpgpu2dBfEHfVJY57LHjl5sTB/H+0qUNG/Nd1FB8nCVHsI1Xauu+e0oMFXVwPZW5fHiuG2WgTbyq3gQJADaJA709G20gDOgh3HFDCU+bVie5wwtzL5USH4O6nXQSZSk0Qo+H8lymM6MDAZL65I/5z+H10o9EORiSaC/LjuQJAda31QduQFM1jOdyMNamA43VpXOHHFdefjvsaIlR6RcSu1GYuvHmeN3PFxhuu4US2sgnbPibfqAPJBwfmbh5GTA==";
        String md5Password = DigestUtils.md5Hex((String)password);
        try {
            String ciphertextPassword = RsaCoderUtils.encryptByPrivateKey(md5Password, rsa_key);
            String encodePassword = URLEncoder.encode(ciphertextPassword, "utf-8");
            System.out.println(encodePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean befAppentParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, Object> param, Map<String, String> configMap) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap)) {
            return true;
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return true;
        }
        this.logger.error(this.SYS_CODE + ".befAppentParam", (Object)channelApiCode);
        if (channelApiCode.equals("cmc.disOauth.getUrl")) {
            String redirect_uri = configMap.get("redirect_uri");
            String username = configMap.get("username");
            String password = configMap.get("password");
            String rsa_key = configMap.get("rsa_key");
            try {
                String encodeRedirectUri = URLEncoder.encode(redirect_uri, "utf-8");
                sendParam.put("redirect_uri", encodeRedirectUri);
                String encodeUsername = URLEncoder.encode(username, "utf-8");
                sendParam.put("username", encodeUsername);
                String md5Password = DigestUtils.md5Hex((String)password);
                String ciphertextPassword = RsaCoderUtils.encryptByPrivateKey(md5Password, rsa_key);
                String encodePassword = URLEncoder.encode(ciphertextPassword, "utf-8");
                sendParam.put("password", encodePassword);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.e1", (Throwable)e);
            }
            String url = configMap.get(JdVopConstants.serviceUrl);
            HashMap<String, String> httpParam = new HashMap<String, String>();
            if (MapUtil.isNotEmpty(sendParam)) {
                for (String key : sendParam.keySet()) {
                    httpParam.put(key, String.valueOf(sendParam.get(key)));
                }
            }
            String json = "";
            try {
                json = WebUtils.doGet((String)url, httpParam);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            }
            if (StringUtils.isBlank((String)json)) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            }
            this.logger.error(this.SYS_CODE + ".befAppentParam.json1", (Object)(json + "=" + url + ":" + sendParam.toString() + ":" + configMap.toString()));
        }
        return false;
    }

    public Map<String, Object> sendGetTokenParam(Map<String, Object> map) {
        return map;
    }

    protected String getChannelCode() {
        return JdVopConstants.channelCode;
    }
}

