/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.oauth.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOauthBaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdvop.JdVopConstants;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.OauthBeanForJdVop;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.JdHttpUtil;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.RsaCoderUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class DisOauthServiceImpl
extends DisOauthBaseServiceImpl {
    private String SYS_CODE = "jdvop.DisOauthServiceImpl";

    private String saveDisTokenForJd(DisChannel disChannel, OauthBeanForJdVop oauthBean, String memberCode) {
        if (StringUtils.isBlank((String)memberCode) || null == disChannel || null == oauthBean) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode(disChannel.getChannelCode());
        disOauthTokenDomain.setChannelName(disChannel.getChannelName());
        disOauthTokenDomain.setMemberCode(memberCode);
        disOauthTokenDomain.setMemberName(memberCode);
        disOauthTokenDomain.setOauthTokenExpireIn(oauthBean.getExpires_in());
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthBean.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthBean.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(disChannel.getTenantCode());
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }

    public String sendGetToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.param");
            return "error";
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return "error";
        }
        String json = null;
        String url = configMap.get(JdVopConstants.serviceUrl);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = JdHttpUtil.httpGet(url, httpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        this.logger.error(this.SYS_CODE + ".sendGetToken.json1", (Object)(json + ":" + channelApiCode));
        String memberCode = (String)param.get("memberCode");
        if (channelApiCode.equals("cmc.disOauth.getUrl")) {
            return "success";
        }
        OauthBeanForJdVop oa = (OauthBeanForJdVop)JsonUtil.buildNormalBinder().getJsonToObject(json, OauthBeanForJdVop.class);
        return this.saveDisTokenForJd(disChannel, oa, memberCode);
    }

    public String sendReflashToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.param");
            return "error";
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return "error";
        }
        String json = null;
        String url = configMap.get(JdVopConstants.serviceUrl);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = JdHttpUtil.httpGet(url, httpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        String memberCode = (String)param.get("memberCode");
        OauthBeanForJdVop oa = new OauthBeanForJdVop();
        Map remap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        oa.setAccess_token((String)remap.get("access_token"));
        oa.setExpires_in((Integer)remap.get("expires_in"));
        oa.setRefresh_token((String)remap.get("refresh_token"));
        return this.saveDisTokenForJd(disChannel, oa, memberCode);
    }

    public static void main(String[] args) {
        String url = "https://open-oauth.jd.com/oauth2/authorizeForVOP";
        HashMap<String, String> httpParam = new HashMap<String, String>();
        httpParam.put("password", "EtJ%2Fv8Z%2B4AAfEJqS%2B9DKpxzHFF%2BS2IH6B2idTvbhzRd8eah%2FLlc7CC5lFkZyJx1huiua4XNehDUBtKktMFGfeFDPlBZ5W2IXJKoz7fGRUjuFsax1ONNdlLZsLsNUAHHrpQCjx%2BYm00YWLXhEgp4FTqNdhH8UOR%2FA6J%2F72cHdwlE%3D");
        httpParam.put("app_key", "F203DCB9B45FC527B0146BF93509F032");
        httpParam.put("redirect_uri", "http%3A%2F%2Fyouse.xytest.qjclouds.com%2FlaserDis%2Fhttp%2Fget%2Fdis%2Fjdvop%2F20000210359526%2F2020102600000001");
        httpParam.put("response_type", "code");
        httpParam.put("scope", "snsapi_base");
        httpParam.put("username", "%E4%B8%8A%E6%B5%B7%E6%9C%89%E8%89%B2%E7%BD%91%E6%99%BA%E9%87%87");
        try {
            String re = JdHttpUtil.httpGet(url, httpParam);
            System.out.println(re);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean befAppentParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, Object> param, Map<String, String> configMap) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap)) {
            return true;
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return true;
        }
        this.logger.error(this.SYS_CODE + ".befAppentParam", (Object)channelApiCode);
        if (channelApiCode.equals("cmc.disOauth.getUrl")) {
            String redirect_uri = configMap.get("redirect_uri");
            String username = configMap.get("username");
            String password = configMap.get("password");
            String rsa_key = configMap.get("rsa_key");
            try {
                String encodeRedirectUri = URLEncoder.encode(redirect_uri, "utf-8");
                sendParam.put("redirect_uri", encodeRedirectUri);
                String encodeUsername = URLEncoder.encode(username, "utf-8");
                sendParam.put("username", encodeUsername);
                String md5Password = DigestUtils.md5Hex((String)password);
                String ciphertextPassword = RsaCoderUtils.encryptByPrivateKey(md5Password, rsa_key);
                String encodePassword = URLEncoder.encode(ciphertextPassword, "utf-8");
                sendParam.put("password", encodePassword);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.e1", (Throwable)e);
            }
            String url = configMap.get(JdVopConstants.serviceUrl);
            HashMap<String, String> httpParam = new HashMap<String, String>();
            if (MapUtil.isNotEmpty(sendParam)) {
                for (String key : sendParam.keySet()) {
                    httpParam.put(key, String.valueOf(sendParam.get(key)));
                }
            }
            String json = "";
            try {
                json = JdHttpUtil.httpGet(url, httpParam);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            }
            if (StringUtils.isBlank((String)json)) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            }
            this.logger.error(this.SYS_CODE + ".befAppentParam.json1", (Object)(json + "=" + url + ":" + sendParam.toString() + ":" + configMap.toString()));
        }
        return false;
    }

    public Map<String, Object> sendGetTokenParam(Map<String, Object> map) {
        return map;
    }

    protected String getChannelCode() {
        return JdVopConstants.channelCode;
    }
}

