/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.order.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.request.submitOrder.ConsigneeInfoOrderOpenReq;
import com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.request.submitOrder.PaymentInfoOrderOpenReq;
import com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.request.submitOrder.SkuInfoOrderOpenReq;
import com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.request.submitOrder.SubmitOrderOpenReq;
import com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.response.submitOrder.QueryOrderOpenResp;
import com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.response.submitOrder.VopOrderRpcResult;
import com.jd.open.api.sdk.domain.vopdd.QueryBalanceOpenProvider.response.checkAccountBalance.CheckAccountBalanceOpenResp;
import com.jd.open.api.sdk.domain.vopdd.QueryBalanceOpenProvider.response.checkBalanceChangeInfo.OpenPagingResult;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.request.querySkuFreight.AreaBaseInfoOpenReq;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.request.querySkuFreight.FreightQueryOpenReq;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryDeliveryInfo.DeliveryInfoQueryOpenResp;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryDeliveryInfo.OpenRpcResult;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.querySkuFreight.FreightQueryOpenResp;
import com.jd.open.api.sdk.domain.vopdz.ConvertAddressOpenProvider.response.convertFourAreaByDetailStr.QueryAreaFourIdOpenResp;
import com.jd.open.api.sdk.domain.vopdz.QueryAddressOpenProvider.response.queryJdAreaIdList.AreaInfoBaseResp;
import com.jd.open.api.sdk.domain.vopdz.QueryAddressOpenProvider.response.queryJdAreaIdList.QueryJdAreaIdListOpenResp;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderCancelOrderRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderCheckAccountBalanceRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderCheckBalanceChangeInfoRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderConfirmOrderRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderQueryDeliveryInfoRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderQuerySkuFreightRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderSubmitOrderRequest;
import com.jd.open.api.sdk.request.vopdz.VopAddressConvertFourAreaByDetailStrRequest;
import com.jd.open.api.sdk.request.vopdz.VopAddressQueryJdAreaIdListRequest;
import com.jd.open.api.sdk.response.vopdd.VopOrderCancelOrderResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderCheckAccountBalanceResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderCheckBalanceChangeInfoResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderConfirmOrderResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderQueryDeliveryInfoResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderQuerySkuFreightResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderSubmitOrderResponse;
import com.jd.open.api.sdk.response.vopdz.VopAddressConvertFourAreaByDetailStrResponse;
import com.jd.open.api.sdk.response.vopdz.VopAddressQueryJdAreaIdListResponse;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisRefundService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.JdVopFreight;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.WhGoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.jdvop.JdVopConstants;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.BsAreaDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.BsProvinceDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.BsRoadDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "jdvop.DisOrderServiceImpl";
    DisRefundService disRefundService;
    static final String PROVINCE_ADD_API_CODE = "bs.province.saveProvince";
    static final String AREA_ADD_API_CODE = "bs.area.saveAreaList";
    static final String ROAD_ADD_API_CODE = "bs.road.saveRoadBatch";

    public void setDisRefundService(DisRefundService disRefundService) {
        this.disRefundService = disRefundService;
    }

    protected String getChannelCode() {
        return JdVopConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComOrderParam", (Object)("====" + channelApiCode + "===" + sendParam.toString() + "====" + configMap.toString() + "====" + param.toString()));
            return null;
        }
        sendParam.put("serverUrl", configMap.get("ophost"));
        sendParam.put("accessToken", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode()));
        sendParam.put("appKey", configMap.get("key"));
        sendParam.put("appSecret", configMap.get("secret"));
        if ("cmc.disOrder.saveOcContract".equals(channelApiCode)) {
            sendParam.put("ocContractReDomain", param.get("ocContractReDomain"));
            sendParam.put("memberCode", param.get("memberCode"));
            sendParam.put("tenantCode", param.get("tenantCode"));
        }
        this.logger.error(this.SYS_CODE + "." + channelApiCode, (Object)("=:= " + configMap + "=:= " + param + "=:= " + sendParam));
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String serverUrl = configMap.get("ophost");
        String accessToken = this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode());
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String tenantCode = (String)param.get("tenantCode");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        if ("cmc.disOrder.saveOcContract".equalsIgnoreCase(channelApiCode)) {
            OcContractReDomain ocContractReDomain = (OcContractReDomain)sendhttpParam.get("ocContractReDomain");
            QueryOrderOpenResp queryOrderOpenResp = this.submitJdVopOrder((JdClient)client, ocContractReDomain);
            if (null == queryOrderOpenResp) {
                return "ERROR";
            }
            this.saveJdVopToLocal(disChannel, ocContractReDomain, queryOrderOpenResp);
            return "SUCCESS";
        }
        if ("cmc.disOrder.saveOcContractState".equalsIgnoreCase(channelApiCode)) {
            OcContractReDomain ocContractReDomain = (OcContractReDomain)sendhttpParam.get("ocContractReDomain");
            String thirdOrderId = ocContractReDomain.getContractBillcode();
            String jdOrderId = ocContractReDomain.getContractNbillcode();
            boolean result = false;
            if (ocContractReDomain.getDataState() == -1) {
                result = this.cancelJdVopOrder((JdClient)client, thirdOrderId, jdOrderId);
                return result ? "SUCCESS" : "ERROR";
            }
            if (ocContractReDomain.getDataState() == 1) {
                result = this.confirmJdVopOrder((JdClient)client, thirdOrderId, jdOrderId);
                return result ? "SUCCESS" : "ERROR";
            }
            if (ocContractReDomain.getDataState() == 2) {
                DeliveryInfoQueryOpenResp deliveryInfoQueryOpenResp = this.queryJdVopOrderDelivery((JdClient)client, thirdOrderId, jdOrderId);
                if (null == deliveryInfoQueryOpenResp) {
                    return "ERROR";
                }
                List logisticInfoList = deliveryInfoQueryOpenResp.getLogisticInfoList();
            }
        } else {
            if ("cmc.disOrder.sendProAreaRoad".equalsIgnoreCase(channelApiCode)) {
                List<AreaInfoBaseResp> proInfoResp = this.queryJdAreaIdList((JdClient)client, 1, 0L);
                if (ListUtil.isEmpty(proInfoResp)) {
                    this.logger.error(this.SYS_CODE + ".sendSaveComArea", (Object)"\u4e00\u7ea7\u5730\u5740\u67e5\u8be2\u5931\u8d25");
                    return "ERROR";
                }
                this.saveProvince(proInfoResp, tenantCode);
                for (AreaInfoBaseResp proInfo : proInfoResp) {
                    List<AreaInfoBaseResp> areaTwoInfoResp = this.queryJdAreaIdList((JdClient)client, 2, proInfo.getAreaId());
                    if (ListUtil.isEmpty(areaTwoInfoResp)) continue;
                    this.saveArea(areaTwoInfoResp, proInfo.getAreaId(), null, tenantCode);
                    for (AreaInfoBaseResp twoAreInfo : areaTwoInfoResp) {
                        List<AreaInfoBaseResp> areaThreeInfoResp = this.queryJdAreaIdList((JdClient)client, 3, twoAreInfo.getAreaId());
                        if (ListUtil.isEmpty(areaThreeInfoResp)) continue;
                        this.saveArea(areaThreeInfoResp, proInfo.getAreaId(), twoAreInfo.getAreaId(), tenantCode);
                        for (AreaInfoBaseResp threeAreaInfo : areaThreeInfoResp) {
                            List<AreaInfoBaseResp> areaFourInfoResp = this.queryJdAreaIdList((JdClient)client, 4, threeAreaInfo.getAreaId());
                            if (ListUtil.isEmpty(areaFourInfoResp)) continue;
                            this.saveRoad(areaFourInfoResp, threeAreaInfo.getAreaId(), tenantCode);
                        }
                    }
                }
                return "SUCCESS";
            }
            if ("cmc.disOrder.getFreight".equals(channelApiCode)) {
                String areaStr;
                List whGoodsBeanList = (List)sendhttpParam.get("whGoodsBeanList");
                JdVopFreight jdVopFreight = this.querySkuFreight((JdClient)client, whGoodsBeanList, areaStr = (String)sendhttpParam.get("areaStr"));
                if (null == jdVopFreight) {
                    return "ERROR";
                }
                return jdVopFreight;
            }
            if ("cmc.disOrder.getBalance".equals(channelApiCode)) {
                CheckAccountBalanceOpenResp accountBalance = this.getAccountBalance((JdClient)client);
                if (null == accountBalance) {
                    return "ERROR";
                }
                return accountBalance;
            }
            if ("cmc.disOrder.getBalanceDetail".equals(channelApiCode)) {
                OpenPagingResult accountBalanceDetail = this.getAccountBalanceDetail((JdClient)client);
                if (null == accountBalanceDetail) {
                    return "ERROR";
                }
                return accountBalanceDetail;
            }
        }
        return "ERROR";
    }

    private boolean confirmJdVopOrder(JdClient client, String thirdOrderId, String jdOrderId) {
        com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.response.confirmOrder.OpenRpcResult openRpcResult = null;
        try {
            VopOrderConfirmOrderRequest request = new VopOrderConfirmOrderRequest();
            request.setThirdOrderId(thirdOrderId);
            request.setJdOrderId(Long.valueOf(jdOrderId));
            VopOrderConfirmOrderResponse response = (VopOrderConfirmOrderResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (!openRpcResult.getSuccess()) {
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".confirmJdVopOrder", (Object)("\u786e\u8ba4VOP\u8ba2\u5355\u5f02\u5e38.Ex" + e));
            return false;
        }
        return "0000".equals(openRpcResult.getResultCode());
    }

    private boolean cancelJdVopOrder(JdClient client, String thirdOrderId, String jdOrderId) {
        com.jd.open.api.sdk.domain.vopdd.OperaOrderOpenProvider.response.cancelOrder.OpenRpcResult openRpcResult = null;
        try {
            VopOrderCancelOrderRequest request = new VopOrderCancelOrderRequest();
            request.setThirdOrderId(thirdOrderId);
            request.setJdOrderId(Long.valueOf(jdOrderId));
            VopOrderCancelOrderResponse response = (VopOrderCancelOrderResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "submitJdVopOrder.openRpcResult", (Object)response.getMsg());
                return false;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "submitJdVopOrder.getSuccess", (Object)openRpcResult.getResultMessage());
                return false;
            }
            if (!openRpcResult.getSuccess()) {
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".cancelJdVopOrder", (Object)("\u53d6\u6d88\u672a\u786e\u8ba4\u8ba2\u5355\u5f02\u5e38.Ex" + e));
            return false;
        }
        return "0000".equals(openRpcResult.getResultCode());
    }

    private DeliveryInfoQueryOpenResp queryJdVopOrderDelivery(JdClient client, String thirdOrderId, String jdOrderId) {
        OpenRpcResult openRpcResult = null;
        DeliveryInfoQueryOpenResp result = null;
        try {
            VopOrderQueryDeliveryInfoRequest request = new VopOrderQueryDeliveryInfoRequest();
            request.setThirdOrderId(thirdOrderId);
            request.setJdOrderId(Long.valueOf(jdOrderId));
            VopOrderQueryDeliveryInfoResponse response = (VopOrderQueryDeliveryInfoResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "queryJdVopOrderDelivery.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "queryJdVopOrderDelivery.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                return null;
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".cancelJdVopOrder", (Object)("\u67e5\u8be2\u8ba2\u5355\u914d\u9001\u4fe1\u606f\u5f02\u5e38.Ex" + e));
            return null;
        }
        return result;
    }

    private void saveJdVopToLocal(DisChannel disChannel, OcContractReDomain ocContractReDomain, QueryOrderOpenResp queryOrderOpenResp) {
        ArrayList disContractDomains = new ArrayList();
        try {
            ocContractReDomain.setContractNbillcode(String.valueOf(queryOrderOpenResp.getJdOrderId()));
            ocContractReDomain.setDataState(queryOrderOpenResp.getOrderState().getJdOrderState());
            DisContractDomain disContractDomain = new DisContractDomain();
            BeanUtils.copyAllPropertys((Object)disContractDomain, (Object)ocContractReDomain);
            this.saveOrder(disContractDomains, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "saveJdVopToLocal.\u5904\u7406\u4eac\u4e1c\u8ba2\u5355\uff0c\u4fdd\u5b58\u81f3\u672c\u5730\u5f02\u5e38.Ex", (Throwable)e);
        }
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + "saveOrderParam.come====", (Object)sendhttpParam.toString());
        if (null == sendhttpParam || null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        if ("afterSaleBillStatus".equals(methodType) || "newAfterSaleBill".equals(methodType) || "newApplyAfterSaleBill".equals(methodType) || "updateApplyAfterSaleBill".equals(methodType)) {
            this.logger.error(this.SYS_CODE, (Object)("come!!!" + jsonToMap + "=:=" + methodType));
            String str = this.disRefundService.saveSendRefundState(sendhttpParam);
            this.logger.error(this.SYS_CODE, (Object)("come =:=" + str + "=:=" + methodType));
            return str;
        }
        String memberCode = (String)sendhttpParam.get("memberCode");
        String tenantCode = (String)sendhttpParam.get("tenantCode");
        if (null == jsonToMap.get("billId") && null == jsonToMap.get("statusId") && null == jsonToMap.get("timestamp")) {
            if (null == jsonToMap.get("orderId")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.orderId is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String orderId = (String)jsonToMap.get("orderId");
            if (null == jsonToMap.get("deliveryStatus")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatus is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String deliveryStatus = (String)jsonToMap.get("deliveryStatus");
            if (null == jsonToMap.get("deliveryStatusTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatusTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierNo")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierNo is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierName")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierName is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("createPin")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.createPin is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("opTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.opTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(orderId, memberCode, tenantCode);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("32000".equals(deliveryStatus)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), deliveryStatus);
            if ("33060".equals(dataStateStr) || "20020".equals(dataStateStr)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(deliveryStatus);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", deliveryStatus);
            try {
                this.updateOrder(disChannel.getTenantCode(), orderId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".updateOrder000 result is error");
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        if (null != jsonToMap.get("billId") && null != jsonToMap.get("statusId") && null != jsonToMap.get("timestamp")) {
            String billId = (String)jsonToMap.get("billId");
            String statusId = (String)jsonToMap.get("statusId");
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(billId, memberCode, tenantCode);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("pickFinishOrder".equals(methodType) && "2".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("applyCancelOrder".equals(methodType)) {
                if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                    this.logger.error(this.SYS_CODE + ".applyCancelOrder:", (Object)("billId:" + billId + ";statusId:" + statusId + "=:=" + jsonToMap));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                if ("20030".equals(statusId)) {
                    return this.buildRefund(disChannel, billId, statusId, memberCode, tenantCode, jsonToMap);
                }
            }
            if ("32000".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), statusId);
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(statusId);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", statusId);
            try {
                this.updateOrder(disChannel.getTenantCode(), billId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                // empty catch block
            }
            if ("20032".equals(statusId) || "20020".equals(statusId)) {
                DisRefundReDomain disRefundReDomain = this.getRefundByNbillcode(disChannel.getTenantCode(), billId, disChannel);
                if (null != disRefundReDomain) {
                    HashMap<String, String> mapP = new HashMap<String, String>();
                    mapP.put("dataStatestr", statusId);
                    this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundReDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(statusId), disRefundReDomain.getDataState(), mapP);
                } else {
                    return this.buildRefund(disChannel, billId, statusId, memberCode, tenantCode, jsonToMap);
                }
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private String resultReturn(String code, String msg, String data) {
        return "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
    }

    private String buildRefund(DisChannel disChannel, String billId, String statusId, String memberCode, String tenantCode, Map<String, Object> jsonToMap) {
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel);
        if (null == disContractDomain) {
            disContractDomain = this.getSendOrder(billId, memberCode, tenantCode);
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".applyCancelOrder.disContractDomain is null", (Object)billId);
                return this.resultReturn("-1", "ERROR", "jd_param_json");
            }
            ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
            disContractList.add(disContractDomain);
            this.saveOrder(disContractList, disChannel);
            disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel);
        }
        if (null == (disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode(), disChannel))) {
            this.logger.error(this.SYS_CODE + ".applyCancelOrder.disContractDomain is null", (Object)(billId + "=:=" + disContractDomain));
            return null;
        }
        DisRefundDomain disRefundDomain = this.createRefundInfoForVop(disContractDomain, disChannel, this.getQueryParamMap("billId,statusId,remark,timestamp", new Object[]{billId, statusId, jsonToMap.get("remark"), jsonToMap.get("timestamp")}));
        ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
        disRefundDomainList.add(disRefundDomain);
        this.logger.error(this.SYS_CODE + " disRefundDomainList.jdVopV2 : ", (Object)(disRefundDomainList.size() + " =:= " + disRefundDomainList));
        this.saveRefund(disRefundDomainList, disChannel);
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private DisRefundDomain createRefundInfoForVop(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundJdVopV2", map);
            return null;
        }
        return this.buildRefundInfoForVop(disContractDomain, disChannel, map);
    }

    private DisRefundDomain buildRefundInfoForVop(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".buildRefundInfoForVop", (Object)(JsonUtil.buildNormalBinder().toJson((Object)disContractDomain) + " =:= " + map));
        if (null == disContractDomain) {
            this.logger.info(this.SYS_CODE + ".buildRefundInfoForVop.disContractDomain", map);
            return null;
        }
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".buildRefundInfoForVop.copyAllPropertys", (Throwable)e);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String ctimeStr = (String)map.get("timestamp");
        try {
            disRefundDomain.setRefundDate(sdf.parse(ctimeStr));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        String refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != refundAuditTime && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        String res_reason = null == map.get("remark") ? null : map.get("remark").toString();
        disRefundDomain.setRefundEx(res_reason);
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo(res_reason);
        disRefundDomain.setDataStatestr(String.valueOf(map.get("statusId")));
        disRefundDomain.setRefundType("JdVop");
        disRefundDomain.setRefundMoney(disContractDomain.getDataBmoney());
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(disContractDomain, disRefundDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        for (String key : map.keySet()) {
            BigDecimal refnum;
            DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(key);
            if (null == disContractGoodsDomain) {
                return null;
            }
            BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
            if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                continue;
            }
            disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
            DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
            refundGoodsList.add(disRefundGoodsDomain);
            refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
        }
        disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
        return refundGoodsList;
    }

    private DisRefundGoodsDomain create(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            this.logger.error(this.SYS_CODE + ".create.", (Object)"param is null");
            return null;
        }
        DisRefundGoodsDomain disRefundGoodsDomain = new DisRefundGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundGoodsDomain, (Object)disContractGoodsDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigDecimal refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
        BigDecimal allowNum = disContractGoodsDomain.getGoodsCamount().subtract(refnum);
        disRefundGoodsDomain.setRefundGoodsNum(allowNum);
        disRefundGoodsDomain.setRefundGoodsAmt(disContractGoodsDomain.getContractGoodsMoney());
        disRefundGoodsDomain.setRefundGoodsWeight(disContractGoodsDomain.getGoodsCweight());
        disRefundGoodsDomain.setRefundGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        return disRefundGoodsDomain;
    }

    public List<AreaInfoBaseResp> queryJdAreaIdList(JdClient client, Integer areaLevel, Long areaId) {
        com.jd.open.api.sdk.domain.vopdz.QueryAddressOpenProvider.response.queryJdAreaIdList.OpenRpcResult openRpcResult = null;
        ArrayList<AreaInfoBaseResp> areaInfoList = new ArrayList();
        try {
            VopAddressQueryJdAreaIdListRequest request = new VopAddressQueryJdAreaIdListRequest();
            request.setAreaLevel(areaLevel);
            request.setJdAreaId(areaId);
            VopAddressQueryJdAreaIdListResponse response = (VopAddressQueryJdAreaIdListResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "queryJdAreaIdList.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "queryJdAreaIdList.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            QueryJdAreaIdListOpenResp rpcResultResult = openRpcResult.getResult();
            areaInfoList = rpcResultResult.getAreaInfoList();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "queryJdAreaIdList.e", (Throwable)e);
            return null;
        }
        return areaInfoList;
    }

    private void saveProvince(List<AreaInfoBaseResp> areaInfoBaseRes, String tenantCode) {
        if (ListUtil.isNotEmpty(areaInfoBaseRes)) {
            for (AreaInfoBaseResp areaInfoBaseRe : areaInfoBaseRes) {
                BsProvinceDomain bsProvinceDomain = new BsProvinceDomain();
                bsProvinceDomain.setProvincName(areaInfoBaseRe.getAreaName());
                bsProvinceDomain.setProvinceCode(areaInfoBaseRe.getAreaId().toString());
                bsProvinceDomain.setTenantCode(tenantCode);
                bsProvinceDomain.setDataState("1");
                HashMap<String, String> proMap = new HashMap<String, String>();
                proMap.put("bsProvinceDomain", JsonUtil.buildNormalBinder().toJson((Object)bsProvinceDomain));
                this.getInternalRouter().inInvoke(PROVINCE_ADD_API_CODE, proMap);
            }
        }
    }

    private void saveArea(List<AreaInfoBaseResp> areaInfoBaseRes, Long proInfoId, Long parentCode, String tenantCode) {
        if (ListUtil.isNotEmpty(areaInfoBaseRes)) {
            ArrayList<BsAreaDomain> bsAreaDomainList = new ArrayList<BsAreaDomain>();
            for (AreaInfoBaseResp areaInfoBaseRe : areaInfoBaseRes) {
                BsAreaDomain bsAreaDomain = new BsAreaDomain();
                bsAreaDomain.setAreaCode(areaInfoBaseRe.getAreaId().toString());
                bsAreaDomain.setAreaName(areaInfoBaseRe.getAreaName());
                bsAreaDomain.setAreaParentCode(parentCode != null ? parentCode.toString() : null);
                bsAreaDomain.setProvinceCode(proInfoId.toString());
                bsAreaDomain.setTenantCode(tenantCode);
                bsAreaDomain.setDataState("1");
                bsAreaDomainList.add(bsAreaDomain);
            }
            HashMap<String, String> proMap = new HashMap<String, String>();
            proMap.put("bsAreaDomains", JsonUtil.buildNormalBinder().toJson(bsAreaDomainList));
            this.getInternalRouter().inInvoke(AREA_ADD_API_CODE, proMap);
        }
    }

    private void saveRoad(List<AreaInfoBaseResp> areaInfoBaseRes, Long areId, String tenantCode) {
        ArrayList<BsRoadDomain> bsRoadDomains = new ArrayList<BsRoadDomain>();
        for (AreaInfoBaseResp areaInfoBaseResp : areaInfoBaseRes) {
            BsRoadDomain bsRoadDomain = new BsRoadDomain();
            bsRoadDomain.setAreaCode(areId.toString());
            bsRoadDomain.setRoadCode(areaInfoBaseResp.getAreaId().toString());
            bsRoadDomain.setRoadName(areaInfoBaseResp.getAreaName());
            bsRoadDomain.setTenantCode(tenantCode);
            bsRoadDomain.setDataState("1");
            bsRoadDomains.add(bsRoadDomain);
        }
        HashMap<String, String> proMap = new HashMap<String, String>();
        proMap.put("bsRoadDomainList", JsonUtil.buildNormalBinder().toJson(bsRoadDomains));
        this.getInternalRouter().inInvoke(ROAD_ADD_API_CODE, proMap);
    }

    private JdVopFreight querySkuFreight(JdClient client, List<WhGoodsBean> whGoodsBeanList, String areaStr) {
        com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.querySkuFreight.OpenRpcResult openRpcResult = null;
        JdVopFreight jdVopFreight = null;
        try {
            FreightQueryOpenReq freightQueryOpenReq = new FreightQueryOpenReq();
            ArrayList<com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.request.querySkuFreight.SkuInfoOrderOpenReq> skuInfos = new ArrayList<com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.request.querySkuFreight.SkuInfoOrderOpenReq>();
            for (WhGoodsBean whGoodsBean : whGoodsBeanList) {
                com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.request.querySkuFreight.SkuInfoOrderOpenReq skuInfo = new com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.request.querySkuFreight.SkuInfoOrderOpenReq();
                skuInfo.setSkuId(Long.valueOf(whGoodsBean.getSkuEocode()).longValue());
                skuInfo.setSkuNum(whGoodsBean.getGoodsNum().intValue());
                skuInfos.add(skuInfo);
            }
            freightQueryOpenReq.setSkuInfoList(skuInfos);
            QueryAreaFourIdOpenResp areaFourIdOpenResp = this.getAreaByDetailStr(client, areaStr);
            if (null == areaFourIdOpenResp) {
                return null;
            }
            AreaBaseInfoOpenReq areaBaseInfoGoodsReq = new AreaBaseInfoOpenReq();
            areaBaseInfoGoodsReq.setCityId(areaFourIdOpenResp.getCityId());
            areaBaseInfoGoodsReq.setCountyId(areaFourIdOpenResp.getCountyId());
            areaBaseInfoGoodsReq.setProvinceId(areaFourIdOpenResp.getProvinceId());
            areaBaseInfoGoodsReq.setTownId(areaFourIdOpenResp.getTownId());
            freightQueryOpenReq.setAreaInfo(areaBaseInfoGoodsReq);
            VopOrderQuerySkuFreightRequest request = new VopOrderQuerySkuFreightRequest();
            request.setFreightQueryOpenReq(freightQueryOpenReq);
            VopOrderQuerySkuFreightResponse response = (VopOrderQuerySkuFreightResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            FreightQueryOpenResp result = openRpcResult.getResult();
            jdVopFreight = new JdVopFreight();
            BeanUtils.copyAllPropertys((Object)jdVopFreight, (Object)result);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".querySkuFreight", (Object)("\u67e5\u8be2\u8fd0\u8d39\u5f02\u5e38.e:" + e));
            return null;
        }
        return jdVopFreight;
    }

    private QueryAreaFourIdOpenResp getAreaByDetailStr(JdClient client, String detailStr) {
        com.jd.open.api.sdk.domain.vopdz.ConvertAddressOpenProvider.response.convertFourAreaByDetailStr.OpenRpcResult openRpcResult = null;
        QueryAreaFourIdOpenResp result = null;
        try {
            VopAddressConvertFourAreaByDetailStrRequest request = new VopAddressConvertFourAreaByDetailStrRequest();
            request.setAddressDetailStr(detailStr);
            VopAddressConvertFourAreaByDetailStrResponse response = (VopAddressConvertFourAreaByDetailStrResponse)client.execute((JdRequest)request);
            if (null == response) {
                this.logger.error(this.SYS_CODE + "getAreaByDetailStr.response");
                return null;
            }
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "getAreaByDetailStr.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "getAreaByDetailStr.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "getAreaByDetailStr.e", (Throwable)e);
            return null;
        }
        return result;
    }

    private CheckAccountBalanceOpenResp getAccountBalance(JdClient client) {
        com.jd.open.api.sdk.domain.vopdd.QueryBalanceOpenProvider.response.checkAccountBalance.OpenRpcResult openRpcResult = null;
        CheckAccountBalanceOpenResp result = null;
        try {
            VopOrderCheckAccountBalanceRequest request = new VopOrderCheckAccountBalanceRequest();
            VopOrderCheckAccountBalanceResponse response = (VopOrderCheckAccountBalanceResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "getAccountBalance.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "getAccountBalance.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".getAccountBalance", (Object)("\u67e5\u8be2\u4f59\u989d\u5f02\u5e38.Ex:" + e));
            return null;
        }
        return result;
    }

    private OpenPagingResult getAccountBalanceDetail(JdClient client) {
        com.jd.open.api.sdk.domain.vopdd.QueryBalanceOpenProvider.response.checkBalanceChangeInfo.OpenRpcResult openRpcResult = null;
        OpenPagingResult result = null;
        try {
            VopOrderCheckBalanceChangeInfoRequest request = new VopOrderCheckBalanceChangeInfoRequest();
            request.setStartDate(new Date());
            request.setJdOrderId(Long.valueOf(123006233275L));
            request.setPageSize(20);
            request.setEndDate(new Date());
            request.setPageIndex(4);
            VopOrderCheckBalanceChangeInfoResponse response = (VopOrderCheckBalanceChangeInfoResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "getAccountBalanceDetail.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "getAccountBalanceDetail.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".getAccountBalance", (Object)("\u67e5\u8be2\u4f59\u989d\u660e\u7ec6\u5f02\u5e38.Ex:" + e));
            return null;
        }
        return result;
    }

    private QueryOrderOpenResp submitJdVopOrder(JdClient client, OcContractReDomain ocContractReDomain) {
        QueryOrderOpenResp result = null;
        List<Object> skuInfos = new ArrayList();
        try {
            VopOrderSubmitOrderRequest request = new VopOrderSubmitOrderRequest();
            SubmitOrderOpenReq submitOrderOpenReq = new SubmitOrderOpenReq();
            ConsigneeInfoOrderOpenReq consigneeInfoOrderOpenReq = this.makeJdConsigneeInfo(client, ocContractReDomain);
            if (null == consigneeInfoOrderOpenReq) {
                return null;
            }
            submitOrderOpenReq.setConsigneeInfo(consigneeInfoOrderOpenReq);
            submitOrderOpenReq.setCustomerName("\u6709\u8272\u798f\u5229\u5546\u57ce");
            PaymentInfoOrderOpenReq paymentInfo = new PaymentInfoOrderOpenReq();
            paymentInfo.setPaymentType(Integer.valueOf(4));
            submitOrderOpenReq.setPaymentInfo(paymentInfo);
            submitOrderOpenReq.setRemark(ocContractReDomain.getContractRemark());
            skuInfos = this.makeJdVopSkuInfos(ocContractReDomain);
            if (ListUtil.isEmpty(skuInfos)) {
                return null;
            }
            submitOrderOpenReq.setSkuInfoList(skuInfos);
            submitOrderOpenReq.setSubmitStateType(Integer.valueOf(0));
            submitOrderOpenReq.setThirdOrderId(ocContractReDomain.getContractBillcode());
            request.setSubmitOrderOpenReq(submitOrderOpenReq);
            VopOrderSubmitOrderResponse response = (VopOrderSubmitOrderResponse)client.execute((JdRequest)request);
            VopOrderRpcResult vopOrderRpcResult = response.getVopOrderRpcResult();
            if (null == vopOrderRpcResult) {
                this.logger.error(this.SYS_CODE + "submitJdVopOrder.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!vopOrderRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "submitJdVopOrder.getSuccess", (Object)vopOrderRpcResult.getResultMessage());
                return null;
            }
            result = vopOrderRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".submitJdVopOrder", (Object)("\u4eac\u4e1c\u4e0b\u5355\u5f02\u5e38.Ex:" + e));
            return null;
        }
        return result;
    }

    private String payType(Integer payChannel) {
        if (null == payChannel) {
            this.logger.error(this.SYS_CODE + ".payType", (Object)"param is null");
            return null;
        }
        String faccountName = "";
        switch (payChannel) {
            case 8001: {
                faccountName = "\u5fae\u4fe1\u652f\u4ed8";
                break;
            }
            case 9000: {
                faccountName = "\u4eac\u4e1c\u652f\u4ed8";
                break;
            }
            default: {
                faccountName = "\u5176\u4ed6\u65b9\u5f0f\u652f\u4ed8";
            }
        }
        return faccountName;
    }

    private List<SkuInfoOrderOpenReq> makeJdVopSkuInfos(OcContractReDomain ocContractReDomain) {
        SkuInfoOrderOpenReq jdVopOrderSkuInfo = null;
        ArrayList<SkuInfoOrderOpenReq> skuInfoOrderOpenReqs = new ArrayList<SkuInfoOrderOpenReq>();
        List goodsList = ocContractReDomain.getGoodsList();
        if (ListUtil.isEmpty((Collection)goodsList)) {
            this.logger.error(this.SYS_CODE + "makeJdVopSkuInfos.Vop\u4e0b\u5355\u5f02\u5e38\uff0c\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            jdVopOrderSkuInfo = new SkuInfoOrderOpenReq();
            jdVopOrderSkuInfo.setSkuId(Long.valueOf(ocContractGoodsDomain.getSkuNo()).longValue());
            jdVopOrderSkuInfo.setSkuNeedGift(false);
            jdVopOrderSkuInfo.setSkuNum(ocContractGoodsDomain.getGoodsNum().intValue());
            jdVopOrderSkuInfo.setSkuUnitPrice(ocContractGoodsDomain.getPricesetNprice());
            skuInfoOrderOpenReqs.add(jdVopOrderSkuInfo);
        }
        return skuInfoOrderOpenReqs;
    }

    private ConsigneeInfoOrderOpenReq makeJdConsigneeInfo(JdClient client, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain) {
            return null;
        }
        ConsigneeInfoOrderOpenReq consigneeInfo = new ConsigneeInfoOrderOpenReq();
        consigneeInfo.setConsigneeName(ocContractReDomain.getGoodsReceiptMem());
        consigneeInfo.setConsigneeMobile(ocContractReDomain.getGoodsReceiptPhone());
        consigneeInfo.setConsigneePhone(ocContractReDomain.getGoodsReceiptPhone());
        consigneeInfo.setConsigneeAddress(ocContractReDomain.getGoodsReceiptArrdess());
        QueryAreaFourIdOpenResp areaByDetailStr = this.getAreaByDetailStr(client, ocContractReDomain.getGoodsReceiptArrdess());
        if (null == areaByDetailStr) {
            return null;
        }
        consigneeInfo.setConsigneeProvinceId(areaByDetailStr.getProvinceId());
        consigneeInfo.setConsigneeCityId(areaByDetailStr.getCityId());
        consigneeInfo.setConsigneeCountyId(areaByDetailStr.getCountyId());
        consigneeInfo.setConsigneeTownId(areaByDetailStr.getTownId());
        return consigneeInfo;
    }
}

