/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.order.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopdz.ConvertAddressOpenProvider.response.convertFourAreaByDetailStr.QueryAreaFourIdOpenResp;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.request.createAfsApply.ApplyAfterSaleOpenReq;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.request.createAfsApply.ApplyInfoItemOpenReq;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.request.createAfsApply.CustomerInfoOpenReq;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.request.createAfsApply.PickupWareInfoOpenReq;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.request.createAfsApply.ReturnWareInfoOpenReq;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.request.createAfsApply.WareDescInfoOpenReq;
import com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.response.createAfsApply.OpenRpcResult;
import com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.findRefundInfo.RefundInfoResultOpenResp;
import com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.getGoodsAttributes.SupportedInfoOpenResp;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.vopdz.VopAddressConvertFourAreaByDetailStrRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsCancelAfsApplyRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsConfirmAfsOrderRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsCreateAfsApplyRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsFindRefundInfoRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsGetGoodsAttributesRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsUpdateSendInfoRequest;
import com.jd.open.api.sdk.response.vopdz.VopAddressConvertFourAreaByDetailStrResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsCancelAfsApplyResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsConfirmAfsOrderResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsCreateAfsApplyResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsFindRefundInfoResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsGetGoodsAttributesResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsUpdateSendInfoResponse;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.jdvop.JdVopConstants;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "jdvop.DisRefundrServiceImpl";

    protected String getChannelCode() {
        return JdVopConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComRefundParam", (Object)("=:=" + channelApiCode + "=:=" + sendParam.toString() + "=:=" + configMap.toString() + "=:=" + param.toString()));
            return null;
        }
        sendParam.put("serverUrl", configMap.get("ophost"));
        sendParam.put("accessToken", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode()));
        sendParam.put("appKey", configMap.get("key"));
        sendParam.put("appSecret", configMap.get("secret"));
        if ("cmc.disRefund.saveSendOcRefund".equals(channelApiCode)) {
            sendParam.put("ocRefundDomain", param.get("ocRefundDomain"));
            sendParam.put("tenantCode", param.get("tenantCode"));
            sendParam.put("memberCode", param.get("memberCode"));
        }
        return sendParam;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String serverUrl = configMap.get("ophost");
        String accessToken = this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode());
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        if ("cmc.disRefund.saveSendOcRefund".equals(channelApiCode)) {
            OcRefundReDomain ocRefundDomain = (OcRefundReDomain)sendhttpParam.get("ocRefundDomain");
            boolean result = this.submitJdVopRefund((JdClient)client, ocRefundDomain);
            return result ? "SUCCESS" : "ERROR";
        }
        if ("cmc.disRefund.saveSendOcRefundState".equals(channelApiCode)) {
            OcRefundReDomain ocRefundDomain = (OcRefundReDomain)sendhttpParam.get("ocRefundDomain");
            boolean result = false;
            if (ocRefundDomain.getDataState() == 2) {
                result = this.fillAfsUpdateSendInfo((JdClient)client, ocRefundDomain);
            } else if (ocRefundDomain.getDataState() == -1) {
                result = this.cancelVopRefund((JdClient)client, ocRefundDomain);
            } else if (ocRefundDomain.getDataState() == 8) {
                result = this.confirmVopRefund((JdClient)client, ocRefundDomain);
            }
            return result ? "SUCCESS" : "ERROR";
        }
        if ("cmc.disRefund.queryVopAfsGetGoodsAttributes".equals(channelApiCode)) {
            String skuIds;
            String orderId;
            String thirdApplyId = (String)param.get("thirdApplyId");
            List<SupportedInfoOpenResp> supportedInfoOpenResps = this.queryVopGoodsAttributes((JdClient)client, thirdApplyId, orderId = (String)param.get("orderId"), skuIds = (String)param.get("skuIds"));
            if (ListUtil.isEmpty(supportedInfoOpenResps)) {
                return null;
            }
            return supportedInfoOpenResps.get(0).getCustomerExpect();
        }
        if ("cmc.disRefund.queryOcRefundInfo".equals(channelApiCode)) {
            String orderId;
            String thirdApplyId = (String)param.get("thirdApplyId");
            String refundInfo = this.queryVopRefundInfo((JdClient)client, thirdApplyId, orderId = (String)param.get("orderId"));
            if (StringUtils.isBlank((String)refundInfo)) {
                return "ERROR";
            }
            return refundInfo;
        }
        return "ERROR";
    }

    private String queryVopRefundInfo(JdClient client, String thirdApplyId, String orderId) {
        com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.findRefundInfo.OpenRpcResult returnType = null;
        String jsonResult = "";
        try {
            VopAfsFindRefundInfoRequest request = new VopAfsFindRefundInfoRequest();
            request.setThirdApplyId(thirdApplyId);
            request.setOrderId(Long.valueOf(orderId));
            VopAfsFindRefundInfoResponse response = (VopAfsFindRefundInfoResponse)client.execute((JdRequest)request);
            returnType = response.getReturnType();
            if (null == returnType) {
                this.logger.error(this.SYS_CODE + "queryVopRefundInfo.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!returnType.getSuccess()) {
                this.logger.error(this.SYS_CODE + "queryVopRefundInfo.getSuccess", (Object)returnType.getResultMessage());
                return null;
            }
            RefundInfoResultOpenResp result = returnType.getResult();
            jsonResult = JsonUtil.buildNormalBinder().toJson((Object)result);
            if (!returnType.getSuccess()) {
                this.logger.error(this.SYS_CODE + ".submitJdVopRefund.\u67e5\u8be2\u552e\u540e\u4fe1\u606f\u5931\u8d25.Ex", (Object)returnType.getResultMessage());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".submitJdVopRefund.\u67e5\u8be2\u552e\u540e\u4fe1\u606f\u5f02\u5e38.Ex", (Throwable)e);
            return null;
        }
        return jsonResult;
    }

    private boolean fillAfsUpdateSendInfo(JdClient client, OcRefundReDomain ocRefundDomain) {
        com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.response.updateSendInfo.OpenRpcResult openRpcResult = null;
        try {
            VopAfsUpdateSendInfoRequest request = new VopAfsUpdateSendInfoRequest();
            request.setThirdApplyId(ocRefundDomain.getRefundCode());
            request.setDeliverDate(DateUtil.getDateOfString((Long)System.currentTimeMillis(), (String)"YYYY-MM-dd HH:mm:ss"));
            request.setWareNum(ocRefundDomain.getGoodsNum().toString());
            request.setExpressCode(ocRefundDomain.getPackageBillno());
            OcRefundGoodsDomain ocRefundGoodsDomain = (OcRefundGoodsDomain)ocRefundDomain.getOcRefundGoodsDomainList().get(0);
            request.setWareId(ocRefundGoodsDomain.getSkuNo());
            String vopSkuType = this.getVopSkuType(ocRefundGoodsDomain.getContractGoodsGtype());
            request.setWareType(vopSkuType);
            request.setExpressCompany(ocRefundDomain.getPackageName());
            request.setFreightMoney(ocRefundDomain.getGoodsLogmoney().toString());
            request.setOrderId(Long.valueOf(ocRefundDomain.getContractNbillcode()));
            VopAfsUpdateSendInfoResponse response = (VopAfsUpdateSendInfoResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "fillAfsUpdateSendInfo.openRpcResult", (Object)response.getMsg());
                return false;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "fillAfsUpdateSendInfo.getSuccess", (Object)openRpcResult.getResultMessage());
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".submitJdVopRefund.\u586b\u5199\u8fd0\u5355\u4fe1\u606f\u5f02\u5e38.Ex", (Throwable)e);
            return false;
        }
        return "0000".equals(openRpcResult.getResultCode());
    }

    private List<SupportedInfoOpenResp> queryVopGoodsAttributes(JdClient client, String thirdApplyId, String orderId, String skuIds) {
        this.logger.error(this.SYS_CODE + ".queryVopGoodsAttributes", (Object)(thirdApplyId + "\uff0c" + orderId + "\uff0c" + skuIds));
        com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.getGoodsAttributes.OpenRpcResult openRpcResult = null;
        ArrayList<SupportedInfoOpenResp> result = new ArrayList();
        try {
            VopAfsGetGoodsAttributesRequest request = new VopAfsGetGoodsAttributesRequest();
            request.setThirdApplyId(thirdApplyId);
            request.setWareId(skuIds);
            request.setOrderId(Long.valueOf(orderId));
            VopAfsGetGoodsAttributesResponse response = (VopAfsGetGoodsAttributesResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + ".queryVopGoodsAttributes.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + ".queryVopGoodsAttributes.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".queryVopGoodsAttributes.e", (Throwable)e);
            return null;
        }
        return result;
    }

    private boolean cancelVopRefund(JdClient client, OcRefundReDomain ocRefundDomain) {
        com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.response.cancelAfsApply.OpenRpcResult openRpcResult = null;
        try {
            VopAfsCancelAfsApplyRequest request = new VopAfsCancelAfsApplyRequest();
            request.setThirdApplyId(ocRefundDomain.getRefundCode());
            request.setRemark("\u53d6\u6d88");
            request.setOrderId(Long.valueOf(ocRefundDomain.getContractNbillcode()));
            VopAfsCancelAfsApplyResponse response = (VopAfsCancelAfsApplyResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "cancelVopRefund.openRpcResult", (Object)response.getMsg());
                return false;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "cancelVopRefund.getSuccess", (Object)openRpcResult.getResultMessage());
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".submitJdVopRefund.\u53d6\u6d88\u552e\u540e\u5f02\u5e38.Ex", (Throwable)e);
            return false;
        }
        return "0000".equals(openRpcResult.getResultCode());
    }

    private boolean confirmVopRefund(JdClient client, OcRefundReDomain ocRefundDomain) {
        com.jd.open.api.sdk.domain.vopsh.OperaAfterSaleOpenProvider.response.confirmAfsOrder.OpenRpcResult openRpcResult = null;
        try {
            VopAfsConfirmAfsOrderRequest request = new VopAfsConfirmAfsOrderRequest();
            request.setThirdApplyId(ocRefundDomain.getRefundCode());
            request.setOrderId(Long.valueOf(ocRefundDomain.getContractNbillcode()));
            VopAfsConfirmAfsOrderResponse response = (VopAfsConfirmAfsOrderResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "confirmVopRefund.openRpcResult", (Object)response.getMsg());
                return false;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "confirmVopRefund.getSuccess", (Object)openRpcResult.getResultMessage());
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".submitJdVopRefund.\u786e\u8ba4\u552e\u540e\u5b8c\u6210\u5f02\u5e38.Ex", (Throwable)e);
            return false;
        }
        return "0000".equals(openRpcResult.getResultCode());
    }

    private boolean submitJdVopRefund(JdClient client, OcRefundReDomain ocRefundDomain) {
        OpenRpcResult openRpcResult = null;
        try {
            VopAfsCreateAfsApplyRequest request = new VopAfsCreateAfsApplyRequest();
            ApplyAfterSaleOpenReq applyAfterSaleOpenReq = new ApplyAfterSaleOpenReq();
            applyAfterSaleOpenReq.setThirdApplyId(ocRefundDomain.getRefundCode());
            applyAfterSaleOpenReq.setIsHasInvoice(Boolean.valueOf(false));
            ArrayList<ApplyInfoItemOpenReq> applyInfoItemOpenReqList = new ArrayList<ApplyInfoItemOpenReq>();
            List goodsList = ocRefundDomain.getGoodsList();
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                if (ocContractGoodsDomain.getRefundFlag() == 0) continue;
                ApplyInfoItemOpenReq applyInfoItemOpenReq = new ApplyInfoItemOpenReq();
                Integer vopRefundType = this.getVopRefundType(ocRefundDomain.getRefundType());
                applyInfoItemOpenReq.setCustomerExpect(vopRefundType);
                WareDescInfoOpenReq wareDescInfoOpenReq = new WareDescInfoOpenReq();
                wareDescInfoOpenReq.setIsNeedDetectionReport(Boolean.valueOf(false));
                wareDescInfoOpenReq.setIsHasPackage(Boolean.valueOf("1".equals(ocRefundDomain.getRefundPake())));
                wareDescInfoOpenReq.setLossPreventionTagFlag(Boolean.valueOf(false));
                wareDescInfoOpenReq.setQuestionDesc(ocRefundDomain.getRefundMeo());
                wareDescInfoOpenReq.setPackageDesc(Integer.valueOf(1));
                applyInfoItemOpenReq.setWareDescInfoOpenReq(wareDescInfoOpenReq);
                applyInfoItemOpenReqList.add(applyInfoItemOpenReq);
            }
            applyAfterSaleOpenReq.setApplyInfoItemOpenReqList(applyInfoItemOpenReqList);
            applyAfterSaleOpenReq.setOrderId(Long.valueOf(ocRefundDomain.getContractNbillcode()));
            CustomerInfoOpenReq customerInfoVo = new CustomerInfoOpenReq();
            customerInfoVo.setCustomerName(ocRefundDomain.getRefundReceiptMem());
            customerInfoVo.setCustomerMobilePhone(ocRefundDomain.getRefundReceiptPhone());
            applyAfterSaleOpenReq.setCustomerInfoVo(customerInfoVo);
            if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundArrdess())) {
                PickupWareInfoOpenReq pickupWareInfoOpenReq = new PickupWareInfoOpenReq();
                QueryAreaFourIdOpenResp areaByDetailStr = this.getAreaByDetailStr(client, ocRefundDomain.getRefundArrdess());
                assert (areaByDetailStr != null);
                pickupWareInfoOpenReq.setPickWareProvince(Integer.valueOf(4));
                pickupWareInfoOpenReq.setPickWareProvince(Integer.valueOf(areaByDetailStr.getProvinceId().intValue()));
                pickupWareInfoOpenReq.setPickWareCity(Integer.valueOf(areaByDetailStr.getCityId().intValue()));
                pickupWareInfoOpenReq.setPickWareCounty(Integer.valueOf(areaByDetailStr.getCountyId().intValue()));
                pickupWareInfoOpenReq.setPickWareVillage(Integer.valueOf(areaByDetailStr.getTownId().intValue()));
                pickupWareInfoOpenReq.setPickWareAddress(ocRefundDomain.getRefundArrdess());
                String beginTime = DateUtil.getDateOfString((Long)System.currentTimeMillis(), (String)"YYYY-MM-dd HH:mm:ss");
                String endDate = DateUtil.getAfterDate((String)beginTime, (int)3, (String)"YYYY-MM-dd HH:mm:ss");
                pickupWareInfoOpenReq.setReserveDateBegin(beginTime);
                pickupWareInfoOpenReq.setReserveDateEnd(endDate);
                applyAfterSaleOpenReq.setPickupWareInfoOpenReq(pickupWareInfoOpenReq);
            }
            if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundReceiptArrdess())) {
                ReturnWareInfoOpenReq returnWareInfoOpenReq = new ReturnWareInfoOpenReq();
                returnWareInfoOpenReq.setReturnWareType(Integer.valueOf(20));
                String refundReceiptArrdess = ocRefundDomain.getRefundReceiptArrdess();
                QueryAreaFourIdOpenResp returnAreaStr = this.getAreaByDetailStr(client, refundReceiptArrdess);
                assert (returnAreaStr != null);
                returnWareInfoOpenReq.setReturnWareProvince(Integer.valueOf(returnAreaStr.getProvinceId().intValue()));
                returnWareInfoOpenReq.setReturnWareCity(Integer.valueOf(returnAreaStr.getCityId().intValue()));
                returnWareInfoOpenReq.setReturnWareCountry(Integer.valueOf(returnAreaStr.getCountyId().intValue()));
                returnWareInfoOpenReq.setReturnWareVillage(Integer.valueOf(returnAreaStr.getTownId().intValue()));
                returnWareInfoOpenReq.setReturnWareAddress(ocRefundDomain.getRefundReceiptArrdess());
                applyAfterSaleOpenReq.setReturnWareInfoOpenReq(returnWareInfoOpenReq);
            }
            request.setApplyAfterSaleOpenReq(applyAfterSaleOpenReq);
            VopAfsCreateAfsApplyResponse response = (VopAfsCreateAfsApplyResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".submitJdVopRefund.\u63d0\u4ea4\u552e\u540e\u5f02\u5e38.Ex", (Throwable)e);
            return false;
        }
        return "0000".equals(openRpcResult.getResultCode());
    }

    private QueryAreaFourIdOpenResp getAreaByDetailStr(JdClient client, String detailStr) {
        com.jd.open.api.sdk.domain.vopdz.ConvertAddressOpenProvider.response.convertFourAreaByDetailStr.OpenRpcResult openRpcResult = null;
        QueryAreaFourIdOpenResp result = null;
        try {
            VopAddressConvertFourAreaByDetailStrRequest request = new VopAddressConvertFourAreaByDetailStrRequest();
            request.setAddressDetailStr(detailStr);
            VopAddressConvertFourAreaByDetailStrResponse response = (VopAddressConvertFourAreaByDetailStrResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                this.logger.error(this.SYS_CODE + "getAreaByDetailStr.openRpcResult", (Object)response.getMsg());
                return null;
            }
            if (!openRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + "getAreaByDetailStr.getSuccess", (Object)openRpcResult.getResultMessage());
                return null;
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "getAreaByDetailStr.\u6839\u636e\u533a\u57df\u5b57\u7b26\u4e32\u67e5\u5730\u5740\u5f02\u5e38.Ex", (Throwable)e);
            return null;
        }
        return result;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        DisRefundDomain disRefundDomain;
        this.logger.error(this.SYS_CODE + "......", (Object)(sendhttpParam + "=:=" + configMap + "=:=" + param));
        if (null == sendhttpParam || null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        String billId = (String)jsonToMap.get("billId");
        String statusId = (String)jsonToMap.get("statusId");
        if ("newApplyAfterSaleBill".equals(methodType) || "newAfterSaleBill".equals(methodType)) {
            if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                this.logger.error(this.SYS_CODE + ".newApplyAfterSaleBill:", (Object)("billId:" + billId + ";statusId:" + statusId));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), billId, disChannel);
            if (null == disRefundDomain && null == (disRefundDomain = this.getSendRefund(null, billId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode()))) {
                this.logger.error(this.SYS_CODE + ".disRefundDomain.", (Object)(billId + "=:=" + sendhttpParam + "=:=" + disChannel.getTenantCode()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        if ("afterSaleBillStatus".equals(methodType)) {
            if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                this.logger.error(this.SYS_CODE + ".afterSaleBillStatus:", (Object)("billId:" + billId + ";statusId:" + statusId));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("11".equals(statusId) || "12".equals(statusId) || "30".equals(statusId) || "90".equals(statusId) || "92".equals(statusId) || "93".equals(statusId) || "110".equals(statusId) || "111".equals(statusId) || "1101".equals(statusId) || "1111".equals(statusId) || "1112".equals(statusId) || "112".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), billId, disChannel);
            if (null == disRefundDomain && null == (disRefundDomain = this.getSendRefund(null, billId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode()))) {
                this.logger.error(this.SYS_CODE + ".afterSaleBillStatus.", (Object)("disRefundDomain is null" + billId + "=:=" + sendhttpParam.get("memberCode")));
                return this.resultReturn("-1", "ERROR", "jd_param_json");
            }
            if ("50".equals(statusId)) {
                statusId = "51";
            }
            HashMap<String, String> mapP = new HashMap<String, String>();
            mapP.put("dataStatestr", statusId);
            this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(statusId), disRefundDomain.getDataState(), mapP);
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeRefund(param, disChannel);
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        Object o;
        String pic;
        this.logger.error(this.SYS_CODE + ".makeRefund1: ", map);
        String PICURL = "http://img10.360buyimg.com/o2o/";
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        String orderId = map.get("orderId").toString();
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel);
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain1", (Object)orderId);
            return null;
        }
        disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode());
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)orderId);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
        }
        disRefundDomain.setContractNbillcode(orderId);
        disRefundDomain.setRefundOcode(map.get("afsServiceOrder").toString());
        disRefundDomain.setDataStatestr(map.get("afsServiceState").toString());
        Object time = map.get("createTime");
        String createTime = null == time ? null : String.valueOf(time);
        Date refundTime = null;
        if (null != createTime && Long.valueOf(createTime) > 0L) {
            refundTime = StringUtils.isNotBlank((String)createTime) ? new Date(Long.valueOf(createTime)) : null;
        }
        disRefundDomain.setRefundDate(refundTime);
        Object questionType = map.get("questionTypeCid");
        String questionTypeCid = null == questionType ? null : String.valueOf(questionType);
        disRefundDomain.setRefundEx(this.fetchRefundType(questionTypeCid));
        String questionDesc = null == map.get("questionDesc") ? "" : (String)map.get("questionDesc");
        disRefundDomain.setRefundMeo(questionDesc);
        disRefundDomain.setRefundUsertype("0");
        if (null != map.get("questionPic") && StringUtils.isNotBlank((String)(pic = String.valueOf(map.get("questionPic"))))) {
            pic = "http://img10.360buyimg.com/o2o/" + pic;
            pic = pic.replace(",", ",http://img10.360buyimg.com/o2o/");
            String[] str = pic.split("\\,");
            List<String> listStr = Arrays.asList(str);
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        String refundPrice = null == (o = map.get("cashMoney")) ? null : String.valueOf(o);
        List goodlist = (List)map.get("afsDetailList");
        if (ListUtil.isEmpty((Collection)goodlist)) {
            this.logger.error(this.SYS_CODE + ".goodsList jddj1", map);
            return null;
        }
        String refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != refundAuditTime && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        BigDecimal refundMoney = new BigDecimal(refundPrice).divide(new BigDecimal("100")).setScale(2, 4);
        if (null != refundMoney) {
            disRefundDomain.setRefundMoney(refundMoney);
        }
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disContractDomain, disRefundDomain));
        this.logger.error(this.SYS_CODE + ".makeRefund2: ", (Object)JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(goodlist + "=:=" + disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            for (String key : map.keySet()) {
                BigDecimal refnum;
                disRefundDomain.setRefundType("jddj2");
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
                if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                    refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                refundGoodsList.add(disRefundGoodsDomain);
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
            }
            if (null == disRefundDomain.getRefundMoney()) {
                disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
            }
        } else {
            BigDecimal addRefundNum = BigDecimal.ZERO;
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(gmap.get("skuIdIsv"));
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                Integer skuCount = null == gmap.get("skuCount") ? null : (Integer)gmap.get("skuCount");
                BigDecimal number = null == skuCount ? BigDecimal.ZERO : BigDecimal.valueOf(skuCount.intValue());
                Object o = map.get("cashMoney");
                String cashMoney = null == o ? null : String.valueOf(o);
                BigDecimal totalRefund = null == cashMoney ? BigDecimal.ZERO : new BigDecimal(cashMoney).divide(new BigDecimal("100")).setScale(2, 4);
                disRefundGoodsDomain.setRefundGoodsNum(number);
                disRefundGoodsDomain.setRefundGoodsPrice(totalRefund.divide(number).setScale(2, 4));
                disRefundGoodsDomain.setRefundGoodsAmt(totalRefund);
                disRefundGoodsDomain.setRefundGoodsWeight(number);
                addRefundNum = addRefundNum.add(number);
                refundGoodsList.add(disRefundGoodsDomain);
            }
            BigDecimal refundNum = BigDecimal.ZERO;
            refundNum = refundNum.add(addRefundNum);
            List disRefundList = this.queryDisRefundByNbbillcode(disContractDomain.getChannelCode(), disContractDomain.getContractNbillcode(), disContractDomain.getTenantCode());
            if (ListUtil.isEmpty((Collection)disRefundList)) {
                disRefundDomain.setRefundType("jddj1");
            } else {
                disRefundDomain.setRefundType("jddj1");
                for (DisRefundReDomain disRefundReDomain : disRefundList) {
                    List ocRefundGoodsDomainList = disRefundReDomain.getOcRefundGoodsDomainList();
                    if (ListUtil.isEmpty((Collection)ocRefundGoodsDomainList)) {
                        return null;
                    }
                    for (DisRefundGoodsDomain disRefundGoods : ocRefundGoodsDomainList) {
                        refundNum = refundNum.add(disRefundGoods.getRefundGoodsNum());
                    }
                }
            }
            if (refundNum.compareTo(disContractDomain.getGoodsNum()) == 0) {
                disRefundDomain.setRefundType("jddj2");
            }
        }
        return refundGoodsList;
    }

    private String fetchRefundType(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("201", "\u5546\u54c1\u8d28\u91cf\u95ee\u9898");
        map.put("202", "\u9001\u9519\u8d27");
        map.put("203", "\u7f3a\u4ef6\u5c11\u4ef6");
        map.put("501", "\u5168\u90e8\u5546\u54c1\u672a\u6536\u5230");
        map.put("208", "\u5305\u88c5\u810f\u6c61\u6709\u7834\u635f");
        map.put("207", "\u7f3a\u65a4\u5c11\u4e24");
        map.put("210", "\u5546\u5bb6\u901a\u77e5\u6211\u7f3a\u8d27");
        map.put("303", "\u5b9e\u7269\u4e0e\u539f\u56fe\u4e0d\u7b26");
        map.put("402", "\u4e0d\u60f3\u8981\u4e86");
        map.put("502", "\u672a\u5728\u65f6\u6548\u5185\u9001\u8fbe");
        return (String)map.get(id);
    }

    private String getVopSkuType(String contractGoodsGtype) {
        String skuType = "10";
        switch (contractGoodsGtype) {
            case "0": {
                skuType = "10";
                break;
            }
            case "1": {
                skuType = "20";
                break;
            }
        }
        return skuType;
    }

    private Integer getVopRefundType(String refundType) {
        Integer vopRefundType = 10;
        switch (refundType) {
            case "JDB02": {
                vopRefundType = 10;
                break;
            }
            case "JDB03": {
                vopRefundType = 20;
                break;
            }
            case "JDB04": {
                vopRefundType = 30;
                break;
            }
        }
        return vopRefundType;
    }

    public static void main(String[] args) {
        String dateOfString = DateUtil.getDateOfString((Long)System.currentTimeMillis(), (String)"YYYY-MM-dd HH:mm:ss");
        String endDate = DateUtil.getAfterDate((String)dateOfString, (int)3, (String)"YYYY-MM-dd HH:mm:ss");
        System.out.println(dateOfString);
        System.out.println(endDate);
    }
}

