/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.goods.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.GetSkuPoolInfoGoodsResp;
import com.jd.open.api.sdk.domain.vopsp.SkuPoolGoodsProvider.response.getSkuPoolInfo.GetSkuPoolInfoItemGoodsResp;
import com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.deleteClientMsgByIdList.OpenRpcResult;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.vopxx.VopMessageDeleteClientMsgByIdListRequest;
import com.jd.open.api.sdk.response.vopxx.VopMessageDeleteClientMsgByIdListResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthToken;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.PoolSkubean;
import com.yqbsoft.laser.service.ext.channel.jdvop.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.channel.jdvop.goods.service.DisGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.JdBeanUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EsGoodsServiceImpl
extends DisGoodsServiceImpl
implements EsGoodsService {
    private String SYS_CODE = "jdvop.EsGoodsServiceImpl";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";
    private static final String RESOURCEGOODS_DEL_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveGoods";

    @Override
    public void saveGoodsPool(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolSkubean", (Object)"===>parm is null");
            return;
        }
        GetSkuPoolInfoItemGoodsResp poolInfo = poolSkubean.getPoolInfo();
        if (null == poolInfo) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolInfo", (Object)"===>parm is null");
            return;
        }
        DisChannel disChannel = poolSkubean.getDisChannel();
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolInfo", (Object)"===>parm is null");
            return;
        }
        String tenantCode = disChannel.getTenantCode();
        JdClient client = poolSkubean.getClient();
        if (null == client) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.client", (Object)"===>parm is null");
            return;
        }
        this.saveGoodsPool(poolInfo, disChannel, tenantCode, client, poolSkubean);
    }

    @Override
    public void saveGoodsPrice(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            return;
        }
        GetSkuPoolInfoItemGoodsResp poolInfo = poolSkubean.getPoolInfo();
        DisChannel disChannel = poolSkubean.getDisChannel();
        JdClient client = poolSkubean.getClient();
        try {
            this.synJdVopPrice(disChannel, client, poolInfo, poolSkubean);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPrice.e", (Throwable)e);
        }
    }

    @Override
    public boolean saveVopJdSkuIds(PoolSkubean poolSkubean) {
        return this.saveGoodsSkuStr(poolSkubean.getPoolInfo(), poolSkubean.getDisChannel(), poolSkubean.getTenantCode(), poolSkubean.getClient(), poolSkubean.getItems(), poolSkubean);
    }

    @Override
    public boolean saveVopJdSkuIdslog(PoolSkubean poolSkubean) {
        return this.saveGoodsSkuStrlog(poolSkubean.getPoolInfo(), poolSkubean.getDisChannel(), poolSkubean.getTenantCode(), poolSkubean.getClient(), poolSkubean.getItems(), poolSkubean);
    }

    @Override
    public void updateGoodsInfo(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            this.logger.info(this.SYS_CODE + ".updateGoodsInfo.updateGoodsSku" + "========16================" + skuId);
            JdClient client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSku(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
    }

    @Override
    public boolean deleteVopMsgById(JdClient client, String msgIds) {
        OpenRpcResult vopOrderRpcResult = null;
        try {
            VopMessageDeleteClientMsgByIdListRequest request = new VopMessageDeleteClientMsgByIdListRequest();
            request.setId(msgIds);
            VopMessageDeleteClientMsgByIdListResponse response = (VopMessageDeleteClientMsgByIdListResponse)client.execute((JdRequest)request);
            if (null == response.getVopOrderRpcResult()) {
                this.logger.error(this.SYS_CODE + ".deleteVopMsgById.response.getVopOrderRpcResult()", (Object)response.getMsg());
                return false;
            }
            vopOrderRpcResult = response.getVopOrderRpcResult();
            if (!vopOrderRpcResult.getSuccess()) {
                this.logger.error(this.SYS_CODE + ".deleteVopMsgById.vopOrderRpcResult.getSuccess()", (Object)vopOrderRpcResult.getResultMessage());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".deleteVopMsgById.Exception", (Throwable)e);
            return false;
        }
    }

    @Override
    public void putOrOffGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.info(this.SYS_CODE + ".putOrOffGoods.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String state = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            this.logger.info(this.SYS_CODE + ".contentMap>>>>>>>>>>>>>>>>" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            ArrayList<String> goodsIds = new ArrayList<String>();
            goodsIds.add(skuId);
            state = JsonUtil.buildNormalBinder().toJson(contentMap.get("state"));
            this.soldOrShelveGoodsByGoodsIds(goodsIds, state, jdResponseMessageContentDomain);
        }
    }

    @Override
    public void addOrRemoveGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = "";
        if (null != jdResponseMessageContentDomain && null != jdResponseMessageContentDomain.getDisChannel()) {
            tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods.e-" + tenantCode, (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        Object pageNum = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoods \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent=" + tenantCode + "--" + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods contentMap= " + tenantCode + "--" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addGoods \u5546\u54c1\u5df2\u7ecf\u5b58\u5728\uff0cskuId= " + tenantCode + "--" + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addGoods skuId= " + tenantCode + "--", (Object)skuId);
            this.addGoodsBySkuId(Long.valueOf(skuId), jdResponseMessageContentDomain);
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".RemoveGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + tenantCode + "--" + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".RemoveGoods goodsIds= " + tenantCode + "--", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            this.delGoodsByGoodsIds(goodsIds);
        }
    }

    private void delGoodsByGoodsIds(List<Integer> goodsIds) {
        this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", goodsIds);
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put("goodsIds", JsonUtil.buildNormalBinder().toJson(goodsIds));
            this.logger.error(this.SYS_CODE + ".deletePromotioneToGoods.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private void addGoodsBySkuId(Long skuId, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String FUNC_CODE = this.SYS_CODE + ".addGoodsBySkuId ----> ";
        this.logger.error(FUNC_CODE, (Object)"====> start");
        if (null == skuId || null == jdResponseMessageContentDomain || null == jdResponseMessageContentDomain.getDisChannel()) {
            this.logger.error(this.SYS_CODE + ".addGoodsBySkuIdStr", (Object)("skuId" + skuId + "jdResponseMessageContentDomain" + JsonUtil.buildNormalBinder().toJson((Object)jdResponseMessageContentDomain)));
        }
        PoolSkubean poolSkubean = new PoolSkubean();
        GetSkuPoolInfoItemGoodsResp poolInfo = new GetSkuPoolInfoItemGoodsResp();
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        JdClient client = this.getJdClient(jdResponseMessageContentDomain);
        poolSkubean.setDisChannel(disChannel);
        poolSkubean.setPoolInfo(poolInfo);
        poolSkubean.setTenantCode(tenantCode);
        poolSkubean.setClient(client);
        poolSkubean.setKeymap(jdResponseMessageContentDomain.getKeyMap());
        ArrayList<Long> items = new ArrayList<Long>();
        items.add(skuId);
        poolSkubean.setItems(items);
        this.saveVopJdSkuIds(poolSkubean);
    }

    private void soldOrShelveGoodsByGoodsIds(List<String> jdSkuIds, String type, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (ListUtil.isEmpty(jdSkuIds) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", (Object)(jdSkuIds + "===" + type));
            return;
        }
        Map<String, Object> keyMap = jdResponseMessageContentDomain.getKeyMap();
        boolean crmFlag = false;
        if (MapUtil.isNotEmpty(keyMap)) {
            crmFlag = "true".equals(String.valueOf(keyMap.get("crmFlag")));
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (String skuNo : jdSkuIds) {
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuNo, jdResponseMessageContentDomain.getDisChannel());
            if (goodsBean == null) {
                this.logger.error(this.SYS_CODE + ".contentMap---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean));
                continue;
            }
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
            this.logger.info(this.SYS_CODE + ".contentMap==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds));
            if (!ListUtil.isNotEmpty(goodsIds)) continue;
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("goodsIds", JsonUtil.buildNormalBinder().toJson(goodsIds));
                if ("0".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                    continue;
                }
                if (!"1".equals(type)) continue;
                this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.mapStr:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25", (Object)e.getMessage());
                throw new ApiException(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.ex", (Throwable)e);
            }
        }
    }

    @Override
    public String updateGoodsSku(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        for (Long skuIds : skuId) {
            GetSkuPoolInfoGoodsResp jdVopGoodsInfo = null;
            try {
                jdVopGoodsInfo = this.getSkuPoolInfoGoodsResp(client, skuIds);
            }
            catch (Exception e1) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.e1", (Throwable)e1);
                return "SUCCESS";
            }
            if (null == jdVopGoodsInfo) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.null", skuId);
                return "SUCCESS";
            }
            String pntreeCode = EsGoodsServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error(this.SYS_CODE + ".saveGoodsPool.pntreeCode", (Object)"=====>pntreeCode");
                return "ERROR";
            }
            this.updateInformation(client, jdVopGoodsInfo, disChannel, tenantCode, pntreeCode, String.valueOf(skuIds));
        }
        return "SUCCESS";
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.error(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        String channelCode = jdResponseMessageContentDomain.getDisChannel().getChannelCode();
        String memberCode = jdResponseMessageContentDomain.getDisChannel().getMemberCcode();
        String accessToken = this.getToken(tenantCode, channelCode, memberCode);
        String serverUrl = (String)jdResponseMessageContentDomain.getKeyMap().get("serverUrl");
        String appKey = (String)jdResponseMessageContentDomain.getKeyMap().get("appKey");
        String appSecret = (String)jdResponseMessageContentDomain.getKeyMap().get("appSecret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    @Override
    public String getToken(DisChannel disChannel) {
        String tokenStr;
        String tenantCode = disChannel.getTenantCode();
        String channelCode = disChannel.getChannelCode();
        String memberCode = disChannel.getMemberCcode();
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = "";
        }
        if (StringUtils.isBlank((String)(tokenStr = DisUtil.getRemotMap((String)"DisOauthToken-channelCode", (String)(channelCode + "-" + memberCode + "-" + tenantCode))))) {
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            return null;
        }
        return disOauthToken.getOauthTokenToken();
    }
}

