/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.jindie.util;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.xmlbeans.impl.util.Base64;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class ImageUtil {
    public static String encodeImgageToBase64Jpg(File imageFile) {
        ByteArrayOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encode((byte[])outputStream.toByteArray()));
    }

    public static String encodeImgageToBase64Png(File imageFile) {
        ByteArrayOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encode((byte[])outputStream.toByteArray()));
    }

    public static String encodeImgageToBase64(File imageFile, String imageType) {
        ByteArrayOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, imageType, outputStream);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encode((byte[])outputStream.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fullFileName, byte[] contents) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(fullFileName, "rw");
            raf.seek(raf.length());
            try (FileChannel channel = raf.getChannel();){
                ByteBuffer buffer = ByteBuffer.allocate(contents.length);
                buffer.put(contents);
                buffer.flip();
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
                channel.force(true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String imageUrlToBase64(String imageUrl) {
        if (StringUtils.isEmpty((Object)imageUrl)) {
            return "url is null";
        }
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            URL url = new URL(imageUrl);
            byte[] by = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            String base64Str = new String(Base64Utils.encode((byte[])data.toByteArray()));
            is.close();
            return base64Str;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "null";
        }
    }

    public static void main(String[] args) throws Exception {
        String picture = "{\"1\":\"https://supplierb2b2020122400000001.xytest.qjclouds.com/paas/shop/2020122400000001/2021-07-20/4936833acf5449df9c425c987d642d12.png\",\"8\":\"https://supplierb2b2020122400000001.xytest.qjclouds.com/paas/shop/2020122400000001/2021-07-20/aa7276e4909e41b88720890a41bc1e0b.png\",\"9\":\"https://supplierb2b2020122400000001.xytest.qjclouds.com/paas/shop/2020122400000001/2021-07-20/a8345daf7ecd4604b39ae0beb51115ea.png\"}";
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(picture, String.class, String.class);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            System.out.println((String)entry.getValue());
        }
    }
}

