/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.goods.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisGoodsBaseService;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.domain.MtResult;
import com.yqbsoft.laser.service.ext.channel.mt.domain.MtResultObject;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DisGoodsServiceImpl
extends DisGoodsBaseService {
    private String SYS_CODE = "mt.DisGoodsServiceImpl";
    @Autowired
    private RsGoodsClassService rsGoodsClassService;

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }

    public Map<String, Object> buildComGoodsClassParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        RsGoodsClassDomain rsGoodsClassDomain = (RsGoodsClassDomain)param.get("rsGoodsClassDomain");
        if (null != rsGoodsClassDomain) {
            String parentId = rsGoodsClassDomain.getGoodsClassParentcode();
            if ("cmc.disGoods.updateSendGoodsClass".equals(channelApiCode)) {
                sendParam.put("category_code_origin", sendParam.get("category_code"));
            } else if (StringUtils.isNotBlank((String)parentId) && !parentId.equals("-1")) {
                HashMap<String, String> mapByCode = new HashMap<String, String>();
                mapByCode.put("tenantCode", disChannel.getTenantCode());
                mapByCode.put("goodsClassCode", rsGoodsClassDomain.getGoodsClassParentcode());
                RsGoodsClassReDomain rsGoodsClassReDomain = this.rsGoodsClassService.getGoodsClassByCode(mapByCode);
                sendParam.put("category_name_origin", rsGoodsClassReDomain.getGoodsClassName());
                sendParam.put("secondary_category_code", sendParam.get("category_code"));
                sendParam.put("secondary_category_name", sendParam.get("category_name"));
                sendParam.put("category_name", rsGoodsClassReDomain.getGoodsClassName());
            }
        }
        return sendParam;
    }

    public String sendComSaveGoodsClass(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        RsGoodsClassDomain rsGoodsClassDomain;
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.realPath);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, null, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        MtResult mtResult = this.make(json);
        if (null == mtResult) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.elmResult", (Object)json);
            return json;
        }
        if (null != mtResult.getError()) {
            return (String)mtResult.getError().get("msg");
        }
        if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode) && null != (rsGoodsClassDomain = (RsGoodsClassDomain)param.get("rsGoodsClassDomain")) && StringUtils.isNotBlank((String)rsGoodsClassDomain.getGoodsClassCode())) {
            this.saveClassDictionary(disChannel, (String)param.get("memberCode"), rsGoodsClassDomain.getGoodsClassCode(), rsGoodsClassDomain.getGoodsClassCode(), (String)param.get("tenantCode"));
        }
        return "SUCCESS";
    }

    private MtResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        MtResult mtResult = (MtResult)JsonUtil.buildNormalBinder().getJsonToObject(json, MtResult.class);
        if (null == mtResult) {
            return null;
        }
        return mtResult;
    }

    public Map<String, Object> buildComGoodsParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        String memberCode = (String)param.get("memberCode");
        DecimalFormat df = new DecimalFormat("#");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            String images = Base64.encodeBase64String((byte[])((byte[])param.get("image")));
            sendParam.put("img_data", images);
            sendParam.put("img_name", "\u540d\u5b57\u5566");
        } else if ("cmc.disGoods.saveSendGoods".equals(channelApiCode) || "cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            sendParam.put("app_food_code", rsResourceGoodsReDomain.getGoodsCode());
            sendParam.put("name", rsResourceGoodsReDomain.getGoodsName());
            List skuDomains = rsResourceGoodsReDomain.getRsSkuDomainList();
            ArrayList skuList = new ArrayList();
            for (RsSkuDomain sku : skuDomains) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sku_id", sku.getSkuCode());
                map.put("spec", sku.getSkuName());
                map.put("price", sku.getPricesetNprice());
                map.put("stock", df.format(sku.getGoodsSupplynum()));
                map.put("weight", sku.getGoodsOneweight() == null ? BigDecimal.ZERO : sku.getGoodsOneweight());
                skuList.add(map);
            }
            int minorder = 1;
            if (null != rsResourceGoodsReDomain.getGoodsMinnum() && rsResourceGoodsReDomain.getGoodsMinnum().compareTo(BigDecimal.ZERO) > 0) {
                minorder = rsResourceGoodsReDomain.getGoodsMinnum().intValue();
            }
            sendParam.put("skus", JsonUtil.buildNormalBinder().toJson(skuList));
            sendParam.put("min_order_count", minorder);
            sendParam.put("unit", StringUtils.isBlank((String)rsResourceGoodsReDomain.getPartsnameNumunit()) ? "\u4e2a" : rsResourceGoodsReDomain.getPartsnameNumunit());
            sendParam.put("box_num", "1");
            sendParam.put("box_price", "1");
            sendParam.put("category_code", StringUtils.isBlank((String)rsResourceGoodsReDomain.getClasstreeShopcode()) ? rsResourceGoodsReDomain.getClasstreeCode() : rsResourceGoodsReDomain.getClasstreeShopcode());
            int state = rsResourceGoodsReDomain.getDataOpbillstate() == 1 ? 0 : 1;
            sendParam.put("is_sold_out", state);
        } else if ("cmc.disGoods.updateSendSkuNum".equals(channelApiCode)) {
            sendParam.put("app_poi_code", sendParam.get("app_poi_code"));
            ArrayList listMap = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sku_id", (String)param.get("skuEocode"));
            map.put("stock", df.format(String.valueOf(param.get("goodsSupplynum"))));
            listMap.add(map);
            ArrayList retList = new ArrayList();
            HashMap<String, Object> foodDataMap = new HashMap<String, Object>();
            foodDataMap.put("app_food_code", param.get("goodsEocode"));
            foodDataMap.put("skus", listMap);
            retList.add(foodDataMap);
            sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(retList));
        } else if ("cmc.disGoods.updateSendSkuPrice".equals(channelApiCode)) {
            sendParam.put("app_poi_code", sendParam.get("app_poi_code"));
            ArrayList listMap = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sku_id", param.get("skuEocode"));
            map.put("price", param.get("pricesetNprice"));
            listMap.add(map);
            ArrayList retList = new ArrayList();
            HashMap<String, Object> foodDataMap = new HashMap<String, Object>();
            foodDataMap.put("app_food_code", param.get("goodsEocode"));
            foodDataMap.put("skus", listMap);
            retList.add(foodDataMap);
            sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(retList));
        } else if ("cmc.disGoods.updateSendSkuUp".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsUp".equals(channelApiCode)) {
            this.buildParam(sendParam, param);
        } else if ("cmc.disGoods.updateSendSkuDow".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsDow".equals(channelApiCode)) {
            this.buildParam(sendParam, param);
        } else if ("cmc.disGoods.delSendSku".equals(channelApiCode)) {
            sendParam.put("app_poi_code", sendParam.get("app_poi_code"));
            sendParam.put("app_food_code", param.get("goodsEocode"));
            sendParam.put("sku_id", param.get("skuEocode"));
        } else if ("cmc.disGoods.delSendGoods".equals(channelApiCode)) {
            sendParam.put("app_poi_code", sendParam.get("app_poi_code"));
            sendParam.put("app_food_code", param.get("goodsEocode"));
        }
        return sendParam;
    }

    private Map<String, Object> buildParam(Map<String, Object> sendParam, Map<String, Object> param) {
        sendParam.put("app_poi_code", sendParam.get("app_poi_code"));
        sendParam.put("sell_status", sendParam.get("sell_status"));
        ArrayList listMap = new ArrayList();
        HashMap<String, Object> foodDataMap = new HashMap<String, Object>();
        foodDataMap.put("app_food_code", param.get("goodsEocode"));
        List skuList = (List)param.get("skuCodeList");
        if (ListUtil.isNotEmpty((Collection)skuList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String sku : skuList) {
                map.put("sku_id", sku);
            }
            listMap.add(map);
            foodDataMap.put("skus", listMap);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sku_id", param.get("skuEocode"));
            listMap.add(map);
            foodDataMap.put("skus", listMap);
        }
        ArrayList<HashMap<String, Object>> retList = new ArrayList<HashMap<String, Object>>();
        retList.add(foodDataMap);
        sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(retList));
        this.logger.error(this.SYS_CODE + ".buildParam.========================", (Object)(":" + sendParam.toString()));
        return sendParam;
    }

    public String sendComSaveGoods(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.realPath);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            MtResultObject elmResult = this.makeObject(json);
            if (null == elmResult) {
                return "ERROR";
            }
            if (null != elmResult.getError()) {
                return elmResult.getError().getMessage();
            }
            String code = (String)elmResult.getResult();
            this.saveFileList(disChannel, (String)param.get("fileCode"), (String)param.get("fchannelCode"), code, (String)param.get("tenantCode"));
        } else {
            MtResult mtResult = this.make(json);
            if (null == mtResult) {
                return "ERROR";
            }
            if (MapUtil.isNotEmpty(mtResult.getError())) {
                return (String)mtResult.getError().get("msg");
            }
            if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.rsResourceGoodsReDomain", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                this.saveGoods(disChannel, rsResourceGoodsReDomain.getGoodsNo(), rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getTenantCode());
            }
            if ("cmc.disGoods.saveSendSku".equals(channelApiCode)) {
                RsSkuDomain rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
                if (null == rsSkuDomain) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.rsSkuDomain", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                this.saveSku(disChannel, rsSkuDomain.getSkuNo(), rsSkuDomain.getSkuCode(), rsSkuDomain.getSkuCode(), rsSkuDomain.getTenantCode());
            }
        }
        return "SUCCESS";
    }

    private MtResultObject makeObject(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".makeObject.json");
            return null;
        }
        MtResultObject elmResult = (MtResultObject)JsonUtil.buildNormalBinder().getJsonToObject(json, MtResultObject.class);
        if (null == elmResult) {
            return null;
        }
        return elmResult;
    }
}

