/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.order.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.WebUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "mt.DisRefundrServiceImpl";

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        return sendParam;
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            strMap.put(key, String.valueOf(map.get(key)));
        }
        return strMap;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, String> mapStr = this.convert(sendhttpParam);
        try {
            json = WebUtils.doGet(url, mapStr, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map mtOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)mtOrderMap)) {
            return null;
        }
        if (null != mtOrderMap.get("error")) {
            throw new ApiException(this.SYS_CODE + ".sendComRefund.mtResultListOrder", (String)mtOrderMap.get("error"));
        }
        if (null == mtOrderMap.get("data")) {
            return null;
        }
        if ("cmc.disRefund.getSendRefund".equals(channelApiCode)) {
            List mapList = (List)mtOrderMap.get("data");
            this.logger.error(this.SYS_CODE + ".sendComRefund", (Object)("===========" + mtOrderMap + ",======" + mapList));
            if (ListUtil.isEmpty((Collection)mapList)) {
                return null;
            }
            for (Map map : mapList) {
                if (!sendhttpParam.get("refundOcode").equals((String)map.get("refund_id"))) continue;
                return this.createRefund(map, disChannel);
            }
        }
        return null;
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        try {
            return this.makeRefund(param, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".createRefund.e", (Throwable)e);
            return null;
        }
    }

    private Date transferLongToDate(Long millSec) {
        try {
            Date date = new Date(millSec);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        if (MapUtil.isEmpty(map) || null == disChannel) {
            return null;
        }
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        String order_id = (String)map.get("order_id");
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), order_id, disChannel);
        disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode());
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)order_id);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
        }
        disRefundDomain.setRefundOcode((String)map.get("refund_id"));
        String ctimeStr = (String)map.get("ctime");
        Date sendTime = null;
        if (null != ctimeStr) {
            sendTime = this.transferLongToDate(Long.valueOf(String.valueOf(ctimeStr) + "000"));
        }
        disRefundDomain.setRefundCreate(sendTime);
        String res_reason = (String)map.get("res_reason");
        disRefundDomain.setRefundEx(res_reason);
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo((String)map.get("apply_reason"));
        disRefundDomain.setDataStatestr(String.valueOf(map.get("res_type")));
        Object moneyObj = map.get("money");
        BigDecimal refundMoney = BigDecimal.ZERO;
        if (null != moneyObj) {
            refundMoney = new BigDecimal(String.valueOf(moneyObj));
        }
        disRefundDomain.setRefundMoney(refundMoney);
        if (String.valueOf(map.get("methodType")).equals("all")) {
            disRefundDomain.setRefundType("mt2");
        } else if (String.valueOf(map.get("methodType")).equals("part")) {
            disRefundDomain.setRefundType("mt1");
        }
        String pictures = (String)map.get("pictures");
        disRefundDomain.setOcRefundFileDomainList(this.createFile(pictures, disRefundDomain));
        List goodlist = (List)JsonUtil.buildNormalBinder().getJsonToList(String.valueOf(map.get("food")), Map.class);
        this.logger.error(this.SYS_CODE + ".goodlist", (Object)(goodlist + "," + map));
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disRefundDomain, disContractDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisRefundDomain disRefundDomain, DisContractDomain disContractDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            return null;
        }
        Map<String, DisContractGoodsDomain> map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            BigDecimal amt = BigDecimal.ZERO;
            for (String key : map.keySet()) {
                DisContractGoodsDomain disContractGoodsDomain = map.get(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                amt = amt.add(disRefundGoodsDomain.getRefundGoodsAmt());
                this.logger.error(this.SYS_CODE + " createRefundGoods.amt: ", (Object)(amt + " === " + disContractGoodsDomain.getContractGoodsMoney()));
            }
            disRefundDomain.setRefundMoney(amt);
        } else {
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = map.remove(gmap.get("sku_id"));
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setRefundGoodsNum(BigDecimal.valueOf(((Integer)gmap.get("count")).intValue()));
                if (null != gmap.get("refund_price")) {
                    disRefundGoodsDomain.setRefundGoodsPrice(BigDecimal.valueOf((Double)gmap.get("refund_price")));
                }
                if (null != gmap.get("refunded_weight")) {
                    disRefundGoodsDomain.setRefundGoodsWeight(BigDecimal.valueOf((Double)gmap.get("refunded_weight")));
                }
                disRefundGoodsDomain.setRefundGoodsAmt(disRefundGoodsDomain.getRefundGoodsPrice().multiply(disRefundGoodsDomain.getRefundGoodsNum()));
                refundGoodsList.add(disRefundGoodsDomain);
            }
        }
        return refundGoodsList;
    }

    private DisRefundGoodsDomain create(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            return null;
        }
        DisRefundGoodsDomain disRefundGoodsDomain = new DisRefundGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundGoodsDomain, (Object)disContractGoodsDomain);
            disRefundGoodsDomain.setRefundGoodsAmt(disContractGoodsDomain.getContractGoodsMoney());
            disRefundGoodsDomain.setRefundGoodsNum(disContractGoodsDomain.getGoodsCamount());
            disRefundGoodsDomain.setRefundGoodsWeight(disContractGoodsDomain.getGoodsCweight());
            disRefundGoodsDomain.setRefundGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return disRefundGoodsDomain;
    }

    private Map<String, DisContractGoodsDomain> getMap(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty((Collection)disContractDomain.getPackageList())) {
            return null;
        }
        HashMap<String, DisContractGoodsDomain> map = new HashMap<String, DisContractGoodsDomain>();
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                map.put(disContractGoodsDomain.getSkuNo(), disContractGoodsDomain);
            }
        }
        return map;
    }

    private List<DisRefundFileDomain> createFile(String pictures, DisRefundDomain disRefundDomain) {
        if (StringUtils.isBlank((String)pictures) || null == disRefundDomain) {
            return null;
        }
        ArrayList<DisRefundFileDomain> disRefundFileDomainList = new ArrayList<DisRefundFileDomain>();
        String[] s = pictures.split("\\,");
        if (null == s || s.length == 0) {
            return null;
        }
        for (String refundFileUrl : s) {
            DisRefundFileDomain disRefundFileDomain = new DisRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disRefundFileDomain, (Object)disRefundDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
            }
            disRefundFileDomain.setRefundFileUrl(refundFileUrl);
            disRefundFileDomainList.add(disRefundFileDomain);
        }
        return disRefundFileDomainList;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == sendhttpParam) {
            return "{\"data\":\"ok\"}";
        }
        String order_id = (String)sendhttpParam.get("order_id");
        if (StringUtils.isBlank((String)order_id)) {
            return "{\"data\":\"ok\"}";
        }
        String refund_id = (String)sendhttpParam.get("refund_id");
        if (StringUtils.isBlank((String)refund_id)) {
            return "{\"data\":\"ok\"}";
        }
        String page_in = (String)sendhttpParam.get("page_in");
        String status = (String)sendhttpParam.get("status");
        String reason_code = (String)sendhttpParam.get("reason_code");
        DisRefundDomain disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), refund_id, disChannel);
        if (null == disRefundDomain) {
            if (StringUtils.isNotBlank((String)page_in) || StringUtils.isNotBlank((String)reason_code)) {
                disRefundDomain = this.getSendRefund(order_id, refund_id, null, disChannel.getTenantCode());
                if (null == disRefundDomain) {
                    return "{\"data\":\"\u9000\u5355\u4e3a\u7a7a\"}";
                }
                ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
                disRefundDomainList.add(disRefundDomain);
                this.saveRefund(disRefundDomainList, disChannel);
                return "{\"data\":\"ok\"}";
            }
            disRefundDomain = this.createRefund(sendhttpParam, disChannel);
            if (null == disRefundDomain) {
                return "{\"data\":\"error\"}";
            }
            ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
            disRefundDomainList.add(disRefundDomain);
            this.saveRefund(disRefundDomainList, disChannel);
            return "{\"data\":\"ok\"}";
        }
        if (StringUtils.isNotBlank((String)page_in)) {
            status = disRefundDomain.getDataStatestr();
        } else {
            String stateOld;
            if (StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)reason_code)) {
                return "{\"data\":\"ok\"}";
            }
            if ("1003".equals(reason_code)) {
                status = "9";
            }
            if (StringUtils.isEmpty((String)(stateOld = disRefundDomain.getDataStatestr()))) {
                return "{\"data\":\"ok\"}";
            }
            if (Integer.parseInt(status) <= Integer.parseInt(stateOld)) {
                return "{\"data\":\"ok\"}";
            }
        }
        String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), status);
        if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
            dataStateStr = status;
        }
        Integer dataState = Integer.valueOf(dataStateStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataStatestr", status);
        this.updateRefund(disChannel.getTenantCode(), refund_id, dataState, null, map, disChannel);
        return "{\"data\":\"ok\"}";
    }
}

