/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.sevice;

import com.yqbsoft.laser.service.ext.channel.mt.sevice.ApiOpException;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.ApiSysException;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.ConvertUtil;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.ErrorEnum;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.PropertiesUtil;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.URLFactory;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static CloseableHttpClient httpClient = HttpClients.createDefault();

    public static String requestOfPost(String url, Map<String, Object> applicationParamsMap) throws ApiSysException {
        HashMap<String, String> hmap = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(applicationParamsMap)) {
            for (String key : applicationParamsMap.keySet()) {
                hmap.put(key, String.valueOf(applicationParamsMap.get(key)));
            }
        }
        RequestConfig.Builder requestConfigBuilder = PropertiesUtil.getRequestConfig();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfigBuilder.build());
        CloseableHttpResponse response = null;
        try {
            List<BasicNameValuePair> nameValuePairList = ConvertUtil.convertToEntity(hmap);
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
            httpPost.setEntity((HttpEntity)uefEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new ApiSysException(e);
        }
        finally {
            httpPost.releaseConnection();
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                throw new ApiSysException(e);
            }
        }
    }

    public static String requestOfPost(String url, Map<String, String> applicationParamsMap, byte[] fileData, String imgName) throws ApiSysException {
        return HttpUtil.requestOfPost(url, applicationParamsMap, fileData, imgName, PropertiesUtil.getRequestConfig());
    }

    private static String requestOfPost(String url, Map<String, String> applicationParamsMap, byte[] fileData, String imgName, RequestConfig.Builder requestConfigBuilder) throws ApiSysException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfigBuilder.build());
        CloseableHttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            List<BasicNameValuePair> nameValuePairList = ConvertUtil.convertToEntity(applicationParamsMap);
            nameValuePairs.addAll(nameValuePairList);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("utf-8"));
            ByteArrayBody byteArray = new ByteArrayBody(fileData, imgName);
            entity.addPart("file", (ContentBody)byteArray);
            URLEncodedUtils.format(nameValuePairs, (String)"UTF-8");
            for (NameValuePair nameValuePair : nameValuePairs) {
                entity.addPart(nameValuePair.getName(), (ContentBody)new StringBody(nameValuePair.getValue(), Charset.forName("utf8")));
            }
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new ApiSysException(e);
        }
        finally {
            httpPost.releaseConnection();
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                throw new ApiSysException(e);
            }
        }
    }

    private static String requestOfGet(String url, RequestConfig.Builder requestConfigBuilder) throws ApiSysException {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfigBuilder.build());
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new ApiSysException(e);
        }
        finally {
            try {
                httpGet.releaseConnection();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                throw new ApiSysException(e);
            }
        }
    }

    public static String httpResultHandler(String httpResult) throws ApiOpException, ApiSysException {
        return HttpUtil.httpResultHandler(httpResult, false);
    }

    public static String httpResultHandler(String httpResult, boolean partSuccess) throws ApiOpException, ApiSysException {
        if (httpResult == null || httpResult.equals("")) {
            throw new ApiSysException(ErrorEnum.SYS_ERR);
        }
        Map resultObj = null;
        try {
            resultObj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(httpResult, String.class, Object.class);
        }
        catch (Exception e) {
            throw new ApiSysException(ErrorEnum.SYS_ERR);
        }
        if (resultObj == null || resultObj.get("data") == null) {
            throw new ApiSysException(ErrorEnum.SYS_ERR);
        }
        String dataStr = resultObj.get("data").toString();
        if (dataStr.equals("ng") || dataStr.equalsIgnoreCase("null")) {
            Map errObject = (Map)resultObj.get("error");
            if (errObject == null || errObject.toString().equals("") || errObject.toString().equalsIgnoreCase("null")) {
                throw new ApiSysException(ErrorEnum.SYS_ERR);
            }
            Map errJsonObject = null;
            try {
                errJsonObject = errObject;
            }
            catch (Exception e) {
                throw new ApiSysException(ErrorEnum.SYS_ERR);
            }
            if (errJsonObject == null || errJsonObject.get("code") == null || errJsonObject.get("code").equals("") || errJsonObject.get("code").toString().equalsIgnoreCase("null")) {
                throw new ApiSysException(ErrorEnum.SYS_ERR);
            }
            Integer errorCode = null;
            try {
                errorCode = Integer.parseInt(errJsonObject.get("code").toString());
            }
            catch (Exception e) {
                throw new ApiSysException(ErrorEnum.SYS_ERR);
            }
            if (errorCode == null) {
                throw new ApiSysException(ErrorEnum.SYS_ERR);
            }
            if (errJsonObject.get("msg") == null || errJsonObject.get("msg").equals("") || errJsonObject.get("msg").toString().equalsIgnoreCase("null")) {
                throw new ApiSysException(ErrorEnum.SYS_ERR);
            }
            String errorMsg = errJsonObject.get("msg").toString();
            throw new ApiOpException(errorCode, errorMsg);
        }
        if (partSuccess && StringUtils.isNotBlank((String)((String)resultObj.get("msg")))) {
            dataStr = (String)resultObj.get("msg");
        }
        return dataStr;
    }

    static {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        poolingHttpClientConnectionManager.setMaxTotal(PropertiesUtil.getHttpClientPoolMaxTotal());
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(PropertiesUtil.getHttpClientPoolDefaultMaxPerRoute());
        poolingHttpClientConnectionManager.setMaxPerRoute(URLFactory.getRequestUrlRoute(), PropertiesUtil.getHttpClientPoolMaxPerRoute());
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
    }
}

