/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.domain.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    private static final String MOBILE_REG_EXP_STRING = "^0?1[3|4|5|8][0-9]\\d{8}$";
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(Integer value) {
        return null == value;
    }

    public static String trim(String value) {
        if (StringUtils.isBlank(value)) {
            return EMPTY;
        }
        return value.trim();
    }

    public static boolean isBlank(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankLoop(String ... values) {
        int strLen;
        if (values == null || (strLen = values.length) == 0) {
            return true;
        }
        for (String value : values) {
            if (value == null || (strLen = value.length()) == 0) continue;
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(value.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasBlank(String ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (String value : values) {
            if (!StringUtils.isBlank(value)) continue;
            return true;
        }
        return false;
    }

    public static String stripToEmpty(String str) {
        return str == null ? EMPTY : StringUtils.strip(str, null);
    }

    private static String strip(String str, String stripChars) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        str = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(str, stripChars);
    }

    private static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    private static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static boolean isNotBlank(String value) {
        return !StringUtils.isBlank(value);
    }

    public static boolean isNotBlankLoop(String ... values) {
        return !StringUtils.isBlankLoop(values);
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        String pattern = "^[\\+\\-]?[\\d]+(\\.[\\d]+)?$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(obj.toString());
        return m.matches();
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtils.isEmpty(value);
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!StringUtils.isEmpty(unicode)) {
            for (int i = 0; i < unicode.length(); ++i) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    public static String stripNonValidXMLCharacters(String input) {
        if (input == null || EMPTY.equals(input)) {
            return EMPTY;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static String getFirstUpper(String str) {
        String newStr = EMPTY;
        if (str.length() > 0) {
            newStr = str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
        }
        return newStr;
    }

    public static String defaultIfBlank(String value, String defaultVal) {
        return StringUtils.isNotBlank(value) ? value : defaultVal;
    }

    public static String replaceAtIndex(int index, String ostr, String replaceChar) {
        if (StringUtils.isNotBlank(ostr)) {
            try {
                return ostr.replaceFirst(ostr.charAt(index) + EMPTY, replaceChar);
            }
            catch (Exception e) {
                return ostr;
            }
        }
        return ostr;
    }

    public static String fillLeft(String source, char fillChar, int len) {
        StringBuffer ret = new StringBuffer();
        if (null == source) {
            ret.append(EMPTY);
        }
        if (source.length() > len) {
            ret.append(source);
        } else {
            int slen = source.length();
            while (ret.toString().length() + slen < len) {
                ret.append(fillChar);
            }
            ret.append(source);
        }
        return ret.toString();
    }

    public static String filRight(String source, char fillChar, int len) {
        StringBuffer ret = new StringBuffer();
        if (null == source) {
            ret.append(EMPTY);
        }
        if (source.length() > len) {
            ret.append(source);
        } else {
            ret.append(source);
            while (ret.toString().length() < len) {
                ret.append(fillChar);
            }
        }
        return ret.toString();
    }

    public static String filterStr(String str) {
        if (null == str || EMPTY.equals(str)) {
            return str;
        }
        str = str.replaceAll("'", "''");
        return str;
    }

    public static boolean isAllChar(String str) {
        String regex = ".*[a-zA-Z]+.*";
        Matcher m = Pattern.compile(regex).matcher(str);
        return m.matches();
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        return cs1 == null ? cs2 == null : cs1.equals(cs2);
    }

    public static boolean isMapJson(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        return str.indexOf("{") == 0 && str.lastIndexOf("}") == str.length() - 1;
    }

    public static boolean isMapOrListJson(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        if ((str = str.trim()).indexOf("{") == 0 && str.lastIndexOf("}") == str.length() - 1) {
            return true;
        }
        return str.indexOf("[") == 0 && str.lastIndexOf("]") == str.length() - 1;
    }

    public static boolean isMobileNO(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        str = str.trim();
        Pattern p = Pattern.compile(MOBILE_REG_EXP_STRING);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static void main(String[] args) {
        String s = "\"dkj\"";
        System.out.println(StringUtils.isNumeric("31952"));
    }
}

