/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.util;

import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.BankInputFeeDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.GoldCirculate;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberOutputFeeDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.PayDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.ServiceMessageHeaderDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.SignDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class PayBuilder {
    private static final RestTemplate restTemplate = new RestTemplate();

    public static String requestSign(SignDomain signDomain) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(signDomain.getFuncFlag() + "&");
        stringBuffer.append(signDomain.getTxDate() + "&");
        if (StringUtils.isBlank(signDomain.getReserve())) {
            stringBuffer.append("&");
        } else {
            stringBuffer.append(signDomain.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String responseSign(SignDomain signDomain) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(signDomain.getFrontLogNo() + "&");
        if (StringUtils.isBlank(signDomain.getReserve())) {
            for (int i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(signDomain.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String requestPay(PayDomain payDomain) {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(payDomain.getSupAcctId() + "&");
        stringBuffer.append(payDomain.getFuncFlag() + "&");
        stringBuffer.append(payDomain.getCustAcctId() + "&");
        stringBuffer.append(payDomain.getThirdCustId() + "&");
        stringBuffer.append(payDomain.getTranAmount() + "&");
        stringBuffer.append(payDomain.getCcyCode() + "&");
        stringBuffer.append(payDomain.getThirdHtId() + "&");
        if (StringUtils.isBlank(payDomain.getNote())) {
            for (i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(payDomain.getNote());
        }
        if (StringUtils.isBlank(payDomain.getReserve())) {
            for (i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(payDomain.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String responsePay(PayDomain payDomain) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(payDomain.getFrontLogNo() + "&");
        if (StringUtils.isBlank(payDomain.getReserve())) {
            for (int i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(payDomain.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String requestQuery(GoldCirculate goldCirculate) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(goldCirculate.getCustAcctId() + "&");
        stringBuffer.append(goldCirculate.getSelectFlag() + "&");
        stringBuffer.append(goldCirculate.getPageNum() + "&");
        if (StringUtils.isBlank(goldCirculate.getReserve())) {
            for (int i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(goldCirculate.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String responseQuery(GoldCirculate goldCirculate) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(goldCirculate.getTotalCount() + "&");
        stringBuffer.append(goldCirculate.getBeginNum() + "&");
        stringBuffer.append(goldCirculate.getLastPage() + "&");
        stringBuffer.append(goldCirculate.getRecordNum() + "&");
        stringBuffer.append(new String[20]);
        stringBuffer.append("&");
        stringBuffer.append(goldCirculate.getCustAcctId() + "&");
        stringBuffer.append(goldCirculate.getAcctFlag() + "&");
        stringBuffer.append(goldCirculate.getTranType() + "&");
        stringBuffer.append(goldCirculate.getAcctName() + "&");
        stringBuffer.append(goldCirculate.getBankCode() + "&");
        stringBuffer.append(goldCirculate.getBankName() + "&");
        stringBuffer.append(goldCirculate.getAddress() + "&");
        stringBuffer.append(goldCirculate.getTranDate() + "&");
        stringBuffer.append(new String[20]);
        stringBuffer.append("&");
        if (StringUtils.isBlank(goldCirculate.getReserve())) {
            for (int i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(goldCirculate.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String outputFeeBycustomer(MemberOutputFeeDomain map) {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(map.getTranWebName() + "&");
        stringBuffer.append(map.getThirdCustId() + "&");
        stringBuffer.append(map.getIdType() + "&");
        stringBuffer.append(map.getIdCode() + "&");
        stringBuffer.append(map.getTranOutType() + "&");
        stringBuffer.append(map.getCustAcctId() + "&");
        stringBuffer.append(map.getCustName() + "&");
        stringBuffer.append(map.getSupAcctId() + "&");
        stringBuffer.append(map.getTranType() + "&");
        stringBuffer.append(map.getOutAcctId() + "&");
        stringBuffer.append(map.getOutAcctIdName() + "&");
        stringBuffer.append(map.getOutAcctIdBankName() + "&");
        if (StringUtils.isBlank(map.getOutAcctIdBankCode())) {
            stringBuffer.append("            &");
        } else {
            stringBuffer.append(map.getOutAcctIdBankCode() + "&");
        }
        if (StringUtils.isBlank(map.getAddress())) {
            for (i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(" &");
        } else {
            stringBuffer.append(map.getAddress() + "&");
        }
        if (StringUtils.isBlank(map.getCcyCode())) {
            stringBuffer.append("   &");
        } else {
            stringBuffer.append(map.getCcyCode() + "&");
        }
        stringBuffer.append(map.getTranAmount() + "&");
        stringBuffer.append(map.getFeeOutCustId() + "&");
        if (StringUtils.isBlank(map.getFeeOutCustId())) {
            for (i = 0; i < 32; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("&");
        } else {
            stringBuffer.append(map.getFeeOutCustId() + "&");
        }
        if (StringUtils.isBlank(map.getReserve())) {
            for (i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(map.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String requestInputFee(BankInputFeeDomain map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(map.getSupAcctId() + "&");
        stringBuffer.append(map.getCustAcctId() + "&");
        stringBuffer.append(map.getTranAmount() + "&");
        stringBuffer.append(map.getInAcctId() + "&");
        stringBuffer.append(map.getInAcctIdName() + "&");
        stringBuffer.append(map.getCcyCode() + "&");
        stringBuffer.append(map.getAcctDate() + "&");
        if (StringUtils.isBlank(map.getReserve())) {
            for (int i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(map.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String requestMember(MemberDomain map) {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(map.getFuncFlag() + "&");
        stringBuffer.append(map.getSupAcctId() + "&");
        stringBuffer.append(map.getCustAcctId() + "&");
        stringBuffer.append(map.getCustName() + "&");
        stringBuffer.append(map.getThirdCustId() + "&");
        stringBuffer.append(map.getIdType() + "&");
        stringBuffer.append(map.getIdCode() + "&");
        stringBuffer.append(map.getRelatedAcctId() + "&");
        stringBuffer.append(map.getAcctFlag() + "&");
        stringBuffer.append(map.getTranType() + "&");
        stringBuffer.append(map.getAcctName() + "&");
        if (StringUtils.isBlank(map.getBankCode())) {
            stringBuffer.append("            &");
        } else {
            stringBuffer.append(map.getBankCode() + "&");
        }
        if (StringUtils.isBlank(map.getBankName())) {
            for (i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("&");
        } else {
            stringBuffer.append(map.getBankName() + "&");
        }
        if (StringUtils.isBlank(map.getOldRelatedAcctId())) {
            for (i = 0; i < 32; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("&");
        } else {
            stringBuffer.append(map.getOldRelatedAcctId() + "&");
        }
        if (StringUtils.isBlank(map.getReserve())) {
            for (i = 0; i < 120; ++i) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(map.getReserve());
        }
        return stringBuffer.toString();
    }

    public static String send(String func, String thridLogNo, String content) {
        String param = PayBuilder.buildRquestMessage(func, thridLogNo, content);
        ResponseEntity response = restTemplate.postForEntity("http://112.124.128.119:7072", (Object)param, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public static String buildRquestMessage(String func, String thridLogNo, String content) {
        return PayBuilder.buildMessage(func, "01", thridLogNo, content);
    }

    public static String buildResponseMessage(String func, String thridLogNo, String content) {
        return PayBuilder.buildMessage(func, "02", thridLogNo, content);
    }

    public static String buildMessage(String func, String serverType, String thridLogNo, String content) {
        CommunicationDomain communicationDomain = new CommunicationDomain();
        Date date = new Date();
        date.setSeconds(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        String time = sdf.format(date);
        String tranDate = time.substring(0, 8);
        String tranTime = time.substring(9);
        communicationDomain.setTranDate(tranDate);
        communicationDomain.setTranTime(tranTime);
        communicationDomain.setCode("9264                ");
        communicationDomain.setOpterator("86301");
        communicationDomain.setServerType(serverType);
        communicationDomain.setThridLogNo(thridLogNo);
        ServiceMessageHeaderDomain serviceMessageHeaderDomain = new ServiceMessageHeaderDomain();
        serviceMessageHeaderDomain.setTranFunc(func);
        serviceMessageHeaderDomain.setServType(serverType);
        serviceMessageHeaderDomain.setMacCode("                ");
        serviceMessageHeaderDomain.setTranDate(tranDate);
        serviceMessageHeaderDomain.setTranTime(tranTime);
        if ("01".equals(serverType)) {
            serviceMessageHeaderDomain.setRspCode("999999");
        } else {
            serviceMessageHeaderDomain.setRspCode("000000");
        }
        serviceMessageHeaderDomain.setRspMsg("                                          ");
        serviceMessageHeaderDomain.setConFlag("0");
        serviceMessageHeaderDomain.setCounterId("EB001");
        serviceMessageHeaderDomain.setThirdLogNo(communicationDomain.getThridLogNo());
        serviceMessageHeaderDomain.setQydm("9264");
        serviceMessageHeaderDomain.setLength(String.format("%08d", content.length()));
        communicationDomain.setContentLenth(String.format("%010d", 122 + content.length()));
        String communicationMessage = communicationDomain.toString();
        String serviceHeader = serviceMessageHeaderDomain.toString();
        String param = communicationMessage + serviceHeader + content;
        return param;
    }

    public static String toFormatString(Object obj) {
        Field[] fields;
        StringBuffer buffer = new StringBuffer();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Object value = PayBuilder.getFieldValueByName(field.getName(), obj);
            buffer.append(value != null ? value : "");
            buffer.append("&");
        }
        return buffer.toString();
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("GBK")));
    }
}

