/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.service;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.support.ObjectService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.dao.UmUserDao;
import com.yqbsoft.laser.service.ext.channel.pinganbank.dao.UmUserinfoDao;
import com.yqbsoft.laser.service.ext.channel.pinganbank.dao.UmUserinfoQuaDao;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.BankInputFeeDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.BankOutputFeeDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.SignDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UserBalanceDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UserPayDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.IdUtil;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PayBuilder;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.UmUserBuilder;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.UtilDate;
import org.springframework.beans.factory.annotation.Autowired;

public class PinganPayamentService
extends ObjectService {
    @Autowired
    private UmUserDao umUserDao;
    @Autowired
    private UmUserinfoDao umUserinfoDao;
    @Autowired
    private UmUserinfoQuaDao umUserinfoQuaDao;

    public String callbackDispatcherMethod(String stream) {
        this.logger.info(stream);
        String func = stream.substring(222, 226);
        String content = stream.substring(344);
        this.logger.info("dispatcher function is :" + func);
        this.logger.info("dispatcher content is :" + content);
        switch (func) {
            case "1303": {
                return this.memberCallBack(content);
            }
            case "1310": {
                return this.bankInputFee(content);
            }
            case "1312": {
                return this.bankOutputFee(content);
            }
            case "1019": {
                return this.bankCheckFee(content);
            }
        }
        this.logger.info("func:" + func + " was not found,please check it");
        return this.defaultMesssage(func, "1");
    }

    public String signIn() {
        return this.userSign("1");
    }

    public String signOut() {
        return this.userSign("2");
    }

    public String userSign(String flag) {
        SignDomain signDomain = new SignDomain();
        signDomain.setFuncFlag(flag);
        signDomain.setTxDate(UtilDate.getDate());
        String content = PayBuilder.toFormatString(signDomain);
        String func = "1330";
        String id = IdUtil.getPinganId(func, signDomain.getFuncFlag(), "1");
        PayBuilder.send(func, id, content);
        return PayBuilder.send(func, id, content);
    }

    public String memberCallBack(String content) {
        MemberDomain memberDomain = MemberDomain.format(content);
        switch (memberDomain.getFuncFlag()) {
            case "1": {
                this.memberRegist(memberDomain);
            }
            case "2": {
                this.memberChangge(memberDomain);
            }
            case "3": {
                this.memberRescission(memberDomain);
            }
        }
        return this.defaultMesssage("1303", memberDomain.getFuncFlag());
    }

    public String defaultMesssage(String func, String flag) {
        String id = IdUtil.getPinganId(func, flag, "2");
        String retContent = id + "&";
        String message = PayBuilder.buildResponseMessage("1303", id, retContent);
        return message;
    }

    public String memberRegist(MemberDomain memberDomain) {
        this.logger.info("\u5f00\u59cb\u5b58\u6570\u636e\u5e93======================");
        UmUserDomain umUserDomain = UmUserBuilder.buildUmUserDomain(memberDomain);
        this.umUserDao.insertSelective(umUserDomain);
        this.logger.info("\u7528\u6237\u4fe1\u606fum_user\u5b58\u50a8\u5b8c\u6bd5======================");
        UmUserinfoDomain umUserinfoDomain = UmUserBuilder.buildUmUserinfoDomain(memberDomain);
        this.umUserinfoDao.insertSelective(umUserinfoDomain);
        this.logger.info("\u7528\u6237\u4fe1\u606fum_user_info\u5b58\u50a8\u5b8c\u6bd5======================");
        UmUserinfoQuaDomain umUserinfoQuaDomain = UmUserBuilder.buildUmUserinfoQuaDomain(memberDomain);
        this.umUserinfoQuaDao.insertSelective(umUserinfoQuaDomain);
        this.logger.info("\u7528\u6237\u4fe1\u606fum_user_info_qua\u5b58\u50a8\u5b8c\u6bd5======================");
        return null;
    }

    public String memberChangge(MemberDomain memberDomain) {
        this.logger.info("\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93======================");
        UmUserDomain umUserDomain = UmUserBuilder.buildUmUserDomain(memberDomain);
        Integer id = this.umUserDao.selectIdByCode(memberDomain.getCustAcctId());
        umUserDomain.setUserId(id);
        this.umUserDao.updateByPrimaryKey(umUserDomain);
        this.logger.info("\u7528\u6237\u4fe1\u606fum_user\u66f4\u65b0\u5b8c\u6bd5======================");
        UmUserinfoDomain umUserinfoDomain = UmUserBuilder.buildUmUserinfoDomain(memberDomain);
        Integer infoId = this.umUserinfoDao.selectIdByCode(umUserinfoDomain.getUserCode());
        umUserinfoDomain.setUserinfoId(infoId);
        this.umUserinfoDao.updateByPrimaryKey(umUserinfoDomain);
        this.logger.info("\u7528\u6237\u4fe1\u606fum_user_info\u66f4\u65b0\u5b8c\u6bd5======================");
        UmUserinfoQuaDomain umUserinfoQuaDomain = UmUserBuilder.buildUmUserinfoQuaDomain(memberDomain);
        Integer quaId = this.umUserinfoQuaDao.selectIdByCode(umUserinfoQuaDomain.getUserinfoCode());
        umUserinfoQuaDomain.setUserinfoQuaId(quaId);
        this.umUserinfoQuaDao.updateByPrimaryKey(umUserinfoQuaDomain);
        this.logger.info("\u7528\u6237\u4fe1\u606fum_user_info_qua\u66f4\u65b0\u5b8c\u6bd5======================");
        return null;
    }

    public String memberRescission(MemberDomain memberDomain) {
        UmUserDomain umUserDomain = UmUserBuilder.buildUmUserDomain(memberDomain);
        Integer id = this.umUserDao.selectIdByCode(memberDomain.getCustAcctId());
        umUserDomain.setUserId(id);
        umUserDomain.setUserType(-1);
        this.umUserDao.updateByPrimaryKey(umUserDomain);
        return null;
    }

    public String memberOutputFee(String content) {
        return null;
    }

    public String bankInputFee(String content) {
        BankInputFeeDomain inputFeeDomain = BankInputFeeDomain.format(content);
        this.logger.info("input_fee=======>>>>>" + JSON.toJSONString((Object)inputFeeDomain));
        return this.defaultMesssage("1310", "1");
    }

    public String bankOutputFee(String content) {
        BankOutputFeeDomain outputFeeDomain = BankOutputFeeDomain.format(content);
        this.logger.info("output_fee=======>>>>>" + JSON.toJSONString((Object)outputFeeDomain));
        return this.defaultMesssage("1312", "1");
    }

    public String bankCheckFee(String content) {
        MemberDomain memberDomain = MemberDomain.formatCheckInfo(content);
        this.logger.info(JSON.toJSONString((Object)memberDomain));
        String id1 = IdUtil.getPinganId("1010", "1", "1");
        String content1 = "&" + memberDomain.getSupAcctId() + "&" + memberDomain.getCustAcctId() + "&1&1";
        String func = "1010";
        String response = PayBuilder.send(func, id1, content1).substring(344);
        this.logger.info("\u67e5\u8be2\u7528\u6237\u4f59\u989d\uff1a" + response);
        UserBalanceDomain userBalanceDomain = UmUserBuilder.buildUserBalanceDomain(response);
        String id = IdUtil.getPinganId("1019", "2", "2");
        String str = PayBuilder.buildResponseMessage("1019", id, PayBuilder.toFormatString(userBalanceDomain));
        this.logger.info("\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u6570\u636e\uff1a " + str);
        return str;
    }

    public String memberPay(String outCustAcctId, String inThirdCustId, String amount, String outORderId) {
        String func = "1332";
        String thNo = IdUtil.getPinganId(func, "1", "1");
        UserPayDomain userPayDomain = this.getUserInfo(outCustAcctId, inThirdCustId);
        userPayDomain.setTranAmount(amount);
        userPayDomain.setHandFee("0");
        userPayDomain.setCcyCode("RMB");
        userPayDomain.setPaySerialNo(outORderId);
        userPayDomain.setThirdHtId(thNo);
        userPayDomain.setThirdHtCont("\u4f1a\u5458\u8f6c\u8d26");
        userPayDomain.setNote("\u4f1a\u5458\u8f6c\u8d26");
        userPayDomain.setReserve(null);
        String content = PayBuilder.toFormatString(userPayDomain);
        String responseContent = PayBuilder.send(func, thNo, content);
        return responseContent;
    }

    public UserPayDomain getUserInfo(String outThirdCustAcctId, String inThirdCustId) {
        UmUserinfoQuaDomain outUmUserinfoQuaDomain = this.umUserinfoQuaDao.selectByUserCode(outThirdCustAcctId, "userinfo");
        String outMemberStr = outUmUserinfoQuaDomain.getMemo();
        MemberDomain out = MemberDomain.format(outMemberStr);
        UmUserinfoQuaDomain inUmUserinfoQuaDomain = this.umUserinfoQuaDao.selectByUserCode(inThirdCustId, "userinfo");
        String inMemberStr = inUmUserinfoQuaDomain.getMemo();
        MemberDomain in = MemberDomain.format(inMemberStr);
        UserPayDomain userPayDomain = new UserPayDomain();
        userPayDomain.setSupAcctId(out.getSupAcctId());
        userPayDomain.setFuncFlag("1");
        userPayDomain.setOutCustAcctId(out.getCustAcctId());
        userPayDomain.setOutThirdCustId(out.getThirdCustId());
        userPayDomain.setInCustAcctId(in.getCustAcctId());
        userPayDomain.setInThirdCustId(in.getThirdCustId());
        return userPayDomain;
    }
}

