/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.WeChatPayMiniConstants;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.service.PinganPayamentService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PayBuilder;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    @Autowired
    private PinganPayamentService payamentService;

    public String getFchannelCode() {
        return WeChatPayMiniConstants.channelCode;
    }

    public ChannelRest channelBPay(CmChannelClear cmChannelClear) {
        return super.channelBPay(cmChannelClear);
    }

    public ChannelRest channelSPay(CmChannelClear cmChannelClear) {
        ChannelRest rest = super.channelSPay(cmChannelClear);
        this.logger.info("channelRest========================================");
        this.logger.info(JSON.toJSONString((Object)rest));
        return rest;
    }

    protected ChannelRest send(ChannelRequest channelRequest, CmChannelClear cmChannelClear) {
        if (StringUtils.isBlank((String)PayBuilder.getURL())) {
            String url = (String)channelRequest.getConfigMap().get("url");
            this.logger.info("\u83b7\u53d6\u5230\u65b0\u7684\u5730\u5740\uff1a" + url);
            PayBuilder.setURL(url);
        }
        String extension = cmChannelClear.getExtension();
        JSONObject json = JSON.parseObject((String)extension);
        String userOcode = json.getString("userOcode");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("tenantCode", cmChannelClear.getTenantCode());
        pmap.put("userinfoQuaCode", userOcode);
        Object obj = this.getInternalRouter().inInvoke("um.userinfoQua.getUserinfoQuaByCode", pmap);
        UmUserinfoQuaDomain quaDomain = (UmUserinfoQuaDomain)JSON.parseObject((String)obj.toString(), UmUserinfoQuaDomain.class);
        String responseCode = "";
        try {
            String responseContent = this.payamentService.pay(quaDomain, cmChannelClear.getOrderAmount(), cmChannelClear.getBusinessOrderno());
            CommunicationDomain domain = CommunicationDomain.format(responseContent);
            responseCode = domain.getResponseCode();
            if ("000000".equals(domain.getResponseCode())) {
                channelRequest.setDebitFlag(true);
                channelRequest.setDebitResult("SUCCESS");
                try {
                    if (responseContent.length() > 344) {
                        channelRequest.setBankSeqno(responseContent.substring(344).split("&")[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                channelRequest.setDebitFlag(false);
                channelRequest.setDebitResult("fail");
                channelRequest.setSuccess(false);
                channelRequest.setBmsg(domain.getResponseMessage());
            }
            channelRequest.setBankRescode(domain.getResponseCode());
            channelRequest.setBankResmsg(domain.getResponseMessage());
        }
        catch (Exception e) {
            channelRequest.setDebitFlag(false);
            channelRequest.setDebitResult("fail");
            channelRequest.setSuccess(false);
            channelRequest.setBmsg("\u652f\u4ed8\u5931\u8d25");
        }
        return this.buildReset(channelRequest, cmChannelClear, responseCode);
    }

    private ChannelRest buildReset(ChannelRequest channelRequest, CmChannelClear cmChannelClear, String responseCode) {
        ChannelRest channelRest = new ChannelRest();
        channelRest.setChannelClearFchannel(cmChannelClear.getChannelClearFchannel());
        channelRest.setChannelClearSeqno(cmChannelClear.getChannelClearSeqno());
        channelRest.setTenantCode(cmChannelClear.getTenantCode());
        channelRest.setClearOrderSeqno(cmChannelClear.getClearOrderSeqno());
        channelRest.setBankSeqno(cmChannelClear.getChannelClearSeqno());
        channelRest.setRestMemo("");
        channelRest.setChannelSubStr(this.getChannelStr(channelRequest));
        channelRest.setDebitFlag(channelRequest.isDebitFlag());
        channelRest.setDebitResult(channelRequest.getDebitResult());
        channelRest.setBankRescode(channelRequest.getBankRescode());
        channelRest.setBankResmsg(channelRequest.getBankResmsg());
        channelRest.setBankSeqno(channelRequest.getBankSeqno());
        channelRest.setChannelAcceptDate(channelRequest.getChannelAcceptDate());
        if ("000000".equals(responseCode)) {
            channelRest.setDataState(Integer.valueOf(2));
        } else {
            channelRest.setDataState(Integer.valueOf(1));
        }
        channelRest.setReError("error");
        channelRest.setReSuccess("error");
        channelRest.setCall(false);
        return channelRest;
    }
}

