/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.BankInputFeeDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.BankOutputFeeDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.PayToPlatform;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.SignDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserinfoQuaReDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UserBalanceDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UserPayDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.IdUtil;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PayBuilder;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PayBuilder1;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PingBankUtils;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.UmUserBuilder;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.UtilDate;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PinganPayamentService
extends BaseServiceImpl {
    public String callbackDispatcherMethod(String stream) {
        this.logger.info(stream);
        String func = stream.substring(222, 226);
        String content = stream.substring(344);
        this.logger.info("dispatcher function is :" + func);
        this.logger.info("dispatcher content is :" + content);
        switch (func) {
            case "1303": {
                return this.memberCallBack(content);
            }
            case "1310": {
                return this.bankInputFee(content);
            }
            case "1312": {
                return this.bankOutputFee(content);
            }
            case "1019": {
                return this.bankCheckFee(content);
            }
            case "1005": {
                return this.bankfile(content);
            }
        }
        this.logger.info("func:" + func + " was not found,please check it");
        return this.defaultMesssage(func, "1");
    }

    public String signIn() {
        return this.userSign("1");
    }

    public String signOut() {
        return this.userSign("2");
    }

    public String userSign(String flag) {
        SignDomain signDomain = new SignDomain();
        signDomain.setFuncFlag(flag);
        signDomain.setTxDate(UtilDate.getDate());
        String content = PayBuilder.toFormatString(signDomain);
        String func = "1330";
        String id = IdUtil.getPinganId(func, signDomain.getFuncFlag(), "1");
        PayBuilder.send(func, id, content);
        return PayBuilder.send(func, id, content);
    }

    public String memberCallBack(String content) {
        MemberDomain memberDomain = MemberDomain.format(content);
        this.logger.error("pinganPayamentService.FuncFlag", (Object)("funcFlag" + memberDomain.getFuncFlag()));
        switch (memberDomain.getFuncFlag()) {
            case "1": {
                this.memberRegist(memberDomain);
            }
            case "2": {
                this.memberChangge(memberDomain);
            }
            case "3": {
                this.memberRescission(memberDomain);
            }
        }
        return this.defaultMesssage("1303", memberDomain.getFuncFlag());
    }

    public String defaultMesssage(String func, String flag) {
        String id = IdUtil.getPinganId(func, flag, "2");
        String retContent = id + "&";
        String message = PayBuilder.buildResponseMessage("1303", id, retContent);
        return message;
    }

    public String memberRegist(MemberDomain memberDomain) {
        this.logger.info("\u5f00\u59cb\u5b58\u6570\u636e\u5e93======================");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPhone", memberDomain.getReserve());
        map.put("tenantCode", "2020021100000063");
        Object obj = this.getInternalRouter().inInvoke("um.user.getUserByUserPhone", map);
        this.logger.info("\u67e5\u8be2\u7528\u6237\u662f\u5426\u5b58\u5728 >>>>>>>>>>>" + (obj != null));
        if (obj != null) {
            this.logger.info("umUserDomainBean>>>>" + obj.getClass() + "     \n" + JSON.toJSONString((Object)obj));
            UmUserDomainBean umUserDomainBean = (UmUserDomainBean)JSON.parseObject((String)obj.toString(), UmUserDomainBean.class);
            umUserDomainBean = PayBuilder1.buildUmUserDomain(memberDomain, umUserDomainBean);
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("umUserDomainBean", JSON.toJSONString((Object)umUserDomainBean));
            Object object = this.getInternalRouter().inInvoke("um.user.updateUser", pmap);
            HashMap<String, String> quaInfo = new HashMap<String, String>();
            quaInfo.put("userinfoQuaCode", umUserDomainBean.getUserOcode());
            quaInfo.put("tenantCode", "2020021100000063");
            Object quaObj = this.getInternalRouter().inInvoke("um.userinfoQua.getUserinfoQuaByCode", quaInfo);
            UmUserinfoQuaReDomain umUserinfoQuaReDomain = PayBuilder1.buildUmUserinfoQuaReDomain(memberDomain);
            this.logger.info("quaObj >>>>>>" + quaObj);
            if (quaObj != null) {
                UmUserinfoQuaReDomain domain1 = (UmUserinfoQuaReDomain)JSON.parseObject((String)quaObj.toString(), UmUserinfoQuaReDomain.class);
                umUserinfoQuaReDomain.setUserinfoQuaId(domain1.getUserinfoQuaId());
                quaInfo.clear();
                quaInfo.put("umUserinfoQuaDomain", JSON.toJSONString((Object)umUserinfoQuaReDomain));
                this.getInternalRouter().inInvoke("um.userinfoQua.updateUserinfoQua", quaInfo);
            } else {
                quaInfo.clear();
                quaInfo.put("umUserinfoQuaDomain", JSON.toJSONString((Object)umUserinfoQuaReDomain));
                this.getInternalRouter().inInvoke("um.userinfoQua.saveUserinfoQua", quaInfo);
            }
            this.logger.info("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u675f=====>>>" + JSON.toJSONString((Object)object));
        } else {
            HashMap<String, String> pmap = new HashMap<String, String>();
            UmUserDomainBean umUserDomainBean = PayBuilder1.buildUmUserDomain(memberDomain, null);
            pmap.put("umUserDomainBean", JSON.toJSONString((Object)umUserDomainBean));
            Object object = this.getInternalRouter().inInvoke("um.user.sendOpenUserinfo", pmap);
            this.logger.info("\u5b58\u50a8\u6570\u636e\u5e93\u7ed3\u675f=====>>>" + JSON.toJSONString((Object)object));
        }
        return null;
    }

    public String memberChangge(MemberDomain memberDomain) {
        return null;
    }

    public String memberRescission(MemberDomain memberDomain) {
        return null;
    }

    public String memberOutputFee(String content) {
        return null;
    }

    public String bankInputFee(String content) {
        BankInputFeeDomain inputFeeDomain = BankInputFeeDomain.format(content);
        this.logger.info("input_fee=======>>>>>" + JSON.toJSONString((Object)inputFeeDomain));
        return this.defaultMesssage("1310", "1");
    }

    public String bankOutputFee(String content) {
        BankOutputFeeDomain outputFeeDomain = BankOutputFeeDomain.format(content);
        this.logger.info("output_fee=======>>>>>" + JSON.toJSONString((Object)outputFeeDomain));
        return this.defaultMesssage("1312", "1");
    }

    public String bankCheckFee(String content) {
        MemberDomain memberDomain = MemberDomain.formatCheckInfo(content);
        this.logger.info(JSON.toJSONString((Object)memberDomain));
        String id1 = IdUtil.getPinganId("1010", "1", "1");
        String content1 = "&" + memberDomain.getSupAcctId() + "&" + memberDomain.getCustAcctId() + "&1&1";
        String func = "1010";
        String response = PayBuilder.send(func, id1, content1).substring(344);
        this.logger.info("\u67e5\u8be2\u7528\u6237\u4f59\u989d\uff1a" + response);
        UserBalanceDomain userBalanceDomain = UmUserBuilder.buildUserBalanceDomain(response);
        String id = IdUtil.getPinganId("1019", "2", "2");
        String str = PayBuilder.buildResponseMessage("1019", id, PayBuilder.toFormatString(userBalanceDomain));
        this.logger.info("\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u6570\u636e\uff1a " + str);
        return str;
    }

    public String bankfile(String content) {
        if (StringUtils.isBlank((String)content)) {
            throw new ApiException("content is null");
        }
        Map<String, Object> paramMap = PingBankUtils.makeResponseParamToMap(content, "funcFlag", "supAcctId", "fileName", "reserve");
        this.saveFile(paramMap);
        long l = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("reserve", "");
        return PingBankUtils.buildMessage("1005", "01", l + "", PingBankUtils.toFormatString(map));
    }

    private void saveFile(Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            return;
        }
    }

    public String pay(UmUserinfoQuaDomain quaDomain, BigDecimal amount, String orderNo) {
        return this.payOrRefund(quaDomain, amount, orderNo, "1");
    }

    public String refund(UmUserinfoQuaDomain quaDomain, BigDecimal amount, String orderNo) {
        return this.payOrRefund(quaDomain, amount, orderNo, "2");
    }

    public String payOrRefund(UmUserinfoQuaDomain quaDomain, BigDecimal amount, String orderNo, String flag) {
        PayToPlatform payToPlatform = PayBuilder1.buildPayToPlatform(quaDomain, amount, orderNo, flag);
        String content = PayBuilder.toFormatString(payToPlatform);
        String responseContent = PayBuilder.send("1031", orderNo, content);
        this.logger.info(responseContent);
        return responseContent;
    }

    public String frozen(UmUserinfoQuaDomain quaDomain, BigDecimal amount, String orderNo, String flag) {
        PayToPlatform payToPlatform = PayBuilder1.buildPayToPlatform(quaDomain, amount, orderNo, flag);
        String content = PayBuilder.toFormatString(payToPlatform);
        String responseContent = PayBuilder.send("1029", orderNo, content);
        this.logger.info(responseContent);
        return responseContent;
    }

    public String memberPay(String outCustAcctId, String inThirdCustId, String amount, String outORderId) {
        String func = "1332";
        String thNo = IdUtil.getPinganId(func, "1", "1");
        UserPayDomain userPayDomain = this.getUserInfo(outCustAcctId, inThirdCustId);
        userPayDomain.setTranAmount(amount);
        userPayDomain.setHandFee("0");
        userPayDomain.setCcyCode("RMB");
        userPayDomain.setPaySerialNo(outORderId);
        userPayDomain.setThirdHtId(thNo);
        userPayDomain.setThirdHtCont("\u4f1a\u5458\u8f6c\u8d26");
        userPayDomain.setNote("\u4f1a\u5458\u8f6c\u8d26");
        userPayDomain.setReserve(null);
        String content = PayBuilder.toFormatString(userPayDomain);
        String responseContent = PayBuilder.send(func, thNo, content);
        return responseContent;
    }

    public UserPayDomain getUserInfo(String outThirdCustAcctId, String inThirdCustId) {
        return null;
    }

    public ChannelRest send(ChannelRequest channelRequest, CmChannelClear cmChannelClear, String channelStr, String type) {
        this.logger.error("send", (Object)"==============================================================\u8fdb\u5165send==============================================================");
        if (StringUtils.isBlank((String)PayBuilder.getURL())) {
            String url = (String)channelRequest.getConfigMap().get("url");
            this.logger.info("\u83b7\u53d6\u5230\u65b0\u7684\u5730\u5740\uff1a" + url);
            PayBuilder.setURL(url);
        }
        String extension = cmChannelClear.getExtension();
        JSONObject json = JSON.parseObject((String)extension);
        String userOcode = json.getString("userOcode");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("tenantCode", cmChannelClear.getTenantCode());
        pmap.put("userinfoQuaCode", userOcode);
        String responseCode = "";
        try {
            this.logger.info(type.equals("pay") ? "\u652f\u4ed8\u4e2d" : "\u9000\u6b3e\u4e2d\u3002\u3002\u3002\u3002 \u91d1\u989d\uff1a" + cmChannelClear.getOrderAmount() + " \u8ba2\u5355\u53f7\uff1a" + cmChannelClear.getBusinessOrderno());
            this.logger.info("cmChannelClear>>>>>>>", (Object)JSON.toJSONString((Object)cmChannelClear));
            Object obj = this.getInternalRouter().inInvoke("um.userinfoQua.getUserinfoQuaByCode", pmap);
            UmUserinfoQuaDomain quaDomain = (UmUserinfoQuaDomain)JSON.parseObject((String)obj.toString(), UmUserinfoQuaDomain.class);
            String responseContent = null;
            responseContent = type.equals("refund") ? this.refund(quaDomain, cmChannelClear.getOrderAmount(), cmChannelClear.getBusinessOrderno()) : this.pay(quaDomain, cmChannelClear.getOrderAmount(), cmChannelClear.getBusinessOrderno());
            CommunicationDomain domain = CommunicationDomain.format(responseContent);
            this.logger.info("domain >>>>>>>>>" + JSON.toJSONString((Object)domain));
            responseCode = domain.getResponseCode();
            if ("000000".equals(domain.getResponseCode())) {
                channelRequest.setDebitFlag(true);
                channelRequest.setDebitResult("SUCCESS");
                try {
                    this.logger.error("send", (Object)("==============================================================responseContent->" + responseContent + "=============================================================="));
                    if (responseContent.length() > 332) {
                        this.logger.error("send", (Object)("responseContent.substring(332).split(\"&\")[0]=====================->" + responseContent.substring(332).split("&")[0]));
                        channelRequest.setBankSeqno(responseContent.substring(332).split("&")[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                channelRequest.setDebitFlag(false);
                channelRequest.setDebitResult("fail");
                channelRequest.setSuccess(false);
                channelRequest.setBmsg(domain.getResponseMessage());
            }
            channelRequest.setBankRescode(domain.getResponseCode());
            channelRequest.setBankResmsg(domain.getResponseMessage());
        }
        catch (Exception e) {
            channelRequest.setDebitFlag(false);
            channelRequest.setDebitResult("fail");
            channelRequest.setSuccess(false);
            channelRequest.setBmsg("\u652f\u4ed8\u5931\u8d25");
        }
        return this.buildReset(channelRequest, cmChannelClear, responseCode, channelStr);
    }

    private ChannelRest buildReset(ChannelRequest channelRequest, CmChannelClear cmChannelClear, String responseCode, String channelSubStr) {
        ChannelRest channelRest = new ChannelRest();
        channelRest.setChannelClearFchannel(cmChannelClear.getChannelClearFchannel());
        channelRest.setChannelClearSeqno(cmChannelClear.getChannelClearSeqno());
        channelRest.setTenantCode(cmChannelClear.getTenantCode());
        channelRest.setClearOrderSeqno(cmChannelClear.getClearOrderSeqno());
        channelRest.setBankSeqno(cmChannelClear.getChannelClearSeqno());
        channelRest.setRestMemo("");
        channelRest.setChannelSubStr(channelSubStr);
        channelRest.setDebitFlag(channelRequest.isDebitFlag());
        channelRest.setDebitResult(channelRequest.getDebitResult());
        channelRest.setBankRescode(channelRequest.getBankRescode());
        channelRest.setBankResmsg(channelRequest.getBankResmsg());
        channelRest.setBankSeqno(channelRequest.getBankSeqno());
        channelRest.setChannelAcceptDate(channelRequest.getChannelAcceptDate());
        if ("000000".equals(responseCode)) {
            channelRest.setDataState(Integer.valueOf(2));
        } else {
            channelRest.setDataState(Integer.valueOf(1));
        }
        channelRest.setReError("error");
        channelRest.setReSuccess("error");
        channelRest.setCall(false);
        this.logger.info("channelRest >>>>>>>>>" + JSON.toJSONString((Object)channelRest));
        return channelRest;
    }
}

