/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.service;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.service.PinganPayamentService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.service.PinganService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.IdUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PinganServiceImpl
extends BaseServiceImpl
implements PinganService {
    @Autowired
    private PinganPayamentService payamentService;

    @Override
    public void chargeIn(Map<String, Object> pmap) {
        this.payment(pmap, "1031", "1");
    }

    @Override
    public void chargeOut(Map<String, Object> pmap) {
        this.payment(pmap, "1031", "2");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void payment(Map<String, Object> pmap, String func, String flag) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", pmap.get("tenantCode"));
        params.put("userinfoQuaCode", pmap.get("userOcode"));
        BigDecimal amount = (BigDecimal)pmap.get("amount");
        Object obj = this.getInternalRouter().inInvoke("um.userinfoQua.getUserinfoQuaByCode", pmap);
        String orderNo = IdUtil.getPinganId(func, flag, "1");
        UmUserinfoQuaDomain quaDomain = (UmUserinfoQuaDomain)JSON.parseObject((String)obj.toString(), UmUserinfoQuaDomain.class);
        String responseContent = null;
        responseContent = "1031".equals(func) ? this.payamentService.payOrRefund(quaDomain, amount, orderNo, flag) : this.payamentService.frozen(quaDomain, amount, orderNo, flag);
        CommunicationDomain domain = CommunicationDomain.format(responseContent);
        this.logger.info("domain >>>>>>>>>" + JSON.toJSONString((Object)domain));
        String responseCode = domain.getResponseCode();
        if (!"000000".equals(responseCode)) return;
        try {
            if (responseContent.length() <= 344) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void frozenUser(Map<String, Object> pmap) {
        this.payment(pmap, "1029", "1");
    }

    @Override
    public void unFrozenUser(Map<String, Object> pmap) {
        this.payment(pmap, "1029", "2");
    }

    @Override
    public void signIn() {
        this.payamentService.signIn();
    }

    @Override
    public void signOut() {
        this.payamentService.signOut();
    }
}

