/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PingAnReqHead
implements Serializable {
    private String msgType = "A001";
    private String targetSys = "03";
    private String msgCode = "01";
    private String communicationProtocol = "02";
    private String companyBankCode = "                    ";
    private BigDecimal msgLength;
    private String transactionCode = "000000";
    private String operatorCode;
    private String serviceType = "02";
    private String transactionDate;
    private String transactionTime;
    private String requestSysNo;
    private String respondCode = "000000";
    private String respondMsg;
    private String endSign = "0";
    private int requestCount;
    private String signRemark = "0";
    private String signDataType = "0";
    private String signAlgorithm = "000000000000";
    private BigDecimal signDataLength = new BigDecimal(0);
    private int appendix = 0;

    private PingAnReqHead() {
    }

    public static PingAnReqHead decode(String context) {
        int len = context.length();
        PingAnReqHead head = new PingAnReqHead();
        head.setMsgType(context.substring(0, 4));
        head.setTargetSys(context.substring(4, 6));
        head.setMsgCode(context.substring(6, 8));
        head.setCommunicationProtocol(context.substring(8, 10));
        head.setCompanyBankCode(context.substring(10, 30));
        head.setMsgLength(new BigDecimal(context.substring(30, 40)));
        head.setTransactionCode(context.substring(40, 46));
        head.setOperatorCode(context.substring(46, 51));
        head.setServiceType(context.substring(51, 53));
        head.setTransactionDate(context.substring(53, 61));
        head.setTransactionTime(context.substring(61, 67));
        head.setRequestSysNo(context.substring(67, 87));
        head.setRespondCode(context.substring(87, 93));
        head.setRespondMsg(context.substring(93, 193));
        head.setEndSign(context.substring(193, 194));
        head.setRequestCount(new BigDecimal(context.substring(194, 197).equals("   ") ? "0" : context.substring(194, 197)).intValue());
        head.setSignRemark(context.substring(197, 198));
        head.setSignDataType(context.substring(198, 199));
        head.setSignAlgorithm(context.substring(199, 211));
        head.setSignDataLength(new BigDecimal(context.substring(211, 221)));
        head.setAppendix(new BigDecimal(context.substring(221, 222)).intValue());
        return head;
    }

    public static String encode(String companyBankCode, int msgLength, String operatorCode, String requestSysNo, String respondMsg) {
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat ff = new SimpleDateFormat("HHmmss");
        Date date = new Date();
        PingAnReqHead head = new PingAnReqHead();
        head.setCompanyBankCode(companyBankCode);
        head.setMsgLength(new BigDecimal(msgLength));
        head.setOperatorCode(operatorCode);
        head.setTransactionDate(f.format(date));
        head.setTransactionTime(ff.format(date));
        head.setRequestSysNo(requestSysNo);
        head.setRespondMsg(respondMsg);
        DecimalFormat df = new DecimalFormat("0000000000");
        StringBuffer sb = new StringBuffer();
        sb.append(head.getMsgType());
        sb.append(head.getTargetSys());
        sb.append(head.getMsgCode());
        sb.append(head.getCommunicationProtocol());
        sb.append(head.getCompanyBankCode());
        sb.append(df.format(head.getMsgLength()));
        sb.append(head.getTransactionCode());
        sb.append(head.getOperatorCode());
        sb.append(head.getServiceType());
        sb.append(head.getTransactionDate());
        sb.append(head.getTransactionTime());
        sb.append(head.getRequestSysNo());
        sb.append(head.getRespondCode());
        sb.append(head.getRespondMsg());
        sb.append(head.getEndSign());
        DecimalFormat dff = new DecimalFormat("000");
        sb.append(dff.format(head.getRequestCount()));
        sb.append(head.getSignRemark());
        sb.append(head.getSignDataType());
        sb.append(head.getSignAlgorithm());
        sb.append(df.format(head.getSignDataLength()));
        sb.append(head.getAppendix());
        return sb.toString();
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getTargetSys() {
        return this.targetSys;
    }

    public void setTargetSys(String targetSys) {
        this.targetSys = targetSys;
    }

    public String getMsgCode() {
        return this.msgCode;
    }

    public void setMsgCode(String msgCode) {
        this.msgCode = msgCode;
    }

    public String getCommunicationProtocol() {
        return this.communicationProtocol;
    }

    public void setCommunicationProtocol(String communicationProtocol) {
        this.communicationProtocol = communicationProtocol;
    }

    public String getCompanyBankCode() {
        return this.companyBankCode;
    }

    public void setCompanyBankCode(String companyBankCode) {
        this.companyBankCode = companyBankCode;
    }

    public BigDecimal getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(BigDecimal msgLength) {
        this.msgLength = msgLength;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getTransactionTime() {
        return this.transactionTime;
    }

    public void setTransactionTime(String transactionTime) {
        this.transactionTime = transactionTime;
    }

    public String getRequestSysNo() {
        return this.requestSysNo;
    }

    public void setRequestSysNo(String requestSysNo) {
        this.requestSysNo = requestSysNo;
    }

    public String getRespondCode() {
        return this.respondCode;
    }

    public void setRespondCode(String respondCode) {
        this.respondCode = respondCode;
    }

    public String getRespondMsg() {
        return this.respondMsg;
    }

    public void setRespondMsg(String respondMsg) {
        this.respondMsg = respondMsg;
    }

    public String getEndSign() {
        return this.endSign;
    }

    public void setEndSign(String endSign) {
        this.endSign = endSign;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public String getSignRemark() {
        return this.signRemark;
    }

    public void setSignRemark(String signRemark) {
        this.signRemark = signRemark;
    }

    public String getSignDataType() {
        return this.signDataType;
    }

    public void setSignDataType(String signDataType) {
        this.signDataType = signDataType;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public BigDecimal getSignDataLength() {
        return this.signDataLength;
    }

    public void setSignDataLength(BigDecimal signDataLength) {
        this.signDataLength = signDataLength;
    }

    public int getAppendix() {
        return this.appendix;
    }

    public void setAppendix(int appendix) {
        this.appendix = appendix;
    }

    public static void main(String[] args) {
        Date now = new Date();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat ff = new SimpleDateFormat("HHmmss");
        System.out.println("===============" + ff.format(now) + "==========");
    }
}

