/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.unionpaypc.service;

import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ExtPtfchannel;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelDownloadBaseService;
import com.yqbsoft.laser.service.ext.channel.unionpaypc.sign.AcpService;
import com.yqbsoft.laser.service.ext.channel.unionpaypc.unionpayConstants;
import com.yqbsoft.laser.service.ext.channel.unionpaypc.util.SecureUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ChannelDownloadServiceImpl
extends ChannelDownloadBaseService {
    public String getFchannelCode() {
        return unionpayConstants.channelCode;
    }

    public ChannelRest channelSDownload(ExtPtfchannel ptePtfchannel) {
        ChannelRest channelRest = new ChannelRest();
        ChannelRequest channelRequest = this.getChannelRequest(ptePtfchannel);
        if (null == channelRequest) {
            channelRest.setDataState(Integer.valueOf(-1));
            return channelRest;
        }
        Map request = channelRequest.getRequestData();
        if (null == channelRequest.getCmFchannelApi()) {
            channelRest.setDataState(Integer.valueOf(-1));
            this.logger.error("channelSDownload.CmFchannelApi", (Object)"CmFchannelApi is null");
            return channelRest;
        }
        String url = channelRequest.getCmFchannelApi().getFchannelApiUrl();
        if (MapUtil.isEmpty((Map)request) || StringUtils.isEmpty((String)url)) {
            this.logger.error("channelRequest.request[\u53c2\u6570\u4e3a\u7a7a]");
            channelRest.setDataState(Integer.valueOf(-1));
            return channelRest;
        }
        Map<String, String> rspData = AcpService.post(request, url, "UTF-8");
        if (rspData == null) {
            this.logger.error("channelRequest.respon[\u53c2\u6570\u4e3a\u7a7a]");
            channelRest.setDataState(Integer.valueOf(-1));
            return channelRest;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("res", JsonUtil.buildNormalBinder().toJson(rspData));
        map.put("fchanelType", ptePtfchannel.getFchannelType());
        map.put("tenantCode", ptePtfchannel.getTenantCode());
        map.put("channelClearFchannel", this.getFchannelCode());
        channelRest = this.buildResponeBank(map, channelRequest);
        if (channelRest == null || channelRest.getDataState() != 2) {
            this.logger.error("channelRest.respon[\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25]" + (String)map.get("res"));
            channelRest.setDataState(Integer.valueOf(-1));
            return channelRest;
        }
        String billFileDate = DateUtil.getDateString((Date)this.getBillFileDate(ptePtfchannel.getMemo(), ptePtfchannel.getGmtCreate()), (String)"yyyy-MM-dd");
        try {
            this.downloadFile(map, ptePtfchannel.getTenantCode(), billFileDate);
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelDownloadBaseService", (Object)"\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        return channelRest;
    }

    private void downloadFile(Map<String, String> map, String tenantCode, String billFileDate) throws Exception {
        Map tmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(map.get("res"), String.class, String.class);
        String fileContent = (String)tmap.get("fileContent");
        if (null != fileContent && !"".equals(fileContent)) {
            String filePath = "/tmp/original-unionpay-".concat(tenantCode + "-").concat(billFileDate).concat(".zip");
            String fileName = "original-unionpay-".concat(tenantCode + "-").concat(billFileDate).concat(".zip");
            try {
                byte[] fileArray = SecureUtil.inflater(SecureUtil.base64Decode(fileContent.getBytes("UTF-8")));
                File file = new File(filePath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                out.write(fileArray, 0, fileArray.length);
                out.flush();
                out.close();
                this.saveFile(fileArray, fileName, "00000000", "FILE_07", File.separator + billFileDate);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String res = ChannelDownloadServiceImpl.readZip(filePath);
            map.put("date", billFileDate);
            map.put("res", res);
            this.parse(map);
        }
    }

    public static String readZip(String fileName) throws IOException, URISyntaxException {
        ZipFile zf = new ZipFile(fileName, "UTF-8");
        Enumeration e = zf.getEntries();
        ZipEntry ze = null;
        StringBuilder sb = new StringBuilder();
        while (e.hasMoreElements()) {
            String line;
            long size;
            ze = (ZipEntry)e.nextElement();
            if (ze.getName().contains("RD") || (size = ze.getSize()) <= 0L) continue;
            BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze), "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            zf.close();
        }
        File zipFile = new File(fileName);
        if (zipFile.exists()) {
            FileDeleteStrategy strategy = FileDeleteStrategy.FORCE;
            strategy.deleteQuietly(zipFile);
        }
        return sb.toString();
    }
}

