/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.unionpaypc.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.unionpaypc.sign.AcpService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        Map<String, String> submitFromData = AcpService.sign(channelRequest.getRequestData(), (String)channelRequest.getConfigMap().get("certfile_path"), (String)channelRequest.getConfigMap().get("certfile_pwd"), "UTF-8");
        channelRequest.setRequestData(submitFromData);
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("Http_ErrorCode", "\u53c2\u6570\u4e3anull");
        }
        if (bankRequest.isSing()) {
            if (!AcpService.validate(bankRequest.getRequestSignData(), (String)bankRequest.getRequestSignData().get("encoding"), (String)bankRequest.getConfigMap().get("publiccert_path"))) {
                throw new ApiException("Http_ErrorCode", "\u9a8c\u7b7e\u5931\u8d25");
            }
            if (bankRequest.getChannelApiCode().equals("cmc.channelIn.channelSPay") && this.query(bankRequest) == 3) {
                ChannelRest channelRest = new ChannelRest();
                channelRest.setDataState(Integer.valueOf(3));
                return channelRest;
            }
        }
        return this.buildApiCallParam(bankRequest);
    }

    private int query(BankRequest bankRequest) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("version", "5.0.0");
        data.put("encoding", "UTF-8");
        data.put("signMethod", "01");
        data.put("txnType", "00");
        data.put("txnSubType", "00");
        data.put("bizType", "000201");
        data.put("accessType", "0");
        data.put("orderId", (String)bankRequest.getRequestData().get("orderId"));
        data.put("txnTime", (String)bankRequest.getRequestData().get("txnTime"));
        data.put("merId", (String)bankRequest.getConfigMap().get("merId"));
        Map<String, String> reqData = AcpService.sign(data, (String)bankRequest.getConfigMap().get("certfile_path"), (String)bankRequest.getConfigMap().get("certfile_pwd"), "UTF-8");
        String key = bankRequest.getChannelClearFchannel() + "-" + "cmc.channelQuery.channelSQuery" + "-" + bankRequest.getTenantCode();
        String apiStr = DisUtil.getMap((String)"Fchannel_api", (String)key);
        if (StringUtils.isBlank((String)apiStr)) {
            key = bankRequest.getChannelClearFchannel() + "-" + "cmc.channelQuery.channelSQuery" + "-" + "00000000";
            apiStr = DisUtil.getMap((String)"Fchannel_api", (String)key);
        }
        if (StringUtils.isBlank((String)apiStr)) {
            throw new ApiException("cmc.ChannelSignServiceImpl.buildApiCallParam.apiStr", key);
        }
        CmFchannelApi cmFchannelApi = (CmFchannelApi)JsonUtil.buildNormalBinder().getJsonToObject(apiStr, CmFchannelApi.class);
        if (null == cmFchannelApi) {
            throw new ApiException("cmc.ChannelSignServiceImpl.buildApiCallParam.cmFchannelApi", "API\u672a\u8bbe\u7f6e1", key + ":" + apiStr);
        }
        String url = cmFchannelApi.getFchannelApiUrl();
        Map<String, String> rspData = AcpService.post(reqData, url, "UTF-8");
        if (!rspData.isEmpty()) {
            if (AcpService.validate(rspData, "", (String)bankRequest.getConfigMap().get("publiccert_path"))) {
                if ("00".equals(rspData.get("respCode"))) {
                    String origRespCode = rspData.get("origRespCode");
                    if (!"00".equals(origRespCode)) {
                        if ("03".equals(origRespCode) || "04".equals(origRespCode) || "05".equals(origRespCode)) {
                            throw new ApiException("Http_ErrorCode", "\u67e5\u8be2\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u7b49\u5f85\u4e0b\u6b21\u63a8\u9001");
                        }
                        return 3;
                    }
                } else {
                    this.logger.error(SYS_CODE, (Object)("\u67e5\u8be2\u5931\u8d25:" + rspData.get("respCode")));
                }
            }
        } else {
            this.logger.error(SYS_CODE, (Object)"\u67e5\u8be2\u9a8c\u7b7e\u5931\u8d25");
        }
        return 2;
    }
}

