/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.unv.erp.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.unv.erp.dao.ErpOrderInfoMapper;
import com.yqbsoft.laser.service.ext.channel.unv.erp.dao.ErpProductInfoMapper;
import com.yqbsoft.laser.service.ext.channel.unv.erp.domian.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.channel.unv.erp.domian.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.unv.erp.model.ErpDepartInfo;
import com.yqbsoft.laser.service.ext.channel.unv.erp.model.ErpOrderHeaderInfo;
import com.yqbsoft.laser.service.ext.channel.unv.erp.model.ErpOrderLineInfo;
import com.yqbsoft.laser.service.ext.channel.unv.erp.model.ErpProductInfo;
import com.yqbsoft.laser.service.ext.channel.unv.erp.service.ErpOrderService;
import com.yqbsoft.laser.service.ext.channel.unv.erp.utils.ConstUtil;
import com.yqbsoft.laser.service.ext.channel.unv.erp.utils.DateUtils;
import com.yqbsoft.laser.service.ext.channel.unv.erp.utils.OrderKeyUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ErpOrderServiceImpl
extends BaseServiceImpl
implements ErpOrderService {
    private static final String SYS_CODE = "service.ext.channel.unv.erp.service.ErpOrderServiceImpl";
    private ErpProductInfoMapper erpProductInfoMapper;
    private ErpOrderInfoMapper erpOrderInfoMapper;

    public void setErpProductInfoMapper(ErpProductInfoMapper erpProductInfoMapper) {
        this.erpProductInfoMapper = erpProductInfoMapper;
    }

    public void setErpOrderInfoMapper(ErpOrderInfoMapper erpOrderInfoMapper) {
        this.erpOrderInfoMapper = erpOrderInfoMapper;
    }

    @Override
    public String addErpOrder(SgSendgoodsDomain sgSendgoodsDomain) throws ApiException {
        String statusFlag = "success";
        String errorInfo = "";
        if (sgSendgoodsDomain == null) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.sgSendgoodsDomain", (Object)"parame is null!");
            return "error";
        }
        this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.sgSendgoodsDomain:\u5165\u53c2-------" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        ErpOrderHeaderInfo erpOrderHeaderInfo = new ErpOrderHeaderInfo();
        List<Object> erpOrderLineInfoList = new ArrayList();
        try {
            String customerPoNumber = "I" + sgSendgoodsDomain.getContractNbillcode();
            Integer hisNum = this.erpOrderInfoMapper.getErpOrderNumByPoNumber(customerPoNumber);
            if (hisNum == 0) {
                this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.\u7b2c\u4e00\u6b65\u5f00\u59cb\u6570\u636e\u8f6c\u6362\uff01");
                Map<Object, Object> resultMap = this.toChangeErpOrderHeaderInfo(sgSendgoodsDomain);
                errorInfo = (String)resultMap.get("errorInfo");
                this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.\u7b2c\u4e8c\u6b65\u8fd4\u56de\u6570\u636e\u8f6c\u6362\u7ed3\u679c\uff1a" + JsonUtil.buildNonDefaultBinder().toJson(resultMap));
                if ("".equals(errorInfo)) {
                    erpOrderHeaderInfo = (ErpOrderHeaderInfo)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resultMap.get("erpOrderHeaderInfo")), ErpOrderHeaderInfo.class);
                    erpOrderLineInfoList = erpOrderHeaderInfo.getErpOrderLineInfoList();
                    this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.\u7b2c\u4e09\u6b65\u5f00\u59cb\u5934\u8868\u63d2\u5165\uff01");
                    this.logger.error("--------++++++\u5165\u53c2:" + JsonUtil.buildNonDefaultBinder().toJson((Object)erpOrderHeaderInfo));
                    this.erpOrderInfoMapper.insertErpOrderHeaderInfo(erpOrderHeaderInfo);
                    this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.\u7b2c\u56db\u6b65\u5f00\u59cb\u884c\u8868\u63d2\u5165\uff01");
                    for (ErpOrderLineInfo erpOrderLineInfo : erpOrderLineInfoList) {
                        this.erpOrderInfoMapper.insertErpOrderLineInfo(erpOrderLineInfo);
                    }
                } else {
                    this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.e", (Object)("\u7531UPP\u5b50\u8ba2\u5355\u8f6c\u6362\u4e3aERP\u63d2\u5165\u6570\u636e\u51fa\u73b0\u5f02\u5e38\u6570\u636e:" + errorInfo + ";;;;;;\u5165\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)));
                    statusFlag = "error";
                }
            } else {
                errorInfo = "\u5408\u540c\u53f7:" + customerPoNumber + "\u5df2\u7ecf\u63d2\u5165\u8fc7ERP,\u8bf7\u52a1\u91cd\u590d\u63d2\u5165!";
                this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.e", (Object)("\u7531UPP\u5b50\u8ba2\u5355\u8f6c\u6362\u4e3aERP\u63d2\u5165\u6570\u636e\u8be5\u5408\u540c\u53f7\u5df2\u7ecf\u8fdb\u5165\u8fc7ERP:" + errorInfo + ";;;;;;\u5165\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)));
                statusFlag = "error";
            }
        }
        catch (Exception e) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.addErpOrder.e", (Object)("\u7531UPP\u5b50\u8ba2\u5355\u8f6c\u6362\u4e3aERP\u63d2\u5165\u6570\u636e\u51fa\u73b0try catch;;;;;;\u5165\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)), (Throwable)e);
            statusFlag = "error";
        }
        return statusFlag + ";" + errorInfo;
    }

    @Override
    public String cancelErpOrder(SgSendgoodsDomain sgSendgoodsDomain) {
        if (sgSendgoodsDomain == null) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.cancelErpOrder.sgSendgoodsDomain", (Object)"parame is null!");
        }
        this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.cancelErpOrder.sgSendgoodsDomain:\u5165\u53c2-------" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        try {
            ErpOrderHeaderInfo cancelErpHeader = new ErpOrderHeaderInfo();
            String contractMain = sgSendgoodsDomain.getGoodsSupplierName();
            String bussinessDep = sgSendgoodsDomain.getMschannelName();
            String origSysDocumentRef = "UPP_C" + sgSendgoodsDomain.getSendgoodsId();
            String orgId = this.getErpOrgID(contractMain, bussinessDep);
            String customerPoNumber = sgSendgoodsDomain.getContractBillcode();
            cancelErpHeader.setOperationCode("UPDATE");
            cancelErpHeader.setCancelledFlag("Y");
            cancelErpHeader.setOrigSysDocumentRef(origSysDocumentRef);
            cancelErpHeader.setOrgId(Integer.valueOf(orgId));
            cancelErpHeader.setCustomerPoNumber(customerPoNumber);
            String lastUpdatedBy = "";
            this.erpOrderInfoMapper.cancelErpOrderHeaderInfo(cancelErpHeader);
        }
        catch (Exception e) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.cancelErpOrder.e", (Object)("\u7531UPP\u5b50\u8ba2\u5355\u53d6\u6d88\u64cd\u4f5c\u51fa\u73b0try catch;;;;;;\u5165\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)), (Throwable)e);
        }
        return "success";
    }

    @Override
    public String returnErpOrder(SgSendgoodsDomain sgSendgoodsDomain) {
        if (sgSendgoodsDomain == null) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.cancelErpOrder.returnErpOrder", (Object)"parame is null!");
        }
        this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.returnErpOrder.sgSendgoodsDomain:\u5165\u53c2-------" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        return "success";
    }

    @Override
    public List<ErpDepartInfo> getErpDepartList() {
        List<ErpDepartInfo> erpDepartInfoList = this.erpOrderInfoMapper.getAllErpDepartList();
        return erpDepartInfoList;
    }

    public Map<Object, Object> toChangeErpOrderHeaderInfo(SgSendgoodsDomain sgSendgoodsDomain) throws Exception {
        String errorInfo = "";
        ErpOrderHeaderInfo erpOrderHeaderInfo = new ErpOrderHeaderInfo();
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        String contractMain = sgSendgoodsDomain.getGoodsSupplierName();
        String bussinessDep = sgSendgoodsDomain.getMschannelName();
        String origSysDocumentRef = "UPP_A" + sgSendgoodsDomain.getSendgoodsCode();
        String orgId = this.getErpOrgID(contractMain, bussinessDep);
        String customerPoNumber = "I" + sgSendgoodsDomain.getContractNbillcode();
        String shipFromOrgName = sgSendgoodsDomain.getPricesetCurrency1();
        Integer shipFromOrgId = this.getErpShipFromOrgId(shipFromOrgName);
        String goodsSupplierCode = sgSendgoodsDomain.getGoodsSupplierCode();
        String goodsSupplierCodeStr = OrderKeyUtils.getBorderInOrOut(goodsSupplierCode);
        String ucValue = customerPoNumber.substring(0, 1) + "_" + customerPoNumber.substring(11, 12) + "_" + goodsSupplierCodeStr + "_" + shipFromOrgName;
        this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.toChangeErpOrderHeaderInfo\u8f6c\u6362\u8ba2\u5355\u7c7b\u578b\u5165\u53c2:" + ucValue);
        String orderTypeIdStr = this.getUppCollocate("ERP_ORDER_TYPE", ucValue);
        Integer orderTypeId = null;
        if (!StringUtils.isBlank((String)orderTypeIdStr) && !"".equals(orderTypeIdStr)) {
            orderTypeId = Integer.valueOf(orderTypeIdStr);
        }
        String shippingMethodCode = OrderKeyUtils.getDispatchingType(sgSendgoodsDomain.getContractPumode());
        String fobPointCode = OrderKeyUtils.getTradeTerm(sgSendgoodsDomain.getContractPmode());
        String soldTorgId = sgSendgoodsDomain.getPackageName();
        String attribute6 = sgSendgoodsDomain.getGoodsMoney() + "";
        Double paymentAmount = Double.valueOf(sgSendgoodsDomain.getPackageFare());
        String transactionalCurrCode = sgSendgoodsDomain.getProvinceCode();
        String ccpPerson = sgSendgoodsDomain.getMemberMcode();
        String salesrepNumber = sgSendgoodsDomain.getMemberMname();
        String salesrepIdStr = this.getErpDepartID(salesrepNumber, orgId);
        Integer salesrepId = null;
        if (!StringUtils.isBlank((String)salesrepIdStr) && !"".equals(salesrepIdStr)) {
            salesrepId = Integer.valueOf(salesrepIdStr);
        } else {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.toChangeErpOrderHeaderInfo\u83b7\u5f97\u529e\u4e8b\u5904id\u4e3a\u7a7a\uff0c\u5165\u53c2\uff1asalesrepNumber\uff1a" + salesrepNumber + ";orgId:" + orgId);
        }
        Integer paymentTermId = 1001;
        String goodsReceiptArrdess = sgSendgoodsDomain.getGoodsReceiptArrdess();
        String goodsReceiptMem = sgSendgoodsDomain.getGoodsReceiptMem();
        String goodsReceiptPhone = sgSendgoodsDomain.getGoodsReceiptPhone();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String requestDateHadleStr = DateUtils.timeStamp2Date(sgSendgoodsDomain.getRoadCode(), "yyyy-MM-dd");
        Date requestDateHadle = sdf.parse(requestDateHadleStr);
        if (StringUtils.isBlank((String)contractMain) || StringUtils.isBlank((String)bussinessDep) || StringUtils.isBlank((String)origSysDocumentRef) || StringUtils.isBlank((String)orgId) || StringUtils.isBlank((String)customerPoNumber) || StringUtils.isBlank((String)shipFromOrgName) || StringUtils.isBlank((Integer)orderTypeId) || StringUtils.isBlank((String)shippingMethodCode) || StringUtils.isBlank((String)fobPointCode) || StringUtils.isBlank((String)soldTorgId) || StringUtils.isBlank((String)attribute6) || StringUtils.isBlank((String)goodsReceiptArrdess) || StringUtils.isBlank((String)goodsReceiptMem) || StringUtils.isBlank((String)goodsReceiptPhone) || StringUtils.isBlank((String)transactionalCurrCode) || StringUtils.isBlank((String)requestDateHadle.toString()) || StringUtils.isBlank((String)salesrepNumber) || StringUtils.isBlank((Integer)salesrepId)) {
            errorInfo = "\u5b58\u5728\u5b50\u8ba2\u5355\u5934\u8868\u6570\u636e\u4e3a\u7a7a\u7684\u60c5\u51b5:----\u5408\u540c\u4e3b\u4f53:" + contractMain + ",----\u5927\u533a\u4e1a\u52a1\u90e8:" + bussinessDep + ",----\u5b50\u8ba2\u5355ID:" + origSysDocumentRef + ",----ERP\u8d26\u5957ID:" + orgId + ",----\u5408\u540c\u53f7:" + customerPoNumber + ",----\u53d1\u8d27\u4ed3\u5e93\u4e2d\u6587:" + shipFromOrgName + ",----\u4ed3\u5e93ID:" + shipFromOrgId + ",----ERP\u8ba2\u5355\u7c7b\u578bID:" + ucValue + "+" + orderTypeId + ",----\u53d1\u8d27\u65b9\u5f0f:" + shippingMethodCode + ",----\u8d38\u6613\u672f\u8bed :" + fobPointCode + ",----\u5ba2\u6237ID:" + soldTorgId + ",----\u8ba2\u5355\u603b\u91d1\u989d:" + attribute6 + ",----\u5e01\u79cd:" + transactionalCurrCode + ",----\u8981\u8d27\u65f6\u95f4:" + requestDateHadle + ",----\u529e\u4e8b\u5904CODE:" + salesrepNumber + ",----\u529e\u4e8b\u5904ID:" + salesrepId;
            resultMap.put("errorInfo", errorInfo);
            return resultMap;
        }
        String shipSetName = this.getUppCollocate("SHIP_METHOD", shippingMethodCode);
        ArrayList<ErpOrderLineInfo> erpOrderLineInfoList = new ArrayList<ErpOrderLineInfo>();
        List<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomainList = sgSendgoodsDomain.getSgSendgoodsGoodsDomainList();
        this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.toChangeErpOrderHeaderInfo\u5f00\u59cb\u884c\u8868\u7684\u6570\u636e\u8f6c\u6362\uff01\uff01\uff01\uff01");
        for (SgSendgoodsGoodsDomain sgSendgoodsGoods : sgSendgoodsGoodsDomainList) {
            ErpOrderLineInfo erpOrderLineInfo = new ErpOrderLineInfo();
            String origSysLineRef = "UPP_A" + sgSendgoodsGoods.getSendgoodsGoodsCode();
            if (StringUtils.isBlank((String)origSysLineRef)) {
                errorInfo = errorInfo + "\u8ba2\u5355\u884cID\u4e3a\u7a7a:" + origSysLineRef;
            } else {
                erpOrderLineInfo.setOrigSysLineRef(origSysLineRef);
                erpOrderLineInfo.setAttribute3(origSysLineRef);
            }
            String goodsNum = sgSendgoodsGoods.getSendgoodsGoodsCamount().toString().trim();
            if (StringUtils.isBlank((String)goodsNum)) {
                errorInfo = errorInfo + "\u8ba2\u5355\u884c\u6570\u91cf\u4e3a\u7a7a,";
            } else {
                erpOrderLineInfo.setOrderedQuantity(Double.valueOf(goodsNum).intValue());
            }
            if (StringUtils.isBlank((String)sgSendgoodsGoods.getContractGoodsPrice().toString())) {
                errorInfo = errorInfo + "\u8ba2\u5355\u884c\u51cf\u514d\u540e\u4ef7\u683c\u4e3a\u7a7a,";
            } else {
                erpOrderLineInfo.setUnitSellingPrice(sgSendgoodsGoods.getContractGoodsPrice());
            }
            String contractBillcode = sgSendgoodsGoods.getMschannelCode();
            if (StringUtils.isBlank((String)contractBillcode)) {
                errorInfo = errorInfo + "\u8ba2\u5355\u884c\u751f\u4ea7BOM\u4e3a\u7a7a,";
            } else {
                erpOrderLineInfo.setInventoryItem(contractBillcode);
                Integer inventoryItemId = this.getErpInventoryItemId(contractBillcode);
                if (StringUtils.isBlank((Integer)inventoryItemId)) {
                    errorInfo = errorInfo + "\u8ba2\u5355\u884c\u751f\u4ea7BOM\u5bf9\u5e94ERP\u7684ID\u4e3a\u7a7a,";
                } else {
                    erpOrderLineInfo.setInventoryItemId(inventoryItemId + "");
                }
            }
            erpOrderLineInfo.setRequestDate(requestDateHadle);
            erpOrderLineInfo.setScheduleShipDate(requestDateHadle);
            erpOrderLineInfo.setAttribute15(sgSendgoodsGoods.getMemberContactQq());
            erpOrderLineInfo.setShipSetName(shipSetName);
            erpOrderLineInfo.setOperationCode("CREATE");
            erpOrderLineInfo.setPackingInstructions("UPP\u6d77\u5916\u9879\u76ee");
            erpOrderLineInfo.setInterfaceStatus("5");
            erpOrderLineInfo.setOrigSysDocumentRef(origSysDocumentRef);
            erpOrderLineInfo.setShipFromOrgId(shipFromOrgId);
            erpOrderLineInfo.setAttribute17(goodsReceiptArrdess);
            erpOrderLineInfo.setAttribute18(goodsReceiptMem + "," + goodsReceiptPhone);
            erpOrderLineInfo.setOrigSysShipmentRef("");
            erpOrderLineInfo.setAttribute4(ccpPerson);
            erpOrderLineInfoList.add(erpOrderLineInfo);
        }
        if (!"".equals(errorInfo)) {
            resultMap.put("errorInfo", errorInfo);
            return resultMap;
        }
        erpOrderHeaderInfo.setOrigSysDocumentRef(origSysDocumentRef);
        erpOrderHeaderInfo.setOrgId(Integer.valueOf(orgId));
        erpOrderHeaderInfo.setCustomerPoNumber(customerPoNumber);
        erpOrderHeaderInfo.setAttribute16(shipFromOrgName);
        erpOrderHeaderInfo.setShipFromOrgId(shipFromOrgId);
        erpOrderHeaderInfo.setOrderTypeId(orderTypeId);
        erpOrderHeaderInfo.setShippingMethodCode(shippingMethodCode);
        erpOrderHeaderInfo.setFobPointCode(fobPointCode);
        erpOrderHeaderInfo.setSoldTorgId(Integer.valueOf(soldTorgId));
        erpOrderHeaderInfo.setAttribute6(attribute6);
        erpOrderHeaderInfo.setPaymentAmount(paymentAmount);
        erpOrderHeaderInfo.setTransactionalCurrCode(transactionalCurrCode);
        erpOrderHeaderInfo.setSalesrepId(salesrepId);
        erpOrderHeaderInfo.setPaymentTermId(paymentTermId);
        erpOrderHeaderInfo.setErpOrderLineInfoList(erpOrderLineInfoList);
        erpOrderHeaderInfo.setBookedFlag("N");
        erpOrderHeaderInfo.setCancelledFlag("N");
        erpOrderHeaderInfo.setAttribute13("2000");
        erpOrderHeaderInfo.setAttribute17("");
        erpOrderHeaderInfo.setOperationCode("CREATE");
        erpOrderHeaderInfo.setOrderCategory("R");
        erpOrderHeaderInfo.setAttribute11("");
        erpOrderHeaderInfo.setInterfaceStatus(5);
        resultMap.put("errorInfo", errorInfo);
        resultMap.put("erpOrderHeaderInfo", erpOrderHeaderInfo);
        return resultMap;
    }

    public String getErpOrgID(String contractMain, String bussinessDep) {
        String orgId = "373";
        switch (contractMain) {
            case "\u6d59\u6c5f\u5b87\u89c6\u79d1\u6280\u6709\u9650\u516c\u53f8": {
                orgId = "373";
                break;
            }
            case "UNV Digital Technologies Company Limited": {
                orgId = "153";
                break;
            }
            case "UNV Technology USA LLC": {
                orgId = "533";
            }
        }
        if ("\u4e00\u5e26\u4e00\u8def\u4e1a\u52a1\u90e8".equals(bussinessDep)) {
            orgId = "82";
        }
        return orgId;
    }

    public Integer getErpShipFromOrgId(String ShipFromOrgName) {
        Integer shipFromOrgId = null;
        switch (ShipFromOrgName) {
            case "\u676d\u5dde\u4ed3": {
                shipFromOrgId = ConstUtil.SHIP_FROM_ORG_ID_MAIN;
                break;
            }
            case "\u7f8e\u56fd\u4ed3": {
                shipFromOrgId = ConstUtil.SHIP_FROM_ORG_ID_USA;
                break;
            }
            case "\u6b27\u6d32\u4ed3": {
                shipFromOrgId = ConstUtil.SHIP_FROM_ORG_ID_EUROPE;
            }
        }
        return shipFromOrgId;
    }

    public String getUppCollocate(String ucType, String ucValue) {
        String orderTypeIdStr;
        this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImplgetUppCollocate\u8c03\u7528\u5165\u53c2ucType\uff1a" + ucType + ";ucValue" + ucValue + ";");
        if (StringUtils.isBlank((String)ucType) || StringUtils.isBlank((String)ucValue)) {
            return null;
        }
        String orderTypeId = null;
        HashMap<String, String> ucInfoMap = new HashMap<String, String>();
        HashMap<String, String> ucInfoMapStr = new HashMap<String, String>();
        ucInfoMapStr.put("ucType", ucType);
        ucInfoMapStr.put("ucValue", ucValue);
        ucInfoMap.put("map", JsonUtil.buildNormalBinder().toJson(ucInfoMapStr));
        String resultJson = "";
        try {
            resultJson = (String)this.getInternalRouter().inInvoke("unvportal.uppCollocate.getUppCollocate", ucInfoMap);
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.getUppCollocate\u8c03\u7528unvportal.uppCollocate.getUppCollocate\u7684\u8fd4\u56de\u7ed3\u679c" + resultJson);
        }
        catch (Exception e) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.getUppCollocate.e", (Object)("\u83b7\u53d6portal\u4e2dUPP\u914d\u7f6e\u8868\u8ba2\u5355\u7c7b\u578b\u5f02\u5e38ucInfoMap:" + ucInfoMap), (Throwable)e);
            return null;
        }
        orderTypeId = orderTypeIdStr = (String)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, String.class);
        return orderTypeId;
    }

    public String getSoldTorgId(String soldTorgName) {
        String soldTorgIdStr;
        if (StringUtils.isBlank((String)soldTorgName)) {
            return null;
        }
        String soldTorgId = "";
        HashMap<String, String> ucInfoMap = new HashMap<String, String>();
        HashMap<String, String> ucInfoMapStr = new HashMap<String, String>();
        ucInfoMapStr.put("userinfo_code", soldTorgName);
        ucInfoMap.put("map", JsonUtil.buildNormalBinder().toJson(ucInfoMapStr));
        String resultJson = "";
        try {
            resultJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", ucInfoMap);
        }
        catch (Exception e) {
            this.logger.error("service.ext.channel.unv.erp.service.ErpOrderServiceImpl.getSoldTorgId.e", (Object)("\u83b7\u53d6UPP\u4e2d\u5ba2\u6237\u5916\u90e8\u7cfb\u7edfID\u5f02\u5e38ucInfoMap:" + ucInfoMap), (Throwable)e);
            return null;
        }
        soldTorgId = soldTorgIdStr = (String)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, String.class);
        return soldTorgId;
    }

    public Integer getErpInventoryItemId(String bom) {
        if (StringUtils.isBlank((String)bom)) {
            return null;
        }
        Integer inventoryItemId = null;
        ErpProductInfo erpProductInfo = new ErpProductInfo();
        erpProductInfo = this.erpProductInfoMapper.getErpProductByCode(bom);
        inventoryItemId = erpProductInfo.getProductId();
        return inventoryItemId;
    }

    public String getErpDepartID(String salesrepNumber, String orgId) {
        String salesrepId = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("salesrepNumber", salesrepNumber);
        map.put("orgId", orgId);
        ErpDepartInfo erpDepartInfo = this.erpOrderInfoMapper.getErpDepartIdByName(map);
        salesrepId = erpDepartInfo.getSalesrepId();
        return salesrepId;
    }
}

