/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatpaywap.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.wechatpaywap.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.wechatpaywap.util.WeChatPayCore;
import com.yqbsoft.laser.service.ext.channel.wechatpaywap.util.WeChatPayNotify;
import com.yqbsoft.laser.service.ext.channel.wechatpaywap.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        String httpUrl = WeChatPayConfig.url;
        JSONObject extension = JSONObject.json2object((String)channelRequest.getCmChannelClear().getExtension());
        if (extension != null) {
            channelRequest.getRequestData().put("spbill_create_ip", extension.getString("client_ip"));
            JSONObject h5Info = new JSONObject();
            JSONObject info = new JSONObject();
            info.put("type", (Object)extension.getString("wap_type"));
            if ("wap".equals(info.getString("type"))) {
                info.put("wap_url", (Object)extension.getString("wap_url"));
                info.put("wap_name", (Object)extension.getString("wap_name"));
            } else if ("wechat".equals(info.getString("type"))) {
                info.put("wap_url", (Object)extension.getString("wap_url"));
                info.put("wap_name", (Object)extension.getString("wap_name"));
            } else if ("android".equals(info.getString("type"))) {
                info.put("app_name", (Object)extension.getString("wap_url"));
                info.put("package_name", (Object)extension.getString("wap_name"));
            } else if ("ios".equals(info.getString("type"))) {
                info.put("app_name", (Object)extension.getString("wap_url"));
                info.put("bundle_id", (Object)extension.getString("wap_name"));
            }
            h5Info.addObject("h5_info", (Object)info);
            channelRequest.getRequestData().put("scene_info", h5Info.object2json());
        }
        this.makeSubmch(channelRequest.getConfigMap(), channelRequest.getRequestData());
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(channelRequest.getRequestData());
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\uff1a" + params));
        String resXml = "";
        try {
            resXml = WebUtils.doPost((String)httpUrl, (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(params).getBytes("utf-8"), (int)5000, (int)5000);
        }
        catch (IOException e) {
            this.logger.error("ecmalipaypc", (Throwable)e);
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\uff1a" + resXml));
        Map resMap = XmlUtil.getMapFromXML((String)resXml);
        String URI2 = (String)resMap.get("mweb_url");
        String fchannelApiUrl = "";
        HashMap<String, String> fromParam = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)URI2)) {
            fchannelApiUrl = URI2.substring(0, URI2.indexOf("?"));
            String input = URI2.substring(URI2.indexOf("?") + 1);
            String[] inputs = input.split("&");
            if (inputs != null) {
                for (String string : inputs) {
                    String[] v = string.split("=");
                    fromParam.put(v[0], v[1]);
                }
            }
        }
        if (channelRequest.getConfigMap().containsKey("return_url")) {
            fromParam.put("redirect_url", (String)channelRequest.getConfigMap().get("return_url"));
        }
        channelRequest.setRequestData(fromParam);
        channelRequest.getCmFchannelApi().setFchannelApiUrl(fchannelApiUrl);
    }

    private void makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        Map res = bankRequest.getRequestData();
        if (bankRequest.isSing()) {
            res = XmlUtil.getMapFromXML((String)((String)bankRequest.getRequestData().get("resStream")));
            res.put(WeChatPayConfig.pay_key, bankRequest.getConfigMap().get(WeChatPayConfig.pay_key));
            if (!WeChatPayNotify.verify(res)) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.verify", "");
            }
        }
        if (res.containsKey("res")) {
            String resJson = (String)res.get("res");
            Map resMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resJson, String.class, String.class);
            res.putAll(resMap);
        }
        bankRequest.setRequestData(res);
        return this.buildApiCallParam(bankRequest);
    }

    public static void main(String[] args) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("mch_id", "1489225562");
        request.put("total_fee", "1");
        request.put("spbill_create_ip", "218.1.115.186");
        request.put("appid", "wx44ecf8aa3d0c1fc4");
        request.put("nonce_str", "55765d9d2f335eaab2222123584bcd");
        request.put("out_trade_no", "0000000000001");
        request.put("pay_key", "69f049122e4d459e822a37df62669337");
        request.put("sub_appid", "wx5193321c02b54c42");
        request.put("sub_mch_id", "1490621762");
        request.put("body", "\u5145\u503c");
        request.put("notify_url", "http://baidu.com");
        request.put("trade_type", "MWEB");
        JSONObject json = new JSONObject();
        JSONObject json1 = new JSONObject();
        json1.addObject("type", (Object)"Wap");
        json1.addObject("wap_url", (Object)"http://baidu.com");
        json1.addObject("wap_name", (Object)"\u817e\u8baf\u5145\u503c");
        json.put("h5_info", (Object)json1);
        request.put("scene_info", json.object2json());
        Map<String, String> sPara = WeChatPayCore.paraFilter(request);
        String mysign = WeChatPaySubmit.buildRequestMysign(sPara);
        sPara.put("sign", mysign);
        String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        try {
            String result = WebUtils.doPost((String)url, (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(sPara).getBytes("utf-8"), (int)5000, (int)5000);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

