/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.yb.encrypt;

import com.yqbsoft.laser.service.esb.core.ApiException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class Encodes {
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int[] DEFAULT_CONFOUNDER = new int[]{3, 6, 7, 4, 1, 8, 0, 9, 5, 2};

    public static String confuse(long num) {
        String tempStr = Long.toString(num);
        int numLength = tempStr.length();
        char[] input = tempStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numLength; ++i) {
            sb.append(DEFAULT_CONFOUNDER[Integer.parseInt(input[i] + "")]);
        }
        return sb.toString();
    }

    public static String encodeHex(byte[] input) {
        return Hex.encodeHexString((byte[])input);
    }

    public static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException var2) {
            throw new ApiException("Encodes.error", (Throwable)var2);
        }
    }

    public static String encodeBase64(byte[] input) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])input));
    }

    public static String encodeUrlSafeBase64(byte[] input) {
        return Base64.encodeBase64URLSafeString((byte[])input);
    }

    public static byte[] decodeBase64(String input) {
        return Base64.decodeBase64((String)input);
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
        }
        return new String(chars);
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static String unescapeHtml(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml4((String)htmlEscaped);
    }

    public static String escapeXml(String xml) {
        return StringEscapeUtils.escapeXml((String)xml);
    }

    public static String unescapeXml(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, "UTF-8");
        }
        catch (UnsupportedEncodingException var2) {
            throw new ApiException("Encodes.error", (Throwable)var2);
        }
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, "UTF-8");
        }
        catch (UnsupportedEncodingException var2) {
            throw new ApiException("Encodes.error", (Throwable)var2);
        }
    }
}

