/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.ybpayjh.encrypt;

import com.google.common.base.Charsets;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.ybpayjh.encrypt.Encodes;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;

public class RSA {
    public static boolean verifySign(byte[] data, byte[] sign, PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(publicKey);
            signature.update(data);
            boolean result = signature.verify(sign);
            return result;
        }
        catch (Exception var6) {
            throw new ApiException("verifySign fail!", (Throwable)var6);
        }
    }

    public static boolean verifySign(String data, String sign, PublicKey pubicKey) {
        byte[] dataByte = data.getBytes(Charsets.UTF_8);
        byte[] signByte = Encodes.decodeBase64(sign);
        return RSA.verifySign(dataByte, signByte, pubicKey);
    }

    public static byte[] sign(byte[] data, PrivateKey key) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(key);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception var4) {
            throw new ApiException("sign fail!", (Throwable)var4);
        }
    }

    public static String sign(String data, PrivateKey key) {
        byte[] dataByte = data.getBytes(Charsets.UTF_8);
        return Encodes.encodeUrlSafeBase64(RSA.sign(dataByte, key));
    }

    public static byte[] encrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception var4) {
            throw new ApiException("rsa encrypt failed!", (Throwable)var4);
        }
    }

    public static String encryptToBase64(String data, Key key) {
        try {
            return Encodes.encodeUrlSafeBase64(RSA.encrypt(data.getBytes(Charsets.UTF_8), key));
        }
        catch (Exception var3) {
            throw new ApiException("rsa encrypt fail!", (Throwable)var3);
        }
    }

    public static byte[] decrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception var3) {
            throw new ApiException("rsa decrypt fail!", (Throwable)var3);
        }
    }

    public static String decryptFromBase64(String data, Key key) {
        try {
            return new String(RSA.decrypt(Encodes.decodeBase64(data), key), Charsets.UTF_8);
        }
        catch (Exception var3) {
            throw new ApiException("rsa decrypt fail!", (Throwable)var3);
        }
    }
}

