/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.ybpayjh.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProviderRegistry;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.ybpayjh.YbConstants;
import com.yqbsoft.laser.service.ext.channel.ybpayjh.dto.DigitalSignatureDTO;
import com.yqbsoft.laser.service.ext.channel.ybpayjh.util.DigitalEnvelopeUtils;
import com.yqbsoft.laser.service.ext.channel.ybpayjh.util.RSAKeyUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

public class AuthorizationUtil {
    private static final Joiner headerJoiner = Joiner.on((char)'\n');
    private static BitSet URI_UNRESERVED_CHARACTERS = new BitSet();
    private static String[] PERCENT_ENCODED_STRINGS = new String[256];
    private static final Joiner queryStringJoiner = Joiner.on((char)'&');
    private static final Joiner signedHeaderStringJoiner = Joiner.on((char)';');
    private static final Set<String> defaultHeadersToSign = Sets.newHashSet();

    public static Map<String, String> defaultHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("x-yop-session-id", YbConstants.SESSION_ID);
        header.put("x-yop-request-id", UUID.randomUUID().toString());
        return header;
    }

    public static String getAuthorization(ChannelRequest channelRequest, String uri, Map<String, Object> param, Map<String, String> headers) throws InvalidKeySpecException, NoSuchAlgorithmException {
        Map configMap = channelRequest.getConfigMap();
        String date = DateUtil.getDateString((Date)new Date(), (String)"YYYYMMDD'T'HHMMSS'Z'");
        String authString = "yop-auth-v2/" + (String)configMap.get("appKey") + "/" + date + "/1800";
        String canonicalURI = AuthorizationUtil.getCanonicalURIPath(uri);
        String datas = AuthorizationUtil.getCanonicalQueryString(param, true);
        HashSet<String> headersToSignSet = new HashSet<String>();
        headersToSignSet.add("x-yop-request-id");
        SortedMap<String, Object> headersToSign = AuthorizationUtil.getHeadersToSign(headers, headersToSignSet);
        String canonicalHeader = AuthorizationUtil.getCanonicalHeaders(headersToSign);
        String signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
        signedHeaders = signedHeaders.trim().toLowerCase();
        String canonicalRequest = authString + "\n" + channelRequest.getApiRetype() + "\n" + canonicalURI + "\n" + datas + "\n" + canonicalHeader;
        PrivateKey isvPrivateKey = RSAKeyUtils.string2PrivateKey((String)configMap.get("privateKey"));
        DigitalSignatureDTO digitalSignatureDTO = new DigitalSignatureDTO();
        digitalSignatureDTO.setPlainText(canonicalRequest);
        digitalSignatureDTO = DigitalEnvelopeUtils.sign(digitalSignatureDTO, isvPrivateKey);
        return "YOP-RSA2048-SHA256 " + authString + "/" + signedHeaders + "/" + digitalSignatureDTO.getSignature();
    }

    public static String signature(String appKey, String plainText) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PrivateKey isvPrivateKey = RSAKeyUtils.string2PrivateKey(appKey);
        DigitalSignatureDTO digitalSignatureDTO = new DigitalSignatureDTO();
        digitalSignatureDTO.setAppKey(appKey);
        digitalSignatureDTO.setPlainText(plainText);
        return DigitalEnvelopeUtils.sign0(digitalSignatureDTO, isvPrivateKey);
    }

    public static String signature1(String appKey, String plainText) {
        PrivateKey isvPrivateKey = AppSdkConfigProviderRegistry.getProvider().getConfig(appKey).getDefaultIsvPrivateKey();
        com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO digitalSignatureDTO = new com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO();
        digitalSignatureDTO.setAppKey(appKey);
        digitalSignatureDTO.setCertType(CertTypeEnum.RSA2048);
        digitalSignatureDTO.setDigestAlg(DigestAlgEnum.SHA256);
        digitalSignatureDTO.setPlainText(plainText);
        return com.yeepay.g3.sdk.yop.utils.DigitalEnvelopeUtils.sign0((com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO)digitalSignatureDTO, (PrivateKey)isvPrivateKey);
    }

    public static String normalizePath(String path) {
        return AuthorizationUtil.normalize(path).replace("%2F", "/");
    }

    public static String normalize(String value) {
        StringBuilder builder = new StringBuilder();
        for (byte b : value.getBytes(StandardCharsets.UTF_8)) {
            if (URI_UNRESERVED_CHARACTERS.get(b & 0xFF)) {
                builder.append((char)b);
                continue;
            }
            builder.append(PERCENT_ENCODED_STRINGS[b & 0xFF]);
        }
        return builder.toString();
    }

    public static String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        return path.startsWith("/") ? AuthorizationUtil.normalizePath(path) : "/" + AuthorizationUtil.normalizePath(path);
    }

    private static SortedMap<String, Object> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String key : headersToSign) {
                tempSet.add(key.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        Iterator<Map.Entry<String, String>> var6 = headers.entrySet().iterator();
        while (var6.hasNext()) {
            String key;
            Map.Entry<String, String> entry = var6.next();
            key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || (headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key)) && (headersToSign != null || !AuthorizationUtil.isDefaultHeaderToSign(key))) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private static String getCanonicalHeaders(SortedMap<String, Object> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = (String)entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(AuthorizationUtil.normalize(key.trim().toLowerCase()) + ':' + AuthorizationUtil.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join((Iterable)headerStrings);
    }

    public static String getCanonicalQueryString(Map<String, Object> parameters, boolean forSignature) {
        if (parameters.isEmpty()) {
            return "";
        }
        ArrayList parameterStrings = Lists.newArrayList();
        Iterator<Map.Entry<String, Object>> var3 = parameters.entrySet().iterator();
        block0: while (true) {
            if (!var3.hasNext()) {
                Collections.sort(parameterStrings);
                return queryStringJoiner.join((Iterable)parameterStrings);
            }
            Map.Entry<String, Object> entry = var3.next();
            if (forSignature && "Authorization".equalsIgnoreCase(entry.getKey())) continue;
            String key = entry.getKey();
            Preconditions.checkNotNull((Object)key, (Object)"parameter key should not be null");
            Collection value = (Collection)entry.getValue();
            if (null != value && 0 != value.size()) {
                Iterator var7 = value.iterator();
                while (true) {
                    if (!var7.hasNext()) continue block0;
                    String item = (String)var7.next();
                    parameterStrings.add(AuthorizationUtil.normalize(key) + '=' + AuthorizationUtil.normalize(item));
                }
            }
            if (forSignature) {
                parameterStrings.add(AuthorizationUtil.normalize(key) + '=');
                continue;
            }
            parameterStrings.add(AuthorizationUtil.normalize(key));
        }
    }

    private static boolean isDefaultHeaderToSign(String header) {
        return (header = header.trim().toLowerCase()).startsWith("x-yop-") || defaultHeadersToSign.contains(header);
    }
}

