/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.apim;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.OKHttpClientUtil;
import com.yqbsoft.laser.service.ext.data.facade.SupperFacade;
import com.yqbsoft.laser.service.ext.data.request.SupperRequest;
import com.yqbsoft.laser.service.ext.data.response.SupperResponse;
import com.yqbsoft.laser.service.ext.data.util.WXXmlToMapUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Hex;

public class Crmfacade
extends SupperFacade {
    private static String SYS_CODE = "Httpfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(Crmfacade.class);

    public Crmfacade(String host, String appkey, String secret) {
        super(host, appkey, secret);
    }

    public Crmfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public Crmfacade(String host) {
        super(host);
    }

    private String apimRequestReJson(String url, Map<String, String> params, Map<String, Object> bodyParams, String secret, String Key2, String appKey) {
        if (MapUtil.isEmpty(params)) {
            params = new HashMap<String, String>();
        }
        bodyParams.put("signature", this.sign(params));
        String xml = "";
        try {
            xml = WXXmlToMapUtil.multilayerMapToXml(bodyParams, (boolean)false, (String)params.get("parentName"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.error(SYS_CODE + ".apimRequestReJson", (Object)xml);
        long s1 = System.currentTimeMillis();
        OkHttpClient client = OKHttpClientUtil.getOkHttpClirnt();
        long s2 = System.currentTimeMillis();
        logger.error(SYS_CODE + ".apimRequestReJson.time s2-s1", (Object)(s2 - s1));
        MediaType mediaType = MediaType.parse((String)"text/xml");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)xml);
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("charset", "UTF-8").addHeader("Content-Type", "text/xml").build();
        Response response = null;
        String StringTemp = null;
        try {
            long s3 = System.currentTimeMillis();
            response = client.newCall(request).execute();
            long s4 = System.currentTimeMillis();
            logger.error(SYS_CODE + ".apimRequestReJson.times4-s3", (Object)(s4 - s3));
            StringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StringTemp;
    }

    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String json = null;
        json = supperRequest.getTextParams().containsKey("method") && supperRequest.getTextParams().get("method").equals("GET") ? this.apimRequestReJsonByGet(this.getHost(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), this.getSecret(), this.getAppkey(), this.getSigntype()) : this.apimRequestReJson(this.getHost(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), this.getSecret(), this.getAppkey(), this.getSigntype());
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        logger.error("==Http==POST==APIM", (Object)json);
        localResponse.setBody(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    private String apimRequestReJsonByGet(String url, Map<String, String> params, Map<String, Object> bodyParams, String secret, String Key2, String subKey) {
        if (bodyParams.containsKey("method")) {
            bodyParams.remove("method");
        }
        bodyParams.put("api_key", Key2);
        bodyParams.put("nonce_str", "111");
        bodyParams.put("timestamp", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        bodyParams.put("secret", secret);
        Map stringObjectMap = MapUtil.castMap(bodyParams);
        String sign = this.sign(stringObjectMap);
        bodyParams.remove("secret");
        bodyParams.put("sign", sign);
        long s1 = System.currentTimeMillis();
        OkHttpClient client = OKHttpClientUtil.getOkHttpClirnt();
        long s2 = System.currentTimeMillis();
        logger.error(SYS_CODE + ".apimRequestReJsonByGet.time s2-s1", (Object)(s2 - s1));
        MediaType mediaType = MediaType.parse((String)"application/json");
        url = url + "?";
        for (Map.Entry<String, Object> entry : bodyParams.entrySet()) {
            url = url + entry.getKey() + "=" + entry.getValue() + "&";
        }
        url = url.substring(0, url.length() - 1);
        Request request = new Request.Builder().url(url).addHeader("Ocp-Apim-Subscription-Key", subKey).addHeader("Content-Type", "application/json").build();
        Response response = null;
        String stringTemp = null;
        try {
            long s3 = System.currentTimeMillis();
            response = client.newCall(request).execute();
            long s4 = System.currentTimeMillis();
            logger.error(SYS_CODE + ".apimRequestReJsonByGet.time s4-s3", (Object)(s4 - s3));
            stringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.error(SYS_CODE + ".apimRequestReJsonByGet.stringTemp", stringTemp);
        return stringTemp;
    }

    public String sign(Map<String, String> param) {
        String secret = param.get("signature");
        secret = secret + this.getSecret();
        MessageDigest instance = null;
        byte[] bytes = null;
        try {
            instance = MessageDigest.getInstance("MD5");
            bytes = instance.digest(secret.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Hex.encodeHexString(bytes).toUpperCase();
    }
}

