/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.ext.data.api.DataInChuanHangCardRollService;
import com.yqbsoft.laser.service.ext.data.api.DataOutMessageService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HttpUtils;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.config.RequestConfiguration;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.CouponOrderInfoRQ;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCustomerInfo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DataInChuanHangCardRollServiceImpl
extends DateBaseService
implements DataInChuanHangCardRollService {
    private static final String SYS_CODE = "DataInChuanHangCardRollServiceImpl";
    private DataOutMessageService dataOutMessageService;

    public void setDataOutMessageService(DataOutMessageService dataOutMessageService) {
        this.dataOutMessageService = dataOutMessageService;
    }

    public String createBenefitOrder(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.ocContractDomain is null");
            return "fail";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocContractDomain.getMemberBcode(), tenantCode);
        if (userinfoByCode == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createCouponOrder.userinfoByCode is null");
            return "fail";
        }
        Map customer = this.dataOutMessageService.getCustomer(tenantCode, userinfoByCode.getUserinfoOcode());
        if (MapUtil.isEmpty((Map)customer) || !customer.containsKey("CustomerID")) {
            this.logger.error("DataInChuanHangCardRollServiceImplcustomer error", (Object)JSON.toJSONString((Object)customer));
            return "fail";
        }
        CouponOrderInfoRQ couponOrderInfoRQ = new CouponOrderInfoRQ();
        couponOrderInfoRQ.setCustomerId(customer.get("CustomerID").toString());
        if (ListUtil.isNotEmpty((Collection)ocContractDomain.getGoodsList())) {
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractDomain.getGoodsList().get(0);
            couponOrderInfoRQ.setProductId(ocContractGoodsDomain.getGoodsNo());
            couponOrderInfoRQ.setProductCode(ocContractGoodsDomain.getSkuNo());
            couponOrderInfoRQ.setProductUnitPrice(ocContractGoodsDomain.getPricesetRefrice());
            couponOrderInfoRQ.setCount(1);
        }
        couponOrderInfoRQ.setOrderPrice(ocContractDomain.getPricesetRefrice());
        couponOrderInfoRQ.setChannel(RequestConfiguration.CH_CHANNELCODE);
        couponOrderInfoRQ.setIsPackage("1");
        try {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.couponOrderInfoRQ", (Object)JSON.toJSONString((Object)couponOrderInfoRQ));
            String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.CREATEBENEFITORDER, JSON.toJSONString((Object)couponOrderInfoRQ), tenantCode);
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.doPostJSON", (Object)doPostJSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "fail";
    }

    public String returnOrder(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.returnOrder.ocContractDomain is null");
            return "fail";
        }
        return null;
    }

    public String returnCheck(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.ocContractDomain is null");
            return "fail";
        }
        return null;
    }

    public OrderCustomerInfo makeOrderCustomerInfo(Map<String, Object> customer) {
        if (MapUtil.isNotEmpty(customer)) {
            String MobileNumber = customer.get("MobileNumber") == null ? "" : customer.get("MobileNumber").toString();
            String CustomerID = customer.get("CustomerID") == null ? "" : customer.get("CustomerID").toString();
            String CustomerName = customer.get("CustomerName") == null ? "" : customer.get("CustomerName").toString();
            String Email = customer.get("Email") == null ? "" : customer.get("Email").toString();
            return new OrderCustomerInfo(MobileNumber, CustomerName, CustomerID, null, null);
        }
        return null;
    }

    private UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    public static void main(String[] args) {
        String msg = "{\n  \"activeCode\": \"ACT231108A5025\",\n  \"orderInfoRQ\": {\n    \"agentNo\": \"0\",\n    \"cancelTime\": 0,\n    \"childrenInfo\": [\n      {\n        \"orderDetailInfoList\": [\n          {\n            \"productCount\": 1,\n            \"productDetailInfo\": [\n              {\n                \"couponDescribe\": \"2500\u5143\u53ef\u8d2d\u4e704\u5f20\u91cd\u5e86\u53f0\u5317\u6b21\u5361\",\n                \"couponValue\": 2500.0\n              }\n            ],\n            \"productInfo\": \"COUPON\",\n            \"productName\": \"\u91cd\u5e86\u53f0\u531725\u5e74\u6b21\u5361-2500\",\n            \"productNo\": \"P20231114004\",\n            \"productType\": \"COUPON\"\n          }\n        ],\n        \"orderPrice\": 2500.0,\n        \"orderType\": \"SUB\"\n      }\n    ],\n    \"createOrderCrm\": \"2\",\n    \"orderCustomerInfo\": {\n      \"contactsMobile\": \"\",\n      \"contactsName\": \"\",\n      \"customerId\": \"3836689\",\n      \"memberId\": \"800003422\",\n      \"memberLevel\": \"\"\n    },\n    \"orderPay\": {\n      \"payCurrency\": \"CNY\",\n      \"payPrice\": 2500.0,\n      \"payType\": \"ONLINE\"\n    },\n    \"orderPrice\": 2500.0,\n    \"orderSource\": \"\",\n    \"orderType\": \"MAIN\"\n  }\n}";
        try {
            String doPostJSON = HttpUtils.doPostJSON("http://47.108.178.2/api/bff-service/bff_service/all/channel/order/createCouponOrder", msg, null);
            System.out.println(doPostJSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

