/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.apim;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.NonceUtil;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.RsaUtil;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.enums.LuckincoffeeEnums;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.facade.SupperFacade;
import com.yqbsoft.laser.service.ext.data.request.SupperRequest;
import com.yqbsoft.laser.service.ext.data.response.SupperResponse;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Luckincoffeefacade
extends SupperFacade {
    private static String SYS_CODE = "Httpfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(Luckincoffeefacade.class);
    private static final String AUTH_TYPE = "LUCKY2-SHA256-RSA2048";

    public Luckincoffeefacade(String luckincoffeeUrl, String luckincoffeeApi, String luckincoffeeAppid, String luckincoffeeEntno, String luckincoffeePrivatekey) {
        super(luckincoffeeUrl, luckincoffeeApi, luckincoffeeAppid, luckincoffeeEntno, luckincoffeePrivatekey);
    }

    private String apimRequestReJson(String url, Map<String, String> params, Map<String, Object> bodyParams, String luckincoffeeApi, String luckincoffeeAppid, String luckincoffeeEntno, String luckincoffeePrivatekey) {
        if (null == params) {
            params = new HashMap<String, String>();
        }
        String bodyJson = JsonUtil.buildNormalBinder().toJson(bodyParams);
        params.put(LuckincoffeeEnums.luckincoffeeApi.getKey(), luckincoffeeApi);
        params.put(LuckincoffeeEnums.luckincoffeeAppid.getKey(), luckincoffeeAppid);
        params.put(LuckincoffeeEnums.luckincoffeeEntno.getKey(), luckincoffeeEntno);
        params.put(LuckincoffeeEnums.luckincoffeePrivatekey.getKey(), luckincoffeePrivatekey);
        params.put(LuckincoffeeEnums.bodyParams.getKey(), bodyJson);
        params.put("method", "POST");
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)bodyJson);
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).post(body).addHeader("Content-Type", "application/json").addHeader("Authorization", this.sign(params)).build();
        Response response = null;
        String StringTemp = null;
        try {
            response = client.newCall(request).execute();
            StringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StringTemp;
    }

    @Override
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String json = null;
        Map textParams = supperRequest.getTextParams();
        json = textParams.containsKey("method") && textParams.get("method").equals("GET") ? this.apimRequestReJsonByGet(this.getLuckincoffeeUrl(), supperRequest.getHeaderMap(), textParams, this.getLuckincoffeeApi(), this.getLuckincoffeeAppid(), this.getLuckincoffeeEntno(), this.getLuckincoffeePrivatekey()) : this.apimRequestReJson(this.getLuckincoffeeUrl(), supperRequest.getHeaderMap(), textParams, this.getLuckincoffeeApi(), this.getLuckincoffeeAppid(), this.getLuckincoffeeEntno(), this.getLuckincoffeePrivatekey());
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        logger.error("==Http==POST==APIM", (Object)json);
        localResponse.setBody(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    private String apimRequestReJsonByGet(String url, Map<String, String> params, Map<String, Object> bodyParams, String luckincoffeeApi, String luckincoffeeAppid, String luckincoffeeEntno, String luckincoffeePrivatekey) {
        if (null == params) {
            params = new HashMap<String, String>();
        }
        params.put(LuckincoffeeEnums.luckincoffeeApi.getKey(), luckincoffeeApi);
        params.put(LuckincoffeeEnums.luckincoffeeAppid.getKey(), luckincoffeeAppid);
        params.put(LuckincoffeeEnums.luckincoffeeEntno.getKey(), luckincoffeeEntno);
        params.put(LuckincoffeeEnums.luckincoffeePrivatekey.getKey(), luckincoffeePrivatekey);
        params.put(LuckincoffeeEnums.bodyParams.getKey(), "");
        params.put("method", "GET");
        Request request = new Request.Builder().url(url).get().addHeader("Authorization", this.sign(params)).build();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Response response = null;
        String StringTemp = null;
        try {
            response = client.newCall(request).execute();
            StringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StringTemp;
    }

    @Override
    public String sign(Map<String, String> param) {
        long timestamp = System.currentTimeMillis();
        String nonceStr = NonceUtil.generateNonceStr();
        logger.error(SYS_CODE + ".sign.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String signStr = String.format("%s\n%s\n%s\n%s\n%s\n", param.get("method"), param.get(LuckincoffeeEnums.luckincoffeeApi.getKey()), timestamp, nonceStr, param.get(LuckincoffeeEnums.bodyParams.getKey()));
        byte[] signBytes = signStr.getBytes(Charset.forName("UTF-8"));
        String sign = RsaUtil.sign(signBytes, param.get(LuckincoffeeEnums.luckincoffeePrivatekey.getKey()));
        String authVal = String.format("ent_no=%s,nonce_str=%s,app_id=%s,signature=%s,timestamp=%s", param.get(LuckincoffeeEnums.luckincoffeeEntno.getKey()), nonceStr, param.get(LuckincoffeeEnums.luckincoffeeAppid.getKey()), sign, timestamp);
        return String.format("%s %s", AUTH_TYPE, authVal);
    }
}

