/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataOutChuanHangQueryService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OcsOcserviceConfReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OcsOcserviceReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCall;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCallDetail;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCallGoods;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCallSend;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.data.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataOutChuanHangQueryServiceImpl
extends DateBaseService
implements DataOutChuanHangQueryService {
    private static final String SYS_CODE = "DataCHCallDataCenterServiceImpl";
    private static String ui_startdate = "startDate";
    private static String ui_enddate = "endDate";
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    protected Map<String, Object> checkMapStr(String queryJsonMapStr, String method) {
        this.logger.error("DataCHCallDataCenterServiceImpl.checkMapStr." + method, (Object)queryJsonMapStr);
        queryJsonMapStr = this.verifyPlus(queryJsonMapStr);
        this.logger.error("DataCHCallDataCenterServiceImpl.checkMapStr." + method, (Object)queryJsonMapStr);
        Map map = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(queryJsonMapStr, String.class, Object.class);
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.checkMapStr." + method + ".param is null");
            throw new ApiException("DataCHCallDataCenterServiceImpl." + method, "\u53c2\u6570\u5f02\u5e38");
        }
        return map;
    }

    public String queryOcContractCall(String queryJsonMapStr) {
        Map<String, Object> map = this.checkMapStr(queryJsonMapStr, "queryOcContractCall");
        this.logger.error("DataCHCallDataCenterServiceImpl.queryOcContractCall.queryOrderPage", (Object)JsonUtil.buildNormalBinder().toJson(map));
        DataOutChuanHangQueryServiceImpl.makePage(map);
        map.put("childFlag", true);
        map.put("order", true);
        boolean fuzzy = null == map.get("fuzzy") || Boolean.valueOf(map.get("fuzzy").toString()) != false;
        map.put("fuzzy", fuzzy);
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderPage(map);
        if (ocContractReDomainQueryResult == null || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            throw new ApiException("ocPage null");
        }
        ArrayList<OrderCall> orderCallList = new ArrayList<OrderCall>();
        for (OcContractReDomain ocContractReDomain : ocContractReDomainQueryResult.getList()) {
            OrderCall orderCall = this.createOrderCall(ocContractReDomain);
            orderCallList.add(orderCall);
        }
        QueryResult orderCallQueryResult = new QueryResult();
        orderCallQueryResult.setList(orderCallList);
        orderCallQueryResult.setTotal(ocContractReDomainQueryResult.getTotal());
        return JsonUtil.buildNormalBinder().toJson((Object)orderCallQueryResult);
    }

    private OrderCall createOrderCall(OcContractReDomain ocContractReDomain) {
        String ocserviceCode;
        QueryResult<OcsOcserviceConfReDomain> confResult;
        OrderCall orderCall = new OrderCall();
        QueryResult<OcsOcserviceReDomain> ocsQueryResult = this.queryOcservicePage(ocContractReDomain.getMemberCcode(), ocContractReDomain.getTenantCode());
        if (ocsQueryResult != null && ListUtil.isNotEmpty((Collection)ocsQueryResult.getList()) && (confResult = this.queryOcserviceConfPage(ocserviceCode = ((OcsOcserviceReDomain)ocsQueryResult.getList().get(0)).getOcserviceCode(), ocContractReDomain.getTenantCode())) != null && ListUtil.isNotEmpty((Collection)confResult.getList())) {
            orderCall.setCustomerPhone(((OcsOcserviceConfReDomain)confResult.getList().get(0)).getOcserviceConfValue());
        }
        orderCall.setContractBbillcode(ocContractReDomain.getContractBbillcode());
        orderCall.setContractBillcode(ocContractReDomain.getContractBillcode());
        if (ListUtil.isNotEmpty((Collection)ocContractReDomain.getGoodsList())) {
            orderCall.setGoodsName(((OcContractGoodsDomain)ocContractReDomain.getGoodsList().get(0)).getGoodsName());
        }
        orderCall.setContractInmoney(ocContractReDomain.getContractInmoney());
        orderCall.setDataBmoney(ocContractReDomain.getDataBmoney());
        orderCall.setGoodsNum(ocContractReDomain.getGoodsNum());
        orderCall.setGoodsReceiptMem(ocContractReDomain.getGoodsReceiptMem());
        orderCall.setGoodsReceiptPhone(ocContractReDomain.getGoodsReceiptPhone());
        orderCall.setMemberBname(ocContractReDomain.getMemberBname());
        orderCall.setGmtCreate(ocContractReDomain.getGmtCreate());
        orderCall.setContractType(ocContractReDomain.getContractType());
        orderCall.setDataState(ocContractReDomain.getDataState());
        QueryResult<OcContractSettlDomain> settlDomainQueryResult = this.queryContractSettlPage(ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode());
        if (ListUtil.isNotEmpty((Collection)settlDomainQueryResult.getList())) {
            OcContractSettlDomain ocContractSettlDomain = (OcContractSettlDomain)settlDomainQueryResult.getList().get(0);
            orderCall.setGmtCreateMemo(ocContractSettlDomain.getGmtCreate());
            orderCall.setMemberName(ocContractSettlDomain.getMemberName());
            orderCall.setContractSettlOpem(ocContractSettlDomain.getContractSettlOpemo());
        }
        return orderCall;
    }

    private QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    private QueryResult<OcsOcserviceReDomain> queryOcservicePage(String memberCode, String tenantCode) {
        if (StringUtils.isEmpty((String)memberCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryOcservicePage.null");
            return null;
        }
        String apiCode = "ocs.ocservice.queryOcservicePage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcsOcserviceReDomain.class);
    }

    private QueryResult<OcsOcserviceConfReDomain> queryOcserviceConfPage(String ocserviceCode, String tenantCode) {
        if (StringUtils.isEmpty((String)ocserviceCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryOcservicePage.null");
            return null;
        }
        String apiCode = "ocs.ocservice.queryOcserviceConfPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ocserviceCode", ocserviceCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcsOcserviceConfReDomain.class);
    }

    public String getOcContractDetailCa(String queryJsonMapStr) {
        Map<String, Object> map = this.checkMapStr(queryJsonMapStr, "getOcContractDetailCa");
        this.logger.error("DataCHCallDataCenterServiceImpl.getOcContractDetailCa", (Object)JsonUtil.buildNormalBinder().toJson(map));
        String contractBillcode = map.get("contractBillcode").toString();
        String tenantCode = map.get("tenantCode").toString();
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("DataCHCallDataCenterServiceImpl.getOcContractDetailCa", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain contract = this.getContract(contractBillcode, tenantCode);
        OrderCallDetail orderCallDetail = this.createOrderCallDetail(contract);
        this.createOrderCallSend(orderCallDetail, contract);
        return JsonUtil.buildNormalBinder().toJson((Object)orderCallDetail);
    }

    private void createOrderCallSend(OrderCallDetail orderCallDetail, OcContractReDomain contract) {
        QueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainQueryResult = this.querySgSendgoodsPage(contract.getContractBillcode(), contract.getTenantCode());
        if (sgSendgoodsReDomainQueryResult != null && ListUtil.isNotEmpty((Collection)sgSendgoodsReDomainQueryResult.getList())) {
            ArrayList<OrderCallSend> orderCallSendList = new ArrayList<OrderCallSend>();
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainQueryResult.getList()) {
                OrderCallSend orderCallSend = new OrderCallSend();
                orderCallSend.setSendgoodsCode(sgSendgoodsReDomain.getSendgoodsCode());
                orderCallSend.setContractBillcode(sgSendgoodsReDomain.getContractBillcode());
                orderCallSend.setContractBbillcode(sgSendgoodsReDomain.getContractBbillcode());
                orderCallSend.setMemberCname(sgSendgoodsReDomain.getMemberCname());
                orderCallSend.setGoodsReceiptMem(sgSendgoodsReDomain.getGoodsReceiptMem());
                orderCallSend.setGoodsReceiptArrdess(sgSendgoodsReDomain.getGoodsReceiptArrdess());
                orderCallSend.setGoodsReceiptPhone(sgSendgoodsReDomain.getGoodsReceiptPhone());
                orderCallSend.setMemberBname(sgSendgoodsReDomain.getMemberBname());
                orderCallSend.setGmtCreate(sgSendgoodsReDomain.getGmtCreate());
                orderCallSend.setPackageName(sgSendgoodsReDomain.getPackageName());
                orderCallSend.setPackageBillno(sgSendgoodsReDomain.getPackageBillno());
                orderCallSendList.add(orderCallSend);
            }
            orderCallDetail.setOrderCallSendList(orderCallSendList);
        }
    }

    private OrderCallDetail createOrderCallDetail(OcContractReDomain contract) {
        OrderCallDetail orderCallDetail = new OrderCallDetail();
        orderCallDetail.setPricesetRefrice(contract.getPricesetRefrice());
        orderCallDetail.setPricesetRefrice2(contract.getPricesetRefrice());
        orderCallDetail.setPricesetRefrice3(BigDecimal.ZERO);
        orderCallDetail.setContractInmoney(contract.getContractInmoney());
        orderCallDetail.setDataBmoney(contract.getDataBmoney());
        orderCallDetail.setGoodsPmoney(contract.getGoodsPmoney());
        List ocContractSettlList = contract.getOcContractSettlList();
        if (ListUtil.isNotEmpty((Collection)ocContractSettlList)) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                orderCallDetail.setContractSettlBlance(ocContractSettlDomain.getContractSettlBlance());
                if (!"CAS".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                if (ocContractSettlDomain.getContractSettlOpemo().contains("wechat")) {
                    orderCallDetail.setPrice(ocContractSettlDomain.getContractSettlPmoney());
                    orderCallDetail.setContractSettlOpemo("wechat");
                }
                if (!ocContractSettlDomain.getContractSettlOpemo().contains("alipay")) continue;
                orderCallDetail.setPrice(ocContractSettlDomain.getContractSettlPmoney());
                orderCallDetail.setContractSettlOpemo("alipay");
            }
        }
        orderCallDetail.setContractPmode(contract.getContractPmode());
        orderCallDetail.setGoodsLogmoney(contract.getGoodsLogmoney());
        orderCallDetail.setPackageNum(contract.getPackageList().size());
        orderCallDetail.setGoodsReceiptMem(contract.getGoodsReceiptMem());
        orderCallDetail.setGoodsReceiptPhone(contract.getGoodsReceiptPhone());
        orderCallDetail.setGoodsReceiptArrdess(contract.getGoodsReceiptArrdess());
        if (ListUtil.isNotEmpty((Collection)contract.getGoodsList())) {
            ArrayList<OrderCallGoods> orderCallGoods = new ArrayList<OrderCallGoods>();
            for (OcContractGoodsDomain ocContractGoodsDomain : contract.getGoodsList()) {
                OrderCallGoods callGoods = new OrderCallGoods();
                callGoods.setGoodsName(ocContractGoodsDomain.getGoodsName());
                callGoods.setSkuName(ocContractGoodsDomain.getSkuName());
                callGoods.setGoodsNum(ocContractGoodsDomain.getGoodsNum());
                callGoods.setContractGoodsMoney(ocContractGoodsDomain.getContractGoodsMoney());
                callGoods.setGoodsPricesetRefrice(ocContractGoodsDomain.getPricesetRefrice());
                orderCallGoods.add(callGoods);
            }
            orderCallDetail.setOrderCallGoodsList(orderCallGoods);
        }
        return orderCallDetail;
    }

    private QueryResult<OcContractSettlDomain> queryContractSettlPage(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.queryContractSettlPage";
        HashMap<String, Object> ocMap = new HashMap<String, Object>();
        ocMap.put("contractSettlBlance", "ORMEMO");
        ocMap.put("contractBillcode", contractBillcode);
        ocMap.put("tenantCode", tenantCode);
        ocMap.put("order", true);
        ocMap.put("fuzzy", false);
        ocMap.put("page", 1);
        ocMap.put("rows", 100);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(ocMap));
        return this.sendReSupObject(apiCode, param, OcContractSettlDomain.class);
    }

    private QueryResult<SgSendgoodsReDomain> querySgSendgoodsPage(String contractBillcode, String tenantCode) {
        String apiCode = "sg.sendgoods.querySgSendgoodsPageReDomain";
        HashMap<String, String> ocMap = new HashMap<String, String>();
        ocMap.put("contractBillcode", contractBillcode);
        ocMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(ocMap));
        return this.sendReSupObject(apiCode, param, SgSendgoodsReDomain.class);
    }

    protected String getSendgoods(Map<String, Object> map) {
        return this.internalInvoke("sg.sendgoods.querySgSendgoodsPageReDomain", map);
    }

    private OcContractReDomain getContract(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.getContractByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return (OcContractReDomain)this.getForObject(apiCode, OcContractReDomain.class, param);
    }

    public static void makePage(Map<String, Object> map) {
        String page;
        if (null != map && !map.isEmpty() && null != (page = (String)map.get(ui_page))) {
            String rows;
            if (StringUtils.isBlank((String)page)) {
                page = "1";
            }
            if (StringUtils.isBlank((String)(rows = (String)map.get(ui_rows))) || "0".equals(rows)) {
                rows = "10";
            }
            map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
            map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            map.put(ui_rows, Long.valueOf(rows).intValue());
            map.put(ui_page, Long.valueOf(page).intValue());
        }
    }

    public String getSgSendgoodsCall(String queryJsonMapStr) {
        Map<String, Object> map = this.checkMapStr(queryJsonMapStr, "getSgSendgoodsCall");
        if (StringUtils.isEmpty((String)map.get("contractBillcode").toString())) {
            throw new ApiException("DataCHCallDataCenterServiceImpl.getSgSendgoodsCall", "\u53c2\u6570\u5f02\u5e38");
        }
        String sendgoods = this.getSendgoods(map);
        return sendgoods;
    }

    private String verifyPlus(String content) {
        String secretkey = DataOutChuanHangQueryServiceImpl.getDdFlagPlus("2021062400000001", "secretkeyCHCa", "secretkeyCHCa");
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.verifyPlus secretkey null");
            return null;
        }
        String data = null;
        try {
            data = EncryptUtil.aesDecrypt(content, secretkey);
        }
        catch (Exception e) {
            this.logger.error("DataCHCallDataCenterServiceImpl.verifyPlus.e", (Throwable)e);
            return null;
        }
        return data;
    }

    protected static String getDdFlagPlus(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public String queryOcContractData(String s) {
        return null;
    }

    public String getOcContractDetailData(String s) {
        return null;
    }

    public String getSgSendgoodsData(String s) {
        return null;
    }
}

