/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.data.api.DataOutMessageService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.apim.Crmfacade;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.enums.ReturnEnums;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.GetPhoneRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.SendMessageRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.VerifyMessageRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.GetPhoneResponse;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.SendMessageResponse;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.VerifyMessageResponse;
import com.yqbsoft.laser.service.ext.data.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.ext.data.util.WXXmlToMapUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="dataOutMessageService")
public class DataOutMessageServiceImpl
extends DateBaseService
implements DataOutMessageService {
    private static final String SYS_CODE = "DataOutMessageServiceImpl";

    public Map<String, Object> sendMessage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String tenantCode = (String)map.get("tenantCode");
        String userinfoCode = (String)map.get("userinfoCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("tenantCode is null");
            return null;
        }
        if (StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("userinfoCode is null");
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String channelType = this.getDdFalgSetting(tenantCode, "channelType", "channelType", "");
        String key = this.getDdFalgSetting(tenantCode, "key", "key", "");
        String sendMessageUrl = this.getDdFalgSetting(tenantCode, "sendMessageUrl", "sendMessageUrl", "");
        String userinfoStr = this.internalInvoke(ApiCodeEnums.getUserinfoByUserCode.getApiCode(), map);
        if (StringUtils.isBlank((String)userinfoStr)) {
            throw new ApiException("\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a", map.toString());
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
        if (null == umUserinfo) {
            throw new ApiException("umUserinfo is NULL");
        }
        String monile = this.getPhone(tenantCode, umUserinfo.getUserinfoOcode());
        if (StringUtils.isBlank((String)monile)) {
            throw new ApiException("\u624b\u673a\u53f7\u83b7\u53d6\u5931\u8d25");
        }
        Crmfacade apimfacade = new Crmfacade(sendMessageUrl, null, key);
        SendMessageRequest sendMessageRequest = new SendMessageRequest();
        sendMessageRequest.setChannelType(channelType);
        sendMessageRequest.setMobile(monile);
        sendMessageRequest.setCustomerId(umUserinfo.getUserinfoOcode());
        SendMessageResponse execusend = apimfacade.execute(sendMessageRequest);
        if (ReturnEnums.error.getErrCode().equals(execusend.getErrorCode())) {
            this.logger.error("\u9a8c\u8bc1\u7801\u6821\u9a8c----\u300b", (Object)execusend.getBody());
            result.put("isSuccess", false);
            result.put("body", execusend.getBody());
            return result;
        }
        result.put("isSuccess", true);
        result.put("body", execusend.getBody());
        return result;
    }

    public Map<String, Object> checkMessage(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (MapUtil.isEmpty(map)) {
            result.put("isSuccess", false);
            result.put("body", "map is null");
            return result;
        }
        String tenantCode = (String)map.get("tenantCode");
        String userinfoCode = (String)map.get("userinfoCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            result.put("isSuccess", false);
            result.put("body", "tenantCode is null");
            return result;
        }
        if (StringUtils.isBlank((String)userinfoCode)) {
            result.put("isSuccess", false);
            result.put("body", "userinfoCode is null");
            return result;
        }
        String channelType = this.getDdFalgSetting(tenantCode, "channelType", "channelType", "");
        String key = this.getDdFalgSetting(tenantCode, "key", "key", "");
        String checkMessageUrl = this.getDdFalgSetting(tenantCode, "checkMessageUrl", "checkMessageUrl", "");
        String userinfoStr = this.internalInvoke(ApiCodeEnums.getUserinfoByUserCode.getApiCode(), map);
        if (StringUtils.isBlank((String)userinfoStr)) {
            result.put("isSuccess", false);
            result.put("body", "\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a");
            return result;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
        if (null == umUserinfo) {
            result.put("isSuccess", false);
            result.put("body", "umUserinfo is null");
            return result;
        }
        String monile = this.getPhone(tenantCode, umUserinfo.getUserinfoOcode());
        if (StringUtils.isBlank((String)monile)) {
            result.put("isSuccess", false);
            result.put("body", "\u624b\u673a\u53f7\u83b7\u53d6\u5931\u8d25");
            return result;
        }
        String code = (String)map.get("code");
        if (StringUtils.isBlank((String)code)) {
            result.put("isSuccess", false);
            result.put("body", "\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
            return result;
        }
        Crmfacade apimfacade = new Crmfacade(checkMessageUrl, null, key);
        VerifyMessageRequest verifyMessageRequest = new VerifyMessageRequest();
        verifyMessageRequest.setChannelType(channelType);
        verifyMessageRequest.setMobile(monile);
        verifyMessageRequest.setValidateCode(code);
        verifyMessageRequest.setCustomerId(umUserinfo.getUserinfoOcode());
        VerifyMessageResponse exeverify = apimfacade.execute(verifyMessageRequest);
        if (ReturnEnums.error.getErrCode().equals(exeverify.getErrorCode())) {
            this.logger.error("\u9a8c\u8bc1\u7801\u6821\u9a8c----\u300b", (Object)exeverify.getBody());
            result.put("isSuccess", false);
            result.put("body", exeverify.getBody());
            return result;
        }
        result.put("isSuccess", true);
        result.put("body", exeverify.getBody());
        return result;
    }

    private String getPhone(String tenantCode, String customerId) {
        String channelType = this.getDdFalgSetting(tenantCode, "channelType", "channelType", "");
        String key = this.getDdFalgSetting(tenantCode, "key", "key", "");
        String getPhoneUrl = this.getDdFalgSetting(tenantCode, "getPhoneUrl", "getPhoneUrl", "");
        Crmfacade apimfacade = new Crmfacade(getPhoneUrl, null, key);
        GetPhoneRequest getPhoneRequest = new GetPhoneRequest();
        getPhoneRequest.setChannelType(channelType);
        getPhoneRequest.setAccountNumber(customerId);
        getPhoneRequest.setAccountType("CUSTOMER");
        GetPhoneResponse exegetphone = apimfacade.execute(getPhoneRequest);
        if (ReturnEnums.error.getErrCode().equals(exegetphone.getErrorCode())) {
            this.logger.error("DataOutMessageServiceImpl.GetPhoneResponse.execute" + JsonUtil.buildNormalBinder().toJson((Object)exegetphone));
            return null;
        }
        Map map = WXXmlToMapUtil.multilayerXmlToMap((String)exegetphone.getBody());
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error("\u67e5\u8be2\u5931\u8d25=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)exegetphone));
            return null;
        }
        Map response = (Map)map.get("Response");
        if (MapUtil.isEmpty((Map)response)) {
            this.logger.error("\u67e5\u8be2\u5931\u8d25Response=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            return null;
        }
        Map cardVoucherModel = (Map)response.get("CardVoucherModel");
        if (MapUtil.isEmpty((Map)response)) {
            this.logger.error("\u67e5\u8be2\u5931\u8d25CardVoucherModel=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)cardVoucherModel));
            return null;
        }
        return (String)cardVoucherModel.get("MobileNumber");
    }
}

