/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.apim;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.data.facade.SupperFacade;
import com.yqbsoft.laser.service.ext.data.request.SupperRequest;
import com.yqbsoft.laser.service.ext.data.response.SupperResponse;
import com.yqbsoft.laser.service.ext.data.util.SHA1Util;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Orderfacade
extends SupperFacade {
    private static String SYS_CODE = "Httpfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(Orderfacade.class);

    public Orderfacade(String host, String appkey, String secret) {
        super(host, appkey, secret);
    }

    public Orderfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public Orderfacade(String host) {
        super(host);
    }

    private String apimRequestReJson(String url, Map<String, String> params, Map<String, Object> bodyParams, String secret, String Key, String appKey) {
        if (MapUtil.isEmpty(params)) {
            params = new HashMap<String, String>();
        }
        String sign = this.sign(bodyParams, secret);
        bodyParams.put("time", new Date().getTime() / 1000L);
        params.put("app_id", Key);
        params.put("sign", sign);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        url = url + "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            url = url + entry.getKey() + "=" + entry.getValue() + "&";
        }
        url = url.substring(0, url.length() - 1);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)JsonUtil.buildNonDefaultBinder().toJson(bodyParams));
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = null;
        String StringTemp = null;
        try {
            response = client.newCall(request).execute();
            StringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StringTemp;
    }

    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String json = null;
        json = supperRequest.getTextParams().containsKey("method") && supperRequest.getTextParams().get("method").equals("GET") ? this.apimRequestReJsonByGet(this.getHost(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), this.getSecret(), this.getAppkey(), this.getSigntype()) : this.apimRequestReJson(this.getHost(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), this.getSecret(), this.getAppkey(), this.getSigntype());
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        localResponse.setBody(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    private String apimRequestReJsonByGet(String url, Map<String, String> headerMap, Map<String, Object> textParams, String secret, String appkey, String signtype) {
        if (textParams.containsKey("method")) {
            textParams.remove("method");
        }
        textParams.put("api_key", appkey);
        textParams.put("nonce_str", "111");
        textParams.put("timestamp", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        textParams.put("secret", secret);
        Map stringObjectMap = MapUtil.castMap(textParams);
        String sign = this.sign(stringObjectMap);
        textParams.remove("secret");
        textParams.put("sign", sign);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        url = url + "?";
        for (Map.Entry<String, Object> entry : textParams.entrySet()) {
            url = url + entry.getKey() + "=" + entry.getValue() + "&";
        }
        url = url.substring(0, url.length() - 1);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").build();
        Response response = null;
        String stringTemp = null;
        try {
            response = client.newCall(request).execute();
            stringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.error(SYS_CODE + ".apimRequestReJsonByGet.stringTemp", (Object)stringTemp);
        return stringTemp;
    }

    public String sign(Map<String, Object> bodyParams, String secret) {
        String sign = "";
        try {
            logger.error(SYS_CODE + "---------  :" + secret + JsonUtil.buildNormalBinder().toJson(bodyParams));
            sign = SHA1Util.Sha1((String)(secret + JsonUtil.buildNormalBinder().toJson(bodyParams)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sign;
    }

    public String sign(Map<String, String> param) {
        String secret = param.get("secret");
        param.remove("secret");
        String sign = "";
        try {
            sign = SHA1Util.Sha1((String)(secret + JsonUtil.buildNormalBinder().toJson(param)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sign;
    }
}

