/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataCyyMeituanService;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.DateUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.accountInfo.Key;
import com.yqbsoft.laser.service.ext.data.cyy.service.client.SqtClient;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.PtePtrade;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.ext.data.cyy.service.enums.PayStatusEnum;
import com.yqbsoft.laser.service.ext.data.cyy.service.h5Access.SqtH5Access;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayCallbackRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayQueryRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdRefundRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdPayQueryRespBody;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdPayRespBody;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdRefundRespBody;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.response.BaseApiResponse;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataCyyMeituanServiceImpl
extends BaseServiceImpl
implements DataCyyMeituanService {
    private static final String SYS_CODE = "DataCyyMeituanServiceImpl";
    private static final String URL = "https://m-sqt.meituan.com/open/commonaccess/access";

    public String getH5AccessUrl(String staffNo, String tenantCode) {
        String params = SqtH5Access.h5Params(staffNo);
        return "https://m-sqt.meituan.com/open/commonaccess/access?" + params + "&test_open_swimlane=test-open";
    }

    public BaseApiResponse<String> saveOrder(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdPayRequest thirdPayRequest = JsonUtil.json2Object(decryptContent, ThirdPayRequest.class);
            if (thirdPayRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, thirdPayRequest:{}", (Object)thirdPayRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.thirdPayRequest:{}", (Object)thirdPayRequest);
            ThirdPayRespBody respBody = this.saveCyyOrder(thirdPayRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdPayRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdPayRespBody saveCyyOrder(ThirdPayRequest thirdPayRequest, String tenantCode) throws Exception {
        String payUrl = this.getDdFalgSetting(tenantCode, "payUrl", "payUrl", "");
        Map<String, Object> extInfoMap = thirdPayRequest.getExtInfoMap();
        Object entStaffNum = extInfoMap.get("entStaffNum");
        if (null == entStaffNum) {
            this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.thirdPayRequest:{}, \u5904\u7406\u5f02\u5e38", (Object)thirdPayRequest);
            throw new Exception("\u7528\u6237\u4e3a\u7a7a");
        }
        UmUserinfoReDomainBean userinfo = this.getUserinfo(String.valueOf(entStaffNum), tenantCode);
        if (null == userinfo) {
            this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.extInfoMap:{}, \u5904\u7406\u5f02\u5e38", extInfoMap);
            throw new Exception("\u627e\u4e0d\u5230\u7528\u6237");
        }
        OcContractReDomain contractDomain = this.queryContractPage(thirdPayRequest.getTradeNo(), tenantCode);
        if (contractDomain != null && StringUtils.isNotBlank((String)contractDomain.getContractBillcode())) {
            return new ThirdPayRespBody(contractDomain.getContractBillcode(), payUrl);
        }
        BigDecimal tradeAmount = new BigDecimal(thirdPayRequest.getTradeAmount());
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setContractNbillcode(String.valueOf(thirdPayRequest.getTradeNo()));
        ocContractDomain.setContractNbbillcode(String.valueOf(thirdPayRequest.getSqtBizOrderId()));
        ocContractDomain.setContractRemark(thirdPayRequest.getReturnUrl());
        ocContractDomain.setContractUserurl(thirdPayRequest.getNotifyUrl());
        ocContractDomain.setTenantCode(tenantCode);
        ocContractDomain.setAppmanageIcode(userinfo.getAppmanageIcode());
        ocContractDomain.setUserCode(userinfo.getUserCode());
        ocContractDomain.setUserName(userinfo.getUserinfoPhone());
        ocContractDomain.setMemberBcode(userinfo.getUserinfoCode());
        ocContractDomain.setMemberBname(userinfo.getUserinfoCompname());
        ocContractDomain.setMemberCode("20000210365967");
        ocContractDomain.setMemberName("\u6df1\u5733\u4eba\u624d");
        ocContractDomain.setMemberCcode("20000210365967");
        ocContractDomain.setMemberCname("\u6df1\u5733\u4eba\u624d");
        ocContractDomain.setContractType("45");
        ocContractDomain.setContractInmoney(tradeAmount);
        ocContractDomain.setContractMoney(tradeAmount);
        ocContractDomain.setDataBmoney(tradeAmount);
        ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setGoodsType("45");
        ocContractGoodsDomain.setPricesetNprice(tradeAmount);
        ocContractGoodsDomain.setPricesetAsprice(tradeAmount);
        ocContractGoodsDomain.setContractGoodsGtype("2");
        ocContractGoodsDomain.setGoodsCode("mtgoods");
        ocContractGoodsDomain.setGoodsName("\u7f8e\u56e2\u5546\u54c1");
        if (StringUtils.isNotBlank((String)thirdPayRequest.getGoodsName())) {
            ocContractGoodsDomain.setGoodsName(thirdPayRequest.getGoodsName());
        }
        ocContractGoodsDomain.setGoodsNum(tradeAmount);
        ocContractGoodsDomain.setTenantCode(userinfo.getTenantCode());
        ocContractGoodsDomain.setMemberCode("20000210365967");
        ocContractGoodsDomain.setMemberMname("\u6df1\u5733\u4eba\u624d");
        ocContractGoodsDomain.setMemberCcode("20000210365967");
        ocContractGoodsDomain.setMemberCname("\u6df1\u5733\u4eba\u624d");
        contractGoodsList.add(ocContractGoodsDomain);
        ocPackageDomain.setContractGoodsList(contractGoodsList);
        packageList.add(ocPackageDomain);
        ocContractDomain.setPackageList(packageList);
        this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.ocContractDomain:{}, \u65b0\u589e\u8ba2\u5355", (Object)JsonUtil.object2Json(ocContractDomain));
        String contractBbillcode = this.sendContractByDel(ocContractDomain, null);
        if (StringUtils.isBlank((String)contractBbillcode)) {
            throw new Exception("\u65b0\u589e\u8ba2\u5355\u5931\u8d25");
        }
        payUrl = payUrl + contractBbillcode;
        return new ThirdPayRespBody(contractBbillcode, payUrl);
    }

    public BaseApiResponse<String> saveRefund(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.saveRefund.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdRefundRequest thirdRefundRequest = JsonUtil.json2Object(decryptContent, ThirdRefundRequest.class);
            if (thirdRefundRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.saveRefund.token:{}, thirdRefundRequest:{}", (Object)thirdRefundRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.thirdPayRequest:{}", (Object)thirdRefundRequest);
            ThirdRefundRespBody respBody = this.refund(thirdRefundRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdRefundRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdRefundRespBody refund(ThirdRefundRequest thirdRefundRequest, String tenantCode) throws Exception {
        OcContractReDomain ocContractReDomain = this.queryContractPage(thirdRefundRequest.getTradeNo(), tenantCode);
        if (ocContractReDomain == null) {
            this.logger.error("DataCyyMeituanServiceImpl.\u652f\u4ed8\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
            return new ThirdRefundRespBody(null);
        }
        List<OcRefundDomain> refundDomainList = this.queryRefundPage(thirdRefundRequest.getTradeNo(), thirdRefundRequest.getRefundTradeNo(), ocContractReDomain.getContractBillcode(), tenantCode);
        OcRefundDomain ocRefundDomain = null;
        if (ListUtil.isNotEmpty(refundDomainList)) {
            ocRefundDomain = refundDomainList.get(0);
            this.logger.error("DataCyyMeituanServiceImpl.refund.ocRefundDomain", (Object)JsonUtil.object2Json(ocRefundDomain));
            this.logger.error("DataCyyMeituanServiceImpl.\u9000\u6b3e\u7533\u8bf7\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.object2Json(thirdRefundRequest));
            return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
        }
        if (StringUtils.isBlank((String)ocContractReDomain.getPtradeSeqno()) || ocContractReDomain.getDataState() != 2) {
            if (ocContractReDomain.getDataState() == -1) {
                this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u5df2\u5168\u90e8\u9000\u6b3e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
                return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
            }
            this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
            return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
        }
        PtePtrade pteptrade = this.getPteptrade((OcContractDomain)ocContractReDomain);
        if (pteptrade == null) {
            this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
            return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
        }
        if (pteptrade.getDataState() != 3) {
            this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
            return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
        }
        List<OcRefundDomain> refundDomainListTwo = this.queryRefundPage(thirdRefundRequest.getTradeNo(), null, ocContractReDomain.getContractBillcode(), tenantCode);
        BigDecimal refundMoney = new BigDecimal(thirdRefundRequest.getRefundAmount());
        if (ListUtil.isNotEmpty(refundDomainListTwo)) {
            for (OcRefundDomain refundDomain : refundDomainListTwo) {
                refundMoney = refundMoney.add(refundDomain.getRefundMoney());
                this.logger.error("DataCyyMeituanServiceImpl.refund.refundMoney", (Object)(refundMoney + "\u2014\u2014" + refundDomain.getRefundMoney() + "\u2014\u2014" + refundDomain.getRefundCode()));
            }
            if (refundMoney.compareTo(ocContractReDomain.getDataBmoney()) > 0) {
                this.logger.error("DataCyyMeituanServiceImpl\u9000\u6b3e\u603b\u989d\u8d85\u8fc7\u652f\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo() + "\uff0c\u5df2\u9000\u6b3e\u91d1\u989d:" + refundMoney + ", \u672c\u6b21\u9000\u6b3e\u91d1\u989d:" + thirdRefundRequest.getRefundAmount() + ", \u652f\u4ed8\u91d1\u989d\uff1a" + ocContractReDomain.getDataBmoney());
                return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
            }
        }
        ocRefundDomain = new OcRefundDomain();
        BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
        ocRefundDomain.setRefundNcode(thirdRefundRequest.getRefundTradeNo().toString());
        ocRefundDomain.setRefundType("MTB01");
        ocRefundDomain.setRefundUsertype("1");
        ocRefundDomain.setContractState(ocContractReDomain.getDataState());
        ocRefundDomain.setRefundMoney(new BigDecimal(thirdRefundRequest.getRefundAmount()));
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            ocRefundGoodsDomain.setRefundGoodsAmt(new BigDecimal(thirdRefundRequest.getRefundAmount()));
            ocRefundGoodsDomain.setRefundGoodsNum(new BigDecimal(thirdRefundRequest.getRefundAmount()));
            ocRefundGoodsDomain.setGoodsCamount(ocContractGoodsDomain.getGoodsNum());
            ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        this.logger.error("DataCyyMeituanServiceImpl.refund.\u65b0\u589e\u9000\u5355", (Object)JsonUtil.object2Json(ocRefundDomain));
        String refundCode = this.sendSaveRefund(ocRefundDomain);
        if (StringUtils.isBlank((String)refundCode)) {
            return new ThirdRefundRespBody(null);
        }
        Map map = JsonUtil.json2Map(refundCode);
        return new ThirdRefundRespBody((String)map.get("code"));
    }

    public BaseApiResponse<String> payQuery(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.payQuery.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdPayQueryRequest thirdPayQueryRequest = JsonUtil.json2Object(decryptContent, ThirdPayQueryRequest.class);
            if (thirdPayQueryRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, thirdPayQueryRequest:{}", (Object)thirdPayQueryRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.thirdPayRequest:{}", (Object)thirdPayQueryRequest);
            ThirdPayQueryRespBody respBody = this.cyyPayQuery(thirdPayQueryRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdPayQueryRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdPayQueryRespBody cyyPayQuery(ThirdPayQueryRequest request, String tenantCode) {
        OcContractReDomain contractDomain = this.queryContractPage(request.getTradeNo(), tenantCode);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (contractDomain == null) {
            ThirdPayQueryRespBody respBody = new ThirdPayQueryRespBody();
            respBody.setPayTime(dateFormat.format(new Date()));
            respBody.setTradeNo(request.getTradeNo());
            respBody.setPayStatus(PayStatusEnum.FAILED.getCode());
            return respBody;
        }
        ThirdPayQueryRespBody respBody = new ThirdPayQueryRespBody();
        respBody.setThirdPayOrderId(contractDomain.getContractBillcode());
        respBody.setTradeNo(Long.valueOf(contractDomain.getContractNbillcode()));
        respBody.setPayAmount(contractDomain.getDataBmoney().toString());
        if (StringUtils.isBlank((String)contractDomain.getPtradeSeqno())) {
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
            return respBody;
        }
        PtePtrade pteptrade = this.getPteptrade((OcContractDomain)contractDomain);
        if (pteptrade == null) {
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
            return respBody;
        }
        if (pteptrade.getDataState() == 3) {
            respBody.setPayTime(dateFormat.format(pteptrade.getGmtPaid()));
            respBody.setPayStatus(PayStatusEnum.SUCCESS.getCode());
        } else if (pteptrade.getDataState() == 0 || pteptrade.getDataState() == 1) {
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
        } else {
            respBody.setPayTime(dateFormat.format(pteptrade.getGmtModified()));
            respBody.setPayStatus(PayStatusEnum.FAILED.getCode());
        }
        return respBody;
    }

    public String payNotice(OcContractDomain contractDomain) {
        if (contractDomain == null || StringUtils.isBlank((String)contractDomain.getContractUserurl())) {
            return "error";
        }
        ThirdPayCallbackRequest request = new ThirdPayCallbackRequest();
        request.setTradeNo(Long.valueOf(contractDomain.getContractNbillcode()));
        request.setThirdPayOrderId(contractDomain.getContractBillcode());
        request.setPayAmount(String.valueOf(contractDomain.getDataBmoney()));
        request.setPayTime(DateUtil.getStringByDate(new Date(), null));
        request.setMethod("trade.third.pay.callback");
        SqtClient client = new SqtClient("CNJTXQHWOGZN-TK", Key.ENTID_lONG, "'liCCzoSLI4PvUKQN9nFAXA==");
        String responseStr = client.commonPostInvokeOk(contractDomain.getContractUserurl(), request);
        this.logger.error("DataCyyMeituanServiceImpl.payNotice.responseStr", (Object)responseStr);
        return "success";
    }

    private PtePtrade getPteptrade(OcContractDomain contractDomain) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "pte.ptrade.getPtradeByCode";
        param.put("ptradeSeqno", contractDomain.getPtradeSeqno());
        param.put("tenantCode", contractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.getPteptrade.params", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String ptradeStr = this.internalInvoke(apiCode, params);
        this.logger.error("DataCyyMeituanServiceImpl.getPteptrade.ptradeStr", (Object)ptradeStr);
        PtePtrade ptePtrade = (PtePtrade)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(ptradeStr, PtePtrade.class);
        return ptePtrade;
    }

    protected OcContractReDomain queryContractPage(Long sqtBizOrderId, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        String apiCode = "oc.contract.queryContractPageReDomain";
        param.put("contractNbillcode", sqtBizOrderId.toString());
        param.put("tenantCode", tenantCode);
        param.put("childFlag", true);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractReDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractReDomain.class);
        OcContractReDomain ocContractReDomain = null;
        if (ListUtil.isNotEmpty((Collection)contractReDomainList)) {
            ocContractReDomain = (OcContractReDomain)contractReDomainList.get(0);
            this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.ocContractReDomain", (Object)JsonUtil.object2Json(ocContractReDomain));
        }
        return ocContractReDomain;
    }

    protected List<OcRefundDomain> queryRefundPage(Long tradeNo, Long refundTradeNo, String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", tradeNo.toString());
        param.put("contractBillcode", contractBillcode);
        if (null != refundTradeNo) {
            param.put("refundNcode", refundTradeNo.toString());
        }
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryRefundPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    protected UmUserinfoReDomainBean getUserinfo(String userinfoCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "um.user.getUserinfoByCode";
        param.put("userinfoCode", userinfoCode);
        param.put("tenantCode", tenantCode);
        this.logger.error("DataCyyMeituanServiceImpl.getUserinfo.param", param);
        String contractStr = this.internalInvoke(apiCode, param);
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, UmUserinfoReDomainBean.class);
        return umUserinfoReDomainBean;
    }

    protected String sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        String apiCode = "oc.shopping.sendContractByDel";
        param.put("ocContractDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        param.put("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.internalInvoke(apiCode, param);
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.object2Json(ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    public String getSecretKey(String token, String tenantCode) throws Exception {
        String accessKey = "CNJTXQHWOGZN-TK";
        if (!Objects.equals(accessKey, token)) {
            throw new Exception("token\u975e\u6cd5\uff0c\u7f8e\u56e2\u5546\u4f01\u901a\u4f20\u8fc7\u6765\u7684token\u4e0d\u6b63\u786e");
        }
        return "'liCCzoSLI4PvUKQN9nFAXA==";
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getRemotMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }
}

