/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.client;

import com.yqbsoft.laser.service.ext.data.cyy.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.HttpClientUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.BaseApiRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayMockRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqtClient {
    private static final Logger log = LoggerFactory.getLogger(SqtClient.class);
    private static final String VERSION = "1.0";
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String ACCEPT_JSON = "application/json";
    protected String host = "https://inf-openapi.apigw.test.meituan.com/api/sqt/openapi";
    protected String token;
    protected Long entId;
    protected String aesKey;

    public SqtClient(String token, Long entId, String aesKey) {
        this.token = token;
        this.entId = entId;
        this.aesKey = aesKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public String commonPostInvoke(String url, BaseApiRequest request) {
        request.setTs(System.currentTimeMillis() / 1000L);
        request.setEntId(this.entId);
        try {
            String rawContent = JsonUtil.object2Json(request, false);
            System.out.println(rawContent);
            String body = "token=" + this.getToken() + "&version=" + VERSION + "&content=" + EncryptUtil.aesEncrypt(rawContent, this.getAesKey());
            String responseStr = HttpClientUtil.invokePost(url, body, FORM_URLENCODED, ACCEPT_JSON);
            return responseStr;
        }
        catch (Exception e) {
            log.error("HTTP\u8c03\u7528\u5931\u8d25, url:{}", (Object)url, (Object)e);
            return null;
        }
    }

    public String jsonPostInvoke(String url, String body) {
        try {
            return HttpClientUtil.invokePost(url, body, "application/json; charset=utf-8", ACCEPT_JSON);
        }
        catch (Exception e) {
            log.error("HTTP\u8c03\u7528\u5931\u8d25, url:{}", (Object)url, (Object)e);
            return null;
        }
    }

    public String thirdPayMockTest(ThirdPayMockRequest req) {
        req.setMethod("trade.third.standard.mock");
        return this.commonPostInvoke(this.host + "/trade/standardThird/mock/test", req);
    }
}

