/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataCyyMeituanService;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.SqtH5Access;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdPayRespBody;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.response.BaseApiResponse;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataCyyMeituanServiceImpl
extends BaseServiceImpl
implements DataCyyMeituanService {
    private static final String SYS_CODE = "DataCyyMeituanServiceImpl";
    private static final String url = "https://m-sqt.meituan.com/open/commonaccess/access";

    public String getH5AccessUrl(String staffNo, String tenantCode) {
        String entId = this.getDdFalgSetting(tenantCode, "entId", "entId", "");
        String appkey = this.getDdFalgSetting(tenantCode, "appkey", "appkey", "");
        String productType = this.getDdFalgSetting(tenantCode, "productType", "productType", "");
        if (StringUtils.isBlank((String)productType)) {
            productType = "mt_waimai";
        }
        String privateKey = this.getDdFalgSetting(tenantCode, "privateKey", "privateKey", "");
        return SqtH5Access.getH5AccessUrl(url, privateKey, appkey, Integer.valueOf(entId), productType, staffNo);
    }

    public BaseApiResponse saveOrder(String token, String version, String content, String tenantCode) throws Exception {
        this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdPayRequest thirdPayRequest = JsonUtil.json2Object(decryptContent, ThirdPayRequest.class);
            if (thirdPayRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, thirdPayRequest:{}", (Object)thirdPayRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.thirdPayRequest:{}", (Object)thirdPayRequest);
            ThirdPayRespBody respBody = this.saveCyyOrder(thirdPayRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdPayRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdPayRespBody saveCyyOrder(ThirdPayRequest thirdPayRequest, String tenantCode) throws Exception {
        String payUrl = this.getDdFalgSetting(tenantCode, "payUrl", "payUrl", "");
        Map<String, Object> extInfoMap = thirdPayRequest.getExtInfoMap();
        Object entStaffNum = extInfoMap.get("entStaffNum");
        if (null == entStaffNum) {
            throw new Exception("\u7528\u6237\u4e3a\u7a7a");
        }
        UmUserinfoReDomainBean userinfo = this.getUserinfo(String.valueOf(entStaffNum), tenantCode);
        if (null == userinfo) {
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.extInfoMap:{}, \u5904\u7406\u5f02\u5e38", extInfoMap);
            throw new Exception("\u627e\u4e0d\u5230\u7528\u6237");
        }
        String contractBbillcode = this.queryContractPage(thirdPayRequest.getSqtBizOrderId(), tenantCode);
        if (StringUtils.isNotBlank((String)contractBbillcode)) {
            return new ThirdPayRespBody(contractBbillcode, payUrl);
        }
        BigDecimal tradeAmount = new BigDecimal(thirdPayRequest.getTradeAmount());
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setContractNbillcode(String.valueOf(thirdPayRequest.getSqtBizOrderId()));
        ocContractDomain.setContractNbbillcode(String.valueOf(thirdPayRequest.getSqtBizOrderId()));
        ocContractDomain.setContractRemark(thirdPayRequest.getReturnUrl());
        ocContractDomain.setContractUserurl(thirdPayRequest.getNotifyUrl());
        ocContractDomain.setTenantCode(tenantCode);
        ocContractDomain.setAppmanageIcode(userinfo.getAppmanageIcode());
        ocContractDomain.setUserCode(userinfo.getUserCode());
        ocContractDomain.setUserName(userinfo.getUserinfoPhone());
        ocContractDomain.setMemberBcode(userinfo.getUserinfoCode());
        ocContractDomain.setMemberBname(userinfo.getUserinfoCompname());
        ocContractDomain.setMemberCode(userinfo.getUserinfoCode());
        ocContractDomain.setMemberName(userinfo.getUserinfoCompname());
        ocContractDomain.setMemberCcode(userinfo.getUserinfoCode());
        ocContractDomain.setMemberCname(userinfo.getUserinfoCompname());
        ocContractDomain.setContractType("45");
        ocContractDomain.setContractInmoney(tradeAmount);
        ocContractDomain.setContractMoney(tradeAmount);
        ocContractDomain.setDataBmoney(tradeAmount);
        ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setGoodsType("45");
        ocContractGoodsDomain.setPricesetNprice(tradeAmount);
        ocContractGoodsDomain.setPricesetAsprice(tradeAmount);
        ocContractGoodsDomain.setContractGoodsGtype("2");
        ocContractGoodsDomain.setGoodsCode("mtgoods");
        ocContractGoodsDomain.setGoodsName("\u7f8e\u56e2\u5546\u54c1");
        if (StringUtils.isNotBlank((String)thirdPayRequest.getGoodsName())) {
            ocContractGoodsDomain.setGoodsName(thirdPayRequest.getGoodsName());
        }
        ocContractGoodsDomain.setGoodsNum(new BigDecimal(1));
        ocContractGoodsDomain.setTenantCode(userinfo.getTenantCode());
        ocContractGoodsDomain.setMemberCode(userinfo.getUserinfoCode());
        ocContractGoodsDomain.setMemberMname(userinfo.getUserinfoCompname());
        ocContractGoodsDomain.setMemberCcode(userinfo.getUserinfoCode());
        ocContractGoodsDomain.setMemberCname(userinfo.getUserinfoCompname());
        contractGoodsList.add(ocContractGoodsDomain);
        ocPackageDomain.setContractGoodsList(contractGoodsList);
        packageList.add(ocPackageDomain);
        ocContractDomain.setPackageList(packageList);
        contractBbillcode = this.sendContractByDel(ocContractDomain, null);
        if (StringUtils.isBlank((String)contractBbillcode)) {
            throw new Exception("\u65b0\u589e\u8ba2\u5355\u5931\u8d25");
        }
        return new ThirdPayRespBody(contractBbillcode, payUrl);
    }

    protected String queryContractPage(Long sqtBizOrderId, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String apiCode = "oc.contract.queryContractPage";
        param.put("contractNbillcode", sqtBizOrderId);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractDomain.class);
        String contractBbillcode = null;
        if (ListUtil.isNotEmpty((Collection)contractDomainList)) {
            contractBbillcode = ((OcContractDomain)contractDomainList.get(0)).getContractBbillcode();
        }
        return contractBbillcode;
    }

    protected UmUserinfoReDomainBean getUserinfo(String userinfoCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        String apiCode = "um.user.getUserinfoByCode";
        param.put("userinfoCode", userinfoCode);
        param.put("tenantCode", tenantCode);
        this.logger.error("DataCyyMeituanServiceImpl.getUserinfo.param", param);
        String contractStr = this.internalInvoke(apiCode, param);
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, UmUserinfoReDomainBean.class);
        return umUserinfoReDomainBean;
    }

    protected String sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String apiCode = "oc.shopping.sendContractByDel";
        param.put("ocContractDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        param.put("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.internalInvoke(apiCode, param);
    }

    public String getSecretKey(String token, String tenantCode) throws Exception {
        String accessKey = this.getDdFalgSetting(tenantCode, "accessKey", "accessKey", "");
        if (!Objects.equals(accessKey, token)) {
            throw new Exception("token\u975e\u6cd5\uff0c\u7f8e\u56e2\u5546\u4f01\u901a\u4f20\u8fc7\u6765\u7684token\u4e0d\u6b63\u786e");
        }
        return accessKey;
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getRemotMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }
}

