/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.Util;

import com.yqbsoft.laser.service.ext.data.cyy.service.Util.SslUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpClient = null;
    private static CloseableHttpClient httpsClient = null;
    private static HttpConfig httpConfig = null;
    private static SSLConnectionSocketFactory sslsf = null;
    private static final String HTTP_CONF_FILE_NAME = "fenxiao-httpconf.properties";
    private static final int MAX_TOTAL_CONNECTION = 800;
    private static final int MAX_PER_ROUTE = 150;
    private static String UTF_8 = "UTF-8";

    private HttpClientUtil() {
    }

    private static void loadConf() {
        if (httpConfig == null) {
            httpConfig = new HttpConfig();
        }
        Properties properties = new Properties();
        try {
            InputStream inputStream = HttpClientUtil.class.getClassLoader().getResourceAsStream(HTTP_CONF_FILE_NAME);
            if (inputStream == null) {
                LOGGER.warn("httpConfig file={} does not exist", (Object)HTTP_CONF_FILE_NAME);
                return;
            }
            properties.load(inputStream);
            int maxTotalConnection = Integer.parseInt(properties.getProperty("max_total_connection"));
            int maxPerRoute = Integer.parseInt(properties.getProperty("max_per_route"));
            LOGGER.info("max_total_connection={}, max_per_route={}", (Object)maxTotalConnection, (Object)maxPerRoute);
            httpConfig.setMaxTotalConnection(maxTotalConnection);
            httpConfig.setMaxPerRoute(maxPerRoute);
        }
        catch (IOException e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        catch (Exception e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
    }

    private static void initHttps() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.1");
            sslContext.init(null, trustManagers, new SecureRandom());
            sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("\u521d\u59cb\u5316https\u652f\u6301\u5931\u8d25", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("\u521d\u59cb\u5316https\u652f\u6301\u5931\u8d25", (Throwable)e);
        }
    }

    public static String invokePost(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        URIBuilder uriBuilder = new URIBuilder();
        HttpClientUtil.valueForUriBuilder(url, uriBuilder);
        HttpPost httpPost = new HttpPost(uriBuilder.build());
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                pairs.add(new BasicNameValuePair(param.getKey(), param.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, UTF_8));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, Map<String, String> headers, String body) throws Exception {
        URIBuilder uriBuilder = new URIBuilder();
        HttpClientUtil.valueForUriBuilder(url, uriBuilder);
        HttpPost httpPost = new HttpPost(uriBuilder.build());
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (body != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, String body, String contentType, String accept) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", contentType);
        httpPost.setHeader("Accept", accept);
        httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokeGet(String url) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpGet);
    }

    private static String sendRequest(String url, HttpRequestBase request) throws Exception {
        String responseStr;
        CloseableHttpClient client = url.startsWith("https") ? httpsClient : httpClient;
        long st = System.currentTimeMillis();
        int status = 0;
        try {
            SslUtil.ignoreSsl();
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            status = response.getStatusLine().getStatusCode();
            if (entity != null) {
                responseStr = EntityUtils.toString((HttpEntity)entity, (String)UTF_8);
                response.close();
            } else {
                responseStr = "";
            }
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (ClientProtocolException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            request.releaseConnection();
        }
        LOGGER.info("HttpClient Success, status:{}, url:{}, use_time:{} ms", new Object[]{status, request.getURI(), System.currentTimeMillis() - st});
        return responseStr;
    }

    private static RequestConfig buildRequestConfig(Integer connTimeout, Integer readTimeout) {
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (connTimeout != null) {
            customReqConf.setConnectTimeout(connTimeout.intValue());
        }
        if (readTimeout != null) {
            customReqConf.setSocketTimeout(connTimeout.intValue());
        }
        return customReqConf.build();
    }

    private static void valueForUriBuilder(String url, URIBuilder uriBuilder) {
        Integer apartIndex = url.indexOf("?");
        if (apartIndex == -1) {
            uriBuilder.setPath(url);
        } else {
            uriBuilder.setPath(url.substring(0, apartIndex));
            uriBuilder.setCustomQuery(url.substring(apartIndex + 1, url.length()));
        }
    }

    public static void main(String[] args) {
        try {
            String result = HttpClientUtil.invokePost("https://rcyx-platform-test.yoxuan.vip/laserEr/http/post/data.dataCyyApiService.receivedOrder/1.0/2021011200000001/utf-8/shangshu", "a=b", "application/x-www-form-urlencoded", "application/json");
            System.out.println(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        HttpClientUtil.initHttps();
        HttpClientUtil.loadConf();
        httpClientConnectionManager.setMaxTotal(httpConfig.getMaxTotalConnection());
        httpClientConnectionManager.setDefaultMaxPerRoute(httpConfig.getMaxPerRoute());
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        httpsClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        LOGGER.info("HttpClient initialization");
    }

    static class HttpConfig {
        private int maxTotalConnection = 800;
        private int maxPerRoute = 150;

        HttpConfig() {
        }

        public int getMaxTotalConnection() {
            return this.maxTotalConnection;
        }

        public void setMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
        }

        public int getMaxPerRoute() {
            return this.maxPerRoute;
        }

        public void setMaxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
        }
    }

    static interface AcceptType {
        public static final String ACCEPT_JSON = "application/json";
        public static final String ACCEPT_ANNY = "*/*";
    }

    static interface ContentType {
        public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String JSON = "application/json; charset=utf-8";
    }
}

