/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataCyyApiService;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.HttpClientUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.HttpUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.DisChannel;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.RsPntree;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.RsSpec;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.RsSpecGroup;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.SkuData;
import com.yqbsoft.laser.service.ext.data.cyy.service.es.EsSendEnginePollThread;
import com.yqbsoft.laser.service.ext.data.cyy.service.es.EsSendEnginePutThread;
import com.yqbsoft.laser.service.ext.data.cyy.service.es.EsSendEngineService;
import com.yqbsoft.laser.service.ext.data.cyy.service.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.data.cyy.service.goods.service.EsGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractproDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.data.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.data.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.data.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.data.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.ext.data.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class DataCyyApiServiceImpl
extends BaseServiceImpl
implements DataCyyApiService {
    private static final String SYS_CODE = "DataCyyApiServiceImpl";
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    private static final String RESOURCEGOODS_GET_CODE = "rs.resourceGoods.getResourceGoodsByCode";
    private static final String RESOURCEGOODS_GET_CODE_STR = "rs.resourceGoods.getResourceGoodsByCodeStr";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveGoods";
    private static final String RESOURCEGOODS_AUDIT_CODE = "rs.resource.sendUpdateAuditResource";
    private static final String RESOURCEGOODS_CANCEL_AUDIT_CODE = "rs.resource.sendUpdateCanlAuditResource";
    private static final String RESOURCEGOODS_UPDATE_CODE = "rs.resource.sendUpdateResourceGoods";
    private static EsSendEngineService esSendEngineService;
    private static final Object eslock;

    DataCyyApiServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsSendEngineService getEsSendEngineService() {
        Object object = eslock;
        synchronized (object) {
            if (null == esSendEngineService) {
                esSendEngineService = new EsSendEngineService((EsGoodsService)SpringApplicationContextUtil.getBean((String)"esGoodsService"));
                for (int i = 0; i < 50; ++i) {
                    esSendEngineService.addPollPool(new EsSendEnginePollThread(esSendEngineService));
                }
            }
            return esSendEngineService;
        }
    }

    public String saveGoodsList(String appId, String content, String tenantCode) {
        if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)content)) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.param is null", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", appId);
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.verify appId", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        DisChannel disChannel = this.getChannelSup(appId, tenantCode);
        if (null == disChannel) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.disChannel is null", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u6e20\u9053\u4e3a\u7a7a");
        }
        List skuDataList = (List)JsonUtil.buildNormalBinder().getJsonToList(content, SkuData.class);
        if (ListUtil.isEmpty((Collection)skuDataList)) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.skuDataList", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
        }
        if (skuDataList.size() > 200) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.skuDataList.size", (Object)skuDataList.size());
            return this.makeResult(false, "\u4e00\u6b21\u53ea\u80fd\u63a5\u6536200\u6761\u5546\u54c1\u6570\u636e");
        }
        String pntreeCode = DataCyyApiServiceImpl.getPntreeCode(tenantCode);
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.pntreeCode is null", (Object)tenantCode);
            return this.makeResult(false, "\u670d\u52a1\u5668\u9519\u8bef");
        }
        for (SkuData skuData : skuDataList) {
            if (ListUtil.isEmpty(skuData.getGoodsFileList())) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.getGoodsFileList is null", (Object)skuData.getGoodsNo());
                return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
            }
            if (StringUtils.isBlank((String)skuData.getGoodsType())) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.getGoodsType is null", (Object)skuData.getGoodsNo());
                return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
            }
            if (StringUtils.isBlank((String)skuData.getGoodsNo())) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.getGoodsNo is null", (Object)skuData.getGoodsNo());
                return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
            }
            if (skuData.getGoodsNum() == null) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.getGoodsNum is null", (Object)skuData.getGoodsNo());
                return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
            }
            if (StringUtils.isBlank((String)skuData.getFreightTemCode())) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.getFreightTemCode is null", (Object)skuData.getGoodsNo());
                return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
            }
            skuData.setTenantCode(tenantCode);
            skuData.setDisChannel(disChannel);
            skuData.setPntreeCode(pntreeCode);
            skuData.setPntreeName("\u4e09\u65b9\u9ed8\u8ba4");
        }
        DataCyyApiServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(DataCyyApiServiceImpl.getEsSendEngineService(), skuDataList));
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String sendContract(OcContractReDomain ocContractDomain) {
        String responseBody;
        String memberCcode;
        if (ocContractDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendContract.ocContractDomain is null");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode = ocContractDomain.getMemberCcode());
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.sendContract.secretkey is null", (Object)memberCcode);
            return "error";
        }
        String saveOrderUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "saveOrderUrl", memberCcode);
        if (StringUtils.isBlank((String)saveOrderUrl)) {
            this.logger.error("DataCyyApiServiceImpl.sendContract.saveOrderUrl is null", (Object)memberCcode);
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", ocContractDomain.getContractBillcode());
        param.put("dataState", ocContractDomain.getDataState());
        param.put("dataBmoney", ocContractDomain.getDataBmoney());
        param.put("goodsReceiptMem", ocContractDomain.getGoodsReceiptMem());
        param.put("goodsReceiptPhone", ocContractDomain.getGoodsReceiptPhone());
        param.put("goodsReceiptArrdess", ocContractDomain.getGoodsReceiptArrdess());
        ArrayList goodsList = new ArrayList();
        param.put("goodsList", goodsList);
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
            goodsMap.put("goodsNo", ocContractGoodsDomain.getGoodsNo());
            goodsMap.put("goodsName", ocContractGoodsDomain.getGoodsName());
            goodsMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
            goodsMap.put("skuName", ocContractGoodsDomain.getSkuName());
            goodsMap.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
            goodsMap.put("pricesetNprice", ocContractGoodsDomain.getPricesetNprice());
            goodsList.add(goodsMap);
        }
        if (ListUtil.isNotEmpty((Collection)ocContractDomain.getOcContractproDomainList())) {
            HashMap<String, String> extInfoMap = new HashMap<String, String>();
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                if (!ocContractproDomain.getContractproKey().contains("extInfo")) continue;
                String contractproKey = ocContractproDomain.getContractproKey();
                contractproKey = contractproKey.substring(contractproKey.indexOf("extInfo_") + 8);
                extInfoMap.put(contractproKey, ocContractproDomain.getContractproValue());
            }
            if (MapUtil.isNotEmpty(extInfoMap)) {
                param.put("extInfoMap", extInfoMap);
            }
        }
        if (StringUtils.isBlank((String)(responseBody = this.apimRequestReJson(saveOrderUrl, param, secretkey, memberCcode)))) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main(String[] args) {
        String tlsVersion;
        SSLSession session;
        SSLSocket sslSocket;
        Socket socket;
        URL url;
        try {
            url = new URL("https://example.com");
            socket = SSLSocketFactory.getDefault().createSocket(url.getHost(), 443);
            sslSocket = (SSLSocket)socket;
            sslSocket.startHandshake();
            session = sslSocket.getSession();
            tlsVersion = session.getProtocol();
            System.out.println("TLS\u7248\u672c: " + tlsVersion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            url = new URL("https://v3.api.fufentong.com");
            socket = SSLSocketFactory.getDefault().createSocket(url.getHost(), 443);
            sslSocket = (SSLSocket)socket;
            sslSocket.startHandshake();
            session = sslSocket.getSession();
            tlsVersion = session.getProtocol();
            System.out.println("\u63a5\u53e3\u63d0\u4f9b\u65b9\u7684TLS\u7248\u672c: " + tlsVersion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String sendOrderStatus(OcContractReDomain ocContractDomain) {
        String memberCcode;
        if (ocContractDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendContract.ocContractDomain is null");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode = ocContractDomain.getMemberCcode());
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.sendOrderStatus.secretkey is null", (Object)memberCcode);
            return "error";
        }
        String orderStatusUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "orderStatusUrl", memberCcode);
        if (StringUtils.isBlank((String)orderStatusUrl)) {
            this.logger.error("DataCyyApiServiceImpl.sendOrderStatus.orderStatusUrl is null", (Object)memberCcode);
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", ocContractDomain.getContractBillcode());
        param.put("dataState", ocContractDomain.getDataState());
        String responseBody = this.apimRequestReJson(orderStatusUrl, param, secretkey, memberCcode);
        if (StringUtils.isBlank((String)responseBody)) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    public String receivedOrderStatus(String appId, String content, String tenantCode) {
        Map jsonToMap;
        if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)content)) {
            this.logger.error("DataCyyApiServiceImpl.receivedOrderStatus.null", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("DataCyyApiServiceImpl.receivedOrderStatus.appId", (Object)appId);
        this.logger.info("DataCyyApiServiceImpl.receivedOrderStatus.content", (Object)content);
        String data = this.verify(appId, content, tenantCode);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("DataCyyApiServiceImpl.receivedOrderStatus.verify error", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        this.logger.info("DataCyyApiServiceImpl.receivedOrderStatus.param", (Object)data);
        try {
            jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receivedOrderStatus.json.error.e", (Throwable)e);
            return this.makeResult(false, "\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        Integer dataState = (Integer)jsonToMap.get("dataState");
        String contractBillcode = jsonToMap.get("contractBillcode").toString();
        OcContractReDomain contractReDomain = this.getContractByCode(contractBillcode, tenantCode);
        String contractType = contractReDomain.getContractType();
        if ("24".equals(contractType) || "26".equals(contractType)) {
            contractType = contractReDomain.getContractTypepro();
        }
        try {
            String handleCard;
            if ("60".equals(contractType)) {
                String handleGoods = this.handleGoods(dataState, contractReDomain, jsonToMap);
                if (StringUtils.isNotBlank((String)handleGoods)) {
                    return handleGoods;
                }
            } else if ("61".equals(contractType)) {
                String handleRecharged = this.handleRecharged(dataState, contractReDomain);
                if (StringUtils.isNotBlank((String)handleRecharged)) {
                    return handleRecharged;
                }
            } else if ("62".equals(contractType) && StringUtils.isNotBlank((String)(handleCard = this.handleCard(dataState, contractReDomain, jsonToMap)))) {
                return handleCard;
            }
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receivedOrderStatus.Exception", (Throwable)e);
            return this.makeResult(false, "\u7cfb\u7edf\u9519\u8bef");
        }
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String sendRefund(OcRefundReDomain ocRefundDomain) {
        String memberCcode;
        if (ocRefundDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendRefund null");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode = ocRefundDomain.getMemberCcode());
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.sendRefund.secretkey is null", (Object)memberCcode);
            return "error";
        }
        String refundApplyUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "refundApplyUrl", memberCcode);
        if (StringUtils.isBlank((String)refundApplyUrl)) {
            this.logger.error("DataCyyApiServiceImpl.sendRefund.refundApplyUrl is null", (Object)memberCcode);
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", ocRefundDomain.getContractBillcode());
        param.put("refundCode", ocRefundDomain.getRefundCode());
        param.put("refundMoney", ocRefundDomain.getRefundMoney());
        if ("SWB01".equals(ocRefundDomain.getRefundType())) {
            param.put("refundType", "SW001");
        } else {
            param.put("refundType", "SW002");
        }
        ArrayList ocRefundGoodsDomainList = new ArrayList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
            goodsMap.put("goodsNo", ocRefundGoodsDomain.getGoodsNo());
            goodsMap.put("goodsName", ocRefundGoodsDomain.getGoodsName());
            goodsMap.put("skuNo", ocRefundGoodsDomain.getSkuNo());
            goodsMap.put("skuName", ocRefundGoodsDomain.getSkuName());
            goodsMap.put("refundGoodsNum", ocRefundGoodsDomain.getRefundGoodsNum());
            ocRefundGoodsDomainList.add(goodsMap);
        }
        param.put("ocRefundGoodsDomainList", ocRefundGoodsDomainList);
        String responseBody = this.apimRequestReJson(refundApplyUrl, param, secretkey, memberCcode);
        if (StringUtils.isBlank((String)responseBody)) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    public String sendRefundStatus(OcRefundReDomain ocRefundDomain) {
        String memberCcode;
        if (ocRefundDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundStatus null");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode = ocRefundDomain.getMemberCcode());
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundStatus.secretkey is null", (Object)memberCcode);
            return "error";
        }
        String refundStatusUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "refundStatusUrl", memberCcode);
        if (StringUtils.isBlank((String)refundStatusUrl)) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundStatus.refundStatusUrl is null", (Object)memberCcode);
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", ocRefundDomain.getContractBillcode());
        param.put("refundCode", ocRefundDomain.getRefundCode());
        param.put("packageBillno", ocRefundDomain.getPackageBillno());
        param.put("packageName", ocRefundDomain.getPackageName());
        param.put("packageCode", ocRefundDomain.getPackageCode());
        String responseBody = this.apimRequestReJson(refundStatusUrl, param, secretkey, memberCcode);
        if (StringUtils.isBlank((String)responseBody)) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    public String receivedRefundStatus(String appId, String content, String tenantCode) {
        Map jsonToMap;
        if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)content)) {
            this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.null", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("DataCyyApiServiceImpl.receivedRefundStatus.appId", (Object)appId);
        this.logger.info("DataCyyApiServiceImpl.receivedRefundStatus.content", (Object)content);
        String data = this.verify(appId, content, tenantCode);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.verify error", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        this.logger.info("DataCyyApiServiceImpl.receivedRefundStatus.param", (Object)data);
        try {
            jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.json.error.e", (Throwable)e);
            return this.makeResult(false, "\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        Integer dataState = (Integer)jsonToMap.get("dataState");
        String refundCode = jsonToMap.get("refundCode").toString();
        OcRefundReDomain refundByCode = this.getRefundByCode(refundCode, tenantCode);
        if (refundByCode == null) {
            return this.makeResult(false, "\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        }
        OcContractReDomain contractByCode = this.getContractByCode(refundByCode.getContractBillcode(), tenantCode);
        if (contractByCode == null) {
            return this.makeResult(false, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (contractByCode.getDataState() == -1) {
            return this.makeResult(false, "\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        switch (dataState) {
            case 1: {
                if (refundByCode.getDataState() != 0) {
                    this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.getDataState.1", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                if ("SWB02".equals(refundByCode.getRefundType())) {
                    if (jsonToMap.get("goodsReceiptMem") == null || jsonToMap.get("goodsReceiptPhone") == null || jsonToMap.get("goodsReceiptArrdess") == null) {
                        this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.getDataState.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
                        return this.makeResult(false, "\u7f3a\u5c11\u5730\u5740\u4fe1\u606f");
                    }
                    refundByCode.setGoodsReceiptMem(jsonToMap.get("goodsReceiptMem").toString());
                    refundByCode.setGoodsReceiptPhone(jsonToMap.get("goodsReceiptPhone").toString());
                    refundByCode.setGoodsReceiptArrdess(jsonToMap.get("goodsReceiptArrdess").toString());
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)refundByCode));
                    String string = this.inInvokeApi("oc.refund.updateRefund", param);
                }
                this.sendRefundNext(refundCode, tenantCode, jsonToMap);
                break;
            }
            case -2: {
                if (refundByCode.getDataState() != 0) {
                    this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.getDataState.2", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                this.sendRefundBack(refundCode, tenantCode, jsonToMap);
                break;
            }
            case 8: {
                if (refundByCode.getDataState() != 2) {
                    this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.getDataState.3", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                this.sendRefundNext(refundCode, tenantCode, jsonToMap);
                break;
            }
            case 6: {
                if (refundByCode.getDataState() != 2) {
                    this.logger.error("DataCyyApiServiceImpl.receivedRefundStatus.getDataState.4", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                this.sendRefundBack(refundCode, tenantCode, jsonToMap);
                break;
            }
            default: {
                return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
            }
        }
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String sendRefundDeliveryInfo(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundDeliveryInfo null");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String memberCcode = ocRefundDomain.getMemberCcode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode);
        String refundPackageUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "refundPackageUrl", memberCcode);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", ocRefundDomain.getContractBillcode());
        param.put("refundCode", ocRefundDomain.getRefundCode());
        param.put("packageBillno", ocRefundDomain.getPackageBillno());
        param.put("packageName", ocRefundDomain.getPackageName());
        param.put("packageCode", ocRefundDomain.getPackageCode());
        String responseBody = this.apimRequestReJson(refundPackageUrl, param, secretkey, memberCcode);
        if (StringUtils.isBlank((String)responseBody)) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    public String handleGoods(Integer dataState, OcContractReDomain contractReDomain, Map<String, Object> jsonToMap) {
        String tenantCode = contractReDomain.getTenantCode();
        String contractBillcode = contractReDomain.getContractBillcode();
        if (dataState == 3) {
            if (contractReDomain.getDataState() != 2) {
                this.logger.error("DataCyyApiServiceImpl.handleGoods.60.3.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            if (jsonToMap.get("deliveryInfoList") == null) {
                this.logger.error("DataCyyApiServiceImpl.handleGoods.60.3.deliveryInfoList is null", jsonToMap.get("deliveryInfoList"));
                return this.makeResult(false, "\u5feb\u9012\u4fe1\u606f\u4e3a\u7a7a");
            }
            List dataMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(jsonToMap.get("deliveryInfoList")), Map.class);
            if (ListUtil.isEmpty((Collection)dataMapList)) {
                this.logger.error("DataCyyApiServiceImpl.handleGoods.60.3.deliveryInfoList error", jsonToMap.get("deliveryInfoList"));
                return this.makeResult(false, "\u5feb\u9012\u4fe1\u606f\u89e3\u6790\u9519\u8bef");
            }
            for (Map map : dataMapList) {
                SgSendgoodsReDomain sgSendgoodsReDomain = new SgSendgoodsReDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsReDomain, (Object)contractReDomain);
                }
                catch (Exception e) {
                    this.logger.error("DataCyyApiServiceImpl.handleGoods.60.3.sgSendgoodsReDomain e", (Throwable)e);
                    return this.makeResult(false, "\u7cfb\u7edf\u9519\u8bef");
                }
                sgSendgoodsReDomain.setPackageBillno((String)map.get("courierNumber"));
                sgSendgoodsReDomain.setPackageMode((String)map.get("courierCompanyCode"));
                sgSendgoodsReDomain.setPackageName((String)map.get("courierCompany"));
                HashMap<String, Object> sgParam = new HashMap<String, Object>();
                sgParam.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
                String string = this.inInvokeApi("sg.sendgoods.saveSendgoods", sgParam);
            }
            for (OcContractGoodsDomain ocContractGoodsDomain : contractReDomain.getGoodsList()) {
                ocContractGoodsDomain.setContractGoodsSendnum(ocContractGoodsDomain.getGoodsCamount());
                HashMap<String, Object> sgParam = new HashMap<String, Object>();
                sgParam.put("ocContractGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain));
                String string = this.inInvokeApi("oc.contract.updateContractGoods", sgParam);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sendGoods", true);
            this.sendContractNext(contractBillcode, tenantCode, map);
        } else if (dataState == 4) {
            if (contractReDomain.getDataState() != 3) {
                this.logger.error("DataCyyApiServiceImpl.handleGoods.getDataState.4", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exchange", true);
            this.sendContractNext(contractBillcode, tenantCode, map);
        } else if (dataState == -1) {
            if (contractReDomain.getDataState() != 2) {
                this.logger.error("DataCyyApiServiceImpl.handleRecharged.61.-1.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            this.applyRefund(contractReDomain);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("createOrderError", true);
            this.sendContractBack(contractBillcode, tenantCode, map);
        } else {
            this.logger.error("DataCyyApiServiceImpl.handleGoods.60.dataState error", (Object)dataState);
            return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
        }
        return null;
    }

    public String handleRecharged(Integer dataState, OcContractReDomain contractReDomain) {
        String tenantCode = contractReDomain.getTenantCode();
        String contractBillcode = contractReDomain.getContractBillcode();
        if (dataState == 5) {
            if (contractReDomain.getDataState() != 2) {
                this.logger.error("DataCyyApiServiceImpl.handleRecharged.61.5.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RechargedSuccess", true);
            this.sendContractNext(contractBillcode, tenantCode, map);
        } else if (dataState == -1) {
            if (contractReDomain.getDataState() != 2) {
                this.logger.error("DataCyyApiServiceImpl.handleRecharged.61.-1.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            this.applyRefund(contractReDomain);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("RechargedFail", true);
            this.sendContractBack(contractBillcode, tenantCode, map);
        } else {
            this.logger.error("DataCyyApiServiceImpl.handleRecharged.61.dataState error", (Object)dataState);
            return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
        }
        return null;
    }

    private void applyRefund(OcContractReDomain contractReDomain) {
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)contractReDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ocRefundDomain.setRefundType("XUB01");
        ocRefundDomain.setRefundUsertype("1");
        ocRefundDomain.setContractState(contractReDomain.getDataState());
        ocRefundDomain.setRefundMoney(contractReDomain.getDataBmoney());
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : contractReDomain.getGoodsList()) {
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocRefundDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsCamount());
            ocRefundGoodsDomain.setRefundGoodsAmt(ocContractGoodsDomain.getPricesetNprice());
            ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        this.logger.error("DataCyyApiServiceImpl.refund.\u65b0\u589e\u9000\u5355", (Object)contractReDomain.getContractBillcode());
        String refundCode = this.sendSaveRefund(ocRefundDomain);
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("DataCyyApiServiceImpl.refund.\u65b0\u589e\u9000\u5355\u5931\u8d25", (Object)contractReDomain.getContractBillcode());
            return;
        }
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    public String handleCard(Integer dataState, OcContractReDomain contractReDomain, Map<String, Object> jsonToMap) {
        String tenantCode = contractReDomain.getTenantCode();
        String contractBillcode = contractReDomain.getContractBillcode();
        if (dataState == 3) {
            if (contractReDomain.getDataState() != 2) {
                this.logger.error("DataCyyApiServiceImpl.handleCard.62.3.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            SgSendgoodsReDomain sgSendgoodsReDomain = new SgSendgoodsReDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsReDomain, (Object)contractReDomain);
            }
            catch (Exception e) {
                this.logger.error("DataCyyApiServiceImpl.handleCard.62.3.sgSendgoodsReDomain e", (Throwable)e);
                return this.makeResult(false, "\u7cfb\u7edf\u9519\u8bef");
            }
            sgSendgoodsReDomain.setPackageBillno((String)jsonToMap.get("QRcodeUrl"));
            sgSendgoodsReDomain.setPackageMode((String)jsonToMap.get("cardPass"));
            sgSendgoodsReDomain.setPackageName((String)jsonToMap.get("cardNumber"));
            if (jsonToMap.get("termOfValidity") != null) {
                String termOfValidity = jsonToMap.get("termOfValidity").toString();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date parse = format.parse(termOfValidity);
                    sgSendgoodsReDomain.setGmtVaild(parse);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Object> sgParam = new HashMap<String, Object>();
            sgParam.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
            String s = this.inInvokeApi("sg.sendgoods.saveSendgoods", sgParam);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sendGoods", true);
            this.sendContractNext(contractBillcode, tenantCode, map);
        } else if (dataState == 5) {
            if (contractReDomain.getDataState() != 3) {
                this.logger.error("DataCyyApiServiceImpl.handleCard.62.5.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exchange", true);
            this.sendContractNext(contractBillcode, tenantCode, map);
        } else if (dataState == -1) {
            if (contractReDomain.getDataState() != 2) {
                this.logger.error("DataCyyApiServiceImpl.handleRecharged.61.-1.dataState", (Object)contractReDomain.getDataState());
                return this.makeResult(false, "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            }
            this.applyRefund(contractReDomain);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("createOrderError", true);
            this.sendContractBack(contractBillcode, tenantCode, map);
        } else {
            this.logger.error("DataCyyApiServiceImpl.handleCard.62.3.dataState error", (Object)dataState);
            return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
        }
        return null;
    }

    public String receivedOrder(String appId, String content, String tenantCode) {
        String decryptContent;
        this.logger.info("DataCyyApiServiceImpl.receivedOrder.appId", (Object)appId);
        this.logger.info("DataCyyApiServiceImpl.receivedOrder.content", (Object)content);
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", appId);
        this.logger.info("DataCyyApiServiceImpl.receivedOrder.secretkey", (Object)secretkey);
        try {
            decryptContent = EncryptUtil.aesDecrypt(content, secretkey);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receivedOrder.e", (Throwable)e);
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        this.logger.error("DataCyyApiServiceImpl.receivedOrder.decryptContent", (Object)decryptContent);
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String sendGoodsAuditNotice(RsResourceGoodsDomain rsResourceGoodsDomain) {
        String memberCcode;
        if (rsResourceGoodsDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendGoodsAuditNotice.ocContractDomain is null");
            return "error";
        }
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode = rsResourceGoodsDomain.getMemberCcode());
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.sendGoodsAuditNotice.secretkey is null", (Object)memberCcode);
            return "error";
        }
        String sendGoodsAuditUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "sendGoodsAuditUrl", memberCcode);
        if (StringUtils.isBlank((String)sendGoodsAuditUrl)) {
            this.logger.error("DataCyyApiServiceImpl.sendGoodsAuditNotice.sendGoodsAuditUrl is null", (Object)memberCcode);
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("goodsNo", rsResourceGoodsDomain.getGoodsNo());
        param.put("dataState", rsResourceGoodsDomain.getDataOpbillstate());
        String responseBody = this.apimRequestReJson(sendGoodsAuditUrl, param, secretkey, memberCcode);
        if (StringUtils.isBlank((String)responseBody)) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    public String receiveGoodsState(String appId, String content, String tenantCode) {
        RsResourceGoodsReDomain resourceGoods;
        Map jsonToMap;
        if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)content)) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsState.null", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("DataCyyApiServiceImpl.receiveGoodsState.appId", (Object)appId);
        this.logger.info("DataCyyApiServiceImpl.receiveGoodsState.content", (Object)content);
        String data = this.verify(appId, content, tenantCode);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsState.verify error", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        this.logger.info("DataCyyApiServiceImpl.receiveGoodsState.param", (Object)data);
        try {
            jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsState.json.error.e", (Throwable)e);
            return this.makeResult(false, "\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        String goodsNo = (String)jsonToMap.get("goodsNo");
        Integer dataState = (Integer)jsonToMap.get("dataState");
        if (StringUtils.isBlank((String)goodsNo) || dataState == null) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsState.param error", (Object)(appId + "-" + tenantCode + "-" + data));
            return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
        }
        RsSkuDomain rsSkuDomain = this.getSkuBySkuNo(goodsNo, appId, tenantCode);
        if (rsSkuDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsState.rsSkuDomain is null", (Object)(appId + "-" + tenantCode + "-" + data));
            return this.makeResult(false, "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (dataState == 1 && rsSkuDomain.getDataState() == 0 && rsSkuDomain.getDataOpbillstate() == 0) {
            RsResourceGoodsReDomain resourceGoods2 = this.getResourceGoodsByCodeStr(rsSkuDomain.getGoodsCode(), tenantCode);
            if (resourceGoods2 != null) {
                this.handleUpAndDown(resourceGoods2, 1);
            }
        } else if (dataState == 0 && rsSkuDomain.getDataOpbillstate() == 1) {
            RsResourceGoodsReDomain resourceGoods3 = this.getResourceGoodsByCodeStr(rsSkuDomain.getGoodsCode(), tenantCode);
            if (resourceGoods3 != null) {
                this.handleUpAndDown(resourceGoods3, 0);
            }
        } else if (dataState == 0 && rsSkuDomain.getDataOpbillstate() == 0 && rsSkuDomain.getDataState() == 1 && (resourceGoods = this.getResourceGoodsByCodeStr(rsSkuDomain.getGoodsCode(), tenantCode)) != null) {
            this.handleUpAndDown(resourceGoods, -1);
        }
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String receiveGoodsInfo(String appId, String content, String tenantCode) {
        String freightTemCode;
        String goodsRemark;
        String skuName;
        String pricesetAsprice;
        String pricesetMakeprice;
        String pricesetNprice;
        String dataPic;
        Integer goodsNum;
        String goodsProperty2;
        String goodsProperty1;
        String goodsProperty5;
        Integer goodsMinnum;
        Integer goodsOneweight;
        String goodsProperty;
        String goodsName;
        String brandName;
        String classtreeNameEnd;
        Map jsonToMap;
        if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)content)) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.null", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("DataCyyApiServiceImpl.receiveGoodsInfo.appId", (Object)appId);
        this.logger.info("DataCyyApiServiceImpl.receiveGoodsInfo.content", (Object)content);
        String data = this.verify(appId, content, tenantCode);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.verify error", (Object)(appId + "-" + tenantCode + "-" + content));
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        this.logger.info("DataCyyApiServiceImpl.receiveGoodsInfo.param", (Object)data);
        try {
            jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.json.error.e", (Throwable)e);
            return this.makeResult(false, "\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        String goodsNo = (String)jsonToMap.get("goodsNo");
        RsSkuDomain rsSkuDomain = this.getSkuBySkuNo(goodsNo, appId, tenantCode);
        if (rsSkuDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.rsSkuDomain is null", (Object)(appId + "-" + tenantCode + "-" + data));
            return this.makeResult(false, "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        RsResourceGoodsReDomain rsResourceGoodsDomain = this.getResourceGoodsByCode(rsSkuDomain.getGoodsCode(), tenantCode);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.resourceGoods is null", (Object)(appId + "-" + tenantCode + "-" + data));
            return this.makeResult(false, "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        DisChannel disChannel = this.getChannelSup(appId, tenantCode);
        if (null == disChannel) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.disChannel is null", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u6e20\u9053\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setTenantCode(tenantCode);
        String classtreeName = (String)jsonToMap.get("classtreeName");
        String classtreeCode = (String)jsonToMap.get("classtreeCode");
        if (StringUtils.isNotBlank((String)classtreeName) && StringUtils.isNotBlank((String)classtreeCode) && !(classtreeNameEnd = classtreeName.substring(classtreeName.lastIndexOf(",") + 1)).equals(rsResourceGoodsDomain.getClasstreeName())) {
            String pntreeCode = DataCyyApiServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.pntreeCode is null", (Object)tenantCode);
                return this.makeResult(false, "\u670d\u52a1\u5668\u9519\u8bef");
            }
            String classTreeCode = EsGoodsServiceImpl.checkClasstreeMap(classtreeName, classtreeCode, disChannel, pntreeCode);
            if (StringUtils.isBlank((String)classTreeCode)) {
                this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.classtreeName is null", (Object)classtreeName);
                return this.makeResult(false, "\u5206\u7c7b\u4fe1\u606f\u5f02\u5e38");
            }
            rsResourceGoodsDomain.setClasstreeName(classtreeNameEnd);
            rsResourceGoodsDomain.setClasstreeCode(classTreeCode);
            rsResourceGoodsDomain.setClasstreeFullName(classtreeName);
        }
        if (StringUtils.isNotBlank((String)(brandName = (String)jsonToMap.get("brandName"))) && !brandName.equals(rsSkuDomain.getBrandName())) {
            String brandCode = EsGoodsServiceImpl.checkBrandMap(brandName, tenantCode);
            rsResourceGoodsDomain.setBrandName(brandName);
            rsResourceGoodsDomain.setBrandCode(brandCode);
        }
        if (StringUtils.isNotBlank((String)(goodsName = (String)jsonToMap.get("goodsName")))) {
            rsResourceGoodsDomain.setGoodsName(goodsName);
            rsResourceGoodsDomain.setGoodsShowname(goodsName);
        }
        if (StringUtils.isNotBlank((String)(goodsProperty = (String)jsonToMap.get("goodsProperty")))) {
            rsResourceGoodsDomain.setGoodsProperty(goodsProperty);
        }
        if ((goodsOneweight = (Integer)jsonToMap.get("goodsOneweight")) != null) {
            rsResourceGoodsDomain.setGoodsOneweight(new BigDecimal(goodsOneweight.toString()));
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setGoodsOneweight(new BigDecimal(goodsOneweight.toString()));
            }
        }
        if ((goodsMinnum = (Integer)jsonToMap.get("goodsMinnum")) != null) {
            rsResourceGoodsDomain.setGoodsMinnum(new BigDecimal(goodsMinnum.toString()));
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setGoodsMinnum(new BigDecimal(goodsMinnum.toString()));
            }
        }
        if (StringUtils.isNotBlank((String)(goodsProperty5 = (String)jsonToMap.get("goodsProperty5")))) {
            rsResourceGoodsDomain.setGoodsProperty5(goodsProperty5);
        }
        if (StringUtils.isNotBlank((String)(goodsProperty1 = (String)jsonToMap.get("goodsProperty1")))) {
            rsResourceGoodsDomain.setGoodsProperty1(goodsProperty1);
        }
        if (StringUtils.isNotBlank((String)(goodsProperty2 = (String)jsonToMap.get("goodsProperty2")))) {
            rsResourceGoodsDomain.setGoodsProperty2(goodsProperty2);
        }
        if ((goodsNum = (Integer)jsonToMap.get("goodsNum")) != null) {
            BigDecimal bigDecimal = new BigDecimal(goodsNum.toString());
            rsResourceGoodsDomain.setGoodsNum(bigDecimal);
            rsResourceGoodsDomain.setGoodsSupplynum(bigDecimal);
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setGoodsNum(bigDecimal);
                skuDomain.setGoodsSupplynum(bigDecimal);
            }
        }
        if (StringUtils.isNotBlank((String)(dataPic = (String)jsonToMap.get("dataPic")))) {
            rsResourceGoodsDomain.setDataPic(dataPic);
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setDataPic(dataPic);
            }
        }
        if ((pricesetNprice = (String)jsonToMap.get("pricesetNprice")) != null) {
            rsResourceGoodsDomain.setPricesetNprice(new BigDecimal(pricesetNprice));
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setPricesetNprice(new BigDecimal(pricesetNprice));
            }
        }
        if ((pricesetMakeprice = (String)jsonToMap.get("pricesetMakeprice")) != null) {
            rsResourceGoodsDomain.setPricesetMakeprice(new BigDecimal(pricesetMakeprice));
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setPricesetMakeprice(new BigDecimal(pricesetMakeprice));
            }
        }
        if ((pricesetAsprice = (String)jsonToMap.get("pricesetAsprice")) != null) {
            rsResourceGoodsDomain.setPricesetAsprice(new BigDecimal(pricesetAsprice));
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setPricesetAsprice(new BigDecimal(pricesetAsprice));
            }
        }
        if (StringUtils.isNotBlank((String)(skuName = (String)jsonToMap.get("skuName"))) && !skuName.equals(rsSkuDomain.getSkuName())) {
            rsSkuDomain.setSkuName(skuName);
            List<RsSpecValueDomain> rsSpecValueDomainList = this.makeSpec(rsSkuDomain);
            rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setSkuName(skuName);
            }
        }
        if (StringUtils.isNotBlank((String)(goodsRemark = (String)jsonToMap.get("goodsRemark")))) {
            rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        }
        if (StringUtils.isNotBlank((String)(freightTemCode = (String)jsonToMap.get("freightTemCode")))) {
            rsResourceGoodsDomain.setFreightTemCode(freightTemCode);
        }
        if (jsonToMap.get("goodsFileList") != null) {
            List goodsFileList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(jsonToMap.get("goodsFileList")), String.class);
            List<RsGoodsFileDomain> goodsFile = EsGoodsServiceImpl.getGoodsFile(goodsFileList, tenantCode);
            rsResourceGoodsDomain.setRsGoodsFileDomainList(goodsFile);
            for (RsSkuDomain skuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                skuDomain.setRsGoodsFileDomainList(goodsFile);
            }
        }
        if (rsResourceGoodsDomain.getDataOpbillstate() == 1) {
            this.handleUpAndDown(rsResourceGoodsDomain, 0);
        }
        HashMap<String, String> goodsparamMap = new HashMap<String, String>();
        String toJson = JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain);
        goodsparamMap.put("rsResourceGoodsDomain", toJson);
        String resultGoods = null;
        this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.inInvoke.rsResourceGoodsDomain", (Object)toJson);
        try {
            resultGoods = (String)this.getInternalRouter().inInvoke(RESOURCEGOODS_UPDATE_CODE, goodsparamMap);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.receiveGoodsInfo.inInvoke.e", (Object)resultGoods, (Throwable)e);
            return this.makeResult(false, "\u7cfb\u7edf\u9519\u8bef");
        }
        if (rsResourceGoodsDomain.getDataOpbillstate() == 1 || rsResourceGoodsDomain.getDataState() == 0) {
            this.handleUpAndDown(rsResourceGoodsDomain, 1);
        }
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String sendRefundCancelNotice(OcRefundReDomain ocRefundDomain) {
        String memberCcode;
        if (ocRefundDomain == null) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundCancelNotice.ocContractDomain is null");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", memberCcode = ocRefundDomain.getMemberCcode());
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundCancelNotice.secretkey is null", (Object)memberCcode);
            return "error";
        }
        String sendRefundCancelUrl = this.getDdFalgSetting(tenantCode, "cyyapi", "sendRefundCancelUrl", memberCcode);
        if (StringUtils.isBlank((String)sendRefundCancelUrl)) {
            this.logger.error("DataCyyApiServiceImpl.sendRefundCancelNotice.sendRefundCancelUrl is null", (Object)memberCcode);
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", ocRefundDomain.getContractBillcode());
        param.put("refundCode", ocRefundDomain.getRefundCode());
        param.put("dataState", -1);
        String responseBody = this.apimRequestReJson(sendRefundCancelUrl, param, secretkey, memberCcode);
        if (StringUtils.isBlank((String)responseBody)) {
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(responseBody, String.class, Object.class);
        if (!((Boolean)jsonToMap.get("success")).booleanValue()) {
            return "error";
        }
        return "success";
    }

    private synchronized List<RsSpecValueDomain> makeSpec(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return null;
        }
        String tenantCode = rsSkuDomain.getTenantCode();
        String memberCode = rsSkuDomain.getMemberCode();
        String memberName = rsSkuDomain.getMemberName();
        String skuName = rsSkuDomain.getSkuName();
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("memberCode", memberCode);
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        QueryResult supQueryResult = this.sendReSupObject("rs.spec.querySpecGroupPage", specGroupMap, RsSpecGroup.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, String> mapStr = new HashMap<String, String>();
            RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
            rsSpecGroupDomain.setTenantCode(tenantCode);
            rsSpecGroupDomain.setMemberCode(memberCode);
            rsSpecGroupDomain.setMemberName(memberName);
            rsSpecGroupDomain.setSpecGroupName(memberName);
            rsSpecGroupDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecGroupDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecGroupDomain));
            String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
            if (StringUtils.isBlank((String)specGroupCode)) {
                this.logger.error("DataCyyApiServiceImpl.makeSpec.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain)));
                return null;
            }
            specGroupMapStr.put("specName", skuName);
            specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
            QueryResult querySpecPage = this.sendReSupObject("rs.spec.querySpecPage", specGroupMap, RsSpec.class);
            String specCode = null;
            if (null == querySpecPage || ListUtil.isEmpty((Collection)querySpecPage.getList())) {
                HashMap<String, String> mapStr1 = new HashMap<String, String>();
                RsSpecDomain rsSpecDomain = new RsSpecDomain();
                rsSpecDomain.setSpecName(skuName);
                rsSpecDomain.setSpecGroupCode(specGroupCode);
                rsSpecDomain.setTenantCode(tenantCode);
                rsSpecDomain.setSpecDefault("0");
                rsSpecDomain.setMemberCode(memberCode);
                rsSpecDomain.setMemberName(memberName);
                mapStr1.put("rsSpecDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecDomain));
                specCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpec", mapStr1);
                if (StringUtils.isBlank((String)specCode)) {
                    this.logger.error("DataCyyApiServiceImpl.makeSpec.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                    return null;
                }
                HashMap<String, String> mapStr2 = new HashMap<String, String>();
                RsSpecOptionDomain specOptionDomain = new RsSpecOptionDomain();
                specOptionDomain.setTenantCode(tenantCode);
                specOptionDomain.setSpecGroupCode(specGroupCode);
                specOptionDomain.setSpecCode(specCode);
                specOptionDomain.setSpecOptionName(skuName);
                specOptionDomain.setMemberCode(memberCode);
                specOptionDomain.setMemberName(memberName);
                mapStr2.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)specOptionDomain));
                String specOptionCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", mapStr2);
                if (StringUtils.isBlank((String)specOptionCode)) {
                    this.logger.error("DataCyyApiServiceImpl.makeSpec.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)specOptionDomain)));
                }
            } else {
                specCode = ((RsSpec)querySpecPage.getList().get(0)).getSpecCode();
            }
            rsSpecValueDomain.setSpecCode(specCode);
            rsSpecValueDomain.setSpecGroupCode(specGroupCode);
            rsSpecValueDomain.setSpecName(skuName);
        } else {
            RsSpecGroup rsSpecGroup = (RsSpecGroup)supQueryResult.getList().get(0);
            String specGroupCode = rsSpecGroup.getSpecGroupCode();
            rsSpecValueDomain.setSpecGroupCode(specGroupCode);
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            HashMap<String, String> querySpecMapStr = new HashMap<String, String>();
            querySpecMapStr.put("specGroupCode", specGroupCode);
            querySpecMapStr.put("specName", skuName);
            querySpecMapStr.put("memberCode", memberCode);
            querySpecMapStr.put("tenantCode", tenantCode);
            querySpecMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(querySpecMapStr));
            QueryResult supRsSpecQueryResult = this.sendReSupObject("rs.spec.querySpecPage", querySpecMap, RsSpec.class);
            if (null == supRsSpecQueryResult || ListUtil.isEmpty((Collection)supRsSpecQueryResult.getList())) {
                HashMap<String, String> mapStr = new HashMap<String, String>();
                RsSpecDomain rsSpecDomain = new RsSpecDomain();
                rsSpecDomain.setSpecName(skuName);
                rsSpecDomain.setSpecGroupCode(specGroupCode);
                rsSpecDomain.setTenantCode(tenantCode);
                rsSpecDomain.setSpecDefault("0");
                rsSpecDomain.setMemberCode(memberCode);
                rsSpecDomain.setMemberName(memberName);
                mapStr.put("rsSpecDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecDomain));
                String specCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpec", mapStr);
                if (StringUtils.isBlank((String)specCode)) {
                    this.logger.error("DataCyyApiServiceImpl.makeSpec.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                    return null;
                }
                HashMap<String, String> mapStr2 = new HashMap<String, String>();
                RsSpecOptionDomain specOptionDomain = new RsSpecOptionDomain();
                specOptionDomain.setTenantCode(tenantCode);
                specOptionDomain.setSpecGroupCode(specGroupCode);
                specOptionDomain.setSpecCode(specCode);
                specOptionDomain.setSpecOptionName(skuName);
                specOptionDomain.setMemberCode(memberCode);
                specOptionDomain.setMemberName(memberName);
                mapStr2.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)specOptionDomain));
                String specOptionCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", mapStr2);
                if (StringUtils.isBlank((String)specOptionCode)) {
                    this.logger.error("DataCyyApiServiceImpl.makeSpec.checkGoods.saveSpec", (Object)("specOptionCode:" + specOptionCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)specOptionDomain)));
                }
                rsSpecValueDomain.setSpecCode(specCode);
                rsSpecValueDomain.setSpecGroupCode(specGroupCode);
                rsSpecValueDomain.setSpecName(skuName);
            } else {
                rsSpecValueDomain.setSpecCode(((RsSpec)supRsSpecQueryResult.getList().get(0)).getSpecCode());
                rsSpecValueDomain.setSpecGroupCode(specGroupCode);
                rsSpecValueDomain.setSpecName(skuName);
            }
        }
        ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        rsSpecValueDomain.setTenantCode(tenantCode);
        rsSpecValueDomain.setSpecValueValue(rsSpecValueDomain.getSpecName());
        rsSpecValueDomain.setSpecValueType("1");
        rsSpecValueDomain.setSpecValueFlag("1");
        rsSpecValueDomainList.add(rsSpecValueDomain);
        return rsSpecValueDomainList;
    }

    private RsSkuDomain getSkuBySkuNo(String skuNo, String memberCode, String tenantCode) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("skuNo", skuNo);
        mapP.put("memberCode", memberCode);
        mapP.put("memberCcode", memberCode);
        mapP.put("channelCode", null);
        mapP.put("tenantCode", tenantCode);
        mapP.put("goodsType", "60,61,62");
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String skuStr = (String)internalRouter.inInvoke("rs.sku.getSkuBySkuNo", mapP);
        if (StringUtils.isBlank((String)skuStr)) {
            return null;
        }
        return (RsSkuDomain)JsonUtil.buildNormalBinder().getJsonToObject(skuStr, RsSkuDomain.class);
    }

    private RsResourceGoodsReDomain getResourceGoodsByCodeStr(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("goodsCode", goodsCode);
        params.put("tenantCode", tenantCode);
        this.logger.error("DataCyyApiServiceImpl.getResourceGoodsByCodeStr", (Object)JsonUtil.buildNormalBinder().toJson(params));
        return (RsResourceGoodsReDomain)this.getForObject(RESOURCEGOODS_GET_CODE_STR, RsResourceGoodsReDomain.class, params);
    }

    private RsResourceGoodsReDomain getResourceGoodsByCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        params.put("goodsCode", goodsCode);
        params.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(params));
        this.logger.error("DataCyyApiServiceImpl.getResourceGoodsByCodeStr", (Object)JsonUtil.buildNormalBinder().toJson(params));
        return (RsResourceGoodsReDomain)this.getForObject(RESOURCEGOODS_GET_CODE, RsResourceGoodsReDomain.class, map);
    }

    public void handleUpAndDown(RsResourceGoodsReDomain goods, Integer state) {
        if (goods == null || state == null) {
            return;
        }
        String apiCode = null;
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        switch (state) {
            case -1: {
                apiCode = RESOURCEGOODS_CANCEL_AUDIT_CODE;
                goodsIds.add(goods.getGoodsId());
                break;
            }
            case 0: {
                apiCode = RESOURCEGOODS_SOLD_CODE;
                goodsIds.add(goods.getGoodsId());
                break;
            }
            case 1: {
                apiCode = RESOURCEGOODS_AUDIT_CODE;
                goodsIds.add(goods.getGoodsId());
                break;
            }
            case 2: {
                apiCode = RESOURCEGOODS_SHELVE_CODE;
                goodsIds.add(goods.getGoodsId());
                break;
            }
            default: {
                this.logger.error("DataCyyApiServiceImpl.handleUpAndDown.state", (Object)state);
            }
        }
        if (ListUtil.isNotEmpty(goodsIds)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("goodsIds", JsonUtil.buildNormalBinder().toJson(goodsIds));
            this.logger.info("DataCyyApiServiceImpl.handleUpAndDown.\u6267\u884c\u64cd\u4f5c===" + state, (Object)(apiCode + "===" + JsonUtil.buildNormalBinder().toJson(goodsIds)));
            String string = this.inInvokeApi(apiCode, paramMap);
        }
    }

    private String verify(String appId, String content, String tenantCode) {
        String secretkey = this.getDdFalgSetting(tenantCode, "cyyapi", "secretkey", appId);
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.verify appId", (Object)(appId + "-" + tenantCode));
            return null;
        }
        String data = null;
        try {
            data = EncryptUtil.aesDecrypt(content, secretkey);
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.verify.e", (Throwable)e);
            return null;
        }
        return data;
    }

    private String makeResult(Boolean flag, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", flag);
        resultMap.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    private DisChannel getChannelSup(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelStr = DisUtil.getMap((String)"DisChannel-memberCcode", (String)(memberCode + "-1-" + tenantCode));
        if (StringUtils.isBlank((String)channelStr)) {
            return null;
        }
        return (DisChannel)JsonUtil.buildNormalBinder().getJsonToObject(channelStr, DisChannel.class);
    }

    private String apimRequestReJson(String url, Map<String, Object> bodyParams, String secret, String key) {
        this.logger.info("DataCyyApiServiceImpl.apimRequestReJson.paramStr", (Object)(secret + "_____" + url + "_____" + JsonUtil.buildNormalBinder().toJson(bodyParams)));
        String responseStr = null;
        try {
            String body = "appId=" + key + "&content=" + EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson(bodyParams), secret);
            responseStr = HttpClientUtil.invokePost(url, body, "application/x-www-form-urlencoded", "application/json");
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.apimRequestReJson.result.e", (Throwable)e);
            return null;
        }
        this.logger.info("DataCyyApiServiceImpl.apimRequestReJson.result", (Object)responseStr);
        return responseStr;
    }

    private String requestJson(String url, Map<String, Object> bodyParams, String secret, String key) {
        this.logger.info("DataCyyApiServiceImpl.requestJson.paramStr", (Object)(secret + "_____" + url + "_____" + JsonUtil.buildNormalBinder().toJson(bodyParams)));
        String responseStr = null;
        try {
            String body = "appId=" + key + "&content=" + EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson(bodyParams), secret);
            responseStr = HttpUtil.invokePost(url, body, "application/x-www-form-urlencoded", "application/json");
        }
        catch (Exception e) {
            this.logger.error("DataCyyApiServiceImpl.requestJson.result.e", (Throwable)e);
            return null;
        }
        this.logger.info("DataCyyApiServiceImpl.requestJson.result", (Object)responseStr);
        return responseStr;
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + "_" + appmanageIcode).concat("-").concat(flagSettingCode + "_" + appmanageIcode);
        String value = SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
        return value;
    }

    protected OcContractReDomain getContractByCode(String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.getContractByCode";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        OcContractReDomain contractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, OcContractReDomain.class);
        return contractReDomain;
    }

    protected OcRefundReDomain getRefundByCode(String refundCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.refund.getRefundByCode";
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, OcRefundReDomain.class);
        return ocRefundReDomain;
    }

    private void sendRefundNext(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.inInvokeApi("oc.refundEngine.sendRefundNext", param);
    }

    private void sendRefundBack(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.inInvokeApi("oc.refundEngine.sendRefundBack", param);
    }

    protected void sendContractNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.contractEngine.sendContractNext";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.logger.info("DataCyyApiServiceImpl.sendContractNext.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String s = this.internalInvoke(apiCode, param);
    }

    private void sendContractBack(String contractBillcode, String tenantCode, Map<String, Object> map) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.contractEngine.sendContractBack";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.logger.info("DataCyyApiServiceImpl.sendContractBack.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String s = this.internalInvoke(apiCode, param);
    }

    protected DisChannel getDisChannel(String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error("DataCyyApiServiceImpl.param");
            return null;
        }
        String json = DisUtil.getMap((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("DataCyyApiServiceImpl.getDisChannel.json", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        DisChannel disChannel = (DisChannel)JsonUtil.buildNormalBinder().getJsonToObject(json, DisChannel.class);
        if (null == disChannel) {
            this.logger.error("DataCyyApiServiceImpl.getDisChannel.disChannel", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disChannel;
    }

    public static String getPntreeCode(String tenantCode) {
        HashMap<String, String> mapR = new HashMap<String, String>();
        mapR.put("pntreeName", "\u4e09\u65b9\u9ed8\u8ba4");
        mapR.put("tenantCode", tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(mapR));
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String pntreeStr = (String)internalRouter.inInvoke("rs.pntree.queryPntreePage", mapP);
        List pntreeList = null;
        try {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(pntreeStr, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return null;
            }
            pntreeList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsPntree.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ListUtil.isEmpty(pntreeList)) {
            return null;
        }
        return ((RsPntree)pntreeList.get(0)).getPntreeCode();
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    public <T> T inInvokeApi(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return (T)JsonUtil.buildNormalBinder().getJsonToObject(result, clazz);
    }

    static {
        eslock = new Object();
    }
}

