/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataCyyMeituanService;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.DateUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.adapter.MTOrderGoodsInfo;
import com.yqbsoft.laser.service.ext.data.cyy.service.adapter.MTOrderInfo;
import com.yqbsoft.laser.service.ext.data.cyy.service.client.SqtClient;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.OrgEmployee;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.PtePtrade;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.ServiceFee;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.ext.data.cyy.service.domain.order.OrderBaseInfo;
import com.yqbsoft.laser.service.ext.data.cyy.service.enums.PayStatusEnum;
import com.yqbsoft.laser.service.ext.data.cyy.service.h5Access.SqtH5Access;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.order.OrderDetailQueryRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayCallbackRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayQueryRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdPayRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay.ThirdRefundRequest;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.order.MaicaiOrderDetailQueryResponse;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.order.MaicaiQueryRespBody;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.order.OrderChangeInfo;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.order.OrderDetailQueryRespBody;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.order.OrderDetailQueryResponse;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.order.ThirdOrderChangInfo;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdPayQueryRespBody;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdPayRespBody;
import com.yqbsoft.laser.service.ext.data.cyy.service.response.thirdpay.ThirdRefundRespBody;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractproDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.response.BaseApiResponse;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataCyyMeituanServiceImpl
extends BaseServiceImpl
implements DataCyyMeituanService {
    private static final String SYS_CODE = "DataCyyMeituanServiceImpl";
    private static final String URL = "https://m-sqt.meituan.com/open/commonaccess/access";
    static Map<Integer, String> stateMap = new HashMap<Integer, String>();
    static Map<Integer, HashMap<String, String>> map = new HashMap<Integer, HashMap<String, String>>();

    private MTOrderInfo getOrderInfo(OrderDetailQueryRespBody orderDetail) {
        OrderBaseInfo orderBaseInfo = orderDetail.getOrderBaseInfo();
        MTOrderInfo mtOrderInfo = null;
        if (4 == orderBaseInfo.getSqtType()) {
            mtOrderInfo = orderDetail.getWmOrder();
        } else if (20 == orderBaseInfo.getSqtType()) {
            mtOrderInfo = orderDetail.getMaicaiOrder();
        }
        return mtOrderInfo;
    }

    private String getFlagSettingCode(OrderDetailQueryRespBody orderDetail) {
        OrderBaseInfo orderBaseInfo = orderDetail.getOrderBaseInfo();
        String flagSettingCode = null;
        if (4 == orderBaseInfo.getSqtType()) {
            flagSettingCode = "mtwaimai";
        } else if (20 == orderBaseInfo.getSqtType()) {
            flagSettingCode = "mtmaicai";
        }
        return flagSettingCode;
    }

    public String getH5AccessUrl(String staffNo, String tenantCode, String productType) {
        String h5url = this.getDdFalgSetting("00000000", "meituan", "h5url", "");
        String params = SqtH5Access.h5Params(staffNo, productType);
        return h5url + "?" + params + "&test_open_swimlane=test-open";
    }

    public BaseApiResponse<String> saveOrder(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdPayRequest thirdPayRequest = JsonUtil.json2Object(decryptContent, ThirdPayRequest.class);
            if (thirdPayRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, thirdPayRequest:{}", (Object)thirdPayRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.thirdPayRequest:{}", (Object)thirdPayRequest);
            ThirdPayRespBody respBody = this.saveCyyOrder(thirdPayRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdPayRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.sendOrder.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdPayRespBody saveCyyOrder(ThirdPayRequest thirdPayRequest, String tenantCode) throws Exception {
        OrgEmployee employee;
        String payUrl = this.getDdFalgSetting(tenantCode, "payUrl", "payUrl", "");
        Map<String, Object> extInfoMap = thirdPayRequest.getExtInfoMap();
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 14);
        Object entStaffNum = extInfoMap.get("entStaffNum");
        if (null == entStaffNum) {
            this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.thirdPayRequest:{}, \u5904\u7406\u5f02\u5e38", (Object)thirdPayRequest);
            throw new Exception("\u7528\u6237\u4e3a\u7a7a");
        }
        UmUserinfoReDomainBean userinfo = this.getUserinfo(String.valueOf(entStaffNum), tenantCode);
        if (null == userinfo) {
            this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.extInfoMap:{}, \u5904\u7406\u5f02\u5e38", extInfoMap);
            throw new Exception("\u627e\u4e0d\u5230\u7528\u6237");
        }
        OcContractReDomain contractDomain = this.queryContractPageSqt(thirdPayRequest.getSqtBizOrderId(), tenantCode);
        if (contractDomain != null && StringUtils.isNotBlank((String)contractDomain.getContractBillcode())) {
            return new ThirdPayRespBody(contractDomain.getContractBillcode(), payUrl);
        }
        OrderDetailQueryRespBody orderDetail = this.getOrderDetail(thirdPayRequest.getSqtBizOrderId());
        if (orderDetail == null) {
            throw new Exception("\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u8be6\u60c5");
        }
        this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.getOrderDetail:{}, \u8ba2\u5355\u8be6\u60c5", (Object)JsonUtil.object2Json(orderDetail));
        BigDecimal tradeAmount = new BigDecimal(thirdPayRequest.getTradeAmount());
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setCashback(BigDecimal.ZERO);
        String flagSettingCode = this.getFlagSettingCode(orderDetail);
        if (StringUtils.isBlank((String)flagSettingCode)) {
            throw new Exception("\u4e1a\u52a1\u7c7b\u578b\u9519\u8bef");
        }
        String serviceFee = this.getDdFalgSetting(tenantCode, "serviceFee", flagSettingCode, "");
        if (StringUtils.isNotBlank((String)serviceFee)) {
            this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.serviceFee.thirdPayRequest.getSqtBizOrderId()", (Object)(thirdPayRequest.getSqtBizOrderId() + "-serviceFee:" + serviceFee));
            ServiceFee fee = JsonUtil.json2Object(serviceFee, ServiceFee.class);
            if (null != fee && "1".equals(fee.getD())) {
                ArrayList<OcContractproDomain> ocContractproDomainList = new ArrayList<OcContractproDomain>();
                OcContractproDomain ocContractproDomain = new OcContractproDomain();
                ocContractproDomain.setContractproRefrice1(tradeAmount);
                if ("1".equals(fee.getT())) {
                    tradeAmount = tradeAmount.add(fee.getN()).setScale(2, 4);
                    ocContractproDomain.setContractproRefrice(fee.getN());
                }
                if ("0".equals(fee.getT())) {
                    BigDecimal divide = fee.getN().divide(new BigDecimal(100), 2, 4);
                    BigDecimal feenum = tradeAmount.multiply(divide).setScale(2, 4);
                    tradeAmount = tradeAmount.add(feenum);
                    ocContractproDomain.setContractproRefrice(feenum);
                }
                ocContractproDomain.setTenantCode(tenantCode);
                ocContractproDomain.setContractproKey("serviceFee");
                ocContractproDomain.setContractproName("\u670d\u52a1\u8d39");
                ocContractproDomain.setContractproValue(fee.getM());
                ocContractproDomain.setContractproType(fee.getT());
                ocContractproDomain.setContractproNum(fee.getN());
                ocContractproDomainList.add(ocContractproDomain);
                ocContractDomain.setOcContractproDomainList(ocContractproDomainList);
                ocContractDomain.setDataBmoney(tradeAmount);
                ocContractDomain.setCashback(ocContractproDomain.getContractproRefrice());
                ocContractDomain.setContractDelcode(fee.getT());
            }
        }
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        ocContractDomain.setTenantCode(tenantCode);
        ocContractDomain.setContractPaydate(calendar.getTime());
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        QueryResult<OrgEmployee> queryEmployeePage = this.queryEmployeePage(userinfo.getUserinfoCode(), tenantCode);
        if (ListUtil.isNotEmpty((Collection)queryEmployeePage.getList()) && (employee = (OrgEmployee)queryEmployeePage.getList().get(0)) != null) {
            ocContractDomain.setCompanyCode(employee.getCompanyCode());
            ocContractDomain.setCompanyShortname(employee.getCompanyShortname());
            ocContractDomain.setChannelName(employee.getCompanyShortname());
        }
        OrderBaseInfo orderBaseInfo = orderDetail.getOrderBaseInfo();
        String shopName = orderBaseInfo.getShopName();
        String shopPhone = orderBaseInfo.getShopPhone();
        this.makeContract(thirdPayRequest, userinfo, tradeAmount, ocContractDomain, contractGoodsList, orderDetail, memberCode);
        MTOrderInfo orderInfo = this.getOrderInfo(orderDetail);
        if (orderInfo == null) {
            throw new Exception("\u4e1a\u52a1\u7c7b\u578b\u9519\u8bef");
        }
        this.makeOrderMTParam(orderInfo, ocContractDomain);
        this.makeContractGoods(shopName, shopPhone, orderInfo.getGoodsList(), ocContractDomain, contractGoodsList);
        this.logger.error("DataCyyMeituanServiceImpl.saveCyyOrder.ocContractDomain:{}, \u65b0\u589e\u8ba2\u5355", (Object)JsonUtil.object2Json(ocContractDomain));
        String contractBbillcode = this.sendContractByDel(ocContractDomain, null);
        if (StringUtils.isBlank((String)contractBbillcode)) {
            throw new Exception("\u65b0\u589e\u8ba2\u5355\u5931\u8d25");
        }
        payUrl = payUrl + contractBbillcode;
        return new ThirdPayRespBody(contractBbillcode, payUrl);
    }

    private void makeContract(ThirdPayRequest thirdPayRequest, UmUserinfoReDomainBean userinfo, BigDecimal tradeAmount, OcContractDomain ocContractDomain, List<OcContractGoodsDomain> contractGoodsList, OrderDetailQueryRespBody orderDetail, String memberCode) throws Exception {
        ocContractDomain.setDataStatestr("\u63d0\u4ea4\u8ba2\u5355");
        ocContractDomain.setContractNbillcode(String.valueOf(thirdPayRequest.getTradeNo()));
        ocContractDomain.setContractNbbillcode(String.valueOf(thirdPayRequest.getSqtBizOrderId()));
        ocContractDomain.setContractRemark(thirdPayRequest.getReturnUrl());
        ocContractDomain.setContractUserurl(thirdPayRequest.getNotifyUrl());
        ocContractDomain.setAppmanageIcode(userinfo.getAppmanageIcode());
        ocContractDomain.setUserCode(userinfo.getUserCode());
        ocContractDomain.setUserName(userinfo.getUserinfoPhone());
        ocContractDomain.setMemberBcode(userinfo.getUserinfoCode());
        ocContractDomain.setMemberBname(userinfo.getUserinfoCompname());
        ocContractDomain.setMemberCode(memberCode);
        ocContractDomain.setContractPumode("3");
        ocContractDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
        ocContractDomain.setMemberCcode(memberCode);
        ocContractDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
        OrderBaseInfo orderBaseInfo = orderDetail.getOrderBaseInfo();
        if (null == stateMap.get(orderBaseInfo.getSqtType())) {
            throw new Exception("\u8ba2\u5355\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        ocContractDomain.setContractType(stateMap.get(orderBaseInfo.getSqtType()));
        ocContractDomain.setContractInmoney(tradeAmount.subtract(ocContractDomain.getCashback()));
        ocContractDomain.setContractMoney(tradeAmount);
        ocContractDomain.setDataBmoney(tradeAmount);
        ocContractDomain.setContractEcflag(Integer.valueOf(0));
        ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        ocPackageDomain.setContractGoodsList(contractGoodsList);
        packageList.add(ocPackageDomain);
        ocContractDomain.setPackageList(packageList);
    }

    public void makeOrderMTParam(MTOrderInfo mtOrderInfo, OcContractDomain ocContractDomain) {
        ocContractDomain.setGoodsReceiptMem(mtOrderInfo.getRecipientName());
        ocContractDomain.setGoodsReceiptPhone(mtOrderInfo.getRecipientPhone());
        ocContractDomain.setGoodsReceiptArrdess(mtOrderInfo.getRecipientAddress());
        ocContractDomain.setGoodsLogmoney(new BigDecimal(mtOrderInfo.getFreight()));
        ocContractDomain.setGoodsNum(new BigDecimal(String.valueOf(mtOrderInfo.getGoodsNum())));
    }

    public void makeContractGoods(String shopName, String shopPhone, List<MTOrderGoodsInfo> mtOrderInfoList, OcContractDomain ocContractDomain, List<OcContractGoodsDomain> contractGoodsList) {
        for (MTOrderGoodsInfo food : mtOrderInfoList) {
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setGoodsType(ocContractDomain.getContractType());
            ocContractGoodsDomain.setPricesetNprice(food.getGoodsPrice());
            ocContractGoodsDomain.setPricesetAsprice(ocContractDomain.getDataBmoney());
            ocContractGoodsDomain.setContractGoodsGtype("2");
            ocContractGoodsDomain.setGoodsCode("mtgoods");
            ocContractGoodsDomain.setTenantCode(ocContractDomain.getTenantCode());
            ocContractGoodsDomain.setMemberCode(ocContractDomain.getMemberCode());
            ocContractGoodsDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
            ocContractGoodsDomain.setMemberCcode(ocContractDomain.getMemberCode());
            ocContractGoodsDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
            ocContractGoodsDomain.setGoodsName(food.getName());
            ocContractGoodsDomain.setSkuCode(food.getSkuCode());
            ocContractGoodsDomain.setSkuNo(food.getSkuCode());
            ocContractGoodsDomain.setGoodsNo(food.getSkuCode());
            ocContractGoodsDomain.setContractGoodsMoney(food.getTotalPrice());
            ocContractGoodsDomain.setDataPic(food.getPicUrl());
            BigDecimal itemNum = new BigDecimal(String.valueOf(food.getCount()));
            ocContractGoodsDomain.setGoodsNum(itemNum);
            ocContractGoodsDomain.setGoodsCamount(itemNum);
            ocContractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
            ocContractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
            ocContractGoodsDomain.setMemberContact(shopName);
            ocContractGoodsDomain.setMemberContactPhone(shopPhone);
            contractGoodsList.add(ocContractGoodsDomain);
        }
    }

    protected QueryResult<OrgEmployee> queryEmployeePage(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    public BaseApiResponse<String> saveRefund(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.saveRefund.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdRefundRequest thirdRefundRequest = JsonUtil.json2Object(decryptContent, ThirdRefundRequest.class);
            if (thirdRefundRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.saveRefund.token:{}, thirdRefundRequest:{}", (Object)thirdRefundRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.thirdPayRequest:{}", (Object)thirdRefundRequest);
            ThirdRefundRespBody respBody = this.refund(thirdRefundRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdRefundRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.saveRefund.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdRefundRespBody refund(ThirdRefundRequest thirdRefundRequest, String tenantCode) throws Exception {
        try {
            OcContractReDomain ocContractReDomain = this.queryContractPage(thirdRefundRequest.getTradeNo(), tenantCode);
            if (ocContractReDomain == null) {
                this.logger.error("DataCyyMeituanServiceImpl.\u652f\u4ed8\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
                return new ThirdRefundRespBody(null);
            }
            List<OcRefundDomain> refundDomainList = this.queryRefundPage(thirdRefundRequest.getTradeNo(), thirdRefundRequest.getRefundTradeNo(), ocContractReDomain.getContractBillcode(), tenantCode);
            OcRefundDomain ocRefundDomain = new OcRefundDomain();
            if (ListUtil.isNotEmpty(refundDomainList)) {
                ocRefundDomain = refundDomainList.get(0);
                this.logger.error("DataCyyMeituanServiceImpl.refund.ocRefundDomain", (Object)JsonUtil.object2Json(ocRefundDomain));
                this.logger.error("DataCyyMeituanServiceImpl.\u9000\u6b3e\u7533\u8bf7\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.object2Json(thirdRefundRequest));
                return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
            }
            if (StringUtils.isBlank((String)ocContractReDomain.getPtradeSeqno()) || ocContractReDomain.getDataState() < 2) {
                if (ocContractReDomain.getDataState() == -1) {
                    this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u5df2\u5168\u90e8\u9000\u6b3e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
                    return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
                }
                this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
                return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
            }
            PtePtrade pteptrade = this.getPteptrade((OcContractDomain)ocContractReDomain);
            if (pteptrade == null) {
                this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
                return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
            }
            if (pteptrade.getDataState() != 3) {
                this.logger.error("DataCyyMeituanServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo());
                return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
            }
            List<OcRefundDomain> refundDomainListTwo = this.queryRefundPage(thirdRefundRequest.getTradeNo(), null, ocContractReDomain.getContractBillcode(), tenantCode);
            BigDecimal refundMoney = new BigDecimal(thirdRefundRequest.getRefundAmount());
            if (ListUtil.isNotEmpty(refundDomainListTwo)) {
                for (OcRefundDomain refundDomain : refundDomainListTwo) {
                    refundMoney = refundMoney.add(refundDomain.getRefundMoney());
                    this.logger.error("DataCyyMeituanServiceImpl.refund.refundMoney", (Object)(refundMoney + "\u2014\u2014" + refundDomain.getRefundMoney() + "\u2014\u2014" + refundDomain.getRefundCode()));
                }
                if (refundMoney.compareTo(ocContractReDomain.getDataBmoney()) > 0) {
                    this.logger.error("DataCyyMeituanServiceImpl\u9000\u6b3e\u603b\u989d\u8d85\u8fc7\u652f\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + thirdRefundRequest.getTradeNo() + "\uff0c\u5df2\u9000\u6b3e\u91d1\u989d:" + refundMoney + ", \u672c\u6b21\u9000\u6b3e\u91d1\u989d:" + thirdRefundRequest.getRefundAmount() + ", \u652f\u4ed8\u91d1\u989d\uff1a" + ocContractReDomain.getDataBmoney());
                    return new ThirdRefundRespBody(String.valueOf(ocRefundDomain.getRefundCode()));
                }
            }
            ocRefundDomain = new OcRefundDomain();
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
            ocRefundDomain.setCashback(BigDecimal.ZERO);
            BigDecimal refundAmount = new BigDecimal(thirdRefundRequest.getRefundAmount());
            List ocContractproDomainList = ocContractReDomain.getOcContractproDomainList();
            if (ListUtil.isNotEmpty((Collection)ocContractproDomainList)) {
                for (OcContractproDomain ocContractproDomain : ocContractproDomainList) {
                    if (!"serviceFee".equals(ocContractproDomain.getContractproKey())) continue;
                    BigDecimal divide = refundAmount.divide(ocContractproDomain.getContractproRefrice1(), 2, 4).multiply(ocContractproDomain.getContractproRefrice()).setScale(2, 4);
                    ocRefundDomain.setCashback(divide);
                    refundAmount = refundAmount.add(divide);
                }
            }
            ocRefundDomain.setRefundNcode(thirdRefundRequest.getRefundTradeNo().toString());
            ocRefundDomain.setRefundType("MTB01");
            ocRefundDomain.setRefundUsertype("1");
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setRefundMoney(refundAmount);
            ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractReDomain.getGoodsList().get(0);
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocRefundDomain);
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            ocRefundGoodsDomain.setRefundGoodsNum(BigDecimal.ZERO);
            ocRefundGoodsDomain.setRefundGoodsAmt(BigDecimal.ZERO);
            ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
            this.logger.error("DataCyyMeituanServiceImpl.refund.\u65b0\u589e\u9000\u5355", (Object)JsonUtil.object2Json(ocRefundDomain));
            String refundCode = this.sendSaveRefund(ocRefundDomain);
            if (StringUtils.isBlank((String)refundCode)) {
                return new ThirdRefundRespBody(null);
            }
            ocContractGoodsDomain.setRefundFlag(Integer.valueOf(1));
            this.updateContractGoods(ocContractGoodsDomain);
            Map map = JsonUtil.json2Map(refundCode);
            return new ThirdRefundRespBody((String)map.get("code"));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.refund.e", (Object)JsonUtil.object2Json(e));
            return new ThirdRefundRespBody(null);
        }
    }

    private OcContractGoodsDomain getMinPriceItem(List<OcContractGoodsDomain> goodsList) {
        OcContractGoodsDomain minItem = goodsList.get(0);
        for (OcContractGoodsDomain goods : goodsList) {
            if (goods.getContractGoodsRefnum() == null) {
                goods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (goods.getGoodsNum().compareTo(goods.getContractGoodsRefnum()) <= 0 || goods.getPricesetNprice().compareTo(minItem.getPricesetNprice()) >= 0) continue;
            minItem = goods;
        }
        goodsList.remove(minItem);
        return minItem;
    }

    public BaseApiResponse<String> payQuery(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.payQuery.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdPayQueryRequest thirdPayQueryRequest = JsonUtil.json2Object(decryptContent, ThirdPayQueryRequest.class);
            if (thirdPayQueryRequest == null) {
                this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, thirdPayQueryRequest:{}", (Object)thirdPayQueryRequest);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.thirdPayRequest:{}", (Object)thirdPayQueryRequest);
            ThirdPayQueryRespBody respBody = this.cyyPayQuery(thirdPayQueryRequest, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.request:{}, response:{}", (Object)(JsonUtil.object2Json(thirdPayQueryRequest) + "---" + JsonUtil.object2Json(respBody)));
            return BaseApiResponse.success((Object)EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey));
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.payQuery.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public ThirdPayQueryRespBody cyyPayQuery(ThirdPayQueryRequest request, String tenantCode) {
        OcContractReDomain contractDomain = this.queryContractPage(request.getTradeNo(), tenantCode);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (contractDomain == null) {
            ThirdPayQueryRespBody respBody = new ThirdPayQueryRespBody();
            respBody.setPayTime(dateFormat.format(new Date()));
            respBody.setTradeNo(request.getTradeNo());
            respBody.setPayStatus(PayStatusEnum.FAILED.getCode());
            return respBody;
        }
        BigDecimal subtract = contractDomain.getDataBmoney().subtract(contractDomain.getCashback());
        ThirdPayQueryRespBody respBody = new ThirdPayQueryRespBody();
        respBody.setThirdPayOrderId(contractDomain.getContractBillcode());
        respBody.setTradeNo(Long.valueOf(contractDomain.getContractNbillcode()));
        respBody.setPayAmount(subtract.toString());
        if (StringUtils.isBlank((String)contractDomain.getPtradeSeqno())) {
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
            return respBody;
        }
        PtePtrade pteptrade = this.getPteptrade((OcContractDomain)contractDomain);
        if (pteptrade == null) {
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
            return respBody;
        }
        if (pteptrade.getDataState() == 3) {
            respBody.setPayTime(dateFormat.format(pteptrade.getGmtPaid()));
            respBody.setPayStatus(PayStatusEnum.SUCCESS.getCode());
        } else if (pteptrade.getDataState() == 0) {
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
        } else {
            respBody.setPayTime(dateFormat.format(pteptrade.getGmtModified()));
            respBody.setPayStatus(PayStatusEnum.TO_PAY.getCode());
        }
        return respBody;
    }

    public String payNotice(OcContractDomain contractDomain) {
        if (contractDomain == null || StringUtils.isBlank((String)contractDomain.getContractUserurl())) {
            return "error";
        }
        String entid = this.getDdFalgSetting("00000000", "meituan", "entid", "");
        String accesskey = this.getDdFalgSetting("00000000", "meituan", "accesskey", "");
        String secretkey = this.getDdFalgSetting("00000000", "meituan", "secretkey", "");
        ThirdPayCallbackRequest request = new ThirdPayCallbackRequest();
        request.setTradeNo(Long.valueOf(contractDomain.getContractNbillcode()));
        request.setThirdPayOrderId(contractDomain.getContractBillcode());
        BigDecimal subtract = contractDomain.getDataBmoney().subtract(contractDomain.getCashback());
        request.setPayAmount(String.valueOf(subtract));
        request.setPayTime(DateUtil.getStringByDate(new Date(), null));
        request.setMethod("trade.third.pay.callback");
        SqtClient client = new SqtClient(accesskey, Long.valueOf(entid), secretkey);
        String responseStr = client.commonPostInvokeOk(contractDomain.getContractUserurl(), request);
        this.logger.error("DataCyyMeituanServiceImpl.payNotice.responseStr", (Object)responseStr);
        return "success";
    }

    public BaseApiResponse<String> receivedOrderstatus(String token, String version, String content, String tenantCode) {
        this.logger.error("DataCyyMeituanServiceImpl.receivedOrderstatus.token:{}, version:{}, \u5bc6\u6587content:{}\uff0ctenantCode", (Object)(token + "---" + version + "---" + content + "---" + tenantCode));
        try {
            String secretKey = this.getSecretKey(token, tenantCode);
            this.logger.error("DataCyyMeituanServiceImpl.receivedOrderstatus.secretKey:{}, tenantCode:{}", (Object)(secretKey + "---" + tenantCode));
            String decryptContent = EncryptUtil.aesDecrypt(content, secretKey);
            this.logger.error("DataCyyMeituanServiceImpl.receivedOrderstatus.token:{}, \u660e\u6587decryptContent:{}", (Object)(token + "---" + decryptContent));
            ThirdOrderChangInfo thirdOrderChangInfo = JsonUtil.json2Object(decryptContent, ThirdOrderChangInfo.class);
            if (thirdOrderChangInfo == null || thirdOrderChangInfo.getData() == null) {
                this.logger.error("DataCyyMeituanServiceImpl.sendOrder.token:{}, orderChangeInfo:{}", (Object)thirdOrderChangInfo);
                throw new Exception("\u53c2\u6570\u4e3a\u7a7a");
            }
            this.logger.error("DataCyyMeituanServiceImpl.receivedOrderstatus.orderChangeInfo:{}", (Object)thirdOrderChangInfo);
            this.updateOrderState(thirdOrderChangInfo.getData(), tenantCode);
            return BaseApiResponse.success(null);
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.receivedOrderstatus.content:{}, \u5904\u7406\u5f02\u5e38", (Object)(content + "---" + e));
            return BaseApiResponse.fail((String)e.getMessage());
        }
    }

    public String getOrderInfo(OcContractReDomain contractReDomain) {
        if (contractReDomain == null || contractReDomain.getContractNbbillcode() == null) {
            return "error";
        }
        OrderDetailQueryRespBody orderDetail = this.getOrderDetail(Long.valueOf(contractReDomain.getContractNbbillcode()));
        if (orderDetail == null) {
            return "error";
        }
        OrderBaseInfo orderBaseInfo = orderDetail.getOrderBaseInfo();
        MTOrderInfo mtOrderInfo = this.getOrderInfo(orderDetail);
        if (mtOrderInfo == null) {
            this.logger.error("DataCyyMeituanServiceImpl.getOrderInfo.sqtType:{}, \u4e1a\u52a1\u7c7b\u578b\u9519\u8bef", (Object)orderBaseInfo.getSqtType());
            return "error";
        }
        try {
            this.makeDataState(orderBaseInfo.getSqtType(), mtOrderInfo, contractReDomain);
        }
        catch (Exception e) {
            this.logger.error("DataCyyMeituanServiceImpl.getOrderInfo.Exception", (Throwable)e);
            return "error";
        }
        contractReDomain.setGoodsList(null);
        this.updateContractReById(contractReDomain);
        return "success";
    }

    public String queryMaicaiDetail(String tenantCode) {
        List<OcContractReDomain> ocContractReDomainList = this.queryContractPage(tenantCode);
        if (ListUtil.isEmpty(ocContractReDomainList)) {
            return "success";
        }
        HashMap<String, MaicaiQueryRespBody.MaicaiInvoiceDetailInfo.MaicaiInvoiceItemInfo> maicaiInvoiceItemInfoMap = null;
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            MaicaiQueryRespBody maicaiDetail = this.getMaicaiDetail(Long.valueOf(ocContractReDomain.getContractNbbillcode()));
            if (maicaiDetail == null) continue;
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                maicaiInvoiceItemInfoMap = new HashMap<String, MaicaiQueryRespBody.MaicaiInvoiceDetailInfo.MaicaiInvoiceItemInfo>();
                for (MaicaiQueryRespBody.MaicaiInvoiceDetailInfo.MaicaiInvoiceItemInfo maicaiInvoiceItemInfo : maicaiDetail.getInvoiceList().get(0).getProductInvoiceList()) {
                    maicaiInvoiceItemInfoMap.put(maicaiInvoiceItemInfo.getSkuId(), maicaiInvoiceItemInfo);
                }
                MaicaiQueryRespBody.MaicaiInvoiceDetailInfo.MaicaiInvoiceItemInfo maicaiInvoiceItemInfo = (MaicaiQueryRespBody.MaicaiInvoiceDetailInfo.MaicaiInvoiceItemInfo)maicaiInvoiceItemInfoMap.get(ocContractGoodsDomain.getSkuCode());
                if (null == maicaiInvoiceItemInfo) continue;
                ocContractGoodsDomain.setGoodsProperty2(maicaiInvoiceItemInfo.getTaxRate());
                BigDecimal actualPrice = new BigDecimal(maicaiInvoiceItemInfo.getItemAmount()).subtract(new BigDecimal(maicaiInvoiceItemInfo.getDiscountAmount()));
                ocContractGoodsDomain.setContractGoodsMoney(actualPrice);
                ocContractGoodsDomain.setPricesetNprice(actualPrice.multiply(ocContractGoodsDomain.getGoodsCamount()));
                this.updateContractGoods(ocContractGoodsDomain);
            }
            ocContractReDomain.setContractEcflag(Integer.valueOf(2));
            this.updateContractReById(ocContractReDomain);
        }
        return "success";
    }

    private void updateOrderState(OrderChangeInfo orderChangeInfo, String tenantCode) throws Exception {
        OcContractReDomain contractReDomain = this.queryContractPage2(orderChangeInfo.getSqtBizOrderId(), tenantCode);
        if (contractReDomain == null) {
            this.logger.error("DataCyyMeituanServiceImpl.updateOrderState.getSqtBizOrderId:{}", (Object)orderChangeInfo.getSqtBizOrderId());
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (10 != orderChangeInfo.getChangeType()) {
            return;
        }
        this.makeDataStateStr(orderChangeInfo.getSqtType(), orderChangeInfo.getChangeStatus(), contractReDomain);
        this.logger.error("DataCyyMeituanServiceImpl.updateOrderState.changeStatus:{}, dataState:{}", (Object)(orderChangeInfo.getChangeStatus() + "---" + contractReDomain.getDataState()));
        contractReDomain.setGoodsList(null);
        this.updateContractReById(contractReDomain);
    }

    private void makeDataState(Integer sqtType, MTOrderInfo orderInfo, OcContractReDomain contractReDomain) throws Exception {
        String orderStatus = orderInfo.getOrderStatus().toString();
        this.makeDataStateStr(sqtType, orderStatus, contractReDomain);
    }

    private void makeDataStateStr(Integer sqtType, String orderStatus, OcContractReDomain contractReDomain) throws Exception {
        Integer dataState = contractReDomain.getDataState();
        HashMap<String, String> hashMap = map.get(sqtType);
        if (hashMap == null) {
            this.logger.error("DataCyyMeituanServiceImpl.makeDataStateStr.sqtType", (Object)sqtType);
            throw new Exception("\u4e1a\u52a1\u7c7b\u578b\u9519\u8bef");
        }
        String str = hashMap.get(orderStatus);
        if (str == null) {
            this.logger.error("DataCyyMeituanServiceImpl.makeDataStateStr.orderStatus", (Object)orderStatus);
            throw new Exception("\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        String[] split = str.split("_");
        String dataStateStr = split[0];
        dataState = Integer.parseInt(split[1]);
        this.logger.error("DataCyyMeituanServiceImpl.makeDataStateStr.orderStatus:{}, dataStateStr:{}, dataState:{}", (Object)(orderStatus + "---" + dataStateStr + "---" + dataState));
        contractReDomain.setDataState(dataState);
        contractReDomain.setDataStatestr(dataStateStr);
    }

    private void makeDataStateStr(Integer orderStatus, OcContractReDomain contractReDomain) {
        Integer dataState = contractReDomain.getDataState();
        String dataStateStr = null;
        switch (orderStatus) {
            case 1: {
                dataStateStr = "\u63d0\u4ea4\u8ba2\u5355";
                dataState = 1;
                break;
            }
            case 2: {
                dataStateStr = "\u5411\u9910\u5385\u63a8\u5355";
                dataState = 2;
                break;
            }
            case 4: {
                dataStateStr = "\u5df2\u63a5\u5355";
                dataState = 3;
                break;
            }
            case 8: {
                dataStateStr = "\u5df2\u5b8c\u6210";
                dataState = 5;
                break;
            }
            case 9: {
                dataStateStr = "\u5df2\u53d6\u6d88";
                dataState = -1;
                break;
            }
        }
        this.logger.error("DataCyyMeituanServiceImpl.makeDataStateStr.orderStatus:{}, dataStateStr:{}", (Object)(orderStatus + "---" + dataStateStr));
        contractReDomain.setDataState(dataState);
        contractReDomain.setDataStatestr(dataStateStr);
    }

    public OrderDetailQueryRespBody getOrderDetail(Long sqtBizOrderId) {
        if (sqtBizOrderId == null) {
            return null;
        }
        String entid = this.getDdFalgSetting("00000000", "meituan", "entid", "");
        String accesskey = this.getDdFalgSetting("00000000", "meituan", "accesskey", "");
        String secretkey = this.getDdFalgSetting("00000000", "meituan", "secretkey", "");
        OrderDetailQueryRequest request = new OrderDetailQueryRequest();
        request.setMethod("order.detail.query");
        request.setSqtBizOrderId((long)sqtBizOrderId);
        SqtClient client = new SqtClient(accesskey, Long.valueOf(entid), secretkey);
        String result = client.commonPostInvoke("https://bep-openapi.meituan.com/api/sqt/openapi/queryOrderDetail", request);
        OrderDetailQueryResponse response = JsonUtil.json2Object(result, OrderDetailQueryResponse.class);
        if (response == null) {
            return null;
        }
        return (OrderDetailQueryRespBody)response.getData();
    }

    public MaicaiQueryRespBody getMaicaiDetail(Long sqtBizOrderId) {
        if (sqtBizOrderId == null) {
            return null;
        }
        String entid = this.getDdFalgSetting("00000000", "meituan", "entid", "");
        String accesskey = this.getDdFalgSetting("00000000", "meituan", "accesskey", "");
        String secretkey = this.getDdFalgSetting("00000000", "meituan", "secretkey", "");
        OrderDetailQueryRequest request = new OrderDetailQueryRequest();
        request.setMethod("invoice.maicai.detail.query");
        request.setSqtBizOrderId(sqtBizOrderId);
        SqtClient client = new SqtClient(accesskey, Long.valueOf(entid), secretkey);
        String result = client.commonPostInvoke("https://bep-openapi.meituan.com/api/sqt/openapi/invoice/queryMaicaiDetail", request);
        MaicaiOrderDetailQueryResponse response = JsonUtil.json2Object(result, MaicaiOrderDetailQueryResponse.class);
        if (response == null) {
            return null;
        }
        return (MaicaiQueryRespBody)response.getData();
    }

    private PtePtrade getPteptrade(OcContractDomain contractDomain) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "pte.ptrade.getPtradeByCode";
        param.put("ptradeSeqno", contractDomain.getPtradeSeqno());
        param.put("tenantCode", contractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.getPteptrade.params", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String ptradeStr = this.internalInvoke(apiCode, params);
        this.logger.error("DataCyyMeituanServiceImpl.getPteptrade.ptradeStr", (Object)ptradeStr);
        PtePtrade ptePtrade = (PtePtrade)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(ptradeStr, PtePtrade.class);
        return ptePtrade;
    }

    protected OcContractReDomain queryContractPage(Long sqtBizOrderId, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        String apiCode = "oc.contract.queryContractPageReDomain";
        param.put("contractNbillcode", sqtBizOrderId.toString());
        param.put("tenantCode", tenantCode);
        param.put("childFlag", true);
        param.put("goodsProFlag", true);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractReDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractReDomain.class);
        OcContractReDomain ocContractReDomain = null;
        if (ListUtil.isNotEmpty((Collection)contractReDomainList)) {
            ocContractReDomain = (OcContractReDomain)contractReDomainList.get(0);
            this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.ocContractReDomain", (Object)JsonUtil.object2Json(ocContractReDomain));
        }
        return ocContractReDomain;
    }

    protected OcContractReDomain queryContractPageSqt(Long sqtBizOrderId, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        String apiCode = "oc.contract.queryContractPageReDomain";
        param.put("contractNbbillcode", sqtBizOrderId.toString());
        param.put("tenantCode", tenantCode);
        param.put("childFlag", true);
        param.put("goodsProFlag", true);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractReDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractReDomain.class);
        OcContractReDomain ocContractReDomain = null;
        if (ListUtil.isNotEmpty((Collection)contractReDomainList)) {
            ocContractReDomain = (OcContractReDomain)contractReDomainList.get(0);
            this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.ocContractReDomain", (Object)JsonUtil.object2Json(ocContractReDomain));
        }
        return ocContractReDomain;
    }

    protected List<OcContractReDomain> queryContractPage(String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>(7);
        String apiCode = "oc.contract.queryContractPageReDomain";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, -5);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        param.put("contractDepositdateQend", df.format(calendar.getTime()));
        param.put("colValue0", "-1,2,3,4,5");
        param.put("colName0", "DATA_STATE");
        param.put("contractEcflag", 0);
        param.put("contractType", "46");
        param.put("tenantCode", tenantCode);
        param.put("childFlag", true);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractReDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractReDomain.class);
        return contractReDomainList;
    }

    protected OcContractReDomain queryContractPage2(Long sqtBizOrderId, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.queryContractPageReDomain";
        param.put("contractNbbillcode", sqtBizOrderId.toString());
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractReDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractReDomain.class);
        OcContractReDomain ocContractReDomain = null;
        if (ListUtil.isNotEmpty((Collection)contractReDomainList)) {
            ocContractReDomain = (OcContractReDomain)contractReDomainList.get(0);
            this.logger.error("DataCyyMeituanServiceImpl.queryContractPage.ocContractReDomain", (Object)JsonUtil.object2Json(ocContractReDomain));
        }
        return ocContractReDomain;
    }

    protected List<OcRefundDomain> queryRefundPage(Long tradeNo, Long refundTradeNo, String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", tradeNo.toString());
        param.put("contractBillcode", contractBillcode);
        if (null != refundTradeNo) {
            param.put("refundNcode", refundTradeNo.toString());
        }
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataCyyMeituanServiceImpl.queryRefundPage.param", (Object)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    protected UmUserinfoReDomainBean getUserinfo(String userinfoCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "um.user.getUserinfoByCode";
        param.put("userinfoCode", userinfoCode);
        param.put("tenantCode", tenantCode);
        this.logger.error("DataCyyMeituanServiceImpl.getUserinfo.param", param);
        String contractStr = this.internalInvoke(apiCode, param);
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractStr, UmUserinfoReDomainBean.class);
        return umUserinfoReDomainBean;
    }

    protected String sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        String apiCode = "oc.shopping.sendContractByDel";
        param.put("ocContractDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        param.put("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.internalInvoke(apiCode, param);
    }

    protected String updateContractReById(OcContractReDomain ocContractReDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.contract.updateContractReById";
        param.put("ocContractReDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected String updateContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.contract.updateContractGoods";
        param.put("ocContractGoodsDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.object2Json(ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    public String getSecretKey(String token, String tenantCode) throws Exception {
        String accessKey = this.getDdFalgSetting("00000000", "meituan", "accesskey", "");
        if (!Objects.equals(accessKey, token)) {
            throw new Exception("token\u975e\u6cd5\uff0c\u7f8e\u56e2\u5546\u4f01\u901a\u4f20\u8fc7\u6765\u7684token\u4e0d\u6b63\u786e");
        }
        String secretkey = this.getDdFalgSetting("00000000", "meituan", "secretkey", "");
        return secretkey;
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }

    static {
        stateMap.put(4, "45");
        stateMap.put(20, "46");
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("1", "\u63d0\u4ea4\u8ba2\u5355_1");
        infoMap.put("2", "\u5411\u9910\u5385\u63a8\u5355_2");
        infoMap.put("4", "\u5df2\u63a5\u5355_3");
        infoMap.put("8", "\u5df2\u5b8c\u6210_5");
        infoMap.put("9", "\u53d6\u6d88_-1");
        map.put(4, infoMap);
        infoMap = new HashMap();
        infoMap.put("0", "\u63d0\u4ea4\u8ba2\u5355_1");
        infoMap.put("10", "\u4ed8\u6b3e\u4e2d_1");
        infoMap.put("20", "\u4ed8\u6b3e\u5931\u8d25_1");
        infoMap.put("30", "\u652f\u4ed8\u6210\u529f_2");
        infoMap.put("40", "\u5df2\u63a8\u9001\u81f3\u914d\u9001\u4e2d\u5fc3_3");
        infoMap.put("50", "\u5df2\u9001\u8fbe_4");
        infoMap.put("60", "\u5df2\u5b8c\u6210_5");
        infoMap.put("70", "\u7528\u6237\u53d6\u6d88_-1");
        infoMap.put("80", "\u5ba2\u670d\u53d6\u6d88_-1");
        infoMap.put("90", "\u7cfb\u7edf\u81ea\u52a8\u53d6\u6d88_-1");
        map.put(20, infoMap);
    }
}

