/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.thread;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.data.domain.RsSkuDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSupplierAllGoodsStockRunnableImpl
extends BaseServiceImpl
implements Runnable {
    private static final String SYS_CODE = "DataCyyYouXiangServiceImpl";
    private static Integer PAGE_SIZE = 500;
    private String userinfoCode;
    private String goodsSupplynum;

    public UpdateSupplierAllGoodsStockRunnableImpl(String userinfoCode, String goodsSupplynum) {
        this.userinfoCode = userinfoCode;
        this.goodsSupplynum = goodsSupplynum;
    }

    @Override
    public void run() {
        SupQueryResult<RsResourceGoodsReDomain> dataList;
        Map param = this.getQueryMapParam("memberCode,children", new Object[]{this.userinfoCode, true});
        int pageNumber = 1;
        do {
            try {
                dataList = this.fetchDataByPage(pageNumber, PAGE_SIZE, param);
                if (dataList == null || !ListUtil.isNotEmpty((Collection)dataList.getList())) continue;
                this.processData(dataList.getList());
                ++pageNumber;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } while (dataList != null && dataList.getList() != null && dataList.getList().size() == PAGE_SIZE.intValue());
    }

    private void processData(List<RsResourceGoodsReDomain> rsResourceGoodsReDomains) throws Exception {
        this.logger.error("DataCyyYouXiangServiceImpl.processData.rsResourceGoodsReDomains", (Object)rsResourceGoodsReDomains.size());
        BigDecimal goodsNum = new BigDecimal(this.goodsSupplynum);
        for (RsResourceGoodsReDomain rsResourceGoodsReDomain : rsResourceGoodsReDomains) {
            if (!ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsSkuDomainList())) continue;
            if (rsResourceGoodsReDomain.getRsSkuDomainList().size() == 1) {
                this.updateGoodsStock(rsResourceGoodsReDomain, goodsNum, goodsNum);
                continue;
            }
            this.updateGoodsStock(rsResourceGoodsReDomain, goodsNum.divide(new BigDecimal(rsResourceGoodsReDomain.getRsSkuDomainList().size())), goodsNum);
        }
    }

    private void updateGoodsStock(RsResourceGoodsReDomain rsResourceGoodsReDomain, BigDecimal spuGoodsNum, BigDecimal skuGoodsNum) {
        Map param = this.getQueryMapParam("memberCcode,goodsNo,children", new Object[]{rsResourceGoodsReDomain.getMemberCcode(), rsResourceGoodsReDomain.getGoodsNo(), true});
        QueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage = this.queryResourceGoodsPage(param);
        this.logger.error("DataCyyYouXiangServiceImpl.updateGoodsStock.queryResourceGoodsPage", (Object)queryResourceGoodsPage.getTotal());
        if (queryResourceGoodsPage != null && ListUtil.isNotEmpty((Collection)queryResourceGoodsPage.getList())) {
            for (RsResourceGoodsReDomain resourceGoodsReDomain : queryResourceGoodsPage.getList()) {
                resourceGoodsReDomain.setGoodsNum(spuGoodsNum);
                resourceGoodsReDomain.setGoodsSupplynum(spuGoodsNum);
                if (ListUtil.isNotEmpty((Collection)resourceGoodsReDomain.getRsSkuDomainList())) {
                    for (RsSkuDomain rsSkuDomain : resourceGoodsReDomain.getRsSkuDomainList()) {
                        rsSkuDomain.setGoodsNum(skuGoodsNum);
                        rsSkuDomain.setGoodsSupplynum(skuGoodsNum);
                    }
                }
                this.logger.error("DataCyyYouXiangServiceImpl.updateGoodsStock.resourceGoodsReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)resourceGoodsReDomain));
                this.sendUpdateResourceGoods(resourceGoodsReDomain);
            }
        }
    }

    protected String sendUpdateResourceGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        String apiCode = "rs.resource.sendUpdateResourceGoods";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    public SupQueryResult<RsResourceGoodsReDomain> fetchDataByPage(int pageNumber, int pageSize, Map<String, Object> rsParam) throws Exception {
        rsParam.put("page", pageNumber);
        rsParam.put("rows", pageSize);
        return this.queryResourceGoodsPage(rsParam);
    }

    protected QueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(Map<String, Object> map) {
        String apiCode = "rs.resourceGoods.queryResourceGoodsPage";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, param, RsResourceGoodsReDomain.class);
    }
}

