/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastJsonUtil {
    private static Logger logger = LoggerFactory.getLogger(FastJsonUtil.class);
    private static final SerializeConfig serializeConfig = new SerializeConfig();

    public static String toJsonString(Object object) {
        return FastJsonUtil.toJsonString(object, false);
    }

    public static String toJsonString(Object object, boolean seralizerClass) {
        if (object == null) {
            return null;
        }
        if (object instanceof String && StringUtils.isNotBlank((CharSequence)((String)object))) {
            return "";
        }
        if (seralizerClass) {
            return JSON.toJSONString((Object)object, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        }
        return JSON.toJSONString((Object)object, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> T parseObject(String json, Class<T> cla) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)json, cla);
        }
        catch (JSONException jsonException) {
            logger.error("JSON\u89e3\u6790\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{},\u5f02\u5e38\uff1a", (Object)json, (Object)jsonException);
            return null;
        }
    }

    public static Object parseObject(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return JSON.parse((String)json);
        }
        catch (JSONException jsonException) {
            logger.error("JSON\u89e3\u6790\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{},\u5f02\u5e38\uff1a{}", (Object)json, (Object)jsonException);
            return null;
        }
    }

    public static <T> T parseObject(String json, TypeReference<T> typeReference) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)json, typeReference, (Feature[])new Feature[0]);
        }
        catch (JSONException jsonException) {
            logger.error("JSON\u89e3\u6790\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{},\u5f02\u5e38\uff1a{}", (Object)json, (Object)jsonException);
            return null;
        }
    }

    public static <T> List<T> parseArray(String json, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return JSON.parseArray((String)json, cls);
        }
        catch (JSONException jsonException) {
            logger.error("JSON\u89e3\u6790\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{},\u5f02\u5e38\uff1a{}", (Object)json, (Object)jsonException);
            return null;
        }
    }

    static {
        ParserConfig.getGlobalInstance().addAccept("cn.xuankua");
    }
}

