/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.xuankua.service.impl;

import com.alibaba.fastjson.TypeReference;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataXuankuaService;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.xuankua.service.domain.PtePtrade;
import com.yqbsoft.laser.service.ext.data.xuankua.service.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.data.xuankua.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpResult;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpUtils;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.sec.ApiSign;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.support.ResultCode;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.util.DateUtil;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.util.FastJsonUtil;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkHotMovieVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCinemaListVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCinemaVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCityPlaydateVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCityVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCountyVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieLockResVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieMovieVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOpiV2ListVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOpiV3ListVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOrderVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMoviePlayCinemaVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieSeatVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.drama.AuthCodeDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataXuankuaServiceImpl
extends BaseServiceImpl
implements DataXuankuaService {
    private static final String SYS_CODE = "DataXuankuaServiceImpl";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String url = "https://test-open.xuankua.cn/route";
    public static final String jumpUrl = "https://testwap.mayiufu.com/rencaiyx/index";
    public static final String appkey = "rencaiyx";
    public static final String privatekey = "VHJDVOXRRILPMDPC34TE7BPWDYBRWUF8";
    private String pushUrl;
    private static Map<String, String> orderStatusMap = new ConcurrentHashMap<String, String>();

    private Map<String, String> getCommon(String method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("signmethod", "md5");
        params.put("method", method);
        params.put("v", "1.0");
        params.put("timestamp", DateUtil.getCurFullTimestampStr());
        return params;
    }

    private <T> ResultCode<T> getRes(Map<String, String> params, Class<T> clazz) {
        String url = this.getDdFalgSetting("00000000", "xuankua", "url", "");
        String appkey = this.getDdFalgSetting("00000000", "xuankua", "appkey", "");
        String privatekey = this.getDdFalgSetting("00000000", "xuankua", "privatekey", "");
        params.put("appkey", appkey);
        String sign = ApiSign.signMD5(params, privatekey);
        params.put("sign", sign);
        HttpResult result = null;
        for (int i = 0; i < 3 && !(result = HttpUtils.postUrlAsString(url, params)).isSuccess(); ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!result.isSuccess()) {
            return ResultCode.getFailure(result.getStatus() + "", result.getMsg());
        }
        String response = result.getResponse();
        XkMovieVo vo = (XkMovieVo)FastJsonUtil.parseObject(response, new TypeReference<XkMovieVo<T>>(new Type[]{clazz}){});
        if (!vo.isSuccess()) {
            if (vo.getError() == null) {
                this.logger.warn("xk\u63a5\u53e3\u5f02\u5e38\uff1a{},{}", (Object)params.toString(), (Object)response);
                return ResultCode.getFailure("\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
            }
            return ResultCode.getFailure(vo.getError().getCode() + "", vo.getError().getDesp());
        }
        return ResultCode.getSuccessReturn(vo.getData());
    }

    public ResultCode<XkMovieCityVo> getCityList() {
        Map<String, String> params = this.getCommon("xuankua.city.list");
        return this.getRes(params, XkMovieCityVo.class);
    }

    public ResultCode<XkMovieCountyVo> getCountyList(Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.county.list");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkMovieCountyVo.class);
    }

    public ResultCode<XkHotMovieVo> getHotMovie(Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.movie.hot.list");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkHotMovieVo.class);
    }

    public ResultCode<XkHotMovieVo> getFutureMovie(Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.movie.future.list");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkHotMovieVo.class);
    }

    public ResultCode<XkMovieMovieVo> getMovieDetail(Integer movieId, Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.movie.detail");
        params.put("movieid", movieId + "");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkMovieMovieVo.class);
    }

    public ResultCode<AuthCodeDomain> getAuthcode(String userPhone) {
        Map<String, String> params = this.getCommon("xuankua.member.get.authcode");
        params.put("mobile", userPhone);
        return this.getRes(params, AuthCodeDomain.class);
    }

    public ResultCode<XkMovieCinemaVo> getCinemaDetail(Integer cinemaId) {
        Map<String, String> params = this.getCommon("xuankua.cinema.detail");
        params.put("cinemaid", cinemaId + "");
        return this.getRes(params, XkMovieCinemaVo.class);
    }

    public ResultCode<XkMovieCinemaListVo> getCinemaList(Integer citycode, Integer pageNo) {
        Map<String, String> params = this.getCommon("xuankua.cinema.list");
        params.put("citycode", citycode + "");
        params.put("page_no", pageNo + "");
        params.put("per", "100");
        return this.getRes(params, XkMovieCinemaListVo.class);
    }

    public ResultCode<XkMoviePlayCinemaVo> getMoviePlayCinemaList(Integer cityCode, Integer movieId, String playdate) {
        Map<String, String> params = this.getCommon("xuankua.movie.play.cinema.list");
        params.put("citycode", cityCode + "");
        params.put("movieid", movieId + "");
        params.put("playdate", playdate);
        return this.getRes(params, XkMoviePlayCinemaVo.class);
    }

    public ResultCode<XkMovieOpiV2ListVo> getOpiList(Integer cinemaId) {
        Map<String, String> params = this.getCommon("xuankua.opi.list.v2");
        params.put("cinemaid", cinemaId + "");
        return this.getRes(params, XkMovieOpiV2ListVo.class);
    }

    public ResultCode<XkMovieOpiV3ListVo> getOpiV3List(Integer cinemaId) {
        Map<String, String> params = this.getCommon("xuankua.opi.list.v3");
        params.put("cinemaid", cinemaId + "");
        return this.getRes(params, XkMovieOpiV3ListVo.class);
    }

    public ResultCode<XkMovieCityPlaydateVo> getCityMoviePlaydateList(Integer cityCode, Integer movieId) {
        Map<String, String> params = this.getCommon("xuankua.movie.city.playdate.list");
        params.put("citycode", cityCode + "");
        params.put("movieid", movieId + "");
        return this.getRes(params, XkMovieCityPlaydateVo.class);
    }

    public ResultCode<XkMovieSeatVo> getSeatMap(String opiid) {
        Map<String, String> params = this.getCommon("xuankua.opi.seat");
        params.put("opiid", opiid);
        return this.getRes(params, XkMovieSeatVo.class);
    }

    public ResultCode<XkMovieLockResVo> lockSeat(String opiid, String seatids, String seatnames, String mobile) {
        Map<String, String> params = this.getCommon("xuankua.order.create.v2");
        params.put("opiid", opiid);
        params.put("seatids", seatids);
        params.put("seatnames", seatnames);
        params.put("mobile", mobile);
        params.put("checkUnpaid", "N");
        params.put("checkTicking", "N");
        params.put("pushUrl", this.pushUrl);
        return this.getRes(params, XkMovieLockResVo.class);
    }

    public ResultCode<String> sellSeat(String xkTradeno, String partnerTradeno) {
        Map<String, String> params = this.getCommon("xuankua.order.pay.notify");
        params.put("tradeno", xkTradeno);
        params.put("partner_tradeno", partnerTradeno);
        return this.getRes(params, String.class);
    }

    public ResultCode<String> cancelOrder(String xkTradeno) {
        Map<String, String> params = this.getCommon("xuankua.order.cancel");
        params.put("tradeno", xkTradeno);
        return this.getRes(params, String.class);
    }

    public ResultCode<XkMovieOrderVo> getOrderDetail(String xkTradeno) {
        Map<String, String> params = this.getCommon("xuankua.order.detail.v2");
        params.put("tradeno", xkTradeno);
        return this.getRes(params, XkMovieOrderVo.class);
    }

    public boolean isValidSign(Map<String, String> params) {
        String privatekey = this.getDdFalgSetting("00000000", "xuankua", "privatekey", "");
        String signx = ApiSign.signMD5(params, privatekey);
        String sign = MapUtils.getString(params, (Object)"sign");
        return org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)sign, (CharSequence)signx);
    }

    public String getXuankuaShopUrl(String userPhone, String tenantCode, String userinfoCode) throws Exception {
        ResultCode<AuthCodeDomain> resultCode = this.getAuthcode(userPhone);
        this.logger.error("DataXuankuaServiceImpl.getXuankuaShopUrl.resultCode = " + JsonUtil.buildNormalBinder().toJson(resultCode));
        if (!resultCode.isSuccess()) {
            this.logger.error("DataXuankuaServiceImplgetXuankuaShopUrl.result = " + userinfoCode + " \u8bf7\u6c42\u5931\u8d25!" + resultCode.getMsg());
            return "\u8bf7\u6c42\u5931\u8d25!" + resultCode.getMsg();
        }
        if (resultCode.getData() == null) {
            this.logger.error("DataXuankuaServiceImplgetXuankuaShopUrl.result = " + userinfoCode + " \u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a!" + resultCode.getMsg());
            return "\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a!" + resultCode.getMsg();
        }
        AuthCodeDomain data = resultCode.getData();
        String jumpUrl = this.getDdFalgSetting("00000000", "xuankua", "jumpUrl", "");
        String appkey = this.getDdFalgSetting("00000000", "xuankua", "appkey", "");
        this.logger.error("DataXuankuaServiceImplgetXuankuaShopUrl.result = " + jumpUrl + "?appkey=" + appkey + "&auth_code=" + data.getAuthCode() + "&txid=" + userinfoCode);
        return jumpUrl + "?appkey=" + appkey + "&auth_code=" + data.getAuthCode() + "&txid=" + userinfoCode;
    }

    public static void main(String[] args) {
        DataXuankuaServiceImpl dataXuankuaService = new DataXuankuaServiceImpl();
        String xuankuaShopUrl = null;
        try {
            xuankuaShopUrl = dataXuankuaService.saveXuankuaContract("12309152255091053", "2021011200000001");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("xuankuaShopUrl = " + xuankuaShopUrl);
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    public String saveXuankuaContract(String tradeno, String tenantCode) {
        ResultCode<XkMovieOrderVo> orderDetail = this.getOrderDetail(tradeno);
        this.logger.error("DataXuankuaServiceImpl.saveXuankuaContract" + JsonUtil.buildNormalBinder().toJson(orderDetail));
        if (!orderDetail.isSuccess()) {
            return "error";
        }
        XkMovieOrderVo.OrderVo order = orderDetail.getData().getOrder();
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{order.getTradeno(), tenantCode}));
        if (ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            return ((OcContractReDomain)queryResult.getList().get(0)).getContractBillcode();
        }
        UmUserinfoDomain userinfoByCode = null;
        if (null == userinfoByCode) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoPhone,tenantCode", new Object[]{order.getMobile(), tenantCode}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                this.logger.error("DataXuankuaServiceImpl.userinfoByCode is nulll" + JsonUtil.buildNormalBinder().toJson((Object)tradeno));
                return "error";
            }
            userinfoByCode = (UmUserinfoReDomain)qlist.getList().get(0);
        }
        try {
            OcContractDomain ocContractDomain = new OcContractDomain();
            ocContractDomain.setTenantCode(tenantCode);
            ocContractDomain.setContractNbillcode(order.getTradeno());
            ocContractDomain.setAppmanageIcode("031");
            ocContractDomain.setUserCode(userinfoByCode.getUserCode());
            ocContractDomain.setUserName(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberCode(userinfoByCode.getUserinfoParentCode());
            ocContractDomain.setMemberMname(userinfoByCode.getUserinfoParentName());
            ocContractDomain.setMemberCcode(userinfoByCode.getUserinfoParentCode());
            ocContractDomain.setMemberCname(userinfoByCode.getUserinfoParentName());
            ocContractDomain.setContractType("43");
            ocContractDomain.setContractInmoney(order.getSettleAmount());
            ocContractDomain.setContractMoney(order.getSettleAmount());
            ocContractDomain.setGoodsReceiptArrdess(order.getCityname() + order.getCinemaAddr() + order.getCinemaname());
            ocContractDomain.setGoodsReceiptMem(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setGoodsReceiptPhone(userinfoByCode.getUserinfoPhone());
            ocContractDomain.setDataBmoney(order.getSettleAmount());
            ocContractDomain.setContractRemark(order.getTxid());
            ocContractDomain.setGoodsLogmoney(BigDecimal.ZERO);
            ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setGoodsType("43");
            ocContractGoodsDomain.setRefundFlag(Integer.valueOf(1));
            ocContractGoodsDomain.setDataPic(order.getMovielogo());
            ocContractGoodsDomain.setPricesetNprice(order.getSettleAmount());
            ocContractGoodsDomain.setPricesetAsprice(order.getSettleAmount());
            ocContractGoodsDomain.setContractGoodsGtype("2");
            ocContractGoodsDomain.setGoodsCode("jygoods");
            ocContractGoodsDomain.setGoodsName(order.getMoviename() + order.getRoomname());
            ocContractGoodsDomain.setSkuName(order.getSeats_price());
            ocContractGoodsDomain.setGoodsNum(new BigDecimal(1));
            ocContractGoodsDomain.setTenantCode(tenantCode);
            ocContractGoodsDomain.setMemberCode(userinfoByCode.getUserinfoParentCode());
            ocContractGoodsDomain.setMemberMname(userinfoByCode.getUserinfoParentName());
            ocContractGoodsDomain.setMemberCcode(userinfoByCode.getUserinfoParentCode());
            ocContractGoodsDomain.setMemberCname(userinfoByCode.getUserinfoParentName());
            contractGoodsList.add(ocContractGoodsDomain);
            ocPackageDomain.setContractGoodsList(contractGoodsList);
            packageList.add(ocPackageDomain);
            ocContractDomain.setPackageList(packageList);
            String code = this.saveOrder(ocContractDomain);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("contractBillcode", code);
            resultMap.put("url", order.getTxid());
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        catch (Exception e) {
            this.logger.error("DataXuankuaServiceImpl.getXuankuaShopUrl.Exception" + JsonUtil.buildNormalBinder().toJson((Object)e));
            return "error";
        }
    }

    protected QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataXuankuaServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected String saveOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("DataXuankuaServiceImpl.saveOrder.ocContractDomain");
            return null;
        }
        String apiCode = "oc.shopping.sendContractByDel";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    public String sendContract(OcContractReDomain ocContractDomain) {
        ResultCode<String> resultCode = this.sellSeat(ocContractDomain.getContractNbillcode(), ocContractDomain.getContractBillcode());
        this.logger.error("DataXuankuaServiceImpl.sendContract.resultCode", (Object)JsonUtil.buildNormalBinder().toJson(resultCode));
        if (resultCode.isSuccess()) {
            return "success";
        }
        return "error";
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }

    protected List<OcRefundDomain> queryRefundPage(String tradeNo, String refundTradeNo, String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", tradeNo);
        param.put("contractBillcode", contractBillcode);
        if (null != refundTradeNo) {
            param.put("refundNcode", refundTradeNo);
        }
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataXuankuaServiceImpl.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    private PtePtrade getPteptrade(OcContractDomain contractDomain) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "pte.ptrade.getPtradeByCode";
        param.put("ptradeSeqno", contractDomain.getPtradeSeqno());
        param.put("tenantCode", contractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataXuankuaServiceImpl.getPteptrade.params", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String ptradeStr = this.internalInvoke(apiCode, params);
        this.logger.error("DataXuankuaServiceImpl.getPteptrade.ptradeStr", (Object)ptradeStr);
        PtePtrade ptePtrade = (PtePtrade)JsonUtil.buildNormalBinder().getJsonToObject(ptradeStr, PtePtrade.class);
        return ptePtrade;
    }

    public String sendContractState(String tradeno, String ordertype, String orderstatus, String refundReason, String sign, String tenantCode) {
        if (!"R".equals(orderstatus)) {
            this.logger.error("DataXuankuaServiceImpl.sendContractState.tradeNo:" + tradeno + "|" + orderstatus + "|" + refundReason + "|" + sign);
            return "success";
        }
        OcContractReDomain ocContractReDomain = this.queryContractPage(tradeno, tenantCode);
        if (ocContractReDomain == null) {
            this.logger.error("DataXuankuaServiceImpltradeNo:" + tradeno);
            return "error";
        }
        List<OcRefundDomain> refundDomainList = this.queryRefundPage(tradeno, null, ocContractReDomain.getContractBillcode(), tenantCode);
        OcRefundDomain ocRefundDomain = null;
        if (ListUtil.isNotEmpty(refundDomainList)) {
            return "error";
        }
        if (StringUtils.isBlank((String)ocContractReDomain.getPtradeSeqno()) || ocContractReDomain.getDataState() != 2) {
            if (ocContractReDomain.getDataState() == -1) {
                return "error";
            }
            return "error";
        }
        PtePtrade pteptrade = this.getPteptrade((OcContractDomain)ocContractReDomain);
        if (pteptrade == null) {
            this.logger.error("DataXuankuaServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + tradeno);
            return "error";
        }
        if (pteptrade.getDataState() != 3) {
            this.logger.error("DataXuankuaServiceImpl.\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u6b3e\uff0ctradeNo:" + tradeno);
            return "error";
        }
        ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ocRefundDomain.setRefundType("MTB01");
        ocRefundDomain.setRefundUsertype("1");
        ocRefundDomain.setContractState(ocContractReDomain.getDataState());
        ocRefundDomain.setRefundMoney(ocContractReDomain.getDataBmoney());
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundGoodsDomain.setRefundGoodsAmt(ocContractReDomain.getDataBmoney());
            ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsCamount());
            ocRefundGoodsDomain.setGoodsCamount(ocContractGoodsDomain.getGoodsNum());
            ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        String refundCode = this.sendSaveRefund(ocRefundDomain);
        if (StringUtils.isBlank((String)refundCode)) {
            return "error";
        }
        return "success";
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected OcContractReDomain queryContractPage(String contractNbillcode, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        String apiCode = "oc.contract.queryContractPageReDomain";
        param.put("contractNbillcode", contractNbillcode);
        param.put("tenantCode", tenantCode);
        param.put("childFlag", true);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataXuankuaServiceImpl.queryContractPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult contractQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List contractReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)contractQuery.getList()), OcContractReDomain.class);
        OcContractReDomain ocContractReDomain = null;
        if (ListUtil.isNotEmpty((Collection)contractReDomainList)) {
            ocContractReDomain = (OcContractReDomain)contractReDomainList.get(0);
        }
        return ocContractReDomain;
    }

    static {
        orderStatusMap.put("N", "\u5f85\u652f\u4ed8");
        orderStatusMap.put("C", "\u5df2\u53d6\u6d88");
        orderStatusMap.put("E", "\u8ba2\u5355\u6709\u6548\u671f\u8fc7\u540e,\u6ca1\u6709\u6536\u5230\u4ed8\u6b3e\u901a\u77e5");
        orderStatusMap.put("P", "\u5df2\u4ed8\u6b3e");
        orderStatusMap.put("T", "\u901a\u77e5\u5904\u7406\u4e2d");
        orderStatusMap.put("S", "\u51fa\u7968\u6210\u529f");
        orderStatusMap.put("R", "\u9000\u6b3e\u5b8c\u6210");
    }
}

