/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final long m_second = 1000L;
    public static final long m_minute = 60000L;
    public static final long m_hour = 3600000L;
    public static final long m_day = 86400000L;
    public static final String PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String PATTERN_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String PATTERN_YYYYMMDD = "yyyyMMdd";
    public static final String PATTERN_YYYYMM = "yyyyMM";
    public static final String PATTERN_HH_MM_SS = "HH:mm:ss";
    public static final String MAX_TIMESTAMP = "2038-01-01 00:00:00";
    private static int[] chweek = new int[]{0, 7, 1, 2, 3, 4, 5, 6};
    public static String[] cnweek = new String[]{"", "\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    public static String[] cnweek2 = new String[]{"", "\u54687", "\u54681", "\u54682", "\u54683", "\u54684", "\u54685", "\u54686"};
    private static String[] cnSimpleweek = new String[]{"", "\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};

    public static final long timeMillis() {
        return System.currentTimeMillis();
    }

    public static final String currentDateStr() {
        return DateUtil.formatDate(DateUtil.currentTime());
    }

    public static final Date currentTime() {
        return new Date();
    }

    public static final String getCurFullTimestampStr() {
        return DateUtil.formatTimestamp(DateUtil.getCurFullTimestamp());
    }

    public static final Timestamp getCurFullTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static final int nextMonth() {
        String next = DateUtil.format(new Date(), "M");
        int nextMonth = Integer.parseInt(next) + 1;
        if (nextMonth == 13) {
            return 1;
        }
        return nextMonth;
    }

    public static final Date parseDate(String strDate) {
        return DateUtil.parseDate(strDate, PATTERN_YYYY_MM_DD);
    }

    public static int getWeekOfYear(Timestamp time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDateFromTimestamp(time));
        int week = cal.get(3);
        return week;
    }

    public static int getCnWeekOfYear(Timestamp time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDateFromTimestamp(time));
        cal.setFirstDayOfWeek(2);
        int week = cal.get(3);
        return week;
    }

    public static final Timestamp parseTimestamp(String strDate) {
        return DateUtil.parseTimestamp(strDate, PATTERN_YYYY_MM_DD_HH_MM_SS);
    }

    public static final Timestamp parseTimestamp(String strDate, String pattern) {
        Date date = DateUtil.parseDate(strDate, pattern);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static final Date parseDate(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static final <T extends Date> String formatDate(T date) {
        if (date == null) {
            return null;
        }
        return DateUtil.format(date, PATTERN_YYYY_MM_DD);
    }

    public static final <T extends Date> String formatTime(T date) {
        return DateUtil.format(date, PATTERN_HH_MM_SS);
    }

    public static final <T extends Date> String formatTimestamp(T date) {
        return DateUtil.format(date, PATTERN_YYYY_MM_DD_HH_MM_SS);
    }

    public static final String formatTimestamp(Long mills) {
        return DateUtil.formatTimestamp(new Date(mills));
    }

    public static final <T extends Date> String format(T date, String pattern) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final <T extends Date> T addTime(T original, int days, int hours, int minutes, int seconds) {
        if (original == null) {
            return null;
        }
        long newTime = original.getTime() + 86400000L * (long)days + 3600000L * (long)hours + 60000L * (long)minutes + 1000L * (long)seconds;
        Date another = (Date)original.clone();
        another.setTime(newTime);
        return (T)another;
    }

    public static final <T extends Date> T addDay(T original, int days) {
        if (original == null) {
            return null;
        }
        long newTime = original.getTime() + 86400000L * (long)days;
        Date another = (Date)original.clone();
        another.setTime(newTime);
        return (T)another;
    }

    public static final <T extends Date> T addMonth(T original, int months) {
        if (original == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(original);
        calendar.add(2, months);
        Date another = (Date)original.clone();
        another.setTime(calendar.getTimeInMillis());
        return (T)another;
    }

    public static final <T extends Date> T addHour(T original, int hours) {
        if (original == null) {
            return null;
        }
        long newTime = original.getTime() + 3600000L * (long)hours;
        Date another = (Date)original.clone();
        another.setTime(newTime);
        return (T)another;
    }

    public static final <T extends Date> T addMinute(T original, int minutes) {
        if (original == null) {
            return null;
        }
        long newTime = original.getTime() + 60000L * (long)minutes;
        Date another = (Date)original.clone();
        another.setTime(newTime);
        return (T)another;
    }

    public static final <T extends Date> T addSecond(T original, int second) {
        if (original == null) {
            return null;
        }
        long newTime = original.getTime() + 1000L * (long)second;
        Date another = (Date)original.clone();
        another.setTime(newTime);
        return (T)another;
    }

    public static final <T extends Date> T getBeginningTimeOfDay(T day) {
        if (day == null) {
            return null;
        }
        String strDate = DateUtil.formatDate(day);
        Long mill = DateUtil.parseDate(strDate).getTime();
        Date another = (Date)day.clone();
        another.setTime(mill);
        return (T)another;
    }

    public static final <T extends Date> T getLastTimeOfDay(T day) {
        if (day == null) {
            return null;
        }
        Long mill = DateUtil.getBeginningTimeOfDay(day).getTime() + 86400000L - 1L;
        Date another = (Date)day.clone();
        another.setTime(mill);
        return (T)another;
    }

    public static final String formatTime(String time) {
        if (time == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)(time = StringUtils.trim((String)time)))) {
            throw new IllegalArgumentException("\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef\uff01");
        }
        time = time.replace('\uff1a', ':');
        String[] times = time.split(":");
        String result = "";
        result = times[0].length() < 2 ? result + "0" + times[0] + ":" : result + times[0] + ":";
        result = times.length > 1 ? (times[1].length() < 2 ? result + "0" + times[1] : result + times[1]) : result + "00";
        Timestamp.valueOf("2001-01-01 " + result + ":00");
        return result;
    }

    public static boolean isTomorrow(Date date) {
        if (date == null) {
            return false;
        }
        return DateUtil.formatDate(DateUtil.addTime(new Date(), 1, 0, 0, 0)).equals(DateUtil.formatDate(date));
    }

    public static Integer getWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return chweek[c.get(7)];
    }

    public static Date getCurDateByWeek(Integer week) {
        if (week == null || week < 0 || week > 7) {
            return DateUtil.currentTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, week);
        return calendar.getTime();
    }

    public static String getCnWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return cnweek[c.get(7)];
    }

    public static String getCnWeek2(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return cnweek[c.get(7)];
    }

    public static String getCnSimpleWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return cnSimpleweek[c.get(7)];
    }

    public static Integer getCurrentDay() {
        return DateUtil.getDay(new Date());
    }

    public static Integer getCurrentMonth() {
        return DateUtil.getMonth(new Date());
    }

    public static Integer getCurrentYear() {
        return DateUtil.getYear(new Date());
    }

    public static Integer getYear(Date date) {
        if (date == null) {
            return null;
        }
        String year = DateUtil.format(date, "yyyy");
        return Integer.parseInt(year);
    }

    public static Integer getDay(Date date) {
        if (date == null) {
            return null;
        }
        String year = DateUtil.format(date, "d");
        return Integer.parseInt(year);
    }

    public static Timestamp getYearFirstDay(Date date) {
        Integer year = DateUtil.getYear(date);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, 1, 0, 0, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getYearLastDay(Date date) {
        Integer year = DateUtil.getYear(date);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 11, 31, 23, 59, 59);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Integer getMonth(Date date) {
        if (date == null) {
            return null;
        }
        String month = DateUtil.format(date, "M");
        return Integer.parseInt(month);
    }

    public static Integer getCurrentHour(Date date) {
        if (date == null) {
            return null;
        }
        String hour = DateUtil.format(date, "H");
        return Integer.parseInt(hour);
    }

    public static Integer getCurrentMin(Date date) {
        if (date == null) {
            return null;
        }
        String hour = DateUtil.format(date, "m");
        return Integer.parseInt(hour);
    }

    public static String getCurDateStr() {
        return DateUtil.formatDate(new Date());
    }

    public static String getCurTimeStr() {
        return DateUtil.formatTimestamp(new Date());
    }

    public static boolean isAfter(Date date) {
        if (date == null) {
            return false;
        }
        return date.after(new Date());
    }

    public static List<Date> getWeekDateList(Date date, String weektype) {
        int curMonth = DateUtil.getMonth(date);
        int week = Integer.parseInt(weektype);
        int curWeek = DateUtil.getWeek(date);
        int sub = (7 + week - curWeek) % 7;
        Date next = DateUtil.addDay(date, sub);
        ArrayList<Date> result = new ArrayList<Date>();
        while (DateUtil.getMonth(next) == curMonth) {
            result.add(next);
            next = DateUtil.addDay(next, 7);
        }
        return result;
    }

    public static List<Date> getWeekDateList(Date date, String weektype, int num) {
        int week = Integer.parseInt(weektype);
        int curWeek = DateUtil.getWeek(date);
        ArrayList<Date> result = new ArrayList<Date>();
        int sub = (7 + week - curWeek) % 7;
        Date next = DateUtil.addDay(date, sub);
        for (int i = 0; i < num; ++i) {
            result.add(next);
            next = DateUtil.addDay(next, 7);
        }
        return result;
    }

    public static List<Date> getCurWeekDateList(Date date) {
        int curWeek = DateUtil.getWeek(date);
        ArrayList<Date> dateList = new ArrayList<Date>();
        for (int i = 1; i <= 7; ++i) {
            dateList.add(DateUtil.addDay(date, -curWeek + i));
        }
        return dateList;
    }

    public static Date getWeekLastDay(Date date) {
        int curWeek = DateUtil.getWeek(date);
        return DateUtil.addDay(date, 7 - curWeek);
    }

    public static Date getCurDate() {
        return DateUtil.getBeginningTimeOfDay(new Date());
    }

    public static <T extends Date> T getMonthFirstDay(T date) {
        if (date == null) {
            return null;
        }
        String dateStr = DateUtil.format(date, "yyyy-MM") + "-01";
        Long mill = DateUtil.parseDate(dateStr).getTime();
        Date another = (Date)date.clone();
        another.setTime(mill);
        return (T)another;
    }

    public static <T extends Date> T getNextMonthFirstDay(T day) {
        if (day == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        int month = calendar.get(2);
        calendar.set(2, month + 1);
        calendar.set(5, 1);
        String datefor = DateUtil.format(calendar.getTime(), PATTERN_YYYY_MM_DD);
        Long mill = DateUtil.parseDate(datefor).getTime();
        Date another = (Date)day.clone();
        another.setTime(mill);
        return (T)another;
    }

    public static <T extends Date> T getMonthLastDay(T date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String dateStr = DateUtil.format(date, "yyyy-MM") + "-" + c.getActualMaximum(5);
        Long mill = DateUtil.parseDate(dateStr).getTime();
        Date another = (Date)date.clone();
        another.setTime(mill);
        return (T)another;
    }

    public static String formatDate(int days) {
        return DateUtil.formatDate(DateUtil.addDay(new Date(), days));
    }

    public static Timestamp getCurTruncTimestamp() {
        return DateUtil.getBeginningTimeOfDay(new Timestamp(System.currentTimeMillis()));
    }

    public static Integer getHour(Date date) {
        if (date == null) {
            return null;
        }
        String hour = DateUtil.format(date, "H");
        return Integer.parseInt(hour);
    }

    public static Integer getMinute(Date date) {
        if (date == null) {
            return null;
        }
        String m = DateUtil.format(date, "m");
        return Integer.parseInt(m);
    }

    public static String getTimeDesc(Timestamp time) {
        String timeContent;
        if (time == null) {
            return "";
        }
        Long ss = System.currentTimeMillis() - time.getTime();
        Long minute = ss / 60000L;
        if (minute < 1L) {
            Long second = ss / 1000L;
            timeContent = second + "\u79d2\u524d";
        } else {
            Long hour;
            timeContent = minute >= 60L ? ((hour = Long.valueOf(minute / 60L)) >= 24L ? (hour > 720L ? "1\u6708\u524d" : (hour > 168L && hour <= 720L ? hour / 168L + "\u5468\u524d" : hour / 24L + "\u5929\u524d")) : hour + "\u5c0f\u65f6\u524d") : minute + "\u5206\u949f\u524d";
        }
        return timeContent;
    }

    public static String getDateDesc(Date time) {
        String timeContent;
        if (time == null) {
            return "";
        }
        Long ss = System.currentTimeMillis() - time.getTime();
        Long minute = ss / 60000L;
        if (minute < 1L) {
            Long second = ss / 1000L;
            timeContent = second + "\u79d2\u524d";
        } else {
            Long hour;
            timeContent = minute >= 60L ? ((hour = Long.valueOf(minute / 60L)) >= 24L ? (hour > 720L ? "1\u6708\u524d" : (hour > 168L && hour <= 720L ? hour / 168L + "\u5468\u524d" : hour / 24L + "\u5929\u524d")) : hour + "\u5c0f\u65f6\u524d") : minute + "\u5206\u949f\u524d";
        }
        return timeContent;
    }

    public static String getMonthAndDay(Date date) {
        return DateUtil.formatDate(date).substring(5);
    }

    public static Date getMillDate() {
        return new Date();
    }

    public static Timestamp getMillTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static final <T extends Date> String getDiffDayStr(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return "---";
        }
        long diff = day1.getTime() - day2.getTime();
        long sign = diff / Math.abs(diff);
        if (sign < 0L) {
            return "\u5df2\u7ecf\u8fc7\u671f";
        }
        diff = Math.abs(diff) / 1000L;
        long day = diff / 3600L / 24L;
        long hour = (diff - day * 3600L * 24L) / 3600L;
        long minu = diff % 3600L / 60L;
        return (day == 0L ? "" : day + "\u5929") + (hour == 0L ? "" : hour + "\u5c0f\u65f6") + (minu == 0L ? "" : minu + "\u5206");
    }

    public static final <T extends Date> String getDiffStr(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return "---";
        }
        long diff = day1.getTime() - day2.getTime();
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        long hour = diff / 3600L;
        long minu = diff % 3600L / 60L;
        long second = diff % 60L;
        return (sign < 0L ? "-" : "+") + (hour == 0L ? "" : hour + "\u5c0f\u65f6") + (minu == 0L ? "" : minu + "\u5206") + (second == 0L ? "" : second + "\u79d2");
    }

    public static final <T extends Date> String getDiffStrX(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return "---";
        }
        long diff = day1.getTime() - day2.getTime();
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        long hour = diff / 3600L;
        long minu = diff % 3600L / 60L;
        long second = diff % 60L;
        return (hour == 0L ? "" : hour + "\u5c0f\u65f6") + (minu == 0L ? "" : minu + "\u5206") + (second == 0L ? "" : second + "\u79d2");
    }

    public static final <T extends Date> long getDiffSecond(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0L;
        }
        long diff = day1.getTime() - day2.getTime();
        if (diff == 0L) {
            return 0L;
        }
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        return sign * diff;
    }

    public static final <T extends Date> double getDiffMinu(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0.0;
        }
        long diff = day1.getTime() - day2.getTime();
        if (diff == 0L) {
            return 0.0;
        }
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        return (double)Math.round((double)diff * 1.0 * 10.0 / 6.0) / 100.0 * (double)sign;
    }

    public static final double getMillDiffMinu(long time1, long time2) {
        long diff = time1 - time2;
        if (diff == 0L) {
            return 0.0;
        }
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        return (double)Math.round((double)diff * 1.0 * 10.0 / 6.0) / 100.0 * (double)sign;
    }

    public static final <T extends Date> double getDiffHour(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0.0;
        }
        long diff = day1.getTime() - day2.getTime();
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        return (double)Math.round((double)diff * 1.0 / 3.6) / 1000.0 * (double)sign;
    }

    public static final <T extends Date> int getDiffDay(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0;
        }
        long diff = day1.getTime() - day2.getTime();
        diff = Math.abs(diff) / 1000L;
        return Math.round(diff / 86400L);
    }

    public static final <T extends Date> int getDiffDay2(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0;
        }
        long diff = day1.getTime() - day2.getTime();
        return Math.round((diff /= 1000L) / 86400L);
    }

    public static boolean isAfterOneHour(Date date, String time) {
        String datetime = DateUtil.formatDate(date) + " " + time + ":00";
        return DateUtil.addHour(DateUtil.parseTimestamp(datetime), -1).after(DateUtil.getMillTimestamp());
    }

    public static boolean isValidDate(String fyrq) {
        return DateUtil.parseDate(fyrq) != null;
    }

    public static <T extends Date> long getCurDateMills(T date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static Timestamp getBeginTimestamp(Date date) {
        return new Timestamp(DateUtil.getBeginningTimeOfDay(date).getTime());
    }

    public static Timestamp getEndTimestamp(Date date) {
        return new Timestamp(DateUtil.getLastTimeOfDay(date).getTime());
    }

    public static Date getDateFromTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public static int after(Date date1, Date date2) {
        date1 = DateUtil.getBeginningTimeOfDay(date1);
        date2 = DateUtil.getBeginningTimeOfDay(date2);
        return date1.compareTo(date2);
    }

    public static Timestamp mill2Timestamp(Long mill) {
        if (mill == null) {
            return null;
        }
        return new Timestamp(mill);
    }

    public static int subCurTimeSend() {
        Timestamp curtime = DateUtil.getCurFullTimestamp();
        Timestamp endtime = DateUtil.getLastTimeOfDay(curtime);
        Long scopeSecond = DateUtil.getDiffSecond(endtime, curtime);
        return scopeSecond.intValue();
    }

    public static final <T extends Date> String formatEn(T date, String pattern) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ENGLISH);
            String result = df.format(date);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrAddHour(int hour) {
        return DateUtil.formatTimestamp(System.currentTimeMillis() + 3600000L * (long)hour);
    }

    public static String getCurrAddDay(int day) {
        return DateUtil.formatTimestamp(System.currentTimeMillis() + 86400000L * (long)day);
    }

    public static final Timestamp parseDate2Timestamp(Date date) {
        return DateUtil.parseTimestamp(DateUtil.formatTimestamp(date));
    }

    public static final String currentTimeFull() {
        return DateUtil.format(new Date(), PATTERN_YYYYMMDDHHMMSS);
    }

    public static String getMinutetime(long time) {
        String strSecond;
        if (time <= 0L) {
            return "";
        }
        int ss = 1;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = time / (long)dd;
        long hour = (time - day * (long)dd) / (long)hh;
        long minute = (time - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (time - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String string = strSecond = second < 10L ? "0" + second : "" + second;
        if (StringUtils.equals((CharSequence)strHour, (CharSequence)"00")) {
            String minutetime = strMinute + "\u5206" + strSecond + "\u79d2";
            return minutetime;
        }
        String minutetime = strHour + "\u5c0f\u65f6" + strMinute + "\u5206" + strSecond + "\u79d2";
        return minutetime;
    }

    public static final <T extends Date> String getDiffStrHM(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return "---";
        }
        long diff = day1.getTime() - day2.getTime();
        diff = Math.abs(diff) / 1000L;
        long hour = diff / 3600L;
        long minu = diff % 3600L / 60L;
        return (hour == 0L ? "" : hour + "\u5c0f\u65f6") + (minu == 0L ? "" : minu + "\u5206");
    }

    public static final <T extends Date> long getDiffSecond2(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0L;
        }
        long diff = day1.getTime() - day2.getTime();
        if (diff <= 0L) {
            return 0L;
        }
        long sign = diff / Math.abs(diff);
        diff = Math.abs(diff) / 1000L;
        return sign * diff;
    }

    public static String getTimeDesc3(Timestamp time) {
        if (time == null) {
            return "";
        }
        Long paramsTimes = DateUtil.getBeginningTimeOfDay(time).getTime();
        if (DateUtil.getCurDate().getTime() == paramsTimes.longValue()) {
            return "\u4eca\u5929" + DateUtil.formatTimeH(time);
        }
        if (DateUtil.addDay(DateUtil.getCurDate(), 1).getTime() == paramsTimes.longValue()) {
            return "\u660e\u5929" + DateUtil.formatTimeH(time);
        }
        if (DateUtil.addDay(DateUtil.getCurDate(), 2).getTime() == paramsTimes.longValue()) {
            return "\u540e\u5929" + DateUtil.formatTimeH(time);
        }
        return DateUtil.formatTimeM(time);
    }

    public static String getTimeDesc4(Timestamp time) {
        if (time == null) {
            return "";
        }
        Long paramsTimes = DateUtil.getBeginningTimeOfDay(time).getTime();
        if (DateUtil.getCurDate().getTime() == paramsTimes.longValue()) {
            return "\u4eca\u5929";
        }
        if (DateUtil.addDay(DateUtil.getCurDate(), 1).getTime() == paramsTimes.longValue()) {
            return "\u660e\u5929";
        }
        if (DateUtil.addDay(DateUtil.getCurDate(), 2).getTime() == paramsTimes.longValue()) {
            return "\u540e\u5929";
        }
        return DateUtil.getCnWeek(time);
    }

    public static final <T extends Date> String formatTimeH(T date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        return timeFormat.format(date);
    }

    public static final <T extends Date> String formatTimeM(T date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return timeFormat.format(date);
    }

    public static String getTimeDesc2(Date time) {
        String timeContent;
        if (time == null) {
            return "";
        }
        Long ss = System.currentTimeMillis() - time.getTime();
        Long minute = ss / 60000L;
        if (minute < 1L) {
            return "\u521a\u521a";
        }
        if (minute >= 60L) {
            Long hour = minute / 60L;
            if (hour >= 24L) {
                Integer curYear = DateUtil.getCurrentYear();
                Integer nowYear = DateUtil.getYear(time);
                timeContent = curYear > nowYear ? DateUtil.format(time, PATTERN_YYYY_MM_DD) : DateUtil.format(time, "MM-dd");
            } else {
                timeContent = hour + "\u5c0f\u65f6\u524d";
            }
        } else {
            timeContent = minute + "\u5206\u949f\u524d";
        }
        return timeContent;
    }

    public static final <T extends Date> int getDiffYear(T day1, T day2) {
        if (day1 == null || day2 == null) {
            return 0;
        }
        long diff = day1.getTime() - day2.getTime();
        diff = Math.abs(diff) / 1000L;
        return Math.round(diff / 31536000L);
    }

    public static Date getWeekFirstDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        return c.getTime();
    }
}

