/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.zwy.service.Util;

import java.security.MessageDigest;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashKit {
    private static Logger logger = LoggerFactory.getLogger(HashKit.class);
    private static SecureRandom random = new SecureRandom();

    private HashKit() {
    }

    public static String sha512(String srcStr) {
        return HashKit.hash("SHA-512", srcStr);
    }

    public static String md5(String srcStr) {
        return HashKit.hash("MD5", srcStr);
    }

    public static String hash(String algorithm, String srcStr) {
        try {
            return HashKit.toHex(MessageDigest.getInstance(algorithm).digest(srcStr.getBytes("utf-8")));
        }
        catch (Exception var3) {
            logger.error("hash error! algorithm:{}, srcStr:{}", new Object[]{algorithm, srcStr, var3});
            return null;
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        byte[] var2 = bytes;
        int var3 = bytes.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte b = var2[var4];
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                result.append("0");
            }
            result.append(hex);
        }
        return result.toString();
    }

    public static String generateSalt(int numberOfBytes) {
        byte[] salt = new byte[numberOfBytes];
        random.nextBytes(salt);
        return HashKit.toHex(salt);
    }
}

