/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.zwy.service.Util;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.zwy.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.zwy.service.response.ContractGooodsResponseVo;
import com.yqbsoft.laser.service.ext.data.zwy.service.response.ContractResponseVo;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class BusBaseService
extends BaseServiceImpl {
    public static final String SYS_CODE = "BusBaseService";

    protected String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    protected Map<String, Object> getDdMap(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String json = this.getDdFlag(tenantCode, flagSettingType, flagSettingCode);
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
    }

    protected String getTenantCodeBuUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String s = url.replace("http://", "").replace("https://", "");
        String[] str = s.split("/");
        if (str.length <= 6) {
            return null;
        }
        return str[6];
    }

    protected String getTeananMemberCode(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }

    protected void checkParams(String ... params) {
        if (null == params) {
            throw new RuntimeException("checkParams params is null");
        }
        for (String param : params) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param)) continue;
            throw new RuntimeException("request params is null");
        }
    }

    protected List<OcContractGoodsDomain> getOcContractGoodsDomains(String tenantCode, ContractResponseVo contractVo, UmUserinfoReDomain userinfoByCode) {
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        for (ContractGooodsResponseVo contractVoGood : contractVo.getGoods()) {
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setGoodsType("49");
            ocContractGoodsDomain.setPricesetNprice(contractVoGood.getPrice().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            ocContractGoodsDomain.setPricesetAsprice(contractVoGood.getPrice().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            ocContractGoodsDomain.setContractGoodsGtype("2");
            ocContractGoodsDomain.setSkuName(contractVoGood.getGoodName());
            ocContractGoodsDomain.setGoodsName(contractVoGood.getGoodName());
            ocContractGoodsDomain.setDataPicpath("");
            ocContractGoodsDomain.setGoodsNum(new BigDecimal(contractVoGood.getQuantity()));
            ocContractGoodsDomain.setGoodsSupplynum(new BigDecimal("10"));
            ocContractGoodsDomain.setPricesetAsprice(null);
            ocContractGoodsDomain.setPricesetMakeprice(null);
            ocContractGoodsDomain.setTenantCode(tenantCode);
            ocContractGoodsDomain.setMemberCode(memberCode);
            ocContractGoodsDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
            ocContractGoodsDomain.setMemberCcode(memberCode);
            ocContractGoodsDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
            ocContractGoodsDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractGoodsDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            contractGoodsList.add(ocContractGoodsDomain);
        }
        return contractGoodsList;
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected List<OcRefundDomain> queryRefundPage(String contractNbillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", contractNbillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("BusBaseService.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    protected List<OcRefundDomain> queryRefundNcodePage(String contractNbillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("refundNcode", contractNbillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("BusBaseService.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }
}

