/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.util;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WXXmlToMapUtil {
    private static final Logger logger = LoggerFactory.getLogger(WXXmlToMapUtil.class);

    public static Map<String, String> xmlToMap(String xml) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            org.w3c.dom.Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            ((InputStream)stream).close();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String multilayerMapToXml(Map<String, Object> map, boolean isCDATA) {
        String parentName = "xml";
        Document doc = DocumentHelper.createDocument();
        doc.addElement(parentName);
        String xml = WXXmlToMapUtil.recursionMapToXml(doc.getRootElement(), parentName, map, isCDATA);
        return WXXmlToMapUtil.formatXML(xml);
    }

    public static String multilayerMapToXml(Map<String, Object> map, boolean isCDATA, String parentName) {
        Document doc = DocumentHelper.createDocument();
        doc.addElement(parentName);
        String xml = WXXmlToMapUtil.recursionMapToXml(doc.getRootElement(), parentName, map, isCDATA);
        return WXXmlToMapUtil.formatXML(xml);
    }

    private static String recursionMapToXml(org.dom4j.Element element, String parentName, Map<String, Object> map, boolean isCDATA) {
        org.dom4j.Element xmlElement = element.addElement(parentName);
        for (String key : map.keySet()) {
            String value;
            Object obj = map.get(key);
            if (obj instanceof Map) {
                WXXmlToMapUtil.recursionMapToXml(xmlElement, key, (Map)obj, isCDATA);
                continue;
            }
            if (obj instanceof List) {
                List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(obj), Map.class);
                for (Map param : list) {
                    WXXmlToMapUtil.recursionMapToXml(xmlElement, key, param, isCDATA);
                }
                continue;
            }
            String string = value = obj == null ? "" : obj.toString();
            if (isCDATA) {
                xmlElement.addElement(key).addCDATA(value);
                continue;
            }
            xmlElement.addElement(key).addText(value);
        }
        return xmlElement.asXML();
    }

    public static String mapToXml(Map<String, Object> data) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.newDocument();
            Element root = document.createElement("xml");
            document.appendChild(root);
            for (String key : data.keySet()) {
                String value = (String)data.get(key);
                if (value == null) {
                    value = "";
                }
                value = value.trim();
                Element filed = document.createElement(key);
                filed.appendChild(document.createTextNode(value));
                root.appendChild(filed);
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(document);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            String output = writer.getBuffer().toString();
            writer.close();
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> multilayerXmlToMap(String xml) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            logger.error("xml\u5b57\u7b26\u4e32\u89e3\u6790\uff0c\u5931\u8d25 --> {}", (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == doc) {
            return map;
        }
        org.dom4j.Element rootElement = doc.getRootElement();
        WXXmlToMapUtil.recursionXmlToMap(rootElement, map);
        return map;
    }

    private static void recursionXmlToMap(org.dom4j.Element element, Map<String, Object> outmap) {
        List list = element.elements();
        int size = list.size();
        if (size == 0) {
            outmap.put(element.getName(), element.getTextTrim());
        } else {
            HashMap<String, Object> innermap = new HashMap<String, Object>();
            for (org.dom4j.Element childElement : list) {
                WXXmlToMapUtil.recursionXmlToMap(childElement, innermap);
            }
            outmap.put(element.getName(), innermap);
        }
    }

    public static String formatXML(String xml) {
        String requestXML = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(xml));
            if (null != document) {
                StringWriter stringWriter = new StringWriter();
                OutputFormat format = new OutputFormat("    ", true);
                format.setNewLineAfterDeclaration(false);
                format.setSuppressDeclaration(false);
                format.setNewlines(true);
                XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
                writer.write(document);
                writer.flush();
                writer.close();
                requestXML = stringWriter.getBuffer().toString();
            }
            return requestXML;
        }
        catch (Exception e) {
            logger.error("\u683c\u5f0f\u5316xml\uff0c\u5931\u8d25 --> {}", (Throwable)e);
            return null;
        }
    }
}

