/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActEntranceService;
import com.yqbsoft.laser.service.activiti.util.ActivitiUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class ActEntranceServiceImpl
extends BaseServiceImpl
implements ActEntranceService {
    public static final String SYS_CODE = "act.activiti.ActEntranceServiceImpl";
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ActChannelsendService actChannelsendService;

    @Override
    public List<ActChannelsend> saveDefinitionProcess(String fileName, String processName, String tenantCode) {
        if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)processName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.definitionProcess.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Deployment deploy = null;
        try {
            deploy = this.repositoryService.createDeployment().addClasspathResource("com/yqbsoft/laser/service/activiti/processes/" + fileName).name(processName).tenantId(tenantCode).deploy();
        }
        catch (Exception e) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.definitionProcess.ex");
        }
        if (null == deploy) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.definitionProcess.ex");
        }
        ArrayList<Deployment> list = new ArrayList<Deployment>();
        list.add(deploy);
        return this.buidPmChannelsend(list, "insert");
    }

    public void saveDefinitionProcessByFile(MultipartFile resourceBpmn, String tenantCode) throws ApiException {
        try {
            String resourceNameBpmn = resourceBpmn.getOriginalFilename();
            InputStream inputStreamBpmn = resourceBpmn.getInputStream();
            Deployment deployment = this.repositoryService.createDeployment().tenantId(tenantCode).addInputStream(resourceNameBpmn, inputStreamBpmn).deploy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ProcessDefinition getProcessDefinition(String processDefinitionKey, String tenantCode) {
        if (StringUtils.isBlank((String)processDefinitionKey) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.queryProceccDefinition.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ProcessDefinitionQuery definitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)((ProcessDefinitionQuery)definitionQuery.processDefinitionKey(processDefinitionKey).processDefinitionTenantId(tenantCode).orderByProcessDefinitionVersion().desc()).singleResult();
        return processDefinition;
    }

    @Override
    public List<Deployment> queryDeployList(String tenantCode) {
        List list = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().deploymentTenantId(tenantCode).orderByDeploymenTime().desc()).list();
        return list;
    }

    @Override
    public InputStream getProcessResources(String processDefinitionKey, String tenantCode) {
        if (StringUtils.isBlank((String)processDefinitionKey) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.getProcessResources.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        processDefinitionQuery.processDefinitionKey(processDefinitionKey).processDefinitionTenantId(tenantCode);
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.singleResult();
        String deploymentId = processDefinition.getDeploymentId();
        InputStream png = this.repositoryService.getResourceAsStream(deploymentId, processDefinition.getDiagramResourceName());
        return png;
    }

    @Override
    public List<ActChannelsend> deleteDeployment(String deploymentId, Boolean cascade) {
        if (StringUtils.isBlank((String)deploymentId) || null == cascade) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.deleteDeployment", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        try {
            this.repositoryService.deleteDeployment(deploymentId, cascade.booleanValue());
        }
        catch (Exception e) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.deleteDeployment.ex");
        }
        ArrayList<Deployment> list = new ArrayList<Deployment>();
        list.add(deployment);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public List<HistoricTaskInstance> queryAlreadyHistory(String processInstanceId, String tenantCode) {
        if (StringUtils.isBlank((String)processInstanceId) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.queryAlreadyHistory.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).finished().taskTenantId(tenantCode)).orderByHistoricTaskInstanceStartTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        return list;
    }

    @Override
    public List<HistoricTaskInstance> queryHistory(String processInstanceId, String tenantCode) {
        if (StringUtils.isBlank((String)processInstanceId) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.queryHistory.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskTenantId(tenantCode)).orderByHistoricTaskInstanceStartTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        return list;
    }

    @Override
    public HistoricActivityInstance getUndoHistory(String processInstanceId, String tenantCode) {
        if (StringUtils.isBlank((String)processInstanceId) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.getUndoHistory.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HistoricActivityInstance instance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityTenantIdLike(tenantCode).unfinished().singleResult();
        return instance;
    }

    @Override
    public List<ActChannelsend> saveProcessInstance(String formKey, Map<String, Object> map, String formid, String tenantCode) {
        if (StringUtils.isBlank((String)formKey) || StringUtils.isBlank((String)formid)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.startProcessInstance.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String objId = formKey + "." + formid;
        ProcessInstance processInstance = null;
        if (MapUtil.isEmpty(map)) {
            processInstance = this.runtimeService.startProcessInstanceByKeyAndTenantId(formKey, objId, tenantCode);
        } else {
            map.put("objId", objId);
            processInstance = this.runtimeService.startProcessInstanceByKeyAndTenantId(formKey, objId, map, tenantCode);
        }
        ArrayList<ProcessInstance> list = new ArrayList<ProcessInstance>();
        list.add(processInstance);
        return this.buidProcessInstanceChannelsend(list, "insert");
    }

    @Override
    public String getBusinessKeyByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((String)processInstanceId)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.getBusinessKeyByProcessInstanceId.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return instance.getBusinessKey();
    }

    public void suspendOrActivateProcessDefinition(String key) {
        if (StringUtils.isBlank((String)key)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.suspendOrActivateProcessDefinition.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).singleResult();
        boolean suspend = processDefinition.isSuspended();
        if (suspend) {
            this.logger.info(SYS_CODE, (Object)"\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u6302\u8d77,\u5f00\u59cb\u6fc0\u6d3b");
            this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), true, null);
        } else {
            this.logger.info(SYS_CODE, (Object)"\u5df2\u7ecf\u6fc0\u6d3b,\u5f00\u59cb\u6302\u8d77");
            this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        }
    }

    @Override
    public List<ActChannelsend> updateProcessInstance(String processInstanceId, String tenantCode) {
        if (StringUtils.isBlank((String)processInstanceId)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.suspendOrActiveProcessInstance.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).processInstanceTenantId(tenantCode).singleResult();
        boolean suspended = instance.isSuspended();
        if (suspended) {
            this.runtimeService.activateProcessInstanceById(instance.getId());
        } else {
            this.runtimeService.suspendProcessInstanceById(instance.getId());
        }
        ArrayList<ProcessInstance> list = new ArrayList<ProcessInstance>();
        list.add(instance);
        return this.buidProcessInstanceChannelsend(list, "update");
    }

    @Override
    public Task getTask(String processInstanceId) {
        if (StringUtils.isBlank((String)processInstanceId)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.queryTaskList.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).singleResult();
        return task;
    }

    @Override
    public QueryResult<Task> queryPersonalTaskList(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String candidateUser = (String)map.get("candidateUser");
        String tenantCode = (String)map.get("tenantCode");
        int startRow = (Integer)map.get("startRow");
        int rows = (Integer)map.get("rows");
        if (StringUtils.isBlank((String)candidateUser) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        int maxResults = firstResult + rows;
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateUser(candidateUser)).taskTenantId(tenantCode);
        long count = taskQuery.count();
        List tasks = ((TaskQuery)((TaskQuery)taskQuery.orderByTaskCreateTime()).desc()).listPage(firstResult, maxResults);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount((int)count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setTotal((long)((int)count));
        queryResult.setList(tasks);
        return queryResult;
    }

    @Override
    public List<Task> queryGroupTask(String processInstanceId, String candidateUser, String tenantCode) {
        List list = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskCandidateUser(candidateUser)).taskTenantId(tenantCode)).list();
        return list;
    }

    @Override
    public List<Task> queryTaskByCandidateUser(String candidateUser, String tenantCode) {
        List list = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateUser(candidateUser)).taskTenantId(tenantCode)).includeProcessVariables()).list();
        return list;
    }

    @Override
    public void claimTask(String taskId, String userId, String tenantCode) {
        this.taskService.claim(taskId, userId);
    }

    public void exitClaim(String key, String userId, String tenantCode) {
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(key)).taskAssignee(userId)).taskTenantId(tenantCode)).singleResult();
        if (task != null) {
            this.taskService.claim(task.getId(), null);
        }
    }

    @Override
    public List<ActChannelsend> saveTask(String taskId, String assignee, String tenantCode) {
        if (StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)assignee)) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.completTask", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskAssignee(assignee)).taskTenantId(tenantCode)).singleResult();
        if (null == task) {
            throw new ApiException("act.activiti.ActEntranceServiceImpl.completTask", "\u8be5\u7528\u6237\u6ca1\u6709\u5b8c\u6210\u8be5\u4efb\u52a1\u7684\u6743\u9650");
        }
        this.taskService.complete(taskId);
        ArrayList<Task> list = new ArrayList<Task>();
        list.add(task);
        return this.buidTaskChannelsend(list, "insert");
    }

    private List<ActChannelsend> buidPmChannelsend(List<Deployment> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (Deployment promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getId());
            pmChannelsendDomain.setChannelsendType("deployment");
            pmChannelsendDomain.setChannelsendDir(dri);
            ActivitiUtil<Deployment> util = new ActivitiUtil<Deployment>();
            Map<String, Object> map = util.tOneResult(promotion);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson(map));
            pmChannelsendDomain.setTenantCode(promotion.getTenantId());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<ActChannelsend> buidProcessInstanceChannelsend(List<ProcessInstance> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (ProcessInstance promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getId());
            pmChannelsendDomain.setChannelsendType("processInstance");
            pmChannelsendDomain.setChannelsendDir(dri);
            ActivitiUtil<ProcessInstance> util = new ActivitiUtil<ProcessInstance>();
            Map<String, Object> map = util.tOneResult(promotion);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson(map));
            pmChannelsendDomain.setTenantCode(promotion.getTenantId());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<ActChannelsend> buidTaskChannelsend(List<Task> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (Task promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getId());
            pmChannelsendDomain.setChannelsendType("task");
            pmChannelsendDomain.setChannelsendDir(dri);
            ActivitiUtil<Task> util = new ActivitiUtil<Task>();
            Map<String, Object> map = util.tOneResult(promotion);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson(map));
            pmChannelsendDomain.setTenantCode(promotion.getTenantId());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

